/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common.shortestPath;

import bridge.abstractClasses.AbstractScalar;
import bridge.algorithms.StepAlgo;
import bridge.interfaces.Graph;
import bridge.interfaces.HierarchicalSet;
import bridge.interfaces.Link;
import bridge.interfaces.Map;
import bridge.interfaces.Path;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;

public abstract class Dijkstra<V, E extends Link<V>, G extends Graph<V, E>>
extends StepAlgo<V, E> {
    static final int DISTANCE_MAX = Integer.MAX_VALUE;
    private G g_;
    private Hashtable<V, AbstractScalar> distance_;
    private Hashtable<V, V> parcours_;
    private V start_;
    private boolean init_;
    private Map result_;
    public String DIJKSTRADISTANCE = "distanceDijkstra";

    protected abstract HierarchicalSet<V> createVertexSet(HierarchicalSet<V> var1);

    protected abstract Path<V, E> createPath();

    protected abstract AbstractScalar createScalar(int var1);

    public Dijkstra(G g, Map result) {
        this(g, result, false);
    }

    public Dijkstra(G g, Map result, boolean stepMode) {
        super(stepMode);
        this.g_ = g;
        this.parcours_ = new Hashtable();
        this.distance_ = new Hashtable();
        this.init_ = false;
        this.result_ = result;
    }

    public void valuateFromSource(V u) {
        this.start_ = u;
        if (this.getDemoMode()) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        this.init_ = true;
        if (this.getDemoMode()) {
            this.pause();
        }
        HierarchicalSet c = this.createVertexSet(this.g_.vertexSet());
        c.addAll(this.g_.vertexSet());
        c.remove(this.start_);
        HierarchicalSet<Object> d = this.createVertexSet(this.g_.vertexSet());
        this.parcours_.clear();
        this.distance_.clear();
        for (Object currentNode : this.g_.vertexSet()) {
            this.parcours_.put(currentNode, this.start_);
            if (this.g_.outNeighborhood(this.start_).contains(currentNode)) {
                this.distance_.put((AbstractScalar)currentNode, this.createScalar(1));
                this.result_.putValue(currentNode, this.DIJKSTRADISTANCE, this.createScalar(1));
                continue;
            }
            this.distance_.put((AbstractScalar)currentNode, this.createScalar(Integer.MAX_VALUE));
            this.result_.putValue(currentNode, this.DIJKSTRADISTANCE, this.createScalar(Integer.MAX_VALUE));
        }
        this.distance_.put((AbstractScalar)this.start_, this.createScalar(0));
        this.result_.putValue(this.start_, this.DIJKSTRADISTANCE, this.createScalar(0));
        while (!c.isEmpty()) {
            Iterator itC = c.iterator();
            Object minNode = null;
            AbstractScalar minDistance = this.createScalar(Integer.MAX_VALUE);
            while (itC.hasNext()) {
                Object currentNode = itC.next();
                if (minNode != null && this.distance_.get(currentNode).compareTo(minDistance) >= 0) continue;
                minNode = currentNode;
                minDistance = this.distance_.get(currentNode);
            }
            c.remove(minNode);
            d.add(minNode);
            for (Object e : this.g_.outNeighborhood(minNode)) {
                if (!c.contains(e) || this.distance_.get(minNode).clone().add(this.createScalar(1)).compareTo(this.distance_.get(e)) >= 0) continue;
                this.distance_.put((AbstractScalar)e, this.distance_.get(minNode).clone().add(this.createScalar(1)));
                this.result_.putValue(e, this.DIJKSTRADISTANCE, this.distance_.get(e));
                this.parcours_.put(e, minNode);
            }
            if (!this.getDemoMode()) continue;
            this.result_.putValue(minNode, "color", this.createScalar(Color.green.getRGB()));
            this.pause();
        }
        this.ends();
    }

    public Hashtable<V, AbstractScalar> getDistances() {
        if (this.init_) {
            return this.distance_;
        }
        return null;
    }

    public int getDistanceTo(Object v) {
        if (this.init_) {
            return this.distance_.get(v).intValue();
        }
        return -1;
    }

    public Path<V, E> getShortestPathTo(V v) {
        if (v == this.start_ || !this.init_ || this.distance_.get(v).compareTo(this.createScalar(Integer.MAX_VALUE)) == 0) {
            return null;
        }
        Path<V, Link> result = this.createPath();
        V rendu = v;
        while (rendu != this.start_) {
            V prec = this.parcours_.get(rendu);
            Iterator goodEdge = this.g_.outEdges(prec).iterator();
            Link la_bonne_edge = null;
            while (goodEdge.hasNext()) {
                la_bonne_edge = (Link)goodEdge.next();
                if (la_bonne_edge.leadsTo(rendu)) break;
            }
            assert (la_bonne_edge.leadsTo(rendu));
            result.concat(la_bonne_edge);
            rendu = prec;
        }
        return result;
    }

    public V getStartNode() {
        return this.start_;
    }
}

