/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common.shortestPath;

import bridge.abstractClasses.AbstractScalar;
import bridge.algorithms.common.shortestPath.ShortestPathWithSingleOrigin;
import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import java.awt.Color;
import java.util.HashSet;
import java.util.NoSuchElementException;
import tools.dataStructures.FibonacciHeap;

public abstract class DijkstraAdvanced<V, E extends Link<V>, G extends Graph<V, E>>
extends ShortestPathWithSingleOrigin<V, E, G> {
    private final V destination;

    public DijkstraAdvanced(G g) {
        this(g, false);
    }

    public DijkstraAdvanced(G g, boolean stepMode) {
        this(g, stepMode, null);
    }

    protected DijkstraAdvanced(G g, boolean stepMode, V destination) {
        super(g, stepMode);
        this.destination = destination;
    }

    @Override
    public void run() {
        if (this.infiniteDistance == null) {
            throw new RuntimeException("You must specify infiniteDistance with setInfiniteDistance method");
        }
        if (this.getDemoMode()) {
            this.pause();
        }
        AbstractScalar zero = this.infiniteDistance.zero();
        FibonacciHeap<Object, AbstractScalar> nonComputedVertices = new FibonacciHeap<Object, AbstractScalar>();
        HashSet alreadyComputeVertices = new HashSet();
        this.Initialize(zero);
        nonComputedVertices.insert(this.start_, zero.clone());
        this.pause();
        while (!nonComputedVertices.isEmpty()) {
            Object minNode = null;
            try {
                minNode = nonComputedVertices.findMin();
                nonComputedVertices.deleteMin();
                if (this.getDemoMode()) {
                    this.result.putString(minNode, "Color", "" + Color.green.getRGB());
                }
            }
            catch (NoSuchElementException u) {
                System.err.println("findMin : fibonacci heap is empty");
            }
            this.pause();
            for (Link currentEdge2 : this.g_.outEdges(minNode)) {
                Object currentNode2 = currentEdge2.getOpposite(minNode);
                if (alreadyComputeVertices.contains(currentNode2)) continue;
                if (this.getDemoMode()) {
                    this.result.putString(currentEdge2, "Color", "" + Color.red.getRGB());
                    this.pause();
                }
                if (!this.updateVerticesDistance(minNode, currentNode2, currentEdge2)) continue;
                try {
                    nonComputedVertices.FibHeapDecreaseKey(currentNode2, this.result.getValue(currentNode2, "vertexDistance", this.g_));
                }
                catch (IllegalArgumentException u) {
                    System.err.println("FibHeapDecreaseKey : New value greater than older");
                }
            }
            alreadyComputeVertices.add(minNode);
            if (this.destination != null && minNode == this.destination) {
                this.ends();
                return;
            }
            if (!this.getDemoMode()) continue;
            this.result.putString(minNode, "Color", "" + Color.red.getRGB());
        }
        this.ends();
    }
}

