/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common.shortestPath;

import bridge.abstractClasses.AbstractScalar;
import bridge.algorithms.StepAlgo;
import bridge.algorithms.common.CopyGraph;
import bridge.algorithms.common.shortestPath.DijkstraAdvanced;
import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import bridge.interfaces.Map;
import bridge.interfaces.Path;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import tools.dataStructures.BinaryTree;
import tools.dataStructures.Pair;

public abstract class KShortestPaths<V, E extends Link<V>, G extends Graph<V, E>>
extends StepAlgo<V, E> {
    private AbstractScalar infiniteDistance = null;
    private G g_ = null;
    private int k_ = 1;
    private Map distance_;
    private String distanceName = "distance";
    private Object distanceContext;
    private V source = null;
    private V destination = null;
    private Vector<Path<V, E>> K = null;
    public int numberOfComputedPaths = 0;
    private Vector<AbstractScalar> Weights = null;
    private CopyGraph<V, E, G> graphCopy;

    protected abstract DijkstraAdvanced<V, E, G> createDijkstraAdvanced(G var1, V var2);

    protected abstract CopyGraph<V, E, G> createCopyGraph();

    protected abstract Path<V, E> createPath();

    public KShortestPaths(G g, Map distance) {
        this(g, distance, false);
    }

    public KShortestPaths(G g, Map distance, boolean stepMode) {
        super(stepMode);
        this.g_ = g;
        this.distance_ = distance;
        this.graphCopy = this.createCopyGraph();
        this.distanceContext = this.g_;
    }

    public void setDistanceName(String name) {
        this.distanceName = name;
    }

    public void setDistanceContext(Object context) {
        this.distanceContext = context;
    }

    public void setInfiniteDistance(AbstractScalar infinite) {
        this.infiniteDistance = infinite.clone();
    }

    public void setNumberOfComputedPath(int k) {
        this.k_ = k;
    }

    public void setEndsOfPath(V s, V t) {
        this.source = s;
        this.destination = t;
    }

    public void computeShortestPath(V s, V t, int k) {
        this.source = s;
        this.destination = t;
        this.k_ = k;
        if (this.getDemoMode()) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        if (this.source == null || this.destination == null) {
            throw new RuntimeException("You must specify source and destination");
        }
        if (this.infiniteDistance == null) {
            throw new RuntimeException("You must specify infinite distance with setInfiniteDistance method");
        }
        HashSet<Pair<Path<V, Pair<Path<V, E>, V>>, V>> S = new HashSet<Pair<Path<V, Pair<Path<V, E>, V>>, V>>();
        BinaryTree<Path, AbstractScalar> X = new BinaryTree<Path, AbstractScalar>();
        this.Weights = new Vector();
        this.K = new Vector();
        G g_prime = this.graphCopy.copyGraph(this.g_);
        int k = 1;
        DijkstraAdvanced<V, E, G> dijkstra = this.createDijkstraAdvanced(this.g_, this.destination);
        dijkstra.setDistanceMap(this.distance_);
        dijkstra.setDistanceContext(this.distanceContext);
        dijkstra.setDistanceName(this.distanceName);
        dijkstra.setInfiniteDistance(this.infiniteDistance);
        dijkstra.valuateFromSource(this.source);
        Path p = dijkstra.getShortestPathTo(this.destination);
        if (p == null) {
            return;
        }
        S.add(new Pair(p, this.source));
        X.insert(p, this.getLength(p));
        this.K.add(p);
        if (this.getDemoMode()) {
            this.distance_.putString(p, "Color", "" + Color.red.getRGB());
            this.pause();
            this.distance_.putString(p, "Color", "" + Color.blue.getRGB());
        }
        this.Weights.add(this.getLength(p));
        while (k < this.k_ && !X.isEmpty()) {
            X.deleteMin();
            V w = this.getDeviationVertex(S, p);
            Iterator<V> vertexIt = p.vertexIterator(this.source);
            V v = vertexIt.next();
            while (v != w) {
                v = vertexIt.next();
            }
            while (v != this.destination) {
                if (this.getDemoMode()) {
                    this.distance_.putString(v, "Color", "" + Color.red.getRGB());
                    this.pause();
                }
                this.disableVerticesAndEdges((Graph<V, ? extends E>)g_prime, this.source, v, p);
                this.pause();
                Path<V, Object> q = this.createPath();
                Iterator itEdge = p.edgeIterator(this.source);
                Link current = (Link)itEdge.next();
                if (v != this.source) {
                    q.concat(current);
                    if (!current.contains(v)) {
                        V[] vertices;
                        current = (Link)itEdge.next();
                        do {
                            vertices = current.toArray();
                            q.concat(current);
                            current = (Link)itEdge.next();
                        } while (vertices[0] != v && vertices[1] != v);
                    }
                }
                dijkstra.valuateFromSource(v);
                Path spd = dijkstra.getShortestPathTo(this.destination);
                if (spd != null) {
                    q.concat((Object)spd);
                    X.insert(q, this.getLength(q));
                    S.add(new Pair<Path<V, E>, V>(q, v));
                    if (this.getDemoMode()) {
                        this.distance_.putString(q, "Color", "" + Color.green.getRGB());
                        this.pause();
                        this.distance_.putString(q, "Color", "" + Color.blue.getRGB());
                    }
                }
                if (this.getDemoMode()) {
                    this.distance_.putString(v, "Color", "" + Color.yellow.getRGB());
                }
                assert (vertexIt.hasNext());
                v = vertexIt.next();
            }
            this.g_.vertexSet().addAll(g_prime.vertexSet());
            this.g_.edgeSet().addAll(g_prime.edgeSet());
            if (X.isEmpty()) continue;
            p = (Path)X.findMin();
            this.K.add(p);
            if (this.getDemoMode()) {
                this.distance_.putString(p, "Color", "" + Color.red.getRGB());
                this.pause();
                this.distance_.putString(p, "Color", "" + Color.blue.getRGB());
            }
            this.Weights.add((AbstractScalar)X.getValueOf((Path)X.findMin()));
            ++k;
        }
        this.numberOfComputedPaths = k;
        this.g_.vertexSet().addAll(g_prime.vertexSet());
        this.g_.edgeSet().addAll(g_prime.edgeSet());
        if (this.getDemoMode()) {
            int firstColor = Color.red.getRGB();
            int i = 0;
            while (i < this.K.size()) {
                this.distance_.putString(this.K.get(i), "Color", "" + firstColor);
                firstColor += 64;
                ++i;
            }
        }
        this.ends();
    }

    public Path<V, E> getShortestPath(int k) {
        if (k >= this.K.size()) {
            return null;
        }
        return this.K.elementAt(k);
    }

    public int numberOfComputedPaths() {
        return this.numberOfComputedPaths;
    }

    public double getDistance(int k) {
        return this.Weights.elementAt(k).doubleValue();
    }

    private V getDeviationVertex(HashSet<Pair<Path<V, E>, V>> S, Path<V, E> p) {
        V w = null;
        Iterator<Pair<Path<V, E>, V>> it_s = S.iterator();
        while (it_s.hasNext() && w == null) {
            Pair<Path<V, E>, V> pair = it_s.next();
            Path<V, E> p_in_s = pair.getKey();
            if (!this.comparePaths(p_in_s, p)) continue;
            w = pair.getValue();
        }
        return w;
    }

    private boolean comparePaths(Path<V, ? extends E> p1, Path<V, ? extends E> p2) {
        if (p1.length() != p2.length()) {
            return false;
        }
        Iterator<V> it1 = p1.vertexIterator(p1.isDirected() ? p1.getFirstVertex() : p1.getEnds()[0]);
        Iterator<V> it2 = p2.vertexIterator(p2.isDirected() ? p2.getFirstVertex() : p2.getEnds()[0]);
        while (it1.hasNext() && it2.hasNext()) {
            if (it1.next() == it2.next()) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    private void disableVerticesAndEdges(Graph<V, ? extends E> g_prime, V s, V v, Path<V, ? extends E> p) {
        this.g_.vertexSet().addAll(g_prime.vertexSet());
        this.g_.edgeSet().addAll(g_prime.edgeSet());
        Iterator<V> it = p.vertexIterator(s);
        V cur = it.next();
        while (cur != v) {
            Link[] edges = (Link[])this.g_.inOutEdges(cur).toArray();
            int i = 0;
            while (i < edges.length) {
                this.g_.removeEdge(edges[i]);
                ++i;
            }
            assert (it.hasNext());
            cur = it.next();
        }
        for (Path<V, E> currentPath : this.K) {
            if (!this.compareSubPath(p, currentPath, s, v)) continue;
            this.removeAlreadyFindPath((Graph<V, ? extends E>)this.g_, (Path<V, ? extends E>)currentPath, s, v);
        }
    }

    private boolean compareSubPath(Path<V, ? extends E> p1, Path<V, ? extends E> p2, V beginning, V lastVertex) {
        if (beginning == lastVertex) {
            return true;
        }
        Iterator<E> edgeIt1 = p1.edgeIterator(beginning);
        Iterator<E> edgeIt2 = p2.edgeIterator(beginning);
        while (edgeIt1.hasNext() && edgeIt2.hasNext()) {
            Link currentEdge2;
            Link currentEdge1 = (Link)edgeIt1.next();
            if (currentEdge1 != (currentEdge2 = (Link)edgeIt2.next())) {
                return false;
            }
            if (!currentEdge1.contains(lastVertex)) continue;
            return true;
        }
        return false;
    }

    private void removeAlreadyFindPath(Graph<V, ? extends E> g, Path<V, ? extends E> p, V source, V v) {
        Iterator<E> itEdge = p.edgeIterator(source);
        if (v != source) {
            Link current;
            while (!(current = (Link)itEdge.next()).contains(v)) {
            }
        }
        g.removeEdge(itEdge.next());
    }

    private AbstractScalar getLength(Path<V, E> p) {
        AbstractScalar length = null;
        Iterator<E> it_edge = p.edgeIterator(p.isDirected() ? p.getFirstVertex() : p.getEnds()[0]);
        while (it_edge.hasNext()) {
            Link edge = (Link)it_edge.next();
            if (length == null) {
                length = this.distance_.getValue(edge, this.distanceName, this.distanceContext == null ? edge : this.distanceContext).clone();
                continue;
            }
            length.add(this.distance_.getValue(edge, this.distanceName, this.distanceContext == null ? edge : this.distanceContext));
        }
        return length;
    }
}

