/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common.shortestPath;

import bridge.abstractClasses.AbstractScalar;
import bridge.algorithms.StepAlgo;
import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import bridge.interfaces.Map;
import bridge.interfaces.Path;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;

public abstract class ShortestPathWithSingleOrigin<V, E extends Link<V>, G extends Graph<V, E>>
extends StepAlgo<V, E> {
    public static final String VERTEX_DISTANCE = "vertexDistance";
    protected G g_;
    protected V start_;
    protected Map result;
    protected AbstractScalar infiniteDistance;
    private Map distance;
    private String nameOfValue_ = "distance";
    private Object mapContext;
    private HashMap<V, V> parcours_;
    private boolean init_;

    protected abstract Path<V, E> createPath();

    protected abstract Map createMap();

    public ShortestPathWithSingleOrigin(G g, boolean byStep) {
        super(byStep);
        this.g_ = g;
        this.mapContext = g;
        this.init_ = false;
    }

    public void valuateFromSource(V u) {
        this.start_ = u;
        if (!this.getDemoMode()) {
            this.run();
        }
    }

    protected void Initialize(AbstractScalar zero) {
        if (this.start_ == null) {
            throw new IllegalArgumentException("You must say from which node we compute distance");
        }
        this.init_ = true;
        this.result = this.getDemoMode() ? this.distance : this.createMap();
        this.parcours_ = new HashMap();
        this.parcours_.clear();
        this.result.putValue(this.start_, VERTEX_DISTANCE, this.g_, zero.clone());
        for (Object currentNode : this.g_.vertexSet()) {
            if (currentNode == this.start_) continue;
            this.result.putValue(currentNode, VERTEX_DISTANCE, this.g_, this.infiniteDistance.clone());
        }
    }

    protected boolean updateVerticesDistance(V v1, V v2, E edge) {
        String currentColor;
        AbstractScalar newDistance = this.getDistanceTo(v1).clone().add(this.distance.getValue(edge, this.nameOfValue_, this.mapContext == null ? edge : this.mapContext));
        if (newDistance.compareTo(this.getDistanceTo(v2)) < 0) {
            this.result.putValue(v2, VERTEX_DISTANCE, this.g_, newDistance);
            if (this.getDemoMode()) {
                V father = this.parcours_.get(v2);
                if (father != null) {
                    Link oldEdge = (Link)this.g_.getEdgesConnected(father, v2).iterator().next();
                    this.result.putString(oldEdge, "Color", "" + Color.blue.getRGB());
                }
                this.result.putString(edge, "Color", "" + Color.green.darker().getRGB());
            }
            this.parcours_.put(v2, v1);
            return true;
        }
        if (this.getDemoMode() && (currentColor = this.result.getString(edge, "Color")) != null && currentColor.equals("" + Color.red.getRGB())) {
            this.result.putString(edge, "Color", "" + Color.blue.getRGB());
        }
        return false;
    }

    public Path<V, E> getShortestPathTo(V v) {
        if (v == this.start_ || !this.init_ || this.getDistanceTo(v).compareTo(this.infiniteDistance) == 0) {
            return null;
        }
        Path<V, Link> newPath = this.createPath();
        V current = v;
        while (current != this.start_) {
            V prec = this.parcours_.get(current);
            Iterator edgeIt = this.g_.outEdges(prec).iterator();
            Link currentEdge = null;
            while (edgeIt.hasNext()) {
                currentEdge = (Link)edgeIt.next();
                if (currentEdge.leadsTo(current)) break;
            }
            newPath.concat(currentEdge);
            current = prec;
        }
        return newPath;
    }

    public AbstractScalar getDistanceTo(Object v) {
        if (this.init_) {
            return this.result.getValue(v, VERTEX_DISTANCE, this.g_);
        }
        return this.infiniteDistance.clone();
    }

    public void setDistanceMap(Map m) {
        this.distance = m;
    }

    protected Map getDistanceMap() {
        return this.distance;
    }

    public void setDistanceContext(Object context) {
        this.mapContext = context;
    }

    protected Object getDistanceContext() {
        return this.mapContext;
    }

    public void setDistanceName(String name) {
        this.nameOfValue_ = name;
    }

    protected String getDistanceName() {
        return this.nameOfValue_;
    }

    public void setInfiniteDistance(AbstractScalar max) {
        this.infiniteDistance = max.clone();
    }

    protected void finalize() throws Throwable {
        if (this.result != null) {
            this.result.clear();
            this.result = null;
        }
        this.parcours_.clear();
        this.parcours_ = null;
    }
}

