/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.directed;

import bridge.abstractClasses.AbstractScalar;
import bridge.algorithms.StepAlgo;
import bridge.algorithms.common.AugmentingPath;
import bridge.interfaces.Arc;
import bridge.interfaces.Flow;
import bridge.interfaces.Graph;
import bridge.interfaces.HierarchicalSet;
import bridge.interfaces.Map;
import bridge.interfaces.Path;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;

public abstract class EdmondsKarp<V, A extends Arc<V>, G extends Graph<V, A>>
extends StepAlgo<V, A> {
    private G graph_;
    private Map capacityMap;
    private V source_;
    private V destination_;
    public static final String residualCapacityName = "EDMONDS_KARP_RESIDUAL_CAPACITY_NAME";
    public static final String flowName = "EDMONDS_KARP_FLOW_NAME";
    private String capacityName = "Capacity";
    private Object capacityContext;
    private G graphCopy_;
    private HierarchicalSet<V> sourceSet_;
    private HierarchicalSet<V> destinationSet_;

    protected abstract G createGraph(HierarchicalSet<V> var1);

    protected abstract AugmentingPath<V, A, G> createAugmentingPath(G var1);

    protected abstract Flow<V, A> createSTFlow(G var1);

    protected abstract A createArc(V var1, V var2);

    public EdmondsKarp(G g, Map map) {
        this(g, map, false);
    }

    public EdmondsKarp(G g, Map map, boolean stepMode) {
        super(stepMode);
        this.graph_ = g;
        this.capacityMap = map;
        this.capacityContext = g;
    }

    private void initFlot() {
        for (Arc current : this.graphCopy_.edgeSet()) {
            AbstractScalar capacity = this.capacityMap.getValue(current, this.capacityName, this.capacityContext == null ? current : this.capacityContext).clone();
            this.capacityMap.putValue(current, flowName, this.capacityContext == null ? current : this.capacityContext, capacity.zero());
            this.capacityMap.putValue(current, residualCapacityName, this.capacityContext == null ? current : this.capacityContext, capacity);
        }
    }

    private G getCopy() {
        this.graphCopy_ = this.createGraph(this.graph_.vertexSet());
        Iterator itArcSet = this.graph_.edgeSet().iterator();
        while (itArcSet.hasNext()) {
            this.graphCopy_.addEdge((Arc)((Arc)itArcSet.next()));
        }
        return this.graphCopy_;
    }

    public void setSource(V source) {
        this.source_ = source;
    }

    public void setDestination(V destination) {
        this.destination_ = destination;
    }

    public void setCapacityName(String name) {
        this.capacityName = name;
    }

    public void setCapacityContext(Object context) {
        this.capacityContext = context;
    }

    private void updateResidualGraph(Path<V, A> bestPath, AbstractScalar bestFlow) {
        Iterator<A> pathIt = bestPath.edgeIterator(bestPath.getFirstVertex());
        while (pathIt.hasNext()) {
            Arc currentArc = (Arc)pathIt.next();
            Arc<Object> arc = null;
            AbstractScalar flow = this.capacityMap.getValue(currentArc, flowName, this.capacityContext == null ? currentArc : this.capacityContext);
            flow.add(bestFlow);
            if (this.getDemoMode()) {
                this.capacityMap.putValue(currentArc, flowName, this.capacityContext == null ? currentArc : this.capacityContext, flow);
            }
            Object tail = currentArc.getTail();
            Object head = currentArc.getHead();
            Iterator it = this.graphCopy_.getEdgesConnected(head, tail).iterator();
            if (it.hasNext()) {
                arc = (Arc)it.next();
                AbstractScalar revFlow = this.capacityMap.getValue(arc, flowName, this.capacityContext == null ? arc : this.capacityContext).subtract(bestFlow);
                if (this.getDemoMode()) {
                    this.capacityMap.putValue(arc, flowName, this.capacityContext == null ? arc : this.capacityContext, revFlow);
                }
                AbstractScalar residualCapacity = this.capacityMap.getValue(arc, residualCapacityName, this.capacityContext == null ? arc : this.capacityContext).add(bestFlow);
                if (this.getDemoMode()) {
                    this.capacityMap.putValue(arc, residualCapacityName, this.capacityContext == null ? arc : this.capacityContext, residualCapacity);
                }
            } else {
                HierarchicalSet connectingEdge = this.graph_.getEdgesConnected(head, tail);
                if (connectingEdge.size() == 0) {
                    arc = this.createArc(head, tail);
                    this.capacityMap.putValue(arc, flowName, this.capacityContext == null ? arc : this.capacityContext, bestFlow.clone().negate());
                } else {
                    arc = (Arc)connectingEdge.iterator().next();
                    this.capacityMap.putValue(arc, flowName, this.capacityContext == null ? arc : this.capacityContext, flow.zero());
                }
                this.graphCopy_.addEdge((Arc)arc);
                this.capacityMap.putValue(arc, residualCapacityName, this.capacityContext == null ? arc : this.capacityContext, bestFlow.clone());
            }
            AbstractScalar capacity = this.capacityMap.getValue(currentArc, residualCapacityName, this.capacityContext == null ? currentArc : this.capacityContext);
            capacity.subtract(bestFlow);
            if (capacity.intValue() == 0) {
                this.graphCopy_.removeEdge(currentArc);
            }
            if (this.capacityMap.getValue(arc, residualCapacityName, this.capacityContext == null ? arc : this.capacityContext).intValue() == 0) {
                this.graphCopy_.removeEdge(arc);
            }
            if (!this.getDemoMode()) continue;
            this.capacityMap.putValue(currentArc, residualCapacityName, this.capacityContext == null ? currentArc : this.capacityContext, capacity);
            this.capacityMap.putString(currentArc, "Color", "" + Color.blue.getRGB());
        }
    }

    private void computeSourceAndDestinationSet() {
        HashSet<V> visitedVertices = new HashSet<V>(this.graphCopy_.vertexSet().size() * 2);
        HashSet destinationSet = new HashSet(this.graphCopy_.vertexSet());
        HashSet sourceSet = new HashSet(this.graphCopy_.vertexSet().size() * 2);
        class RecAux {
            private final /* synthetic */ HashSet val$sourceSet;
            private final /* synthetic */ HashSet val$destinationSet;
            private final /* synthetic */ HashSet val$visitedVertices;

            RecAux(HashSet hashSet, HashSet hashSet2, HashSet hashSet3) {
                this.val$sourceSet = hashSet;
                this.val$destinationSet = hashSet2;
                this.val$visitedVertices = hashSet3;
            }

            void call(V actualVertex) {
                this.val$sourceSet.add(actualVertex);
                this.val$destinationSet.remove(actualVertex);
                for (Arc outArc : EdmondsKarp.this.graphCopy_.outEdges(actualVertex)) {
                    AbstractScalar capacity = EdmondsKarp.this.capacityMap.getValue(outArc, EdmondsKarp.residualCapacityName);
                    if (capacity.compareTo(capacity.zero()) <= 0 || !this.val$visitedVertices.add(outArc.getHead())) continue;
                    this.call(outArc.getHead());
                }
            }
        }
        RecAux recAux = new RecAux(sourceSet, destinationSet, visitedVertices);
        assert (this.source_ != null);
        assert (this.destination_ != null);
        visitedVertices.add(this.source_);
        recAux.call(this.source_);
        this.destinationSet_ = this.graphCopy_.vertexSet().newSubSet(destinationSet.iterator());
        this.sourceSet_ = this.graphCopy_.vertexSet().newSubSet(sourceSet.iterator());
    }

    public Flow<V, A> getFlow() {
        AbstractScalar maxFlow = null;
        for (Arc currentArc : this.graph_.outEdges(this.source_)) {
            if (maxFlow == null) {
                maxFlow = this.capacityMap.getValue(currentArc, flowName, this.capacityContext == null ? currentArc : this.capacityContext).clone();
                continue;
            }
            maxFlow.add(this.capacityMap.getValue(currentArc, flowName, this.capacityContext == null ? currentArc : this.capacityContext));
        }
        Flow<V, Arc> result = this.createSTFlow(this.graph_);
        result.setFlow(this.source_, this.destination_, maxFlow);
        for (Arc currentArc : this.graph_.edgeSet()) {
            AbstractScalar currentFlow = this.capacityMap.getValue(currentArc, flowName, this.capacityContext == null ? currentArc : this.capacityContext);
            if (currentFlow.compareTo(currentFlow.zero()) <= 0) continue;
            result.setFlow(currentArc, currentFlow.clone());
        }
        if (result.verify()) {
            System.err.println("Warning : The flow compute by Edmonds-Karp is not consistant");
        }
        return result;
    }

    public HierarchicalSet<V> getDestinationSet() {
        if (this.destinationSet_ == null) {
            this.computeSourceAndDestinationSet();
        }
        return this.destinationSet_;
    }

    public HierarchicalSet<V> getSourceSet() {
        if (this.destinationSet_ == null) {
            this.computeSourceAndDestinationSet();
        }
        return this.sourceSet_;
    }

    public HierarchicalSet<A> getLinkSet() {
        if (this.destinationSet_ == null) {
            this.computeSourceAndDestinationSet();
        }
        HashSet<Arc> result = new HashSet<Arc>();
        for (Object vertex : this.sourceSet_) {
            for (Arc link : this.graph_.outEdges(vertex)) {
                if (this.sourceSet_.contains(link.getOpposite(vertex))) continue;
                result.add(link);
            }
        }
        return this.graph_.edgeSet().newSubSet(result.iterator());
    }

    @Override
    public void run() {
        Path<V, A> bestPath;
        if (this.source_ == null || this.destination_ == null) {
            throw new IllegalStateException("You must specify source and destination");
        }
        this.graphCopy_ = this.getCopy();
        this.initFlot();
        AugmentingPath<V, A, G> f = this.createAugmentingPath(this.graphCopy_);
        f.setCapacityMap(this.capacityMap);
        f.setCapacityName(residualCapacityName);
        f.setCapacityContext(this.capacityContext);
        if (this.getDemoMode()) {
            this.notifyGraphDisplayRequest(this.graphCopy_, "Residual Graph");
            this.notifyLabelEdgesRequest(this.graphCopy_, this.capacityMap, this.capacityContext, "$(EDMONDS_KARP_RESIDUAL_CAPACITY_NAME)");
        }
        while ((bestPath = f.getBestPath(this.source_, this.destination_)).length() != 0) {
            AbstractScalar bestFlow = f.getFlow();
            if (this.getDemoMode()) {
                Iterator<A> pathIt = bestPath.edgeIterator(bestPath.getFirstVertex());
                while (pathIt.hasNext()) {
                    Arc currentArc = (Arc)pathIt.next();
                    if (!this.getDemoMode()) continue;
                    this.capacityMap.putString(currentArc, "Color", "" + Color.red.getRGB());
                }
                this.pause();
            }
            this.updateResidualGraph(bestPath, bestFlow);
            this.pause();
        }
        this.ends();
    }
}

