/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.undirected;

import bridge.abstractClasses.AbstractScalar;
import bridge.algorithms.StepAlgo;
import bridge.interfaces.Edge;
import bridge.interfaces.Graph;
import bridge.interfaces.Map;
import java.awt.Color;
import java.util.HashMap;
import mascoptLib.numeric.MascoptDouble;
import tools.dataStructures.FibonacciHeap;

public abstract class PrimST<V, E extends Edge<V>>
extends StepAlgo<V, E> {
    public static final String VERTEX_WEIGHT_NAME = "PRIMST_VERTEX_WEIGHT";
    private Graph<V, E> graph;
    private Graph<V, E> result;
    private HashMap<V, E> mst;
    private Map mymap;
    private String lengthName = "Length";
    private Object lengthContext;
    private AbstractScalar infiniteValue = new MascoptDouble(Double.MAX_VALUE);
    private AbstractScalar mstWeigth = null;
    private V initialVertex = null;

    protected abstract Graph<V, E> createGraph(Graph<V, E> var1);

    public PrimST(Graph<V, E> g, Map map) {
        this(g, map, false);
    }

    public PrimST(Graph<V, E> g, Map m, boolean demoMode) {
        super(demoMode);
        this.graph = g;
        this.mymap = m;
        this.mst = new HashMap();
    }

    public void setInitialVertex(V initialVertex) {
        if (!this.graph.vertexSet().contains(initialVertex)) {
            throw new IllegalArgumentException(initialVertex + " doesn't belong to " + this.graph);
        }
        this.initialVertex = initialVertex;
    }

    public void setLengthName(String name) {
        this.lengthName = name;
    }

    public void setLengthContext(Object context) {
        this.lengthContext = context;
    }

    public void setInfiniteValue(AbstractScalar infinity) {
        this.infiniteValue = infinity;
    }

    @Override
    public void run() {
        this.result = this.createGraph(this.graph);
        FibonacciHeap<Object, AbstractScalar> heap = new FibonacciHeap<Object, AbstractScalar>();
        for (Object currentVertex : this.graph.vertexSet()) {
            if (this.initialVertex == null) {
                this.initialVertex = currentVertex;
            }
            heap.insert(currentVertex, this.infiniteValue);
            if (!this.getDemoMode()) continue;
            this.mymap.putValue(currentVertex, VERTEX_WEIGHT_NAME, this.graph, this.infiniteValue);
        }
        heap.FibHeapDecreaseKey(this.initialVertex, this.infiniteValue.zero());
        if (this.getDemoMode()) {
            this.mymap.putValue(this.initialVertex, VERTEX_WEIGHT_NAME, this.graph, this.infiniteValue.zero());
        }
        this.pause();
        while (!heap.isEmpty()) {
            Object currentVertex;
            currentVertex = heap.deleteMin();
            if (this.getDemoMode()) {
                this.mymap.putString(currentVertex, "Color", "" + Color.green.getRGB());
            }
            this.pause();
            for (Edge currentEdge : this.graph.outEdges(currentVertex)) {
                Object opposite = currentEdge.getOpposite(currentVertex);
                AbstractScalar edgeValue = this.mymap.getValue(currentEdge, this.lengthName, this.lengthContext == null ? currentEdge : this.lengthContext);
                if (this.mstWeigth == null) {
                    this.mstWeigth = edgeValue.zero();
                }
                if (!heap.contains(opposite)) continue;
                if (this.getDemoMode()) {
                    this.mymap.putString(currentEdge, "Color", "" + Color.red.getRGB());
                }
                this.pause();
                if (heap.contains(opposite) && edgeValue.compareTo((AbstractScalar)heap.getValueOf(opposite)) < 0) {
                    Edge oldEdge = (Edge)this.mst.get(opposite);
                    if (oldEdge != null) {
                        this.result.removeEdge(oldEdge);
                    }
                    this.result.addEdge(currentEdge);
                    if (this.getDemoMode()) {
                        if (oldEdge != null) {
                            this.mymap.putString(oldEdge, "Color", "" + Color.blue.getRGB());
                        }
                        this.mymap.putString(currentEdge, "Color", "" + Color.green.getRGB());
                        if (this.getDemoMode()) {
                            this.mymap.putValue(opposite, VERTEX_WEIGHT_NAME, this.graph, edgeValue);
                        }
                    }
                    this.mst.put((Edge)opposite, (E)currentEdge);
                    this.mstWeigth.add(edgeValue);
                    heap.FibHeapDecreaseKey(opposite, edgeValue);
                }
                if (this.getDemoMode() && (!heap.contains(opposite) || this.mymap.getString(currentEdge, "Color").equals("" + Color.red.getRGB()))) {
                    this.mymap.putString(currentEdge, "Color", "" + Color.blue.getRGB());
                }
                this.pause();
            }
            if (!this.getDemoMode()) continue;
            this.mymap.putString(currentVertex, "Color", "" + Color.red.getRGB());
        }
        this.ends();
    }

    public Graph<V, E> getMST() {
        return this.result;
    }

    public AbstractScalar getMSTWeight() {
        if (this.mstWeigth == null) {
            return null;
        }
        return this.mstWeigth.clone();
    }
}

