/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.undirected.minCut;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.Edge;
import bridge.interfaces.Graph;
import bridge.interfaces.Map;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import mascoptLib.numeric.MascoptInteger;

public abstract class StoerWagnerMinCut<V, E extends Edge<V>> {
    private Graph<V, E> graphCopy_;
    private Map distanceMap_;
    private String distanceName_;
    private Object distanceContext_;
    private HashMap<E, AbstractScalar> edgeDistance_ = new HashMap();

    protected abstract Graph<V, E> copyGraph(Graph<V, E> var1);

    public void setGraph(Graph<V, E> graph) {
        this.graphCopy_ = this.copyGraph(graph);
    }

    public void setDistanceMap(Map map) {
        this.distanceMap_ = map;
    }

    public void setDistanceName(String name) {
        this.distanceName_ = name;
    }

    public void setDistanceContext(Object context) {
        this.distanceContext_ = context;
    }

    private void copyEdgeDistanceToHashMap() {
        for (Edge e : this.graphCopy_.edgeSet()) {
            this.edgeDistance_.put(e, this.distanceMap_ == null ? new MascoptInteger(1) : this.distanceMap_.getValue(e, this.distanceName_, this.distanceContext_ == null ? e : this.distanceContext_).clone());
        }
    }

    public AbstractScalar compute() {
        this.copyEdgeDistanceToHashMap();
        return this.compute(this.graphCopy_.vertexSet().iterator().next());
    }

    private AbstractScalar cutWeight(V vertex, Set<V> set) {
        AbstractScalar result = null;
        assert (!this.graphCopy_.outEdges(vertex).isEmpty());
        for (Edge edge : this.graphCopy_.outEdges(vertex)) {
            if (!set.contains(edge.getOpposite(vertex))) continue;
            if (result == null) {
                result = this.edgeDistance_.get(edge).clone();
                continue;
            }
            result.add(this.edgeDistance_.get(edge));
        }
        return result;
    }

    private void addOrUpgradeEdge(V vertex1, V vertex2, AbstractScalar value, HashMap<E, AbstractScalar> map) {
        if (this.graphCopy_.getEdgesConnected(vertex1, vertex2).size() == 0) {
            this.graphCopy_.addEdge(vertex1, vertex2);
            Edge edge = (Edge)this.graphCopy_.getEdgesConnected(vertex1, vertex2).iterator().next();
            map.put(edge, value.clone());
        } else {
            Edge edge = (Edge)this.graphCopy_.getEdgesConnected(vertex1, vertex2).iterator().next();
            map.get(edge).add(value);
        }
    }

    private void merge(V vertex1, V vertex2) {
        assert (vertex1 != null);
        assert (vertex2 != null);
        assert (this.graphCopy_.vertexSet().contains(vertex1));
        assert (this.graphCopy_.vertexSet().contains(vertex2));
        Iterator iterator = this.graphCopy_.getEdgesConnected(vertex1, vertex2).iterator();
        if (iterator.hasNext()) {
            this.graphCopy_.removeEdge(iterator.next());
        }
        for (Edge edge : this.graphCopy_.outEdges(vertex2)) {
            this.addOrUpgradeEdge(vertex1, edge.getOpposite(vertex2), this.edgeDistance_.get(edge), this.edgeDistance_);
        }
        this.graphCopy_.removeVertex(vertex2);
    }

    private AbstractScalar minCutPhaseSimple(V vertex) {
        HashSet<V> setIn = new HashSet<V>(this.graphCopy_.vertexSet().size() * 2);
        HashSet<V> setOut = new HashSet<V>(this.graphCopy_.vertexSet());
        setIn.add(vertex);
        setOut.remove(vertex);
        AbstractScalar lastCut = null;
        Object lastVertex = null;
        Object lastLastVertex = null;
        while (!setOut.isEmpty()) {
            lastLastVertex = lastVertex;
            lastCut = null;
            for (Object vertexOut : setOut) {
                AbstractScalar maxActual = this.cutWeight(vertexOut, setIn);
                if (lastCut != null && maxActual.compareTo(lastCut) <= 0) continue;
                lastVertex = vertexOut;
                lastCut = maxActual;
            }
            setIn.add(lastVertex);
            setOut.remove(lastVertex);
        }
        if (lastLastVertex != null) {
            this.merge(lastVertex, lastLastVertex);
        } else {
            this.merge(lastVertex, vertex);
        }
        return lastCut;
    }

    private AbstractScalar compute(V oneVertex) {
        AbstractScalar minCandidate = this.minCutPhaseSimple(oneVertex);
        while (this.graphCopy_.vertexSet().size() > 1) {
            AbstractScalar minActual = this.minCutPhaseSimple(oneVertex);
            if (minCandidate.compareTo(minActual) <= 0) continue;
            minCandidate = minActual;
        }
        return minCandidate;
    }
}

