/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algorithms.coloredgraph;

import java.util.HashSet;
import java.util.StringTokenizer;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.numeric.MascoptAbstractScalar;
import mascoptLib.numeric.MascoptInteger;

public class NormalizeColoredGraph<E extends MascoptAbstractLink> {
    private MascoptAbstractGraph<E> graph;
    private MascoptAbstractGraph<E> normalizedGraph;
    private MascoptMap listColorMap_;
    private String listColorName_;
    private MascoptObject listColorContext_;
    private MascoptMap colorMap_;
    private String colorName_;
    private MascoptObject colorContext_;
    private HashSet<ValueCopier> valuesToCopy_ = new HashSet();

    public NormalizeColoredGraph(MascoptAbstractGraph<E> g) {
        this.graph = g;
    }

    public void setListColorMap(MascoptMap map) {
        this.listColorMap_ = map;
    }

    public void setListColorName(String name) {
        this.listColorName_ = name;
    }

    public void setListColorContext(MascoptObject context) {
        this.listColorContext_ = context;
    }

    public void setColorMap(MascoptMap colorMap) {
        this.colorMap_ = colorMap;
    }

    public void setColorName(String name) {
        this.colorName_ = name;
    }

    public void setColorContext(MascoptObject context) {
        this.colorContext_ = context;
    }

    public void normalize() {
        MascoptAbstractLinkSet<E> abstractEdgeSet = this.graph.getFactory().getLinkSetFactory().newLinkSet(this.graph.vertexSet());
        this.normalizedGraph = this.graph.getFactory().getGraphFactory().newGraph(abstractEdgeSet);
        for (MascoptAbstractLink currentEdge : this.graph.edgeSet()) {
            String colorList = this.listColorMap_.getString(currentEdge, this.listColorName_, this.listColorContext_ == null ? currentEdge : this.listColorContext_);
            StringTokenizer colors = new StringTokenizer(colorList);
            int nbTokens = colors.countTokens();
            if (nbTokens == 1) {
                this.normalizedGraph.addEdge(currentEdge);
                this.colorMap_.putValue(currentEdge, this.colorName_, this.colorContext_ == null ? currentEdge : this.colorContext_, new MascoptInteger(colors.nextToken()));
                continue;
            }
            double deltaX = (currentEdge.toArray()[1].getX() - currentEdge.toArray()[0].getX()) / (double)nbTokens - 1.0;
            double deltaY = (currentEdge.toArray()[1].getY() - currentEdge.toArray()[0].getY()) / (double)nbTokens - 1.0;
            MascoptVertex[] tmp = new MascoptVertex[nbTokens + 1];
            tmp[0] = currentEdge.toArray()[0];
            int i = 1;
            while (i < nbTokens) {
                tmp[i] = new MascoptVertex(currentEdge.toArray()[0].getX() + deltaX * (double)i, currentEdge.toArray()[0].getY() + deltaY * (double)i);
                ++i;
            }
            tmp[nbTokens] = currentEdge.toArray()[1];
            i = 0;
            while (i < nbTokens) {
                this.normalizedGraph.addVertex(tmp[i + 1]);
                E newEdge = this.normalizedGraph.getFactory().getGraphFactory().newLink(tmp[i], tmp[i + 1]);
                this.normalizedGraph.addEdge(newEdge);
                this.colorMap_.putValue(newEdge, this.colorName_, this.colorContext_ == null ? newEdge : this.colorContext_, new MascoptInteger(colors.nextToken()));
                for (ValueCopier currentCopier : this.valuesToCopy_) {
                    currentCopier.makeCopy(currentEdge, (MascoptObject)newEdge);
                }
                ++i;
            }
        }
    }

    public MascoptAbstractGraph<E> getNormalizedGraph() {
        return this.normalizedGraph;
    }

    public void CopyValue(MascoptMap map, String name, MascoptObject context) {
        this.valuesToCopy_.add(new ValueCopier(map, name, context));
    }

    private class ValueCopier {
        private MascoptMap map_;
        private String name_;
        private MascoptObject context_;

        public ValueCopier(MascoptMap map, String name, MascoptObject context) {
            this.map_ = map;
            this.name_ = name;
            this.context_ = context;
        }

        public void makeCopy(MascoptObject oldPrincipalKey, MascoptObject newPrincipalKey) {
            MascoptAbstractScalar value = (MascoptAbstractScalar)this.map_.getValue(oldPrincipalKey, this.name_, this.context_ == null ? oldPrincipalKey : this.context_);
            this.map_.putValue(newPrincipalKey, this.name_, this.context_ == null ? newPrincipalKey : this.context_, value);
        }
    }
}

