/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algorithms.digraphs.flow;

import bridge.abstractClasses.AbstractScalar;
import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.algorithms.common.MascoptAugmentingPath;
import mascoptLib.algorithms.digraphs.route.interfaces.MultiFlowRouting;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptDiPath;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.numeric.MascoptDouble;

public class MascoptMultiFlowDecompositionInPaths {
    private static final String CAPACITY_NAME = "Capacity";
    private MascoptDiGraph linkGraph_;
    private MascoptDiGraph requestGraph_;
    private MultiFlowRouting multiFlow_;
    private double epsilon_ = 1.0E-7;

    public MascoptMultiFlowDecompositionInPaths(MultiFlowRouting multiFlow) {
        this.multiFlow_ = multiFlow;
    }

    public void setLinkGraph(MascoptDiGraph linkGraph) {
        this.linkGraph_ = linkGraph;
    }

    public void setRequestGraph(MascoptDiGraph requestGraph) {
        this.requestGraph_ = requestGraph;
    }

    private MascoptDiGraph getFlowGraph(MascoptArc request, MascoptMap capacityMap) {
        MascoptDiGraph result = new MascoptDiGraph(new MascoptArcSet((MascoptVertexSet)this.linkGraph_.vertexSet()));
        for (MascoptArc currentLink : this.linkGraph_.arcSet()) {
            double flowValue = this.multiFlow_.getFlowOnEdgeForRequest(currentLink, request);
            if (!(Math.abs(flowValue) > this.epsilon_)) continue;
            capacityMap.putValue(currentLink, CAPACITY_NAME, new MascoptDouble(flowValue));
            result.addEdge(currentLink);
        }
        return result;
    }

    public HashMap<MascoptDiPath, AbstractScalar> computeMultiFlowDecomposition() {
        HashMap<MascoptDiPath, AbstractScalar> result = new HashMap<MascoptDiPath, AbstractScalar>();
        MascoptMap capacityMap = new MascoptMap();
        Iterator requestIt = this.requestGraph_.arcSet().iterator();
        while (requestIt.hasNext()) {
            capacityMap.clear();
            MascoptArc currentRequest = (MascoptArc)requestIt.next();
            MascoptDiGraph workingGraph = this.getFlowGraph(currentRequest, capacityMap);
            MascoptAugmentingPath<MascoptArc> augmentingPath = new MascoptAugmentingPath<MascoptArc>(workingGraph);
            augmentingPath.setCapacityMap(capacityMap);
            augmentingPath.setCapacityName(CAPACITY_NAME);
            augmentingPath.setCapacityContext(null);
            augmentingPath.setCostMap(null);
            MascoptDiPath currentBestPath = (MascoptDiPath)augmentingPath.getBestPath(currentRequest.getTail(), currentRequest.getHead());
            while (currentBestPath.length() != 0) {
                AbstractScalar toSubstract = augmentingPath.getFlow();
                result.put(currentBestPath, toSubstract.clone());
                Iterator arcPathIt = currentBestPath.edgeIterator(currentBestPath.getFirstVertex());
                while (arcPathIt.hasNext()) {
                    MascoptArc currentArcPath = (MascoptArc)arcPathIt.next();
                    capacityMap.getValue(currentArcPath, CAPACITY_NAME).subtract(toSubstract);
                }
                currentBestPath = (MascoptDiPath)augmentingPath.getBestPath(currentRequest.getTail(), currentRequest.getHead());
            }
        }
        return result;
    }
}

