/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algorithms.digraphs.route.multiFlowRouting;

import java.util.HashMap;
import mascoptLib.algorithms.digraphs.route.interfaces.MultiFlowRouting;
import mascoptLib.algorithms.digraphs.route.multiFlowRouting.lowLevel.AddLinkFlowVariables;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.lpSolver.exception.LpException;
import mascoptLib.lpSolver.interfaces.LinearProgram;
import mascoptLib.lpSolver.interfaces.LpContinuousVariable;
import mascoptLib.lpSolver.interfaces.LpLinearContinuousExpr;
import mascoptLib.lpSolver.interfaces.LpLinearExpr;

public class LPMultiFlowRouting
implements MultiFlowRouting {
    private LinearProgram linearProgram_;
    private AddLinkFlowVariables lpFlow_;
    private MascoptDiGraph linkGraph_;
    private MascoptDiGraph requestsGraph_;
    private MascoptMap requestSizeMap_;
    private String requestSizeName_ = "Request Size";
    private MascoptObject requestSizeContext_;
    private boolean integerComputation_ = false;
    private boolean requestVariable_ = false;
    private HashMap<MascoptArc, LpLinearExpr> requestToRequestSizeLinearExpr_;

    public LPMultiFlowRouting(LinearProgram lp) {
        this.linearProgram_ = lp;
    }

    @Override
    public void setGraph(MascoptDiGraph g) {
        this.linkGraph_ = g;
    }

    @Override
    public void setRequestsGraph(MascoptDiGraph gr) {
        this.requestsGraph_ = gr;
    }

    @Override
    public void setRequestsValuesMap(MascoptMap m) {
        this.requestSizeMap_ = m;
    }

    @Override
    public void setRequestsValuesName(String name) {
        this.requestSizeName_ = name;
    }

    @Override
    public void setRequestsValuesContext(MascoptObject c) {
        this.requestSizeContext_ = c;
    }

    @Override
    public void setIntegerComputation(boolean state) {
        this.integerComputation_ = state;
    }

    public void setRequestToRequestSizeLinearExpr(HashMap<MascoptArc, LpLinearExpr> requestToRequestSizeLinearExpr) {
        this.requestVariable_ = true;
        this.requestToRequestSizeLinearExpr_ = requestToRequestSizeLinearExpr;
    }

    @Override
    public void preSolve() {
        this.lpFlow_ = new AddLinkFlowVariables(this.linkGraph_, this.requestsGraph_, this.requestSizeMap_, this.linearProgram_, this.integerComputation_);
        this.lpFlow_.setRequestValueName(this.requestSizeName_);
        this.lpFlow_.setRequestValueContext(this.requestSizeContext_);
        if (this.requestVariable_) {
            this.lpFlow_.setRequestToRequestSizeLinearExpr(this.requestToRequestSizeLinearExpr_);
        }
        this.lpFlow_.createFlow();
    }

    @Override
    public boolean solve() {
        try {
            return this.linearProgram_.solve();
        }
        catch (LpException e) {
            System.out.println(e);
            System.exit(1);
            return false;
        }
    }

    @Override
    public void postSolve() {
    }

    @Override
    public double getFlowOnEdgeForRequest(MascoptArc a, MascoptArc r) {
        return this.lpFlow_.getValueOfEdgeFlowForRequest(a, r);
    }

    @Override
    public double getFlowOnEdge(MascoptArc a) {
        return this.lpFlow_.getValueOfEdgeFlow(a);
    }

    public LpLinearContinuousExpr getVarOfEdgeFlow(MascoptArc e) {
        return this.lpFlow_.getExprOfEdgeFlow(e);
    }

    public LpContinuousVariable getVarOfEdgeFlowForRequest(MascoptArc a, MascoptArc r) {
        return this.lpFlow_.getVarOfEdgeFlowForRequest(a, r);
    }

    public LinearProgram getLinearProgram() {
        return this.linearProgram_;
    }

    protected MascoptDiGraph getLinkGraph() {
        return this.linkGraph_;
    }
}

