/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algorithms.digraphs.route.multiFlowRouting.lowLevel;

import bridge.interfaces.Map;
import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.lpSolver.exception.LpException;
import mascoptLib.lpSolver.interfaces.LinearProgram;
import mascoptLib.lpSolver.interfaces.LpContinuousVariable;
import mascoptLib.lpSolver.interfaces.LpIntegerVariable;
import mascoptLib.lpSolver.interfaces.LpLinearContinuousExpr;
import mascoptLib.lpSolver.interfaces.LpLinearExpr;

public class AddLinkFlowVariables {
    private MascoptDiGraph linkGraph_;
    private MascoptArcSet requests_;
    private Map requestSizeMap_;
    private LinearProgram linearProgramSolver_;
    private HashMap<MascoptArc, HashMap<MascoptArc, LpContinuousVariable>> linkRequestToFlowVariable_;
    private HashMap<MascoptArc, LpLinearContinuousExpr> linkToFlow_;
    private boolean useVariableForRequestSize_ = false;
    private HashMap<MascoptArc, LpLinearExpr> requestToRequestSizeLinearExpr_ = null;
    private String requestValueName = "Request Size";
    private Object requestValueContext;
    private boolean integerComputation_ = false;
    private static int MAX_FLOW_PER_REQUEST = Integer.MAX_VALUE;

    public AddLinkFlowVariables(MascoptDiGraph g, MascoptArcSet requests, MascoptMap data, LinearProgram linearProgram, boolean integerComputation) {
        this.linkGraph_ = g;
        this.requests_ = requests;
        this.linearProgramSolver_ = linearProgram;
        this.requestSizeMap_ = data;
        this.integerComputation_ = integerComputation;
        this.requestValueContext = requests;
        this.createVariables();
    }

    public AddLinkFlowVariables(MascoptDiGraph g, MascoptDiGraph requests, MascoptMap data, LinearProgram linearProgram, boolean integerComputation) {
        this(g, requests.arcSet(), data, linearProgram, integerComputation);
    }

    public void setRequestValueName(String name) {
        this.requestValueName = name;
    }

    public void setRequestValueContext(MascoptObject context) {
        this.requestValueContext = context;
    }

    public void setRequestToRequestSizeLinearExpr(HashMap<MascoptArc, LpLinearExpr> requestToLpExpr) {
        this.useVariableForRequestSize_ = true;
        this.requestToRequestSizeLinearExpr_ = requestToLpExpr;
    }

    public void createFlow() {
        try {
            for (MascoptArc r : this.requests_) {
                MascoptVertex requestStart = r.getTail();
                MascoptVertex requestEnd = r.getHead();
                double r_size = 0.0;
                if (!this.useVariableForRequestSize_) {
                    r_size = this.requestSizeMap_.getValue(r, this.requestValueName, this.requestValueContext == null ? r : this.requestValueContext).doubleValue();
                }
                for (MascoptVertex n : this.linkGraph_.vertexSet()) {
                    Iterator itEdge = this.linkGraph_.inEdges(n).iterator();
                    LpLinearContinuousExpr in = this.linearProgramSolver_.newLinearContinuousExpr();
                    while (itEdge.hasNext()) {
                        MascoptAbstractLink edgeHere = (MascoptAbstractLink)itEdge.next();
                        in.addTerm(1.0, this.getVarOfEdgeFlowForRequest(edgeHere, r));
                    }
                    itEdge = this.linkGraph_.outEdges(n).iterator();
                    LpLinearContinuousExpr out = this.linearProgramSolver_.newLinearContinuousExpr();
                    while (itEdge.hasNext()) {
                        MascoptAbstractLink edgeHere = (MascoptAbstractLink)itEdge.next();
                        out.addTerm(1.0, this.getVarOfEdgeFlowForRequest(edgeHere, r));
                    }
                    if (n == requestStart) {
                        if (!this.useVariableForRequestSize_) {
                            this.linearProgramSolver_.addEqualConstraint((LpLinearExpr)out, r_size, "Kirchoff_output_" + r.getId() + "_" + n.getId());
                        } else {
                            this.linearProgramSolver_.addEqualConstraint((LpLinearExpr)out, this.getLinearNumExprForRequest(r), "Kirchoff_output_" + r.getId() + "_" + n.getId());
                        }
                        this.linearProgramSolver_.addEqualConstraint((LpLinearExpr)in, 0.0, "Kirchoff_input_" + r.getId() + "_" + n.getId());
                        continue;
                    }
                    if (n == requestEnd) {
                        if (!this.useVariableForRequestSize_) {
                            this.linearProgramSolver_.addEqualConstraint((LpLinearExpr)in, r_size, "Kirchoff_input_" + r.getId() + "_" + n.getId());
                        } else {
                            this.linearProgramSolver_.addEqualConstraint((LpLinearExpr)in, this.getLinearNumExprForRequest(r), "Kirchoff_input_" + r.getId() + "_" + n.getId());
                        }
                        this.linearProgramSolver_.addEqualConstraint((LpLinearExpr)out, 0.0, "Kirchoff_output_" + r.getId() + "_" + n.getId());
                        continue;
                    }
                    this.linearProgramSolver_.addEqualConstraint((LpLinearExpr)in, out, "Kirchoff_in_equal_out_" + r.getId() + "_" + n.getId());
                }
            }
        }
        catch (LpException exception) {
            System.err.println("Error in Lp constraints " + exception);
        }
    }

    public LpContinuousVariable getVarOfEdgeFlowForRequest(MascoptAbstractLink e, MascoptArc r) {
        return this.linkRequestToFlowVariable_.get(e).get(r);
    }

    public double getValueOfEdgeFlowForRequest(MascoptAbstractLink e, MascoptArc r) {
        double d = 0.0;
        try {
            d = this.linearProgramSolver_.getVarValue(this.getVarOfEdgeFlowForRequest(e, r));
        }
        catch (LpException exception) {
            System.err.println("Error in Lp return variable " + exception);
        }
        return d;
    }

    public LpLinearContinuousExpr getExprOfEdgeFlow(MascoptAbstractLink e) {
        return this.linkToFlow_.get(e);
    }

    public double getValueOfEdgeFlow(MascoptAbstractLink e) {
        double d = 0.0;
        try {
            d = this.linearProgramSolver_.getExprValue(this.getExprOfEdgeFlow(e));
        }
        catch (LpException exception) {
            System.err.println("Error in Lp return variable " + exception);
        }
        return d;
    }

    protected MascoptArcSet getRequestArcSet() {
        return this.requests_;
    }

    protected MascoptDiGraph getLinkGraph() {
        return this.linkGraph_;
    }

    protected LinearProgram getLP() {
        return this.linearProgramSolver_;
    }

    protected LpLinearExpr getLinearNumExprForRequest(MascoptArc r) {
        return this.requestToRequestSizeLinearExpr_.get(r);
    }

    private void createVariables() {
        this.linkRequestToFlowVariable_ = new HashMap();
        this.linkToFlow_ = new HashMap();
        for (MascoptArc currentLink : this.linkGraph_.edgeSet()) {
            Iterator itArcRequest = this.requests_.iterator();
            HashMap<MascoptArc, LpIntegerVariable> requestToFlowVariable = new HashMap<MascoptArc, LpIntegerVariable>();
            this.linkRequestToFlowVariable_.put(currentLink, requestToFlowVariable);
            try {
                LpLinearContinuousExpr flow_on_edge = this.linearProgramSolver_.newLinearContinuousExpr();
                this.linkToFlow_.put(currentLink, flow_on_edge);
                while (itArcRequest.hasNext()) {
                    MascoptArc r = (MascoptArc)itArcRequest.next();
                    LpContinuousVariable var = null;
                    var = this.integerComputation_ ? this.linearProgramSolver_.newIntegerVariable(0, MAX_FLOW_PER_REQUEST, "IntVar_L" + currentLink.getId() + "_R" + r.getId()) : this.linearProgramSolver_.newContinuousVariable(0.0, MAX_FLOW_PER_REQUEST, "ContVar_L" + currentLink.getId() + "_R" + r.getId());
                    requestToFlowVariable.put(r, (LpIntegerVariable)var);
                    flow_on_edge.addTerm(1.0, var);
                }
            }
            catch (LpException exception) {
                System.err.println("Error in Lp variable creation " + exception);
            }
        }
    }
}

