/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptCycle;
import mascoptLib.core.MascoptDiCycle;
import mascoptLib.core.MascoptDiPath;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptPath;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.factory.MascoptDirectedMetaFactory;
import mascoptLib.core.factory.MascoptUndirectedMetaFactory;

public class MascoptAbstractCycleTest
extends TestCase {
    private static final int NB_VERTEX = 100;
    private MascoptCycle cycle;
    private MascoptDiCycle diCycle;
    private MascoptVertex[] vertices;
    private MascoptEdge[] edges;
    private MascoptArc[] arcs;

    protected void setUp() throws Exception {
        int j;
        super.setUp();
        this.vertices = new MascoptVertex[100];
        int i = 0;
        while (i < 100) {
            this.vertices[i] = new MascoptVertex();
            ++i;
        }
        this.edges = new MascoptEdge[10000];
        i = 0;
        while (i < 100) {
            j = 0;
            while (j < 100) {
                this.edges[i * 100 + j] = new MascoptEdge(this.vertices[i], this.vertices[j]);
                ++j;
            }
            ++i;
        }
        this.arcs = new MascoptArc[10000];
        i = 0;
        while (i < 100) {
            j = 0;
            while (j < 100) {
                this.arcs[i * 100 + j] = new MascoptArc(this.vertices[i], this.vertices[j]);
                ++j;
            }
            ++i;
        }
        MascoptPath path = new MascoptPath();
        path.concat(this.edges[1]);
        path.concat(this.edges[102]);
        path.concat(this.edges[203]);
        path.concat(this.edges[304]);
        path.concat(this.edges[405]);
        this.cycle = new MascoptCycle(path, this.edges[500]);
        MascoptDiPath diPath = new MascoptDiPath();
        diPath.concat(this.arcs[1]);
        diPath.concat(this.arcs[102]);
        diPath.concat(this.arcs[203]);
        diPath.concat(this.arcs[304]);
        diPath.concat(this.arcs[405]);
        this.diCycle = new MascoptDiCycle(diPath, this.arcs[500]);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.vertices = null;
        this.edges = null;
        this.arcs = null;
        this.cycle = null;
        this.diCycle = null;
    }

    public void testMascoptAbstractCycle() {
        MascoptPath p = new MascoptPath();
        p.concat(this.edges[1]);
        try {
            new MascoptCycle(p, this.edges[2]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MascoptDiPath dp = new MascoptDiPath();
        dp.concat(this.arcs[1]);
        try {
            new MascoptDiCycle(dp, this.arcs[2]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        p = new MascoptPath();
        try {
            new MascoptCycle(p, this.edges[1]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        dp = new MascoptDiPath();
        try {
            new MascoptDiCycle(dp, this.arcs[1]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        p = new MascoptPath();
        try {
            new MascoptCycle(p, this.edges[0]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        dp = new MascoptDiPath();
        try {
            new MascoptDiCycle(dp, this.arcs[0]);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        dp = new MascoptDiPath();
        dp.concat(this.arcs[1]);
        try {
            new MascoptDiCycle(dp, this.arcs[1]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testContainsMascoptVertex() {
        Assert.assertTrue((boolean)this.cycle.contains(this.vertices[0]));
        Assert.assertTrue((boolean)this.cycle.contains(this.vertices[1]));
        Assert.assertTrue((boolean)this.cycle.contains(this.vertices[2]));
        Assert.assertTrue((boolean)this.cycle.contains(this.vertices[3]));
        Assert.assertTrue((boolean)this.cycle.contains(this.vertices[4]));
        Assert.assertTrue((boolean)this.cycle.contains(this.vertices[5]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.vertices[0]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.vertices[1]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.vertices[2]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.vertices[3]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.vertices[4]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.vertices[5]));
    }

    public void testContainsMascoptAbstractEdge() {
        Assert.assertTrue((boolean)this.cycle.contains(this.edges[1]));
        Assert.assertTrue((boolean)this.cycle.contains(this.edges[102]));
        Assert.assertTrue((boolean)this.cycle.contains(this.edges[203]));
        Assert.assertTrue((boolean)this.cycle.contains(this.edges[304]));
        Assert.assertTrue((boolean)this.cycle.contains(this.edges[405]));
        Assert.assertTrue((boolean)this.cycle.contains(this.edges[500]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.arcs[1]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.arcs[102]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.arcs[203]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.arcs[304]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.arcs[405]));
        Assert.assertTrue((boolean)this.diCycle.contains(this.arcs[500]));
    }

    public void testVertexIterator() {
        Iterator<MascoptVertex> verticesIt = this.cycle.vertexIterator();
        Assert.assertTrue((this.vertices[0] == verticesIt.next() ? 1 : 0) != 0);
        try {
            verticesIt.remove();
            MascoptAbstractCycleTest.assertTrue((boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((this.vertices[1] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[2] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[3] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[4] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[5] == verticesIt.next() ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertFalse((boolean)verticesIt.hasNext());
        verticesIt = this.diCycle.vertexIterator();
        Assert.assertTrue((this.vertices[0] == verticesIt.next() ? 1 : 0) != 0);
        try {
            verticesIt.remove();
            MascoptAbstractCycleTest.assertTrue((boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((this.vertices[1] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[2] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[3] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[4] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[5] == verticesIt.next() ? 1 : 0) != 0);
    }

    public void testVertexIteratorMascoptVertex() {
        Iterator<MascoptVertex> verticesIt = this.cycle.vertexIterator(this.vertices[4]);
        Assert.assertTrue((this.vertices[4] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[5] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[0] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[1] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[2] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[3] == verticesIt.next() ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertFalse((boolean)verticesIt.hasNext());
        verticesIt = this.diCycle.vertexIterator(this.vertices[2]);
        Assert.assertTrue((this.vertices[2] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[3] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[4] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[5] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[0] == verticesIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.vertices[1] == verticesIt.next() ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertFalse((boolean)verticesIt.hasNext());
    }

    public void testEdgeIterator() {
        Iterator edgeIt = this.cycle.edgeIterator();
        Assert.assertTrue((this.edges[1] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[102] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[203] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[304] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[405] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[500] == edgeIt.next() ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertFalse((boolean)edgeIt.hasNext());
        Iterator arcIt = this.diCycle.edgeIterator();
        Assert.assertTrue((this.arcs[1] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[102] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[203] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[304] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[405] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[500] == arcIt.next() ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertFalse((boolean)arcIt.hasNext());
    }

    public void testEdgeIteratorMascoptAbstractEdge() {
        Iterator<MascoptEdge> edgeIt = this.cycle.edgeIterator(this.edges[304]);
        Assert.assertTrue((this.edges[304] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[405] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[500] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[1] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[102] == edgeIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.edges[203] == edgeIt.next() ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertFalse((boolean)edgeIt.hasNext());
        Iterator<MascoptArc> arcIt = this.diCycle.edgeIterator(this.arcs[102]);
        Assert.assertTrue((this.arcs[102] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[203] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[304] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[405] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[500] == arcIt.next() ? 1 : 0) != 0);
        Assert.assertTrue((this.arcs[1] == arcIt.next() ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertFalse((boolean)arcIt.hasNext());
    }

    public void testClone() {
        MascoptCycle copyCycle = this.cycle.clone();
        MascoptAbstractCycleTest.assertTrue((copyCycle.length() == this.cycle.length() ? 1 : 0) != 0);
        Iterator<MascoptVertex> originalCycleVertexIt = this.cycle.vertexIterator();
        Iterator<MascoptVertex> copyCycleVertexIt = copyCycle.vertexIterator();
        while (originalCycleVertexIt.hasNext()) {
            MascoptAbstractCycleTest.assertTrue((boolean)copyCycleVertexIt.hasNext());
            MascoptVertex v1 = originalCycleVertexIt.next();
            MascoptVertex v2 = copyCycleVertexIt.next();
            MascoptAbstractCycleTest.assertTrue((v1 == v2 ? 1 : 0) != 0);
        }
        Iterator originalCycleEdgeIt = this.cycle.edgeIterator();
        Iterator copyCycleEdgeIt = this.cycle.edgeIterator();
        while (originalCycleEdgeIt.hasNext()) {
            MascoptAbstractCycleTest.assertTrue((boolean)copyCycleEdgeIt.hasNext());
            MascoptEdge e1 = (MascoptEdge)originalCycleEdgeIt.next();
            MascoptEdge e2 = (MascoptEdge)copyCycleEdgeIt.next();
            MascoptAbstractCycleTest.assertTrue((e1 == e2 ? 1 : 0) != 0);
        }
        MascoptDiCycle copyDiCycle = this.diCycle.clone();
        MascoptAbstractCycleTest.assertTrue((copyDiCycle.length() == this.diCycle.length() ? 1 : 0) != 0);
        originalCycleVertexIt = this.diCycle.vertexIterator();
        copyCycleVertexIt = copyCycle.vertexIterator();
        while (originalCycleVertexIt.hasNext()) {
            MascoptAbstractCycleTest.assertTrue((boolean)copyCycleVertexIt.hasNext());
            MascoptVertex v1 = originalCycleVertexIt.next();
            MascoptVertex v2 = copyCycleVertexIt.next();
            MascoptAbstractCycleTest.assertTrue((v1 == v2 ? 1 : 0) != 0);
        }
        Iterator originalDiCycleEdgeIt = this.diCycle.edgeIterator();
        Iterator copyDiCycleEdgeIt = copyDiCycle.edgeIterator();
        while (originalDiCycleEdgeIt.hasNext()) {
            MascoptAbstractCycleTest.assertTrue((boolean)copyDiCycleEdgeIt.hasNext());
            MascoptArc a1 = (MascoptArc)originalDiCycleEdgeIt.next();
            MascoptArc a2 = (MascoptArc)copyDiCycleEdgeIt.next();
            MascoptAbstractCycleTest.assertTrue((a1 == a2 ? 1 : 0) != 0);
        }
    }

    public void testGetEdges() {
        try {
            this.cycle.getEdges(new MascoptVertex());
            MascoptAbstractCycleTest.assertTrue((boolean)false);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            this.diCycle.getEdges(new MascoptVertex());
            MascoptAbstractCycleTest.assertTrue((boolean)false);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        MascoptAbstractLink[] connectedEdges = this.cycle.getEdges(this.vertices[0]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.edges[1] || connectedEdges[0] == this.edges[500] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.edges[1] || connectedEdges[1] == this.edges[500] ? 1 : 0) != 0);
        connectedEdges = this.cycle.getEdges(this.vertices[1]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.edges[1] || connectedEdges[0] == this.edges[102] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.edges[1] || connectedEdges[1] == this.edges[102] ? 1 : 0) != 0);
        connectedEdges = this.cycle.getEdges(this.vertices[2]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.edges[203] || connectedEdges[0] == this.edges[102] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.edges[203] || connectedEdges[1] == this.edges[102] ? 1 : 0) != 0);
        connectedEdges = this.cycle.getEdges(this.vertices[3]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.edges[203] || connectedEdges[0] == this.edges[304] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.edges[203] || connectedEdges[1] == this.edges[304] ? 1 : 0) != 0);
        connectedEdges = this.cycle.getEdges(this.vertices[4]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.edges[405] || connectedEdges[0] == this.edges[304] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.edges[405] || connectedEdges[1] == this.edges[304] ? 1 : 0) != 0);
        connectedEdges = this.cycle.getEdges(this.vertices[5]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.edges[405] || connectedEdges[0] == this.edges[500] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.edges[405] || connectedEdges[1] == this.edges[500] ? 1 : 0) != 0);
        connectedEdges = this.diCycle.getEdges(this.vertices[0]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.arcs[1] || connectedEdges[0] == this.arcs[500] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.arcs[1] || connectedEdges[1] == this.arcs[500] ? 1 : 0) != 0);
        connectedEdges = this.diCycle.getEdges(this.vertices[1]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.arcs[1] || connectedEdges[0] == this.arcs[102] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.arcs[1] || connectedEdges[1] == this.arcs[102] ? 1 : 0) != 0);
        connectedEdges = this.diCycle.getEdges(this.vertices[2]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.arcs[203] || connectedEdges[0] == this.arcs[102] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.arcs[203] || connectedEdges[1] == this.arcs[102] ? 1 : 0) != 0);
        connectedEdges = this.diCycle.getEdges(this.vertices[3]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.arcs[203] || connectedEdges[0] == this.arcs[304] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.arcs[203] || connectedEdges[1] == this.arcs[304] ? 1 : 0) != 0);
        connectedEdges = this.diCycle.getEdges(this.vertices[4]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.arcs[405] || connectedEdges[0] == this.arcs[304] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.arcs[405] || connectedEdges[1] == this.arcs[304] ? 1 : 0) != 0);
        connectedEdges = this.diCycle.getEdges(this.vertices[5]);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[0] == this.arcs[405] || connectedEdges[0] == this.arcs[500] ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((connectedEdges[1] == this.arcs[405] || connectedEdges[1] == this.arcs[500] ? 1 : 0) != 0);
    }

    public void testToString() {
        String cycleStringRepresentation = "[ ";
        String diCycleStringRepresentation = "[ ";
        int i = 0;
        while (i < 6) {
            if (i != 0) {
                cycleStringRepresentation = String.valueOf(cycleStringRepresentation) + "-";
                diCycleStringRepresentation = String.valueOf(diCycleStringRepresentation) + "->";
            }
            cycleStringRepresentation = String.valueOf(cycleStringRepresentation) + this.vertices[i].toString();
            diCycleStringRepresentation = String.valueOf(diCycleStringRepresentation) + this.vertices[i].toString();
            ++i;
        }
        cycleStringRepresentation = String.valueOf(cycleStringRepresentation) + " ]";
        diCycleStringRepresentation = String.valueOf(diCycleStringRepresentation) + " ]";
        MascoptAbstractCycleTest.assertTrue((this.cycle.toString().compareTo(cycleStringRepresentation) == 0 ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((this.diCycle.toString().compareTo(diCycleStringRepresentation) == 0 ? 1 : 0) != 0);
    }

    public void testGetFactory() {
        MascoptAbstractCycleTest.assertTrue((boolean)(this.cycle.getFactory() instanceof MascoptUndirectedMetaFactory));
        MascoptAbstractCycleTest.assertTrue((boolean)(this.diCycle.getFactory() instanceof MascoptDirectedMetaFactory));
    }

    public void testLength() {
        MascoptAbstractCycleTest.assertTrue((this.cycle.length() == 6 ? 1 : 0) != 0);
        MascoptAbstractCycleTest.assertTrue((this.diCycle.length() == 6 ? 1 : 0) != 0);
    }
}

