/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.interfaces.Graph;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.Messages;
import mascoptLib.core.Notification;
import mascoptLib.core.factory.abstracts.MascoptAbstractMetaFactory;
import org.w3c.dom.Element;
import tools.dataStructures.Fifo;
import tools.dataStructures.Stack;
import tools.dataStructures.interfaces.Accumulator;

public abstract class MascoptAbstractGraph<E extends MascoptAbstractLink>
extends MascoptObject
implements Graph<MascoptVertex, E> {
    private final MascoptAbstractMetaFactory<E, MascoptAbstractGraph<E>> mascoptFactory_;
    private MascoptVertexSet vertexSet_;
    private MascoptAbstractLinkSet<E> edgeSet_;

    public MascoptAbstractGraph(MascoptAbstractLinkSet<E> edgeSet, MascoptAbstractMetaFactory<E, MascoptAbstractGraph<E>> factory, String id) {
        super(id);
        this.mascoptFactory_ = factory;
        this.vertexSet_ = edgeSet.getVertexSet();
        this.edgeSet_ = edgeSet;
    }

    public MascoptAbstractGraph(MascoptAbstractGraph<E> superGraph, MascoptAbstractMetaFactory<E, MascoptAbstractGraph<E>> factory, String id) {
        this(factory.getLinkSetFactory().newLinkSet((MascoptAbstractLinkSet<E>)superGraph.edgeSet()), factory, id);
    }

    public MascoptAbstractMetaFactory<E, MascoptAbstractGraph<E>> getFactory() {
        return this.mascoptFactory_;
    }

    @Override
    protected MascoptAbstractGraph<E> clone() {
        MascoptAbstractGraph copy = (MascoptAbstractGraph)super.clone();
        copy.vertexSet_ = this.vertexSet_.clone();
        copy.edgeSet_ = this.edgeSet_.clone();
        return copy;
    }

    public MascoptVertexSet vertexSet() {
        return this.vertexSet_;
    }

    @Override
    public MascoptAbstractLinkSet<E> edgeSet() {
        return this.edgeSet_;
    }

    @Override
    public boolean addEdge(E e) {
        return this.edgeSet_.add(e);
    }

    @Override
    public boolean addEdge(MascoptVertex o1, MascoptVertex o2) {
        return this.edgeSet_.add(this.edgeSet_.getFactory().getLinkSetFactory().newLink(o1, o2));
    }

    @Override
    public boolean addVertex(MascoptVertex o) {
        return this.vertexSet_.add(o);
    }

    @Override
    public boolean removeEdge(Object e) {
        return this.edgeSet_.remove(e);
    }

    @Override
    public boolean removeEdge(Object o1, Object o2) {
        return this.edgeSet_.removeAll(this.getEdgesConnected((MascoptVertex)o1, (MascoptVertex)o2));
    }

    @Override
    public boolean removeVertex(MascoptVertex o) {
        return this.vertexSet_.remove(o);
    }

    public MascoptAbstractGraph<E> complement() {
        MascoptAbstractLinkSet<E> newEdgeSet = this.getFactory().getLinkSetFactory().newLinkSet(this.vertexSet());
        MascoptAbstractGraph<E> newGraph = this.getFactory().getGraphFactory().newGraph(newEdgeSet);
        for (MascoptVertex v1 : this.vertexSet()) {
            for (MascoptVertex v2 : this.vertexSet()) {
                if (v1 == v2) continue;
                boolean alreadyCreated = newEdgeSet.outNeighborhood(v1).contains(v2);
                boolean inOriginalGraph = this.outNeighborhood(v1).contains(v2);
                if (inOriginalGraph || alreadyCreated) continue;
                E edge = this.getFactory().getLinkSetFactory().newLink(v1, v2);
                newGraph.addEdge(edge);
            }
        }
        return newGraph;
    }

    @Override
    public int[] hashCodeArray() {
        int[] result = new int[this.edgeSet_.size() * 2];
        Iterator<E> it = this.edgeSet_.iterator();
        int index = 0;
        while (it.hasNext()) {
            MascoptAbstractLink current = (MascoptAbstractLink)it.next();
            MascoptVertex[] vertices = current.toArray();
            result[index++] = vertices[0].hashCode();
            result[index++] = vertices[1].hashCode();
        }
        return result;
    }

    public MascoptAbstractGraph<E> inducedSubGraph(Set<MascoptVertex> subSet) {
        subSet.retainAll(this.vertexSet());
        Iterator edgeIt = ((MascoptAbstractLinkSet)this.edgeSet()).iterator();
        MascoptVertexSet induceVertexSet = this.getFactory().getGraphFactory().newVertexSet();
        induceVertexSet.addAll((Collection<? extends MascoptVertex>)subSet);
        MascoptAbstractLinkSet<MascoptAbstractLink> newEdgeSet = this.getFactory().getLinkSetFactory().newLinkSet(induceVertexSet);
        while (edgeIt.hasNext()) {
            MascoptAbstractLink current = (MascoptAbstractLink)edgeIt.next();
            if (!subSet.contains(current.toArray()[0]) || !subSet.contains(current.toArray()[1])) continue;
            newEdgeSet.add(current);
        }
        MascoptAbstractGraph<E> newGraph = this.getFactory().getGraphFactory().newGraph(newEdgeSet);
        return newGraph;
    }

    public MascoptVertexSet neighborhood(MascoptVertex v) {
        return this.edgeSet_.neighborhood(v);
    }

    public MascoptVertexSet outNeighborhood(MascoptVertex v) {
        return this.edgeSet_.outNeighborhood(v);
    }

    public MascoptVertexSet inNeighborhood(MascoptVertex v) {
        return this.edgeSet_.inNeighborhood(v);
    }

    @Override
    public MascoptFixedSet<E> inEdges(MascoptVertex v) {
        return this.edgeSet_.inEdges(v);
    }

    @Override
    public MascoptFixedSet<E> outEdges(MascoptVertex v) {
        return this.edgeSet_.outEdges(v);
    }

    @Override
    public MascoptFixedSet<E> inOutEdges(MascoptVertex v) {
        return this.edgeSet_.inOutEdges(v);
    }

    @Override
    public MascoptFixedSet<E> getEdgesConnected(MascoptVertex v1, MascoptVertex v2) {
        return this.edgeSet_.getEdgesConnected(v1, v2);
    }

    @Override
    public void update(MascoptObservableObject observable, Notification nr) {
        MascoptObservableObject.MascoptEventType message = nr.getEventType();
        if (message == MascoptObservableObject.MascoptEventType.REMOVE) {
            this.notifyRemoveObservers(nr);
        } else if (message == MascoptObservableObject.MascoptEventType.ADD) {
            this.notifyAddObservers(nr);
        } else if (message == MascoptObservableObject.MascoptEventType.VALUE_CHANGE) {
            this.notifyValueObservers(nr);
        } else {
            throw new RuntimeException(Messages.getString("MascoptAbstractGraph.unknowNotification"));
        }
    }

    public Iterator<MascoptVertex> breadthFirstIterator(MascoptVertex root) {
        Fifo<MascoptVertex> data = new Fifo<MascoptVertex>();
        return new TraversalIterator(root, data);
    }

    public Iterator<MascoptVertex> depthFirstIterator(MascoptVertex root) {
        Stack<MascoptVertex> data = new Stack<MascoptVertex>();
        return new TraversalIterator(root, data);
    }

    @Override
    public String getDOMTagHierarchy() {
        return "GRAPHS";
    }

    @Override
    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        ((MascoptObject)((Object)this.edgeSet())).toDOMTreeAsRef(node_to_go);
        return node_to_go;
    }

    private class TraversalIterator
    implements Iterator<MascoptVertex> {
        private Accumulator<MascoptVertex> data;
        private MascoptVertexSet alreadyVisited;

        public TraversalIterator(MascoptVertex root, Accumulator<MascoptVertex> dataStructure) {
            this.data = dataStructure;
            this.alreadyVisited = new MascoptVertexSet();
            this.data.put(root);
            this.alreadyVisited.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.data.isEmpty();
        }

        @Override
        public MascoptVertex next() {
            MascoptVertex result = this.data.get();
            MascoptVertexSet neighbors = MascoptAbstractGraph.this.edgeSet_.outNeighborhood(result);
            for (MascoptVertex current : neighbors) {
                if (this.alreadyVisited.contains(current)) continue;
                this.alreadyVisited.add(current);
                this.data.put(current);
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Messages.getString("MascoptAbstractGraph.iteratorWithoutRemove"));
        }
    }
}

