/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.interfaces.Link;
import java.lang.reflect.Array;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.Notification;
import mascoptLib.core.factory.abstracts.MascoptAbstractMetaFactory;
import org.w3c.dom.Element;

public abstract class MascoptAbstractLink
extends MascoptObject
implements Link<MascoptVertex> {
    private final MascoptVertex[] vertices_ = new MascoptVertex[2];

    protected MascoptAbstractLink(MascoptVertex v0, MascoptVertex v1, String id) {
        super(id);
        this.vertices_[0] = v0;
        this.vertices_[1] = v1;
    }

    public abstract <E extends MascoptAbstractLink> MascoptAbstractMetaFactory<E, MascoptAbstractGraph<E>> getFactory();

    @Override
    public boolean contains(MascoptVertex o) {
        return this.vertices_[0] == o || this.vertices_[1] == o;
    }

    @Override
    public MascoptVertex getOpposite(MascoptVertex o) {
        return this.getVertices()[0] == o ? this.getVertices()[1] : (this.getVertices()[1] == o ? this.getVertices()[0] : null);
    }

    public MascoptVertex[] getVertices() {
        return (MascoptVertex[])this.vertices_.clone();
    }

    public MascoptVertex[] toArray() {
        return (MascoptVertex[])this.vertices_.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < 2) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), 2);
        }
        a[0] = this.getVertices()[0];
        a[1] = this.getVertices()[1];
        return a;
    }

    @Override
    public boolean isLoop() {
        return this.getVertices()[0] == this.getVertices()[1];
    }

    @Override
    protected MascoptAbstractLink clone() {
        MascoptAbstractLink result = (MascoptAbstractLink)super.clone();
        return result;
    }

    @Override
    public Element toDOMTree(Element element) {
        Element newNode = super.toDOMTree(element);
        newNode.setAttribute("color", String.valueOf(this.getColor()));
        this.getVertices()[0].toDOMTreeAsRef(newNode);
        this.getVertices()[1].toDOMTreeAsRef(newNode);
        return newNode;
    }

    @Override
    public void update(MascoptObservableObject observable, Notification message) {
    }
}

