/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.factory.MascoptDirectedMetaFactory;
import mascoptLib.core.factory.MascoptUndirectedMetaFactory;

public class MascoptAbstractLinkTest
extends TestCase {
    private MascoptVertex v0_;
    private MascoptVertex v1_;
    private MascoptVertex v2_;
    private MascoptArc arc_;
    private MascoptEdge edge_;
    private MascoptEdge loopEdge_;
    private MascoptArc loopArc_;

    public static Test suite() {
        return new TestSuite(MascoptAbstractLinkTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.v0_ = new MascoptVertex();
        this.v1_ = new MascoptVertex();
        this.v2_ = new MascoptVertex();
        this.edge_ = new MascoptEdge(this.v0_, this.v1_);
        this.arc_ = new MascoptArc(this.v0_, this.v1_);
        this.loopEdge_ = new MascoptEdge(this.v2_, this.v2_);
        this.loopArc_ = new MascoptArc(this.v2_, this.v2_);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.v0_ = null;
        this.v1_ = null;
        this.arc_ = null;
        this.edge_ = null;
    }

    public void testContains() {
        Assert.assertTrue((boolean)this.edge_.contains(this.v0_));
        Assert.assertTrue((boolean)this.edge_.contains(this.v1_));
        Assert.assertTrue((boolean)this.arc_.contains(this.v0_));
        Assert.assertTrue((boolean)this.arc_.contains(this.v1_));
        Assert.assertFalse((boolean)this.edge_.contains(this.v2_));
        Assert.assertFalse((boolean)this.arc_.contains(this.v2_));
    }

    public void testGetOpposite() {
        Assert.assertTrue((this.v0_ == this.edge_.getOpposite(this.v1_) ? 1 : 0) != 0);
        Assert.assertTrue((this.v1_ == this.edge_.getOpposite(this.v0_) ? 1 : 0) != 0);
        Assert.assertTrue((this.v0_ == this.arc_.getOpposite(this.v1_) ? 1 : 0) != 0);
        Assert.assertTrue((this.v1_ == this.arc_.getOpposite(this.v0_) ? 1 : 0) != 0);
        Assert.assertTrue((this.edge_.getOpposite(this.v2_) == null ? 1 : 0) != 0);
        Assert.assertTrue((this.arc_.getOpposite(this.v2_) == null ? 1 : 0) != 0);
    }

    public void testGetVertices() {
        MascoptVertex[] vertices = this.edge_.getVertices();
        Assert.assertTrue((vertices[0] == this.v0_ && vertices[1] == this.v1_ || vertices[0] == this.v1_ && vertices[1] == this.v0_ ? 1 : 0) != 0);
        vertices = this.arc_.getVertices();
        Assert.assertTrue((vertices[0] == this.v0_ && vertices[1] == this.v1_ || vertices[0] == this.v1_ && vertices[1] == this.v0_ ? 1 : 0) != 0);
    }

    public void testToArray() {
        MascoptAbstractLinkTest.assertTrue((this.edge_.toArray()[0] == this.v0_ ? 1 : 0) != 0);
        MascoptAbstractLinkTest.assertTrue((this.edge_.toArray()[1] == this.v1_ ? 1 : 0) != 0);
        MascoptAbstractLinkTest.assertTrue((this.arc_.toArray()[0] == this.v0_ ? 1 : 0) != 0);
        MascoptAbstractLinkTest.assertTrue((this.arc_.toArray()[1] == this.v1_ ? 1 : 0) != 0);
    }

    public void testToArrayObjectArray() {
        MascoptVertex[] array = new MascoptVertex[1];
        MascoptVertex[] result = this.arc_.toArray(array);
        Assert.assertTrue((result.length == 2 ? 1 : 0) != 0);
    }

    public void testLeadsTo() {
        Assert.assertTrue((this.edge_.leadsTo(this.v0_) && this.edge_.leadsTo(this.v1_) ? 1 : 0) != 0);
        Assert.assertTrue((!this.arc_.leadsTo(this.v0_) && this.arc_.leadsTo(this.v1_) ? 1 : 0) != 0);
    }

    public void testLeavesFrom() {
        Assert.assertTrue((this.edge_.leavesFrom(this.v0_) && this.edge_.leavesFrom(this.v1_) ? 1 : 0) != 0);
        Assert.assertTrue((this.arc_.leavesFrom(this.v0_) && !this.arc_.leavesFrom(this.v1_) ? 1 : 0) != 0);
    }

    public void testIsLoop() {
        Assert.assertTrue((boolean)this.loopArc_.isLoop());
        Assert.assertTrue((boolean)this.loopEdge_.isLoop());
        Assert.assertFalse((boolean)this.arc_.isLoop());
        Assert.assertFalse((boolean)this.edge_.isLoop());
    }

    public void testGetFactory() {
        MascoptAbstractLinkTest.assertTrue((boolean)(this.edge_.getFactory() instanceof MascoptUndirectedMetaFactory));
        MascoptAbstractLinkTest.assertTrue((boolean)(this.arc_.getFactory() instanceof MascoptDirectedMetaFactory));
    }

    public void testToString() {
        this.v0_.setName("V0");
        this.v1_.setName("V1");
        Assert.assertTrue((this.edge_.toString().compareTo("[V0-V1]") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.arc_.toString().compareTo("[V0->V1]") == 0 ? 1 : 0) != 0);
    }

    public void testClone() {
        MascoptEdge edgeCopy = this.edge_.clone();
        MascoptArc arcCopy = this.arc_.clone();
        MascoptAbstractLinkTest.assertTrue((this.edge_.toArray()[0] == edgeCopy.toArray()[0] ? 1 : 0) != 0);
        MascoptAbstractLinkTest.assertTrue((this.edge_.toArray()[1] == edgeCopy.toArray()[1] ? 1 : 0) != 0);
        MascoptAbstractLinkTest.assertTrue((this.arc_.toArray()[0] == arcCopy.toArray()[0] ? 1 : 0) != 0);
        MascoptAbstractLinkTest.assertTrue((this.arc_.toArray()[1] == arcCopy.toArray()[1] ? 1 : 0) != 0);
    }
}

