/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.interfaces.Path;
import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.Messages;
import mascoptLib.core.Notification;
import mascoptLib.core.factory.abstracts.MascoptAbstractMetaFactory;
import mascoptLib.exception.MascoptImpossibleOperationPathException;
import org.w3c.dom.Element;

public abstract class MascoptAbstractPath<E extends MascoptAbstractLink>
extends MascoptObject
implements Path<MascoptVertex, E> {
    private Vector<MascoptVertex> orderedVertices_ = new Vector();
    private Vector<E> orderedLinks_ = new Vector();
    private volatile long modCount_ = 0L;

    protected MascoptAbstractPath(String id) {
        super(id);
    }

    @Override
    public String toString() {
        String result = new String();
        result = String.valueOf(result) + "[ ";
        Iterator<MascoptVertex> vIt = this.vertexIterator(this.isDirected() ? this.getFirstVertex() : this.getEnds()[0]);
        if (vIt.hasNext()) {
            result = String.valueOf(result) + vIt.next().toString();
        }
        while (vIt.hasNext()) {
            result = String.valueOf(result) + (this.isDirected() ? "->" : "-");
            result = String.valueOf(result) + vIt.next().toString();
        }
        result = String.valueOf(result) + " ]";
        return result;
    }

    public MascoptVertex[] getEnds() {
        MascoptVertex[] result = new MascoptVertex[2];
        if (!this.orderedVertices_.isEmpty()) {
            result[0] = this.orderedVertices_.firstElement();
            result[1] = this.orderedVertices_.lastElement();
        }
        return result;
    }

    @Override
    public E[] getEdges(MascoptVertex o) throws IllegalArgumentException {
        MascoptAbstractLink[] result;
        int index = this.orderedVertices_.indexOf(o);
        switch (index) {
            case -1: {
                throw new IllegalArgumentException(Messages.getString("MascoptAbstractPath.missingVertex"));
            }
            case 0: {
                result = (MascoptAbstractLink[])Array.newInstance(((MascoptAbstractLink)this.orderedLinks_.firstElement()).getClass(), 2);
                result[0] = (MascoptAbstractLink)this.orderedLinks_.firstElement();
                break;
            }
            default: {
                if (index == this.orderedVertices_.size() - 1) {
                    result = (MascoptAbstractLink[])Array.newInstance(((MascoptAbstractLink)this.orderedLinks_.lastElement()).getClass(), 2);
                    result[0] = (MascoptAbstractLink)this.orderedLinks_.lastElement();
                    break;
                }
                result = (MascoptAbstractLink[])Array.newInstance(((MascoptAbstractLink)this.orderedLinks_.elementAt(index - 1)).getClass(), 2);
                result[0] = (MascoptAbstractLink)this.orderedLinks_.elementAt(index - 1);
                result[1] = (MascoptAbstractLink)this.orderedLinks_.elementAt(index);
            }
        }
        return result;
    }

    @Override
    public void concat(Path<MascoptVertex, E> p) throws MascoptImpossibleOperationPathException {
        MascoptVertex[] pEnds = p.getEnds();
        Iterator<E> eIt = pEnds[0] == this.getEnds()[0] || pEnds[0] == this.getEnds()[1] ? ((MascoptAbstractPath)p).edgeIterator(pEnds[0], true) : ((MascoptAbstractPath)p).edgeIterator(pEnds[1], false);
        while (eIt.hasNext()) {
            this.concat((E)((MascoptAbstractLink)eIt.next()));
        }
    }

    @Override
    public void remove(E e) {
        MascoptVertex v;
        if (e == this.orderedLinks_.firstElement()) {
            ++this.modCount_;
            v = this.orderedVertices_.firstElement();
            this.orderedLinks_.remove(0);
            this.orderedVertices_.remove(0);
        } else if (e == this.orderedLinks_.lastElement()) {
            ++this.modCount_;
            v = this.orderedVertices_.lastElement();
            this.orderedLinks_.remove(e);
            this.orderedVertices_.remove(this.orderedVertices_.lastElement());
        } else {
            throw new IllegalArgumentException(Messages.getString("MascoptAbstractPath.removeNonEndingEdge"));
        }
        Object[] t1 = new Object[]{v, this};
        this.notifyRemoveObservers(t1);
        Object[] t2 = new Object[]{e, this};
        this.notifyRemoveObservers(t2);
        if (this.orderedLinks_.size() == 0) {
            v = this.orderedVertices_.get(0);
            this.orderedVertices_.remove(0);
            Object[] t3 = new Object[]{v, this};
            this.notifyRemoveObservers(t3);
        }
    }

    @Override
    public void remove(MascoptVertex v) {
        MascoptAbstractLink e;
        if (this.orderedVertices_.size() == 0) {
            return;
        }
        if (v == this.orderedVertices_.firstElement()) {
            ++this.modCount_;
            this.orderedVertices_.remove(0);
            e = (MascoptAbstractLink)this.orderedLinks_.firstElement();
            this.orderedLinks_.remove(0);
        } else if (v == this.orderedVertices_.lastElement()) {
            ++this.modCount_;
            this.orderedVertices_.remove(v);
            e = (MascoptAbstractLink)this.orderedLinks_.lastElement();
            this.orderedLinks_.remove(this.orderedLinks_.lastElement());
        } else {
            throw new IllegalArgumentException(Messages.getString("MascoptAbstractPath.removeNonEndingVertex"));
        }
        Object[] t1 = new Object[]{v, this};
        this.notifyRemoveObservers(t1);
        Object[] t2 = new Object[]{e, this};
        this.notifyRemoveObservers(t2);
        if (this.orderedLinks_.size() == 0) {
            MascoptVertex vertex = this.orderedVertices_.get(0);
            this.orderedVertices_.remove(0);
            Object[] t3 = new Object[]{vertex, this};
            this.notifyRemoveObservers(t3);
        }
    }

    @Override
    public boolean contains(E e) {
        return this.orderedLinks_.contains(e);
    }

    @Override
    public boolean contains(MascoptVertex o) {
        return this.orderedVertices_.contains(o);
    }

    @Override
    public int length() {
        return this.orderedLinks_.size();
    }

    @Override
    public boolean isEnd(MascoptVertex o) {
        return this.getEnds()[0] == o || this.getEnds()[1] == o;
    }

    @Override
    public MascoptVertex getLastVertex() {
        if (this.isDirected()) {
            return this.orderedVertices_.isEmpty() ? null : this.orderedVertices_.lastElement();
        }
        throw new UnsupportedOperationException(Messages.getString("MascoptAbstractPath.notDirected"));
    }

    @Override
    public MascoptVertex getFirstVertex() {
        if (this.isDirected()) {
            return this.orderedVertices_.isEmpty() ? null : this.orderedVertices_.firstElement();
        }
        throw new UnsupportedOperationException(Messages.getString("MascoptAbstractPath.notDirected"));
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public Iterator<E> edgeIterator(MascoptVertex o) {
        if (o != this.getEnds()[0] && o != this.getEnds()[1] && !this.isDirected()) {
            throw new MascoptImpossibleOperationPathException(Messages.getString("MascoptAbstractPath.badVertex"));
        }
        if (!this.isDirected()) {
            if (o == this.getEnds()[0]) {
                return new LinkIterator(o, true);
            }
            return new LinkIterator(o, false);
        }
        return new LinkIterator(o, true);
    }

    Iterator<E> edgeIterator(MascoptVertex o, boolean order) {
        return new LinkIterator(o, order);
    }

    @Override
    public Iterator<MascoptVertex> vertexIterator(MascoptVertex o) {
        if (o != this.getEnds()[0] && o != this.getEnds()[1] && !this.isDirected()) {
            throw new MascoptImpossibleOperationPathException(Messages.getString("MascoptAbstractPath.badVertex"));
        }
        if (!this.isDirected()) {
            if (o == this.getEnds()[0]) {
                return new VertexIterator(o, true);
            }
            return new VertexIterator(o, false);
        }
        return new VertexIterator(o, true);
    }

    @Override
    public MascoptAbstractPath<E> clone() {
        MascoptAbstractPath copy = (MascoptAbstractPath)super.clone();
        copy.orderedVertices_ = (Vector)this.orderedVertices_.clone();
        copy.orderedLinks_ = (Vector)this.orderedLinks_.clone();
        return copy;
    }

    private void internalConcat(E e) throws MascoptImpossibleOperationPathException {
        MascoptVertex newVertex;
        MascoptVertex vertex1;
        MascoptVertex[] vertices = ((MascoptAbstractLink)e).toArray();
        MascoptVertex vertex0 = e.leavesFrom((MascoptVertex)vertices[0]) ? vertices[0] : vertices[1];
        MascoptVertex mascoptVertex = vertex1 = e.leadsTo((MascoptVertex)vertices[1]) ? vertices[1] : vertices[0];
        if (vertex0 == this.orderedVertices_.firstElement() || vertex0 == this.orderedVertices_.lastElement()) {
            if (this.orderedVertices_.contains(vertex1)) {
                throw new MascoptImpossibleOperationPathException(Messages.getString("MascoptAbstractPath.edgeMakeCycle"));
            }
            if (this.isDirected() && vertex0 == this.getFirstVertex()) {
                throw new MascoptImpossibleOperationPathException(Messages.getString("MascoptAbstractPath.badDirection"));
            }
            newVertex = vertex1;
        } else if (vertex1 == this.orderedVertices_.firstElement() || vertex1 == this.orderedVertices_.lastElement()) {
            if (this.orderedVertices_.contains(vertex0)) {
                throw new MascoptImpossibleOperationPathException();
            }
            if (this.isDirected() && vertex1 == this.getLastVertex()) {
                throw new MascoptImpossibleOperationPathException(Messages.getString("MascoptAbstractPath.badDirection"));
            }
            newVertex = vertex0;
        } else {
            throw new MascoptImpossibleOperationPathException(Messages.getString("MascoptAbstractPath.inconsistantEdge"));
        }
        if (newVertex == vertex0 && vertex1 == this.getEnds()[0] || newVertex == vertex1 && vertex0 == this.getEnds()[0]) {
            this.orderedVertices_.add(0, newVertex);
            this.orderedLinks_.add(0, e);
        } else {
            this.orderedVertices_.add(newVertex);
            this.orderedLinks_.add(e);
        }
        Object[] t1 = new Object[]{newVertex, this};
        this.notifyAddObservers(t1);
        Object[] t3 = new Object[]{e, this};
        this.notifyAddObservers(t3);
    }

    @Override
    public void concat(E e) throws MascoptImpossibleOperationPathException {
        MascoptVertex[] vertices = ((MascoptAbstractLink)e).toArray();
        MascoptVertex vertex0 = vertices[0];
        MascoptVertex vertex1 = vertices[1];
        if (((MascoptAbstractLink)e).isLoop()) {
            throw new MascoptImpossibleOperationPathException(Messages.getString("MascoptAbstractPath.addLoop"));
        }
        ++this.modCount_;
        if (this.orderedVertices_.isEmpty()) {
            assert (e.leavesFrom((MascoptVertex)vertices[0]));
            this.orderedVertices_.add(0, vertex0);
            this.orderedVertices_.add(1, vertex1);
            this.orderedLinks_.add(e);
            Object[] t1 = new Object[]{vertex0};
            this.notifyAddObservers(t1);
            Object[] t2 = new Object[]{vertex1};
            this.notifyAddObservers(t2);
            Object[] t3 = new Object[]{e};
            this.notifyAddObservers(t3);
            return;
        }
        this.internalConcat(e);
    }

    public abstract MascoptAbstractMetaFactory<E, MascoptAbstractGraph<E>> getFactory();

    @Override
    public void update(MascoptObservableObject observable, Notification message) {
    }

    @Override
    public String getDOMTagHierarchy() {
        return "PATHS";
    }

    @Override
    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        Iterator<E> it_edges = this.edgeIterator(this.isDirected() ? this.getFirstVertex() : this.getEnds()[0]);
        while (it_edges.hasNext()) {
            MascoptAbstractLink e = (MascoptAbstractLink)it_edges.next();
            e.toDOMTreeAsRef(node_to_go);
        }
        return node_to_go;
    }

    private class LinkIterator
    implements Iterator<E> {
        private boolean removeCalled_ = true;
        private boolean order_;
        private int nextLinkIndex_;
        private long expectedModCount_;

        LinkIterator(MascoptVertex begin, boolean order) {
            this.expectedModCount_ = MascoptAbstractPath.this.modCount_;
            this.nextLinkIndex_ = order ? MascoptAbstractPath.this.orderedVertices_.indexOf(begin) : MascoptAbstractPath.this.orderedVertices_.indexOf(begin) - 1;
            this.order_ = order;
        }

        @Override
        public boolean hasNext() {
            return this.nextLinkIndex_ < MascoptAbstractPath.this.orderedLinks_.size() && this.nextLinkIndex_ >= 0;
        }

        @Override
        public E next() {
            int n;
            if (MascoptAbstractPath.this.modCount_ != this.expectedModCount_) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeCalled_ = false;
            Vector vector = MascoptAbstractPath.this.orderedLinks_;
            if (this.order_) {
                int n2 = this.nextLinkIndex_;
                n = n2;
                this.nextLinkIndex_ = n2 + 1;
            } else {
                int n3 = this.nextLinkIndex_;
                n = n3;
                this.nextLinkIndex_ = n3 - 1;
            }
            return (MascoptAbstractLink)vector.elementAt(n);
        }

        @Override
        public void remove() {
            if (this.removeCalled_) {
                throw new IllegalStateException();
            }
            this.removeCalled_ = true;
            if (this.order_ ? this.nextLinkIndex_ != 1 && this.nextLinkIndex_ != MascoptAbstractPath.this.orderedLinks_.size() : this.nextLinkIndex_ != -1 && this.nextLinkIndex_ != MascoptAbstractPath.this.orderedLinks_.size() - 2) {
                throw new IllegalStateException(Messages.getString("MascoptAbstractPath.removeNonEndingEdge"));
            }
            int indexToRemove = this.nextLinkIndex_ + (this.order_ ? -1 : 1);
            MascoptAbstractPath.this.orderedLinks_.remove(indexToRemove);
            MascoptAbstractPath.this.orderedVertices_.remove(indexToRemove == 0 ? 0 : indexToRemove + 1);
            if (this.order_) {
                --this.nextLinkIndex_;
            }
        }
    }

    private class VertexIterator
    implements Iterator<MascoptVertex> {
        boolean order_;
        private int index_;
        boolean removeCalled_;
        private long expectedModCount_;

        VertexIterator(MascoptVertex begin, boolean order) {
            this.expectedModCount_ = MascoptAbstractPath.this.modCount_;
            this.index_ = MascoptAbstractPath.this.orderedVertices_.indexOf(begin);
            this.removeCalled_ = true;
            this.order_ = order;
        }

        @Override
        public boolean hasNext() {
            return this.index_ < MascoptAbstractPath.this.orderedVertices_.size() && this.index_ >= 0;
        }

        @Override
        public MascoptVertex next() {
            int n;
            if (MascoptAbstractPath.this.modCount_ != this.expectedModCount_) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeCalled_ = false;
            Vector vector = MascoptAbstractPath.this.orderedVertices_;
            if (this.order_) {
                int n2 = this.index_;
                n = n2;
                this.index_ = n2 + 1;
            } else {
                int n3 = this.index_;
                n = n3;
                this.index_ = n3 - 1;
            }
            return (MascoptVertex)vector.elementAt(n);
        }

        @Override
        public void remove() {
            if (this.removeCalled_) {
                throw new IllegalStateException();
            }
            this.removeCalled_ = true;
            if (this.order_ ? this.index_ != 1 && this.index_ != MascoptAbstractPath.this.orderedVertices_.size() : this.index_ != -1 && this.index_ != MascoptAbstractPath.this.orderedVertices_.size() - 2) {
                throw new IllegalStateException(Messages.getString("MascoptAbstractPath.removeNonEndingVertex"));
            }
            if (this.index_ == -1 || this.index_ == 1 && this.order_) {
                MascoptAbstractPath.this.orderedVertices_.remove(0);
                MascoptAbstractPath.this.orderedLinks_.remove(0);
                if (this.order_) {
                    --this.index_;
                }
                if (MascoptAbstractPath.this.orderedLinks_.size() == 0) {
                    MascoptAbstractPath.this.orderedVertices_.remove(0);
                }
            } else {
                MascoptAbstractPath.this.orderedVertices_.remove(MascoptAbstractPath.this.orderedVertices_.size() - 1);
                MascoptAbstractPath.this.orderedLinks_.remove(MascoptAbstractPath.this.orderedLinks_.size() - 1);
            }
        }
    }
}

