/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptDiPath;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptPath;
import mascoptLib.core.MascoptVertex;
import mascoptLib.exception.MascoptImpossibleOperationPathException;

public class MascoptAbstractPathTest
extends TestCase {
    private MascoptPath path;
    private MascoptDiPath diPath;
    private MascoptVertex[] vertices;
    private MascoptEdge[] edges;
    private MascoptArc[] arcs;
    private static final int NB_VERTEX = 100;

    protected void setUp() throws Exception {
        super.setUp();
        this.vertices = new MascoptVertex[100];
        int i = 0;
        while (i < 100) {
            this.vertices[i] = new MascoptVertex();
            ++i;
        }
        this.edges = new MascoptEdge[99];
        i = 0;
        while (i < 99) {
            this.edges[i] = new MascoptEdge(this.vertices[i], this.vertices[i + 1]);
            ++i;
        }
        this.arcs = new MascoptArc[99];
        i = 0;
        while (i < 99) {
            this.arcs[i] = new MascoptArc(this.vertices[i], this.vertices[i + 1]);
            ++i;
        }
        this.path = new MascoptPath();
        this.diPath = new MascoptDiPath();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.path = null;
        this.diPath = null;
        this.vertices = null;
        this.edges = null;
        this.arcs = null;
    }

    public void testGetEnds() {
        this.path.concat(this.edges[0]);
        MascoptVertex[] ends = this.path.getEnds();
        Assert.assertTrue((ends[0] == this.vertices[0] && ends[1] == this.vertices[1] || ends[0] == this.vertices[1] && ends[1] == this.vertices[0] ? 1 : 0) != 0);
        this.diPath.concat(this.arcs[0]);
        ends = this.diPath.getEnds();
        Assert.assertTrue((ends[0] == this.vertices[0] && ends[1] == this.vertices[1] || ends[0] == this.vertices[1] && ends[1] == this.vertices[0] ? 1 : 0) != 0);
    }

    public void testGetEdges() {
        this.path.concat(this.edges[0]);
        this.path.concat(this.edges[1]);
        MascoptAbstractLink[] cEdges = this.path.getEdges(this.vertices[0]);
        Assert.assertTrue((cEdges[0] == this.edges[0] && cEdges[1] == null ? 1 : 0) != 0);
        cEdges = this.path.getEdges(this.vertices[1]);
        Assert.assertTrue((cEdges[0] == this.edges[0] && cEdges[1] == this.edges[1] || cEdges[0] == this.edges[1] && cEdges[1] == this.edges[0] ? 1 : 0) != 0);
        cEdges = this.path.getEdges(this.vertices[2]);
        Assert.assertTrue((cEdges[0] == this.edges[1] && cEdges[1] == null ? 1 : 0) != 0);
        this.diPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        cEdges = this.path.getEdges(this.vertices[0]);
        Assert.assertTrue((cEdges[0] == this.edges[0] && cEdges[1] == null ? 1 : 0) != 0);
        cEdges = this.path.getEdges(this.vertices[1]);
        Assert.assertTrue((cEdges[0] == this.edges[0] && cEdges[1] == this.edges[1] || cEdges[0] == this.edges[1] && cEdges[1] == this.edges[0] ? 1 : 0) != 0);
        cEdges = this.path.getEdges(this.vertices[2]);
        Assert.assertTrue((cEdges[0] == this.edges[1] && cEdges[1] == null ? 1 : 0) != 0);
        try {
            this.path.getEdges(this.vertices[this.vertices.length - 1]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConcatEdge() {
        MascoptArc badArc2;
        this.path.concat(this.edges[0]);
        this.path.concat(this.edges[1]);
        Assert.assertTrue((this.path.contains(this.edges[0]) && this.path.contains(this.edges[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 2 ? 1 : 0) != 0);
        this.path = new MascoptPath();
        this.path.concat(this.edges[1]);
        this.path.concat(this.edges[0]);
        Assert.assertTrue((this.path.contains(this.edges[0]) && this.path.contains(this.edges[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 2 ? 1 : 0) != 0);
        MascoptEdge otherEdge = new MascoptEdge(this.vertices[5], this.vertices[0]);
        this.path = new MascoptPath();
        this.path.concat(this.edges[0]);
        this.path.concat(this.edges[1]);
        this.path.concat(otherEdge);
        Assert.assertTrue((this.path.contains(this.edges[0]) && this.path.contains(this.edges[1]) && this.path.contains(otherEdge) ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 3 ? 1 : 0) != 0);
        otherEdge = new MascoptEdge(this.vertices[0], this.vertices[5]);
        this.path = new MascoptPath();
        this.path.concat(this.edges[1]);
        this.path.concat(this.edges[0]);
        this.path.concat(otherEdge);
        Assert.assertTrue((this.path.contains(this.edges[0]) && this.path.contains(this.edges[1]) && this.path.contains(otherEdge) ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 3 ? 1 : 0) != 0);
        this.diPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        Assert.assertTrue((this.diPath.getFirstVertex() == this.vertices[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.getLastVertex() == this.vertices[2] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.contains(this.arcs[0]) && this.diPath.contains(this.arcs[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.length() == 2 ? 1 : 0) != 0);
        this.diPath = new MascoptDiPath();
        this.diPath.concat(this.arcs[1]);
        this.diPath.concat(this.arcs[0]);
        Assert.assertTrue((this.diPath.getFirstVertex() == this.vertices[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.getLastVertex() == this.vertices[2] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.contains(this.arcs[0]) && this.diPath.contains(this.arcs[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.length() == 2 ? 1 : 0) != 0);
        this.path = new MascoptPath();
        this.path.concat(this.edges[0]);
        this.path.concat(this.edges[1]);
        try {
            this.path.concat(this.edges[3]);
            Assert.fail();
        }
        catch (MascoptImpossibleOperationPathException mascoptImpossibleOperationPathException) {
            // empty catch block
        }
        this.diPath = new MascoptDiPath();
        this.diPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        try {
            this.diPath.concat(this.arcs[3]);
            Assert.fail();
        }
        catch (MascoptImpossibleOperationPathException mascoptImpossibleOperationPathException) {
            // empty catch block
        }
        this.path = new MascoptPath();
        this.path.concat(this.edges[0]);
        this.path.concat(this.edges[1]);
        try {
            MascoptEdge badEdge = new MascoptEdge(this.vertices[0], this.vertices[2]);
            this.path.concat(badEdge);
            Assert.fail();
        }
        catch (MascoptImpossibleOperationPathException badEdge) {
            // empty catch block
        }
        this.diPath = new MascoptDiPath();
        this.diPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        this.diPath.concat(this.arcs[2]);
        try {
            badArc2 = new MascoptArc(this.vertices[1], this.vertices[3]);
            this.diPath.concat(badArc2);
            Assert.fail();
        }
        catch (MascoptImpossibleOperationPathException badArc2) {
            // empty catch block
        }
        this.diPath = new MascoptDiPath();
        this.diPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        try {
            badArc2 = new MascoptArc(this.vertices[3], this.vertices[2]);
            this.diPath.concat(badArc2);
            Assert.fail();
        }
        catch (MascoptImpossibleOperationPathException badArc3) {
            // empty catch block
        }
        this.diPath = new MascoptDiPath();
        this.diPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        try {
            badArc2 = new MascoptArc(this.vertices[0], this.vertices[3]);
            this.diPath.concat(badArc2);
            Assert.fail();
        }
        catch (MascoptImpossibleOperationPathException mascoptImpossibleOperationPathException) {
            // empty catch block
        }
    }

    public void testConcatPath() {
        MascoptPath tmpPath = new MascoptPath();
        MascoptDiPath tmpDiPath = new MascoptDiPath();
        tmpPath.concat(this.edges[0]);
        this.path.concat(this.edges[1]);
        this.path.concat(tmpPath);
        Assert.assertTrue((this.path.contains(this.edges[0]) && this.path.contains(this.edges[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 2 ? 1 : 0) != 0);
        tmpDiPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        this.diPath.concat(tmpDiPath);
        Assert.assertTrue((this.diPath.getFirstVertex() == this.vertices[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.getLastVertex() == this.vertices[2] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.contains(this.arcs[0]) && this.diPath.contains(this.arcs[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.length() == 2 ? 1 : 0) != 0);
    }

    public void testRemoveEdge() {
        this.path.concat(this.edges[0]);
        this.path.concat(this.edges[1]);
        this.path.concat(this.edges[2]);
        try {
            this.path.remove(this.edges[1]);
            Assert.fail((String)"Removing non ending edge don't throw exeption");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.path.remove(this.edges[2]);
        Assert.assertTrue((this.path.contains(this.edges[0]) && this.path.contains(this.edges[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 2 ? 1 : 0) != 0);
        this.path.remove(this.edges[0]);
        this.path.remove(this.edges[1]);
        this.diPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        this.diPath.concat(this.arcs[2]);
        try {
            this.diPath.remove(this.arcs[1]);
            Assert.fail((String)"Removing non ending arc don't throw exeption");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.diPath.remove(this.arcs[2]);
        Assert.assertTrue((this.diPath.getFirstVertex() == this.vertices[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.getLastVertex() == this.vertices[2] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.contains(this.arcs[0]) && this.diPath.contains(this.arcs[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.length() == 2 ? 1 : 0) != 0);
        this.diPath.remove(this.arcs[0]);
        this.diPath.remove(this.arcs[1]);
    }

    public void testRemoveObject() {
        this.path.concat(this.edges[0]);
        this.path.concat(this.edges[1]);
        this.path.concat(this.edges[2]);
        try {
            this.path.remove(this.vertices[1]);
            Assert.fail((String)"Removing non ending vertex don't throw exeption");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.path.remove(this.vertices[3]);
        Assert.assertTrue((this.path.contains(this.edges[0]) && this.path.contains(this.edges[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 2 ? 1 : 0) != 0);
        this.path.remove(this.vertices[0]);
        this.path.remove(this.vertices[1]);
        this.diPath.concat(this.arcs[0]);
        this.diPath.concat(this.arcs[1]);
        this.diPath.concat(this.arcs[2]);
        try {
            this.diPath.remove(this.vertices[1]);
            Assert.fail((String)"Removing non ending vertex don't throw exeption");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.diPath.remove(this.vertices[3]);
        Assert.assertTrue((this.diPath.getFirstVertex() == this.vertices[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.getLastVertex() == this.vertices[2] ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.contains(this.arcs[0]) && this.diPath.contains(this.arcs[1]) ? 1 : 0) != 0);
        Assert.assertTrue((this.diPath.length() == 2 ? 1 : 0) != 0);
        this.diPath.remove(this.vertices[0]);
        this.diPath.remove(this.vertices[1]);
    }

    public void testIsEnd() {
        this.fillPath();
        Assert.assertTrue((boolean)this.path.isEnd(this.vertices[0]));
        Assert.assertTrue((boolean)this.path.isEnd(this.vertices[99]));
        Assert.assertFalse((boolean)this.path.isEnd(this.vertices[98]));
        Assert.assertTrue((boolean)this.diPath.isEnd(this.vertices[0]));
        Assert.assertTrue((boolean)this.diPath.isEnd(this.vertices[99]));
        Assert.assertFalse((boolean)this.diPath.isEnd(this.vertices[98]));
    }

    public void testGetLastVertex() {
        this.diPath.concat(this.arcs[0]);
        Assert.assertTrue((this.diPath.getLastVertex() == this.vertices[1] ? 1 : 0) != 0);
        this.diPath.concat(this.arcs[1]);
        Assert.assertTrue((this.diPath.getLastVertex() == this.vertices[2] ? 1 : 0) != 0);
        this.diPath.concat(this.arcs[2]);
        Assert.assertTrue((this.diPath.getLastVertex() == this.vertices[3] ? 1 : 0) != 0);
    }

    public void testGetFirstVertex() {
        this.diPath.concat(this.arcs[2]);
        Assert.assertTrue((this.diPath.getFirstVertex() == this.vertices[2] ? 1 : 0) != 0);
        this.diPath.concat(this.arcs[1]);
        Assert.assertTrue((this.diPath.getFirstVertex() == this.vertices[1] ? 1 : 0) != 0);
        this.diPath.concat(this.arcs[0]);
        Assert.assertTrue((this.diPath.getFirstVertex() == this.vertices[0] ? 1 : 0) != 0);
    }

    public void testIsDirected() {
        Assert.assertFalse((boolean)this.path.isDirected());
        Assert.assertTrue((boolean)this.diPath.isDirected());
    }

    private void subTestEdgeIteratorAscening(Iterator it, MascoptAbstractPath p) {
        Assert.assertTrue((boolean)it.hasNext());
        if (p instanceof MascoptPath) {
            Assert.assertTrue((it.next() == this.edges[0] ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((it.next() == this.arcs[0] ? 1 : 0) != 0);
        }
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"IllegalStateException throwed when removing ending vertex");
        }
        int i = 1;
        while (i < 99) {
            if (i == 50) {
                try {
                    it.remove();
                    Assert.fail((String)"IllegalStateException don't throwed");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            Assert.assertTrue((boolean)it.hasNext());
            if (p instanceof MascoptPath) {
                Assert.assertTrue((it.next() == this.edges[i] ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((it.next() == this.arcs[i] ? 1 : 0) != 0);
            }
            ++i;
        }
        it.remove();
        Assert.assertTrue((p.getEnds()[0] == this.vertices[98] || p.getEnds()[1] == this.vertices[98] ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 97 ? 1 : 0) != 0);
        try {
            it.next();
            Assert.fail((String)"NoSuchElementException don't throwed");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void subTestEdgeIteratorDescending(Iterator it, MascoptPath p) {
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((it.next() == this.edges[98] ? 1 : 0) != 0);
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"IllegalStateException throwed when removing ending edges");
        }
        int i = 97;
        while (i >= 0) {
            if (i == 50) {
                try {
                    it.remove();
                    Assert.fail((String)"IllegalStateException don't throwed");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertTrue((it.next() == this.edges[i] ? 1 : 0) != 0);
            --i;
        }
        it.remove();
        Assert.assertTrue((p.getEnds()[0] == this.vertices[1] || p.getEnds()[1] == this.vertices[1] ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 97 ? 1 : 0) != 0);
        try {
            it.next();
            Assert.fail((String)"NoSuchElementException don't throwed");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void fillPath() {
        this.path = new MascoptPath();
        this.diPath = new MascoptDiPath();
        int i = 0;
        while (i < 99) {
            this.path.concat(this.edges[i]);
            this.diPath.concat(this.arcs[i]);
            ++i;
        }
    }

    public void testEdgeIterator() {
        this.fillPath();
        Iterator itPath = this.path.edgeIterator(this.vertices[0]);
        this.subTestEdgeIteratorAscening(itPath, this.path);
        Iterator itDiPath = this.diPath.edgeIterator(this.vertices[0]);
        this.subTestEdgeIteratorAscening(itDiPath, this.diPath);
        this.fillPath();
        itPath = this.path.edgeIterator(this.vertices[99]);
        this.subTestEdgeIteratorDescending(itPath, this.path);
        this.fillPath();
        itPath = this.path.edgeIterator(this.vertices[0]);
        itDiPath = this.diPath.edgeIterator(this.vertices[0]);
        this.path.remove(this.edges[0]);
        this.diPath.remove(this.arcs[0]);
        try {
            itPath.next();
            Assert.fail((String)"ConcurrentModificationException don't throwed");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            itDiPath.next();
            Assert.fail((String)"ConcurrentModificationException don't throwed");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.fillPath();
        try {
            itPath = this.path.edgeIterator(this.vertices[50]);
            Assert.fail();
        }
        catch (MascoptImpossibleOperationPathException mascoptImpossibleOperationPathException) {
            // empty catch block
        }
        this.fillPath();
        itPath = this.path.edgeIterator(this.vertices[0]);
        itDiPath = this.diPath.edgeIterator(this.vertices[0]);
        itPath.next();
        itPath.remove();
        itDiPath.next();
        itDiPath.remove();
        try {
            itPath.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            itDiPath.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.fillPath();
        itPath = this.path.edgeIterator(this.vertices[0]);
        itDiPath = this.diPath.edgeIterator(this.vertices[0]);
        while (itPath.hasNext()) {
            itPath.next();
            itPath.remove();
        }
        while (itDiPath.hasNext()) {
            itDiPath.next();
            itDiPath.remove();
        }
    }

    private void subTestAscendingIterator(Iterator it, MascoptAbstractPath p) {
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((it.next() == this.vertices[0] ? 1 : 0) != 0);
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"IllegalStateException throwed when removing ending vertex");
        }
        int i = 1;
        while (i < 100) {
            if (i == 50) {
                try {
                    it.remove();
                    Assert.fail((String)"IllegalStateException don't throwed");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertTrue((it.next() == this.vertices[i] ? 1 : 0) != 0);
            ++i;
        }
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"IllegalStateException throwed when removing ending vertex");
        }
        Assert.assertTrue((p.getEnds()[0] == this.vertices[98] || p.getEnds()[1] == this.vertices[98] ? 1 : 0) != 0);
        Assert.assertTrue((p.length() == 97 ? 1 : 0) != 0);
        try {
            it.next();
            Assert.fail((String)"NoSuchElementException don't throwed");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void subTestDescendingIterator(Iterator it) {
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((it.next() == this.vertices[99] ? 1 : 0) != 0);
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"IllegalStateException throwed when removing ending vertex");
        }
        int i = 98;
        while (i >= 0) {
            if (i == 50) {
                try {
                    it.remove();
                    Assert.fail((String)"IllegalStateException don't throwed");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertTrue((it.next() == this.vertices[i] ? 1 : 0) != 0);
            --i;
        }
        try {
            it.remove();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"IllegalStateException throwed when removing ending vertex");
        }
        Assert.assertTrue((this.path.getEnds()[0] == this.vertices[98] || this.path.getEnds()[1] == this.vertices[98] ? 1 : 0) != 0);
        Assert.assertTrue((this.path.length() == 97 ? 1 : 0) != 0);
        try {
            it.next();
            Assert.fail((String)"NoSuchElementException don't throwed");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testClone() {
        MascoptPath pathCopy = this.path.clone();
        MascoptDiPath diPathCopy = this.diPath.clone();
    }

    public void testVertexIterator() {
        this.fillPath();
        Iterator<MascoptVertex> itPath = this.path.vertexIterator(this.vertices[0]);
        Iterator<MascoptVertex> itDiPath = this.diPath.vertexIterator(this.vertices[0]);
        this.subTestAscendingIterator(itPath, this.path);
        this.subTestAscendingIterator(itDiPath, this.diPath);
        this.fillPath();
        itPath = this.path.vertexIterator(this.vertices[99]);
        this.subTestDescendingIterator(itPath);
        this.fillPath();
        try {
            itPath = this.path.vertexIterator(this.vertices[50]);
            Assert.fail();
        }
        catch (MascoptImpossibleOperationPathException mascoptImpossibleOperationPathException) {
            // empty catch block
        }
        this.fillPath();
        itPath = this.path.vertexIterator(this.vertices[0]);
        itDiPath = this.diPath.vertexIterator(this.vertices[0]);
        this.path.remove(this.edges[0]);
        this.diPath.remove(this.arcs[0]);
        try {
            itPath.next();
            Assert.fail((String)"ConcurrentModificationException don't throwed");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        try {
            itDiPath.next();
            Assert.fail((String)"ConcurrentModificationException don't throwed");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.fillPath();
        itPath = this.path.vertexIterator(this.vertices[0]);
        itDiPath = this.diPath.vertexIterator(this.vertices[0]);
        itPath.next();
        itPath.remove();
        try {
            itPath.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        itDiPath.next();
        itDiPath.remove();
        try {
            itDiPath.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.fillPath();
        itPath = this.path.vertexIterator(this.vertices[0]);
        itDiPath = this.diPath.vertexIterator(this.vertices[0]);
        while (itPath.hasNext()) {
            itPath.next();
            itPath.remove();
        }
        while (itDiPath.hasNext()) {
            itDiPath.next();
            itDiPath.remove();
        }
    }
}

