/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Vector;
import mascoptLib.core.Notification;
import mascoptLib.core.interfaces.MascoptObserver;

public class MascoptObservableObject {
    private Vector<WeakReference<MascoptObserver>> addObservers_ = new Vector();
    private Vector<WeakReference<MascoptObserver>> removeObservers_ = new Vector();
    private Vector<WeakReference<MascoptObserver>> valueObservers_ = new Vector();

    protected Object clone() throws CloneNotSupportedException {
        MascoptObservableObject result = (MascoptObservableObject)super.clone();
        result.addObservers_ = new Vector();
        result.removeObservers_ = new Vector();
        result.valueObservers_ = new Vector();
        return result;
    }

    private WeakReference<MascoptObserver> getRef(MascoptObserver o, Vector<WeakReference<MascoptObserver>> v) {
        Iterator<WeakReference<MascoptObserver>> vIt = v.iterator();
        while (vIt.hasNext()) {
            WeakReference<MascoptObserver> currentRef = vIt.next();
            if (currentRef.get() == o) {
                return currentRef;
            }
            if (currentRef.get() != null) continue;
            vIt.remove();
        }
        return null;
    }

    private boolean alreadyInVector(MascoptObserver o, Vector<WeakReference<MascoptObserver>> v) {
        return this.getRef(o, v) != null;
    }

    private void removeObjectFromVector(MascoptObserver o, Vector<WeakReference<MascoptObserver>> v) {
        WeakReference<MascoptObserver> ref = this.getRef(o, v);
        if (ref != null) {
            v.remove(ref);
        }
    }

    public final void addAddObserver(MascoptObserver o) {
        if (this.alreadyInVector(o, this.addObservers_)) {
            return;
        }
        this.addObservers_.add(new WeakReference<MascoptObserver>(o));
    }

    public final void deleteAddObserver(MascoptObserver o) {
        this.removeObjectFromVector(o, this.addObservers_);
    }

    protected final void notifyAddObservers(Notification nr) {
        Iterator<WeakReference<MascoptObserver>> vIt = this.addObservers_.iterator();
        while (vIt.hasNext()) {
            WeakReference<MascoptObserver> currentRef = vIt.next();
            if (currentRef.get() != null) {
                ((MascoptObserver)currentRef.get()).update(this, nr);
                continue;
            }
            vIt.remove();
        }
    }

    protected final void notifyAddObservers(Object[] objs) {
        this.notifyAddObservers(new Notification(MascoptEventType.ADD, objs));
    }

    public final void addRemoveObserver(MascoptObserver o) {
        if (this.alreadyInVector(o, this.removeObservers_)) {
            return;
        }
        this.removeObservers_.add(new WeakReference<MascoptObserver>(o));
    }

    public final void deleteRemoveObserver(MascoptObserver o) {
        this.removeObjectFromVector(o, this.removeObservers_);
        assert (!this.removeObservers_.contains(o));
    }

    protected final void notifyRemoveObservers(Notification nr) {
        Iterator<WeakReference<MascoptObserver>> vIt = this.removeObservers_.iterator();
        while (vIt.hasNext()) {
            WeakReference<MascoptObserver> currentRef = vIt.next();
            if (currentRef.get() != null) {
                ((MascoptObserver)currentRef.get()).update(this, nr);
                continue;
            }
            vIt.remove();
        }
    }

    protected final void notifyRemoveObservers(Object[] objs) {
        this.notifyRemoveObservers(new Notification(MascoptEventType.REMOVE, objs));
    }

    public final void addValueObserver(MascoptObserver o) {
        if (this.alreadyInVector(o, this.valueObservers_)) {
            return;
        }
        this.valueObservers_.add(new WeakReference<MascoptObserver>(o));
    }

    public final void deleteValueObserver(MascoptObserver o) {
        this.removeObjectFromVector(o, this.valueObservers_);
        assert (!this.valueObservers_.contains(o));
    }

    protected final void notifyValueObservers(Notification nr) {
        Iterator<WeakReference<MascoptObserver>> vIt = this.valueObservers_.iterator();
        while (vIt.hasNext()) {
            WeakReference<MascoptObserver> currentRef = vIt.next();
            if (currentRef.get() != null) {
                ((MascoptObserver)currentRef.get()).update(this, nr);
                continue;
            }
            vIt.remove();
        }
    }

    protected final void notifyValueObservers(Object[] objs) {
        this.notifyValueObservers(new Notification(MascoptEventType.VALUE_CHANGE, objs));
    }

    public static enum MascoptEventType {
        ADD,
        REMOVE,
        VALUE_CHANGE;

    }
}

