/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import bridge.interfaces.HierarchicalSet;
import java.util.Collection;
import java.util.Iterator;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.Messages;

public class MascoptSet<E extends MascoptObject>
extends MascoptFixedSet<E>
implements HierarchicalSet<E> {
    private static int idGenerator_ = 0;
    private boolean addRemoveAllowed_ = true;

    MascoptSet(String id) {
        super(id);
    }

    MascoptSet(MascoptSet<E> superSet, String id) {
        super(superSet, id);
    }

    public MascoptSet() {
        super("S" + idGenerator_++);
    }

    public MascoptSet(MascoptSet<E> superSet) {
        super(superSet, "S" + idGenerator_++);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.throwExceptionForAddRemoveOperation();
        boolean modified = false;
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            modified |= this.add((E)((MascoptObject)it.next()));
        }
        return modified;
    }

    @Override
    public boolean add(E object) {
        this.throwExceptionForAddRemoveOperation();
        return this.addProtected(object);
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof MascoptObject)) {
            throw new IllegalArgumentException(Messages.getString("MascoptSet.notMascoptObject"));
        }
        this.throwExceptionForAddRemoveOperation();
        return this.removeProtected((MascoptObject)object);
    }

    @Override
    public Iterator<E> iterator() {
        return new MascoptSetIterator(this, super.iterator());
    }

    @Override
    public void clear() {
        super.clearProtected();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.throwExceptionForAddRemoveOperation();
        return this.removeAllProtected(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.throwExceptionForAddRemoveOperation();
        return this.retainAllProtected(collection);
    }

    @Override
    public MascoptSet<E> clone() {
        return (MascoptSet)super.clone();
    }

    protected void setAddRemoveAllowed(boolean bool) {
        this.addRemoveAllowed_ = bool;
    }

    protected boolean isAddRemoveAllowed() {
        return this.addRemoveAllowed_;
    }

    @Override
    protected void throwExceptionForAddRemoveOperation() {
        if (!this.isAddRemoveAllowed()) {
            super.throwExceptionForAddRemoveOperation();
        }
    }

    @Override
    public String getDOMTagName() {
        return "SET";
    }

    private class MascoptSetIterator
    implements Iterator<E> {
        private Iterator<E> realIt_;
        private E lastObjectReturn_;
        private MascoptSet<E> thisSet_;

        public MascoptSetIterator(MascoptSet<E> thisSet, Iterator<E> realIt) {
            this.realIt_ = realIt;
            this.thisSet_ = thisSet;
            this.lastObjectReturn_ = null;
        }

        @Override
        public boolean hasNext() {
            return this.realIt_.hasNext();
        }

        @Override
        public E next() {
            this.lastObjectReturn_ = (MascoptObject)this.realIt_.next();
            return this.lastObjectReturn_;
        }

        @Override
        public void remove() {
            if (this.lastObjectReturn_ != null) {
                MascoptSet.this.throwExceptionForAddRemoveOperation();
                Object[] t = new Object[]{this.lastObjectReturn_, this.thisSet_};
                MascoptSet.this.notifyRemoveObservers(t);
                this.realIt_.remove();
                this.lastObjectReturn_ = null;
                return;
            }
            throw new IllegalStateException();
        }
    }
}

