/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core;

import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.Notification;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MascoptVertex
extends MascoptObject {
    private static long idGenerator_ = 0L;
    private double x_;
    private double y_;

    public MascoptVertex() {
        this(0.0, 0.0);
    }

    public MascoptVertex(double x, double y) {
        super("V" + idGenerator_++);
        this.setX(x);
        this.setY(y);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public final double getX() {
        return this.x_;
    }

    public final double getY() {
        return this.y_;
    }

    public final void setX(double x) {
        this.x_ = x;
        Object[] t = new Object[]{this, "x"};
        this.notifyValueObservers(t);
    }

    public final void setY(double y) {
        this.y_ = y;
        Object[] t = new Object[]{this, "y"};
        this.notifyValueObservers(t);
    }

    @Override
    public MascoptVertex clone() {
        return (MascoptVertex)super.clone();
    }

    @Override
    public String getDOMTagHierarchy() {
        return "VERTICES";
    }

    @Override
    public String getDOMTagName() {
        return "VERTEX";
    }

    @Override
    public Element toDOMTree(Element element) {
        Element vertexNode = super.toDOMTree(element);
        vertexNode.setAttribute("color", String.valueOf(this.getColor()));
        Element nodePosition = vertexNode.getOwnerDocument().createElement("POSITION");
        vertexNode.appendChild(nodePosition);
        Element xNode = vertexNode.getOwnerDocument().createElement("X");
        Text xValue = vertexNode.getOwnerDocument().createTextNode("" + this.getX());
        xNode.appendChild(xValue);
        nodePosition.appendChild(xNode);
        Element yNode = vertexNode.getOwnerDocument().createElement("Y");
        Text yValue = vertexNode.getOwnerDocument().createTextNode("" + this.getY());
        yNode.appendChild(yValue);
        nodePosition.appendChild(yNode);
        return vertexNode;
    }

    @Override
    public void update(MascoptObservableObject observable, Notification message) {
    }
}

