/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.core.flows;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.Flow;
import bridge.interfaces.Graph;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.Notification;
import mascoptLib.numeric.MascoptAbstractScalar;
import mascoptLib.numeric.MascoptDouble;
import org.w3c.dom.Element;

public class MascoptFlow
extends MascoptObject
implements Flow<MascoptVertex, MascoptArc> {
    public static final String NAME_OF_FLOW = "FlowValue";
    private static int idGenerator_ = 0;
    private MascoptDiGraph supportingGraph_;
    private MascoptVertex source_;
    private MascoptVertex destination_;
    private MascoptAbstractScalar flowValue_;
    private MascoptMap arcToValue_;

    public MascoptFlow(MascoptDiGraph supportingGraph) {
        super("F" + idGenerator_++);
        this.supportingGraph_ = supportingGraph;
        ((MascoptObservableObject)((Object)supportingGraph.edgeSet())).addRemoveObserver(this);
        this.arcToValue_ = new MascoptMap();
    }

    @Override
    public void setFlow(MascoptVertex source, MascoptVertex destination, AbstractScalar value) {
        assert (((MascoptFixedSet)this.supportingGraph_.vertexSet()).contains(source) && ((MascoptFixedSet)this.supportingGraph_.vertexSet()).contains(destination));
        this.source_ = source;
        this.destination_ = destination;
        this.flowValue_ = (MascoptAbstractScalar)value;
    }

    @Override
    public MascoptVertex getDestination() {
        return this.source_;
    }

    @Override
    public MascoptVertex getSource() {
        return this.destination_;
    }

    @Override
    public AbstractScalar getIncomingFlow(MascoptVertex v) {
        if (v != this.destination_) {
            return new MascoptDouble(0.0);
        }
        return this.flowValue_;
    }

    @Override
    public AbstractScalar getOutgoingFlow(MascoptVertex v) {
        if (v != this.source_) {
            return new MascoptDouble(0.0);
        }
        return this.flowValue_;
    }

    @Override
    public Iterator<MascoptArc> edgeWithFlowIterator() {
        return new IteratorWithoutRemove<MascoptObject>(this.arcToValue_.keysIterator());
    }

    @Override
    public void setFlow(MascoptArc e, AbstractScalar value) {
        Object[] notifyArgs = new Object[2];
        assert (((MascoptFixedSet)this.supportingGraph_.edgeSet()).contains(e));
        this.arcToValue_.putValue(e, NAME_OF_FLOW, value);
        notifyArgs[0] = e;
        notifyArgs[1] = value;
        this.notifyValueObservers(notifyArgs);
    }

    @Override
    public AbstractScalar getFlow(MascoptArc e) {
        assert (((MascoptFixedSet)this.supportingGraph_.edgeSet()).contains(e));
        AbstractScalar result = this.arcToValue_.getValue(e, NAME_OF_FLOW);
        return result == null ? new MascoptDouble(0.0) : result;
    }

    @Override
    public Graph<MascoptVertex, MascoptArc> getUnderlyingGraph() {
        return this.supportingGraph_;
    }

    @Override
    public boolean verify() {
        for (MascoptVertex currentVertex : this.supportingGraph_.vertexSet()) {
            double flowValue = 0.0;
            Iterator inEdgeIt = this.supportingGraph_.inEdges(currentVertex).iterator();
            while (inEdgeIt.hasNext()) {
                flowValue += this.getFlow((MascoptArc)inEdgeIt.next()).doubleValue();
            }
            Iterator outEdgeIt = this.supportingGraph_.outEdges(currentVertex).iterator();
            while (outEdgeIt.hasNext()) {
                flowValue += this.getFlow((MascoptArc)outEdgeIt.next()).doubleValue();
            }
            if (flowValue == this.getIncomingFlow(currentVertex).doubleValue() - this.getOutgoingFlow(currentVertex).doubleValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MascoptFlow clone() {
        MascoptFlow copy = (MascoptFlow)super.clone();
        copy.flowValue_ = (MascoptAbstractScalar)this.flowValue_.clone();
        copy.arcToValue_ = this.arcToValue_.clone();
        return copy;
    }

    @Override
    public Element toDOMTree(Element element) {
        Element flowNode = super.toDOMTree(element);
        this.supportingGraph_.toDOMTreeAsRef(flowNode);
        this.source_.toDOMTreeAsRef(flowNode);
        this.destination_.toDOMTreeAsRef(flowNode);
        this.flowValue_.toDOMTree(flowNode);
        this.arcToValue_.toDOMTreeAsRef(flowNode);
        return flowNode;
    }

    @Override
    public String toString() {
        return String.valueOf(this.supportingGraph_.toString()) + System.getProperty("line.separator") + this.arcToValue_.toString();
    }

    @Override
    public String getDOMTagHierarchy() {
        return "FLOWS";
    }

    @Override
    public String getDOMTagName() {
        return "FLOW";
    }

    @Override
    public void update(MascoptObservableObject o, Notification nr) {
        Object[] objs = nr.getObjects();
        MascoptObservableObject.MascoptEventType message = nr.getEventType();
        if (message == MascoptObservableObject.MascoptEventType.REMOVE && objs[0] instanceof MascoptAbstractLink) {
            this.arcToValue_.removeAll(objs[0]);
        }
    }

    private class IteratorWithoutRemove<T extends MascoptObject>
    implements Iterator<T> {
        Iterator<T> realIt_;

        IteratorWithoutRemove(Iterator<T> realIt) {
            this.realIt_ = realIt;
        }

        @Override
        public boolean hasNext() {
            return this.realIt_.hasNext();
        }

        @Override
        public T next() {
            return (T)((MascoptObject)this.realIt_.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing source or destination of a flow is forbiden");
        }
    }
}

