/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.actions;

import bridge.interfaces.Link;
import java.util.ArrayList;
import java.util.Random;
import mascoptLib.graphgenerator.actions.ActionOnGraph;
import mascoptLib.graphgenerator.actions.ChanceGenerator;

public class SimpleChanceGenerator<V, E extends Link<V>>
implements ChanceGenerator<V, E> {
    private ArrayList<ActionOnGraph<V, E>> actions_;
    private int avaibleNo_;
    private final Random random_ = new Random();

    private boolean iAmConsistent() {
        int i = 0;
        while (i < this.actions_.size()) {
            if (this.actions_.get((int)i).chancePosition_ != i) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public SimpleChanceGenerator(ArrayList<ActionOnGraph<V, E>> actions) {
        this.actions_ = actions;
        this.avaibleNo_ = actions.size();
        int i = 0;
        while (i < actions.size()) {
            actions.get((int)i).chancePosition_ = i;
            ++i;
        }
        assert (this.iAmConsistent());
    }

    @Override
    public void choosed(ActionOnGraph<V, E> action) {
        assert (this.iAmConsistent());
        assert (this.actions_.contains(action));
        assert (action.chancePosition_ >= this.avaibleNo_);
        assert (this.actions_.get(action.chancePosition_) == action);
        if (action.chancePosition_ == this.actions_.size() - 1) {
            this.actions_.remove(this.actions_.size() - 1);
        } else {
            this.actions_.set(action.chancePosition_, this.actions_.get(this.actions_.size() - 1));
            this.actions_.remove(this.actions_.size() - 1);
            this.actions_.get((int)action.chancePosition_).chancePosition_ = action.chancePosition_;
        }
        assert (this.iAmConsistent());
    }

    @Override
    public void swapChances(ActionOnGraph<V, E> action1, ActionOnGraph<V, E> action2) {
        assert (this.iAmConsistent());
        assert (this.actions_.contains(action1));
        assert (!this.actions_.contains(action2));
        assert (action1.chancePosition_ >= this.avaibleNo_);
        assert (this.actions_.get(action1.chancePosition_) == action1);
        action2.chancePosition_ = action1.chancePosition_;
        this.actions_.set(action1.chancePosition_, action2);
        assert (!this.actions_.contains(action1));
        assert (this.actions_.contains(action2));
        assert (this.iAmConsistent());
    }

    @Override
    public void repeatChoices() {
        this.avaibleNo_ = this.actions_.size();
        assert (this.iAmConsistent());
    }

    @Override
    public ActionOnGraph<V, E> getNext() {
        assert (this.iAmConsistent());
        if (this.avaibleNo_ == 0) {
            return null;
        }
        assert (this.avaibleNo_ > 0);
        int position = this.random_.nextInt(this.avaibleNo_);
        --this.avaibleNo_;
        ActionOnGraph<V, E> action = this.actions_.get(position);
        action.chancePosition_ = this.avaibleNo_;
        this.actions_.get((int)this.avaibleNo_).chancePosition_ = position;
        this.actions_.set(position, this.actions_.get(this.avaibleNo_));
        this.actions_.set(this.avaibleNo_, action);
        assert (this.actions_.get(action.chancePosition_) == action);
        assert (this.iAmConsistent());
        return action;
    }

    @Override
    public void addChance(ActionOnGraph<V, E> action) {
        assert (this.iAmConsistent());
        assert (this.avaibleNo_ <= this.actions_.size());
        if (this.avaibleNo_ == this.actions_.size()) {
            this.actions_.add(action);
            action.chancePosition_ = this.actions_.size() - 1;
        } else {
            ActionOnGraph<V, E> lastAvaible = this.actions_.get(this.avaibleNo_);
            this.actions_.add(lastAvaible);
            this.actions_.set(this.avaibleNo_, action);
            action.chancePosition_ = this.avaibleNo_;
            lastAvaible.chancePosition_ = this.actions_.size() - 1;
        }
        ++this.avaibleNo_;
        assert (this.iAmConsistent());
    }

    protected ArrayList<ActionOnGraph<V, E>> getActions() {
        return this.actions_;
    }
}

