/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.numericproperty.common;

import bridge.interfaces.Link;
import java.util.HashSet;
import mascoptLib.graphgenerator.numericproperty.SimpleComputator;
import mascoptLib.numeric.MascoptInteger;
import tools.dataStructures.Fifo;

public class DiameterComputator<V, E extends Link<V>>
extends SimpleComputator<V, E> {
    HashSet<V> visitedVertices_;

    @Override
    public void compute() {
        this.visitedVertices_ = new HashSet(this.graph_.vertexSet().size() * 2);
        int maxCandidate = 0;
        for (Object vertex : this.graph_.vertexSet()) {
            this.visitedVertices_.clear();
            int actualCandidate = this.maxDistance(vertex);
            if (this.visitedVertices_.size() != this.graph_.vertexSet().size()) {
                this.result_ = new MascoptInteger(Integer.MAX_VALUE);
                return;
            }
            if (actualCandidate <= maxCandidate) continue;
            maxCandidate = actualCandidate;
        }
        this.result_ = new MascoptInteger(maxCandidate);
    }

    protected int maxDistance(V rootVertex) {
        int result = 0;
        Fifo fifo = new Fifo();
        Object specialVertex = null;
        this.visitedVertices_.add(rootVertex);
        fifo.put(specialVertex);
        Object actualVertex = rootVertex;
        while (true) {
            if (actualVertex == specialVertex) {
                ++result;
                if (fifo.isEmpty()) {
                    return result - 1;
                }
                fifo.put(specialVertex);
            } else {
                assert (this.visitedVertices_.contains(actualVertex));
                for (Object outVertex : this.graph_.outNeighborhood(actualVertex)) {
                    if (!this.visitedVertices_.add(outVertex)) continue;
                    fifo.put(outVertex);
                }
            }
            actualVertex = fifo.get();
        }
    }
}

