/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.random;

import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import java.util.ArrayList;
import java.util.Iterator;
import mascoptLib.graphgenerator.actions.ActionOnGraph;
import mascoptLib.graphgenerator.actions.AddLinkOnGraph;
import mascoptLib.graphgenerator.actions.ChanceGenerator;
import mascoptLib.graphgenerator.actions.PositiveNegativeChanceGenerator;
import mascoptLib.graphgenerator.actions.RemoveLinkOnGraph;
import mascoptLib.graphgenerator.actions.SimpleChanceGenerator;

public enum Strategy {
    ADD{

        @Override
        protected <V2, L2 extends Link<V2>> ChanceGenerator<V2, L2> generateTheChances(Graph<V2, L2> startGraph) {
            return new SimpleChanceGenerator(this.positiveAction(startGraph));
        }

        @Override
        protected <V2, L2 extends Link<V2>> void onConfirmedAction(ChanceGenerator<V2, L2> chanceGenerator, ActionOnGraph<V2, L2> action) {
            chanceGenerator.choosed(action);
        }
    }
    ,
    REMOVE{

        @Override
        protected <V2, L2 extends Link<V2>> ChanceGenerator<V2, L2> generateTheChances(Graph<V2, L2> startGraph) {
            ArrayList actions = new ArrayList(startGraph.edgeSet().size());
            for (Link link : startGraph.edgeSet()) {
                actions.add(new RemoveLinkOnGraph(link));
            }
            return new SimpleChanceGenerator(actions);
        }

        @Override
        protected <V2, L2 extends Link<V2>> void onConfirmedAction(ChanceGenerator<V2, L2> chanceGenerator, ActionOnGraph<V2, L2> action) {
            chanceGenerator.choosed(action);
        }
    }
    ,
    ADD_REMOVE{

        @Override
        protected <V2, L2 extends Link<V2>> ChanceGenerator<V2, L2> generateTheChances(Graph<V2, L2> startGraph) {
            ArrayList actions = this.positiveAction(startGraph);
            ArrayList actionsNegative = new ArrayList(startGraph.edgeSet().size());
            for (Link link : startGraph.edgeSet()) {
                actionsNegative.add(new AddLinkOnGraph(link).getInverse());
            }
            return new PositiveNegativeChanceGenerator(actions, actionsNegative);
        }

        @Override
        protected <V2, L2 extends Link<V2>> void onConfirmedAction(ChanceGenerator<V2, L2> chanceGenerator, ActionOnGraph<V2, L2> action) {
            chanceGenerator.swapChances(action, action.getInverse());
        }
    };


    private Strategy() {
    }

    protected abstract <V2, L2 extends Link<V2>> ChanceGenerator<V2, L2> generateTheChances(Graph<V2, L2> var1);

    protected abstract <V2, L2 extends Link<V2>> void onConfirmedAction(ChanceGenerator<V2, L2> var1, ActionOnGraph<V2, L2> var2);

    protected <V2, L2 extends Link<V2>> ArrayList<ActionOnGraph<V2, L2>> positiveAction(Graph<V2, L2> startGraph) {
        boolean undirected = this.isUnDirectedGraph(startGraph);
        int size = startGraph.vertexSet().size();
        size = size * size - size;
        size -= startGraph.edgeSet().size();
        if (!undirected) {
            size *= 2;
        }
        ArrayList<ActionOnGraph<V2, L2>> actions = new ArrayList<ActionOnGraph<V2, L2>>(size);
        Object[] vertices = startGraph.vertexSet().toArray();
        int i = 0;
        while (i < vertices.length) {
            int j = i + 1;
            while (j < vertices.length) {
                if (startGraph.getEdgesConnected(vertices[i], vertices[j]).size() == 0) {
                    actions.add(new AddLinkOnGraph(vertices[i], vertices[j]));
                }
                if (!undirected && startGraph.getEdgesConnected(vertices[j], vertices[i]).size() == 0) {
                    actions.add(new AddLinkOnGraph(vertices[j], vertices[i]));
                }
                ++j;
            }
            ++i;
        }
        return actions;
    }

    protected <V2, L2 extends Link<V2>> boolean isUnDirectedGraph(Graph<V2, L2> graph) {
        if (graph.edgeSet().size() != 0) {
            V[] vertices;
            Link link = (Link)graph.edgeSet().iterator().next();
            return link.leadsTo((vertices = link.toArray())[0]) && link.leavesFrom(vertices[0]);
        }
        Iterator vertexIt = graph.vertexSet().iterator();
        Object vertex1 = vertexIt.next();
        Object vertex2 = vertexIt.next();
        graph.addEdge(vertex1, vertex2);
        boolean result = this.isUnDirectedGraph(graph);
        graph.removeEdge(vertex1, vertex2);
        return result;
    }

    /* synthetic */ Strategy(String string, int n, Strategy strategy) {
        this();
    }
}

