/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.topology;

import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import java.util.ArrayList;
import java.util.Random;

public abstract class StartingAbstractGraphFactory<V, L extends Link<V>> {
    private final Random random_ = new Random();

    protected abstract V newVertex(double var1, double var3);

    protected abstract Graph<V, L> newGraph();

    protected abstract void addSingleLink(Graph<V, L> var1, V var2, V var3);

    protected abstract void addDoubleLink(Graph<V, L> var1, V var2, V var3);

    protected V newVertex() {
        return this.newVertex(0.0, 0.0);
    }

    public Graph<V, L> getOnlyVerticesGraph(int verticesNo) {
        Graph graph = this.newGraph();
        double alpha = Math.PI * 2 / (double)verticesNo;
        ArrayList<V> vertices = new ArrayList<V>(verticesNo);
        int x = 0;
        while (x < verticesNo) {
            vertices.add(this.newVertex(Math.sin(alpha * (double)x) * 100.0, Math.cos(alpha * (double)x) * 100.0));
            graph.addVertex(vertices.get(x));
            ++x;
        }
        return graph;
    }

    public Graph<V, L> getTorusGraph(int verticesXNo, int verticesYNo) {
        int x;
        Graph graph = this.newGraph();
        ArrayList<V> vertices = new ArrayList<V>(verticesXNo * verticesYNo);
        int y = 0;
        while (y < verticesYNo) {
            x = 0;
            while (x < verticesXNo) {
                vertices.add(this.newVertex(x * 100, y * 100));
                graph.addVertex(vertices.get(x + verticesXNo * y));
                ++x;
            }
            ++y;
        }
        int x2 = 0;
        while (x2 < verticesXNo) {
            this.addSingleLink(graph, vertices.get(x2 + verticesXNo * (verticesYNo - 1)), vertices.get(x2));
            int y2 = 1;
            while (y2 < verticesYNo) {
                this.addSingleLink(graph, vertices.get(x2 + verticesXNo * (y2 - 1)), vertices.get(x2 + verticesXNo * y2));
                ++y2;
            }
            ++x2;
        }
        y = 0;
        while (y < verticesYNo) {
            this.addSingleLink(graph, vertices.get(verticesXNo - 1 + verticesXNo * y), vertices.get(verticesXNo * y));
            x = 1;
            while (x < verticesXNo) {
                this.addSingleLink(graph, vertices.get(x - 1 + verticesXNo * y), vertices.get(x + verticesXNo * y));
                ++x;
            }
            ++y;
        }
        return graph;
    }

    public Graph<V, L> getRegularGraph(int regularSize, int verticesNo) {
        Graph graph = this.newGraph();
        double alpha = Math.PI * 2 / (double)verticesNo;
        ArrayList<V> vertices = new ArrayList<V>(verticesNo);
        int x = 0;
        while (x < verticesNo) {
            vertices.add(this.newVertex(Math.sin(alpha * (double)x) * 100.0, Math.cos(alpha * (double)x) * 100.0));
            graph.addVertex(vertices.get(x));
            ++x;
        }
        int n = 1;
        while (n <= regularSize / 2) {
            int x2 = 0;
            while (x2 < verticesNo) {
                this.addSingleLink(graph, vertices.get(x2), vertices.get((x2 + n) % verticesNo));
                ++x2;
            }
            ++n;
        }
        return graph;
    }

    public Graph<V, L> getRandomSpanningTreeGraph(int verticesNo) {
        Graph<Object, L> graph = this.newGraph();
        double alpha = Math.PI * 2 / (double)verticesNo;
        ArrayList<V> vertices = new ArrayList<V>(verticesNo);
        vertices.add(this.newVertex(0.0, 0.0));
        graph.addVertex(vertices.get(0));
        while (--verticesNo > 0) {
            V vertex = this.newVertex(Math.sin(alpha * (double)verticesNo) * 100.0, Math.cos(alpha * (double)verticesNo) * 100.0);
            graph.addVertex(vertex);
            this.addDoubleLink(graph, vertex, vertices.get(this.random_.nextInt(vertices.size())));
            vertices.add(vertex);
        }
        return graph;
    }

    public Graph<V, L> getGridGraph(int verticesXNo, int verticesYNo) {
        int x;
        Graph graph = this.newGraph();
        ArrayList<V> vertices = new ArrayList<V>(verticesXNo * verticesYNo);
        int y = 0;
        while (y < verticesYNo) {
            x = 0;
            while (x < verticesXNo) {
                vertices.add(this.newVertex(x * 100, y * 100));
                graph.addVertex(vertices.get(x + verticesXNo * y));
                ++x;
            }
            ++y;
        }
        int x2 = 0;
        while (x2 < verticesXNo) {
            int y2 = 1;
            while (y2 < verticesYNo) {
                this.addDoubleLink(graph, vertices.get(x2 + verticesXNo * (y2 - 1)), vertices.get(x2 + verticesXNo * y2));
                ++y2;
            }
            ++x2;
        }
        y = 0;
        while (y < verticesYNo) {
            x = 1;
            while (x < verticesXNo) {
                this.addDoubleLink(graph, vertices.get(x - 1 + verticesXNo * y), vertices.get(x + verticesXNo * y));
                ++x;
            }
            ++y;
        }
        return graph;
    }

    public Graph<V, L> getStarGraph(int verticesNo) {
        Graph<Object, L> graph = this.newGraph();
        double alpha = Math.PI * 2 / (double)(verticesNo - 1);
        ArrayList<V> vertices = new ArrayList<V>(verticesNo);
        vertices.add(this.newVertex(0.0, 0.0));
        graph.addVertex(vertices.get(0));
        while (--verticesNo > 0) {
            V vertex = this.newVertex(Math.sin(alpha * (double)verticesNo) * 100.0, Math.cos(alpha * (double)verticesNo) * 100.0);
            graph.addVertex(vertex);
            this.addDoubleLink(graph, vertex, vertices.get(0));
            vertices.add(vertex);
        }
        return graph;
    }

    public Graph<V, L> getCompleteGraph(int verticesNo) {
        Graph<V, L> graph = this.getOnlyVerticesGraph(verticesNo);
        return graph.complement();
    }

    public Graph<V, L> getRegularGraphWithCenter(int regularSize, int verticesNo) {
        Graph<Object, L> graph = this.newGraph();
        double alpha = Math.PI * 2 / (double)(--verticesNo);
        ArrayList<V> vertices = new ArrayList<V>(verticesNo);
        V center = this.newVertex(0.0, 0.0);
        graph.addVertex(center);
        int x = 0;
        while (x < verticesNo) {
            vertices.add(this.newVertex(Math.sin(alpha * (double)x) * 100.0, Math.cos(alpha * (double)x) * 100.0));
            graph.addVertex(vertices.get(x));
            ++x;
        }
        int n = 1;
        while (n <= regularSize / 2) {
            int x2 = 0;
            while (x2 < verticesNo) {
                this.addSingleLink(graph, vertices.get(x2), vertices.get((x2 + n) % verticesNo));
                ++x2;
            }
            ++n;
        }
        x = 0;
        while (x < verticesNo) {
            this.addDoubleLink(graph, vertices.get(x), center);
            ++x;
        }
        return graph;
    }

    public Graph<V, L> getCartepilarGraph(int deep) {
        Graph<V, L> graph = this.newGraph();
        ArrayList<V> vertices = new ArrayList<V>(deep * 3);
        V left = this.newVertex(0.0, 0.0);
        V right = this.newVertex(100 + deep * 100, 0.0);
        graph.addVertex(left);
        graph.addVertex(right);
        int j = 0;
        while (j < deep) {
            V upVertex = this.newVertex(j * 100 + 100, -50.0);
            vertices.add(upVertex);
            graph.addVertex(upVertex);
            V centerVertex = this.newVertex(j * 100 + 100, 0.0);
            vertices.add(centerVertex);
            graph.addVertex(centerVertex);
            V downVertex = this.newVertex(j * 100 + 100, 50.0);
            vertices.add(downVertex);
            graph.addVertex(downVertex);
            ++j;
        }
        Object lastCenter = left;
        int i = 0;
        while (i < deep) {
            this.addSingleLink(graph, lastCenter, vertices.get(i * 3 + 1));
            this.addSingleLink(graph, vertices.get(i * 3 + 1), vertices.get(i * 3));
            this.addSingleLink(graph, vertices.get(i * 3 + 1), vertices.get(i * 3 + 2));
            lastCenter = vertices.get(i * 3 + 1);
            ++i;
        }
        this.addSingleLink(graph, lastCenter, right);
        return graph;
    }

    public Graph<V, L> getSpiderGraph(int nbPaw, int pawLenght) {
        int j;
        Graph<V, L> graph = this.newGraph();
        double alpha = Math.PI * 2 / (double)nbPaw;
        ArrayList<V> vertices = new ArrayList<V>(nbPaw * pawLenght);
        V center = this.newVertex(0.0, 0.0);
        graph.addVertex(center);
        int x = 0;
        while (x < nbPaw) {
            j = 0;
            while (j < pawLenght) {
                V currentVertex = this.newVertex(Math.sin(alpha * (double)x) * (double)(100 + 100 * j), Math.cos(alpha * (double)x) * (double)(100 + 100 * j));
                vertices.add(currentVertex);
                graph.addVertex(currentVertex);
                ++j;
            }
            ++x;
        }
        x = 0;
        while (x < nbPaw) {
            this.addSingleLink(graph, center, vertices.get(x * pawLenght));
            ++x;
        }
        x = 0;
        while (x < nbPaw) {
            j = 1;
            while (j < pawLenght) {
                this.addSingleLink(graph, vertices.get(x * pawLenght + j - 1), vertices.get(x * pawLenght + j));
                ++j;
            }
            ++x;
        }
        return graph;
    }
}

