/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.editor;

import bridge.interfaces.HierarchicalSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptDiPath;
import mascoptLib.core.MascoptEdgeSet;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptPath;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.gui.AutoArrangeGraphs;
import mascoptLib.gui.editor.Messages;
import mascoptLib.gui.editor.ViewWindowListener;
import mascoptLib.gui.editor.ViewsEditorListener;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GView;
import mascoptLib.gui.layerManager.LayerManager;
import mascoptLib.gui.mapEditor.MapEditor;
import mascoptLib.io.MascoptChooser.MascoptChooser;
import mascoptLib.io.interfaces.Reader;
import mascoptLib.io.reader.mgl.dom.MGLDOMReader;
import mascoptLib.io.reader.mgl.sax.MGLSaxReader;
import mascoptLib.io.reader.snd.natives.SNDNetworkNativeReader;
import mascoptLib.io.writer.mgl.dom.MGLWriter;

public class Editor
extends JPanel {
    private static final long serialVersionUID = 2L;
    private JMenuBar jMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem openItem = null;
    private JMenuItem reloadItem = null;
    private JMenuItem saveItem = null;
    private JMenuItem saveAsItem = null;
    private JMenuItem insertItem = null;
    private JMenuItem imageItem = null;
    private JMenuItem quitItem = null;
    private JMenu createMenu = null;
    private JMenuItem graphItem = null;
    private JMenuItem diGraphItem = null;
    private JMenuItem pathItem = null;
    private JMenuItem diPathItem = null;
    private JMenuItem mapItem = null;
    private JMenu viewMenu = null;
    private JMenuItem newViewItem = null;
    private JMenuItem setBackgroundItem = null;
    private JMenu optionsMenu = null;
    private JMenuItem autoDisplayItem = null;
    private JMenuItem mixVerticesItem = null;
    private JMenu actionsMenu = null;
    private ButtonGroup actionsGroup = null;
    private JRadioButtonMenuItem createButton = null;
    private JRadioButtonMenuItem deleteButton = null;
    private JRadioButtonMenuItem setNameButton = null;
    private JRadioButtonMenuItem setColorButton = null;
    private JRadioButtonMenuItem setValueButton = null;
    private JList graphList = null;
    private JList mapList = null;
    private JLabel jLabel = null;
    private JSeparator firstSeparator = null;
    private JSeparator secondSeparator = null;
    private JLabel jLabel1 = null;
    private JLabel contextListLabel = null;
    private JList contextList = null;
    private JLabel showLabelLabel = null;
    private JCheckBox showLabelButton = null;
    private JLabel vertexLabelLabel = null;
    private JComboBox vertexLabel = null;
    private JLabel jLabel2 = null;
    private JComboBox edgesLabels = null;
    private Thread autoArrangeThread;
    private ViewsEditorListener el;
    private MascoptObject objectEdited;
    private LayerManager layerManager;
    private GLayer layer;
    private boolean noSaved = false;
    private Vector<MascoptAbstractPath> pathVector = new Vector();
    private Vector<MascoptVertexSet> vertexSetVector = new Vector();
    private Vector<MascoptAbstractGraph> graphVector = new Vector();
    private Vector<MascoptMap> mapsVector = new Vector();
    private MascoptMap currentMap = null;
    private MascoptObject currentContext = null;
    private Vector<GView> gViewVector = new Vector();
    private Vector<JFrame> jFrameVector = new Vector();
    private String lastLoadOrSave = null;
    private String oldX = "0";
    private String oldY = "0";
    private int viewNumber = 0;
    private JScrollPane jScrollPaneMapList = null;
    private JScrollPane jScrollPaneGraphList = null;
    private JScrollPane jScrollPaneContextList = null;

    public Editor() {
        this.initialize();
    }

    private void initialize() {
        this.el = new ViewsEditorListener(this);
        this.layerManager = new LayerManager(this.el);
        this.layer = this.layerManager.newLayer(Messages.getString("Editor.layerName"));
        this.el.setLayer(this.layer);
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.fill = 2;
        gridBagConstraints14.gridx = 5;
        gridBagConstraints14.gridy = 5;
        gridBagConstraints14.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints14.weightx = 1.0;
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 4;
        gridBagConstraints13.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints13.gridy = 5;
        this.jLabel2 = new JLabel();
        this.jLabel2.setText(Messages.getString("Editor.edgesLabels"));
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridx = 3;
        gridBagConstraints12.gridy = 5;
        gridBagConstraints12.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints12.weightx = 1.0;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 2;
        gridBagConstraints11.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints11.gridy = 5;
        this.vertexLabelLabel = new JLabel();
        this.vertexLabelLabel.setText(Messages.getString("Editor.verticesLabels"));
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.gridy = 5;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints9.gridy = 5;
        this.showLabelLabel = new JLabel();
        this.showLabelLabel.setText(Messages.getString("Editor.showLabel"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridwidth = 6;
        gridBagConstraints8.gridy = 4;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.gridx = 4;
        gridBagConstraints7.gridy = 3;
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints7.weightx = 1.0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 4;
        gridBagConstraints6.anchor = 16;
        gridBagConstraints6.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints6.gridy = 2;
        this.contextListLabel = new JLabel();
        this.contextListLabel.setText(Messages.getString("Editor.contextList"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.anchor = 16;
        gridBagConstraints5.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints5.gridy = 2;
        this.jLabel1 = new JLabel();
        this.jLabel1.setText(Messages.getString("Editor.mapList"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 16;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints3.gridx = 0;
        this.jLabel = new JLabel();
        this.jLabel.setText(Messages.getString("Editor.editedGraph"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.weightx = 1.0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(600, 400);
        this.add((Component)this.getJMenuBar(), gridBagConstraints);
        this.add((Component)this.getFirstSeparator(), new GridBagConstraints());
        this.add((Component)this.jLabel, gridBagConstraints3);
        this.add((Component)this.getJScrollPaneGraphList(), gridBagConstraints1);
        this.add((Component)this.jLabel1, gridBagConstraints5);
        this.add((Component)this.getJScrollPaneMapList(), gridBagConstraints2);
        this.add((Component)this.contextListLabel, gridBagConstraints6);
        this.add((Component)this.getJScrollPaneContextList(), gridBagConstraints7);
        this.add((Component)this.getSecondSeparator(), gridBagConstraints8);
        this.add((Component)this.showLabelLabel, gridBagConstraints9);
        this.add((Component)this.getShowLabelButton(), gridBagConstraints10);
        this.add((Component)this.vertexLabelLabel, gridBagConstraints11);
        this.add((Component)this.getVertexLabel(), gridBagConstraints12);
        this.add((Component)this.jLabel2, gridBagConstraints13);
        this.add((Component)this.getEdgesLabels(), gridBagConstraints14);
        this.newView();
    }

    private JMenuBar getJMenuBar() {
        if (this.jMenuBar == null) {
            this.jMenuBar = new JMenuBar();
            this.jMenuBar.add(this.getFileMenu());
            this.jMenuBar.add(this.getCreateMenu());
            this.jMenuBar.add(this.getViewMenu());
            this.jMenuBar.add(this.getOptionsMenu());
            this.jMenuBar.add(this.getActionsMenu());
        }
        return this.jMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText(Messages.getString("Editor.file"));
            this.fileMenu.add(this.getOpenItem());
            this.fileMenu.add(this.getReloadItem());
            this.fileMenu.add(this.getSaveItem());
            this.fileMenu.add(this.getSaveAsItem());
            this.fileMenu.add(this.getInsertItem());
            this.fileMenu.add(this.getImageItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getQuitItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getOpenItem() {
        if (this.openItem == null) {
            this.openItem = new JMenuItem();
            this.openItem.setText(Messages.getString("Editor.open"));
            this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
            this.openItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.loadFile();
                }
            });
        }
        return this.openItem;
    }

    private JMenuItem getReloadItem() {
        if (this.reloadItem == null) {
            this.reloadItem = new JMenuItem();
            this.reloadItem.setText(Messages.getString("Editor.reload"));
            this.reloadItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
            this.reloadItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this.lastLoadOrSave != null) {
                        Editor.this.loadFile(Editor.this.lastLoadOrSave);
                    }
                }
            });
        }
        return this.reloadItem;
    }

    private JMenuItem getSaveItem() {
        if (this.saveItem == null) {
            this.saveItem = new JMenuItem();
            this.saveItem.setText(Messages.getString("Editor.save"));
            this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.saveItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.saveFile();
                }
            });
        }
        return this.saveItem;
    }

    private JMenuItem getSaveAsItem() {
        if (this.saveAsItem == null) {
            this.saveAsItem = new JMenuItem();
            this.saveAsItem.setText(Messages.getString("Editor.saveAs"));
            this.saveAsItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
            this.saveAsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.lastLoadOrSave = null;
                    Editor.this.saveFile();
                }
            });
        }
        return this.saveAsItem;
    }

    private JMenuItem getInsertItem() {
        if (this.insertItem == null) {
            this.insertItem = new JMenuItem(Messages.getString("Editor.insertGraph"));
            this.insertItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
            this.insertItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.insertGraph();
                }
            });
        }
        return this.insertItem;
    }

    private JMenuItem getImageItem() {
        if (this.imageItem == null) {
            this.imageItem = new JMenuItem(Messages.getString("Editor.saveAsImage"));
            this.imageItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
            this.imageItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.dumpGraph();
                }
            });
        }
        return this.imageItem;
    }

    private JMenuItem getQuitItem() {
        if (this.quitItem == null) {
            this.quitItem = new JMenuItem(Messages.getString("Editor.quit"));
            this.quitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
            this.quitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.killEditor();
                }
            });
        }
        return this.quitItem;
    }

    private JMenu getCreateMenu() {
        if (this.createMenu == null) {
            this.createMenu = new JMenu();
            this.createMenu.setText(Messages.getString("Editor.create"));
            this.createMenu.add(this.getGraphItem());
            this.createMenu.add(this.getDiGraphItem());
            this.createMenu.add(this.getPathItem());
            this.createMenu.add(this.getDiPathItem());
            this.createMenu.add(this.getMapItem());
        }
        return this.createMenu;
    }

    private JMenuItem getGraphItem() {
        if (this.graphItem == null) {
            this.graphItem = new JMenuItem(Messages.getString("Editor.createGraph"));
            this.graphItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
            this.graphItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.newGraph();
                }
            });
        }
        return this.graphItem;
    }

    private JMenuItem getDiGraphItem() {
        if (this.diGraphItem == null) {
            this.diGraphItem = new JMenuItem(Messages.getString("Editor.createDiGraph"));
            this.diGraphItem.setAccelerator(KeyStroke.getKeyStroke(71, 8));
            this.diGraphItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.newDiGraph();
                }
            });
        }
        return this.diGraphItem;
    }

    private JMenuItem getPathItem() {
        if (this.pathItem == null) {
            this.pathItem = new JMenuItem(Messages.getString("Editor.createPath"));
            this.pathItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
            this.pathItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.newPath();
                }
            });
        }
        return this.pathItem;
    }

    private JMenuItem getDiPathItem() {
        if (this.diPathItem == null) {
            this.diPathItem = new JMenuItem(Messages.getString("Editor.createDiPath"));
            this.diPathItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
            this.diPathItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.newDiPath();
                }
            });
        }
        return this.diPathItem;
    }

    private JMenuItem getMapItem() {
        if (this.mapItem == null) {
            this.mapItem = new JMenuItem(Messages.getString("Editor.createMap"));
            this.mapItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
            this.mapItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.newMap();
                }
            });
        }
        return this.mapItem;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.setText(Messages.getString("Editor.views"));
            this.viewMenu.add(this.getNewViewItem());
            this.viewMenu.add(this.getSetBackgroundItem());
        }
        return this.viewMenu;
    }

    private JMenuItem getNewViewItem() {
        if (this.newViewItem == null) {
            this.newViewItem = new JMenuItem(Messages.getString("Editor.newView"));
            this.newViewItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.newViewItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.newView();
                }
            });
        }
        return this.newViewItem;
    }

    private JMenuItem getSetBackgroundItem() {
        if (this.setBackgroundItem == null) {
            this.setBackgroundItem = new JMenuItem(Messages.getString("Editor.setBackgroung"));
            this.setBackgroundItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
            this.setBackgroundItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.setImageBackground();
                }
            });
        }
        return this.setBackgroundItem;
    }

    private JMenu getOptionsMenu() {
        if (this.optionsMenu == null) {
            this.optionsMenu = new JMenu();
            this.optionsMenu.setText(Messages.getString("Editor.options"));
            this.optionsMenu.add(this.getAutoDisplayItem());
            this.optionsMenu.add(this.getMixVerticesItem());
        }
        return this.optionsMenu;
    }

    private JMenuItem getAutoDisplayItem() {
        if (this.autoDisplayItem == null) {
            this.autoDisplayItem = new JMenuItem(Messages.getString("Editor.autoDisplay"));
            this.autoDisplayItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.autoDisplayItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((Editor.this.autoArrangeThread == null || !Editor.this.autoArrangeThread.isAlive()) && Editor.this.objectEdited instanceof MascoptAbstractGraph) {
                        AutoArrangeGraphs autoArrange = new AutoArrangeGraphs((MascoptAbstractGraph)Editor.this.objectEdited);
                        Editor.this.autoArrangeThread = autoArrange.start();
                    }
                }
            });
        }
        return this.autoDisplayItem;
    }

    private JMenuItem getMixVerticesItem() {
        if (this.mixVerticesItem == null) {
            this.mixVerticesItem = new JMenuItem(Messages.getString("Editor.mixVertices"));
            this.mixVerticesItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
            this.mixVerticesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.mixVerticesItem.setEnabled(false);
                    AutoArrangeGraphs autoArrange = new AutoArrangeGraphs((MascoptAbstractGraph)Editor.this.objectEdited);
                    autoArrange.mixVertices();
                    Editor.this.mixVerticesItem.setEnabled(true);
                }
            });
        }
        return this.mixVerticesItem;
    }

    private JList getGraphList() {
        if (this.graphList == null) {
            this.graphList = new JList();
            this.graphList.setSelectionMode(0);
            this.graphList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = Editor.this.graphList.getSelectedIndex();
                    if (index != -1) {
                        Editor.this.editGraph(Editor.this.getGraphSelected(index));
                    }
                }
            });
            this.graphList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        int index = Editor.this.graphList.getSelectedIndex();
                        if (index == -1) {
                            return;
                        }
                        Editor.this.removeGraphSelected(index);
                        index = Editor.this.fillGraphList();
                        if (index != -1) {
                            Editor.this.editGraph(Editor.this.getGraphSelected(index));
                            Editor.this.changeCurrentContext(0);
                        } else {
                            Editor.this.layerManager.removeGraph(Editor.this.objectEdited);
                            Editor.this.objectEdited = null;
                        }
                        index = Editor.this.fillContextList();
                        Editor.this.changeCurrentContext(index);
                        Editor.this.setModified();
                    }
                }
            });
        }
        return this.graphList;
    }

    private JList getMapList() {
        if (this.mapList == null) {
            this.mapList = new JList();
            this.mapList.setSelectionMode(0);
            this.mapList.setVisibleRowCount(-1);
            this.mapList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = Editor.this.mapList.locationToIndex(e.getPoint());
                    if (index == -1) {
                        return;
                    }
                    if (e.getClickCount() > 1) {
                        Editor.this.openMapEditor(index);
                    }
                }
            });
            this.mapList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = Editor.this.mapList.getSelectedIndex();
                    if (index == -1) {
                        return;
                    }
                    Editor.this.changeCurrentMap(index);
                }
            });
            this.mapList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        int index = Editor.this.getMapList().getSelectedIndex();
                        if (index == -1 || index == 0) {
                            return;
                        }
                        Editor.this.mapsVector.remove(index - 1);
                        index = Editor.this.fillMapList();
                        Editor.this.changeCurrentMap(index);
                        Editor.this.fillNodeAndEdgeValue();
                        Editor.this.setModified();
                    }
                }
            });
        }
        return this.mapList;
    }

    private JSeparator getFirstSeparator() {
        if (this.firstSeparator == null) {
            this.firstSeparator = new JSeparator();
        }
        return this.firstSeparator;
    }

    private JSeparator getSecondSeparator() {
        if (this.secondSeparator == null) {
            this.secondSeparator = new JSeparator();
        }
        return this.secondSeparator;
    }

    private JList getContextList() {
        if (this.contextList == null) {
            this.contextList = new JList();
            this.contextList.setSelectionMode(0);
            this.contextList.setPreferredSize(new Dimension(300, 100));
            this.contextList.setName("contextList");
            this.contextList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = Editor.this.contextList.getSelectedIndex();
                    if (index == -1) {
                        return;
                    }
                    Editor.this.changeCurrentContext(index);
                }
            });
        }
        return this.contextList;
    }

    private JCheckBox getShowLabelButton() {
        if (this.showLabelButton == null) {
            this.showLabelButton = new JCheckBox();
            this.showLabelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.showLabels(Editor.this.showLabelButton.isSelected());
                }
            });
        }
        return this.showLabelButton;
    }

    private JComboBox getVertexLabel() {
        if (this.vertexLabel == null) {
            this.vertexLabel = new JComboBox();
            this.vertexLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selection = (String)Editor.this.vertexLabel.getSelectedItem();
                    if (selection == null) {
                        return;
                    }
                    if (selection.equals(Messages.getString("Editor.noLabel"))) {
                        Editor.this.layerManager.setVertexLabelGraphInLayer(Editor.this.objectEdited, Editor.this.layer, null);
                        return;
                    }
                    Editor.this.layerManager.setVertexLabelGraphInLayer(Editor.this.objectEdited, Editor.this.layer, new String[]{"$(" + selection + ")"});
                    Editor.this.getShowLabelButton().setSelected(true);
                    Editor.this.layerManager.setVertexLabelGraphInLayerVisibility(Editor.this.objectEdited, Editor.this.layer, Editor.this.getShowLabelButton().isSelected());
                }
            });
        }
        return this.vertexLabel;
    }

    private JComboBox getEdgesLabels() {
        if (this.edgesLabels == null) {
            this.edgesLabels = new JComboBox();
            this.edgesLabels.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selection = (String)Editor.this.edgesLabels.getSelectedItem();
                    if (selection == null) {
                        return;
                    }
                    if (selection.equals(Messages.getString("Editor.noLabel"))) {
                        Editor.this.layerManager.setEdgeLabelGraphInLayer(Editor.this.objectEdited, Editor.this.layer, null);
                        return;
                    }
                    Editor.this.layerManager.setEdgeLabelGraphInLayer(Editor.this.objectEdited, Editor.this.layer, new String[]{"$(" + selection + ")"});
                    Editor.this.getShowLabelButton().setSelected(true);
                    Editor.this.layerManager.setEdgeLabelGraphInLayerVisibility(Editor.this.objectEdited, Editor.this.layer, Editor.this.getShowLabelButton().isSelected());
                }
            });
        }
        return this.edgesLabels;
    }

    private JMenu getActionsMenu() {
        if (this.actionsMenu == null) {
            this.actionsMenu = new JMenu();
            this.actionsMenu.setText(Messages.getString("Editor.actions"));
            this.actionsMenu.add(this.getCreateButton());
            this.actionsMenu.add(this.getDeleteButton());
            this.actionsMenu.add(this.getSetNameButton());
            this.actionsMenu.add(this.getSetColorButton());
            this.actionsMenu.add(this.getSetValueButton());
        }
        return this.actionsMenu;
    }

    private ButtonGroup getActionsGroup() {
        if (this.actionsGroup == null) {
            this.actionsGroup = new ButtonGroup();
        }
        return this.actionsGroup;
    }

    private JRadioButtonMenuItem getCreateButton() {
        if (this.createButton == null) {
            this.createButton = new JRadioButtonMenuItem();
            this.createButton.setSelected(true);
            this.createButton.setText(Messages.getString("Editor.create"));
            this.createButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.el.setAction(0);
                    Editor.this.viewsSetCursor(new Cursor(0));
                }
            });
            this.getActionsGroup().add(this.createButton);
        }
        return this.createButton;
    }

    private JRadioButtonMenuItem getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JRadioButtonMenuItem();
            this.deleteButton.setText(Messages.getString("Editor.delete"));
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.el.setAction(1);
                }
            });
            this.getActionsGroup().add(this.deleteButton);
        }
        return this.deleteButton;
    }

    private JRadioButtonMenuItem getSetNameButton() {
        if (this.setNameButton == null) {
            this.setNameButton = new JRadioButtonMenuItem();
            this.setNameButton.setText(Messages.getString("Editor.setName"));
            this.setNameButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.el.setAction(4);
                    Editor.this.viewsSetCursor(new Cursor(2));
                }
            });
            this.getActionsGroup().add(this.setNameButton);
        }
        return this.setNameButton;
    }

    private JRadioButtonMenuItem getSetColorButton() {
        if (this.setColorButton == null) {
            this.setColorButton = new JRadioButtonMenuItem();
            this.setColorButton.setText(Messages.getString("Editor.setColor"));
            this.setColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.el.setAction(3);
                }
            });
            this.getActionsGroup().add(this.setColorButton);
        }
        return this.setColorButton;
    }

    private JRadioButtonMenuItem getSetValueButton() {
        if (this.setValueButton == null) {
            this.setValueButton = new JRadioButtonMenuItem();
            this.setValueButton.setText(Messages.getString("Editor.setValue"));
            this.setValueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Editor.this.el.setAction(2);
                    Editor.this.viewsSetCursor(new Cursor(2));
                }
            });
            this.getActionsGroup().add(this.setValueButton);
        }
        return this.setValueButton;
    }

    private Point computeMiddle(MascoptObject editedObject) {
        int x = 0;
        int y = 0;
        int nbVertex = 0;
        if (editedObject == null) {
            return new Point(0, 0);
        }
        if (editedObject instanceof MascoptAbstractGraph) {
            for (MascoptVertex v : ((MascoptAbstractGraph)editedObject).vertexSet()) {
                x = (int)((double)x + v.getX());
                y = (int)((double)y + v.getY());
                ++nbVertex;
            }
            return new Point(x / (nbVertex == 0 ? 1 : nbVertex), y / (nbVertex == 0 ? 1 : nbVertex));
        }
        if (editedObject instanceof MascoptAbstractGraph) {
            MascoptAbstractPath p;
            Iterator<MascoptVertex> vertexIt = p.vertexIterator((p = (MascoptAbstractPath)editedObject).isDirected() ? p.getFirstVertex() : p.getEnds()[0]);
            while (vertexIt.hasNext()) {
                MascoptVertex v = vertexIt.next();
                x = (int)((double)x + v.getX());
                y = (int)((double)y + v.getY());
                ++nbVertex;
            }
            return new Point(x / (nbVertex == 0 ? 1 : nbVertex), y / (nbVertex == 0 ? 1 : nbVertex));
        }
        return new Point(0, 0);
    }

    public void editGraph(MascoptObject g) {
        if (this.objectEdited != null) {
            this.layerManager.removeGraph(this.objectEdited);
        }
        this.objectEdited = g;
        this.layerManager.addGraph(g);
        try {
            this.layerManager.setVisibleGraphInLayer(g, this.layer, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.layerManager.setGraphLinkWidth(g, this.layer, 2);
        this.layerManager.setVisibleLabels(false);
        this.layerManager.setGraphLayerMapValues(g, this.layer, this.currentMap);
        this.layerManager.setGraphLayerContextValues(g, this.layer, this.currentContext);
        this.el.setGraph(g);
        this.fillNodeAndEdgeValue();
        this.getVertexLabel().setSelectedIndex(0);
        this.getEdgesLabels().setSelectedIndex(0);
        GView viewZero = this.gViewVector.get(0);
        if (viewZero != null) {
            Point center = this.computeMiddle(g);
            viewZero.setRealCenter(center);
            viewZero.repaint();
        }
        for (JFrame current : this.jFrameVector) {
            current.setTitle(g.getName());
        }
        this.viewsRepaint();
    }

    void fillNodeAndEdgeValue() {
        String nodeSelection = (String)this.getVertexLabel().getSelectedItem();
        String edgeSelection = (String)this.getEdgesLabels().getSelectedItem();
        if (this.objectEdited instanceof MascoptAbstractGraph) {
            this.addValuesToLabelsComboBox(this.getVertexLabel(), ((MascoptAbstractGraph)this.objectEdited).vertexSet(), nodeSelection);
            this.addValuesToLabelsComboBox(this.getEdgesLabels(), (MascoptSet)((MascoptAbstractGraph)this.objectEdited).edgeSet(), edgeSelection);
        } else if (this.objectEdited instanceof MascoptAbstractPath) {
            MascoptAbstractPath p = (MascoptAbstractPath)this.objectEdited;
            MascoptVertexSet vertexSet = new MascoptVertexSet();
            MascoptAbstractLinkSet<MascoptAbstractLink> edgeSet = p.getFactory().getGraphFactory().newEdgeSet(vertexSet);
            Iterator<MascoptVertex> itVertex = p.vertexIterator(p.isDirected() ? p.getFirstVertex() : p.getEnds()[0]);
            while (itVertex.hasNext()) {
                vertexSet.add(itVertex.next());
            }
            this.addValuesToLabelsComboBox(this.getVertexLabel(), vertexSet, nodeSelection);
            Iterator itEdge = p.edgeIterator(p.isDirected() ? p.getFirstVertex() : p.getEnds()[0]);
            while (itEdge.hasNext()) {
                edgeSet.add((MascoptAbstractLink)itEdge.next());
            }
            this.addValuesToLabelsComboBox(this.getEdgesLabels(), edgeSet, edgeSelection);
        } else assert (false);
    }

    private <T extends MascoptObject> void addValuesToLabelsComboBox(JComboBox combo, MascoptSet<T> s, String selection) {
        combo.removeAllItems();
        Iterator<T> itElements = s.iterator();
        HashSet<String> set = new HashSet<String>();
        while (itElements.hasNext()) {
            MascoptObject node = (MascoptObject)itElements.next();
            Iterator<Object> it_value = this.currentMap == null ? new Vector().iterator() : (this.currentContext == null ? this.currentMap.namesIterator(node) : this.currentMap.namesIterator(node, this.currentContext));
            while (it_value.hasNext()) {
                String currentValue = (String)it_value.next();
                if (currentValue.equals("id") || currentValue.equals("name")) continue;
                set.add(currentValue);
            }
        }
        combo.addItem(Messages.getString("Editor.noLabel"));
        combo.addItem("name");
        combo.addItem("id");
        Iterator it_set = set.iterator();
        boolean exist = false;
        while (it_set.hasNext()) {
            String current = (String)it_set.next();
            if (selection != null && selection.equals(current)) {
                exist = true;
            }
            combo.addItem(current);
        }
        if (exist) {
            combo.setSelectedItem(selection);
        } else {
            combo.setSelectedIndex(0);
            if (combo == this.getVertexLabel()) {
                this.layerManager.setVertexLabelGraphInLayerVisibility(this.objectEdited, this.layer, false);
            } else if (combo == this.getEdgesLabels()) {
                this.layerManager.setEdgeLabelGraphInLayerVisibility(this.objectEdited, this.layer, false);
            }
        }
    }

    private void viewsRepaint() {
        for (GView current : this.gViewVector) {
            current.repaint();
        }
    }

    private MascoptObject getGraphSelected(int index) {
        if (this.graphVector.size() - 1 < index) {
            if (this.pathVector.size() <= index - this.graphVector.size()) {
                return null;
            }
            return this.pathVector.get(index - this.graphVector.size());
        }
        return this.graphVector.get(index);
    }

    void changeCurrentMap(int index) {
        this.currentMap = index == 0 ? null : this.mapsVector.get(index - 1);
        if (this.objectEdited != null) {
            this.layerManager.setGraphLayerMapValues(this.objectEdited, this.layer, this.currentMap);
            this.fillNodeAndEdgeValue();
        }
    }

    private void openMapEditor(int index) {
        if (index == 0) {
            return;
        }
        MascoptMap mapToEdit = this.mapsVector.get(index - 1);
        MapEditor ed = new MapEditor();
        ed.setEditedMap(mapToEdit);
        ed.fillComboBox();
    }

    void changeCurrentContext(int index) {
        this.currentContext = index == 0 ? null : (MascoptObject)this.graphVector.get(index - 1);
        if (this.objectEdited != null) {
            this.layerManager.setGraphLayerContextValues(this.objectEdited, this.layer, this.currentContext);
            this.fillNodeAndEdgeValue();
        }
    }

    void setModified() {
        this.noSaved = true;
    }

    public void loadFile() {
        String fileName = MascoptChooser.getFileName("./", new String[]{"mgl", "snd"}, Messages.getString("Editor.mglFile"), Messages.getString("Editor.load"));
        if (fileName != null) {
            this.loadFile(fileName);
        }
    }

    public void loadFile(String fileName) {
        Object[] errorMessage;
        int answer;
        if (this.noSaved && (answer = JOptionPane.showConfirmDialog(null, errorMessage = new Object[]{Messages.getString("Editor.modifcationNotSave"), Messages.getString("Editor.continue")}, Messages.getString("Editor.exiting"), 2)) == 2) {
            return;
        }
        this.vertexSetVector = new Vector();
        this.graphVector = new Vector();
        this.pathVector = new Vector();
        this.mapsVector = new Vector();
        try {
            Reader reader = fileName.endsWith(".mgl") ? new MGLSaxReader(fileName) : new SNDNetworkNativeReader(fileName);
            reader.parse();
            Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> itGraph = reader.getGraphs();
            while (itGraph.hasNext()) {
                this.graphVector.add(itGraph.next());
            }
            Iterator<MascoptMap> itMap = reader.getMaps();
            while (itMap.hasNext()) {
                this.mapsVector.add(itMap.next());
            }
            Iterator<MascoptAbstractPath<? extends MascoptAbstractLink>> itPath = reader.getPaths();
            while (itPath.hasNext()) {
                this.pathVector.add(itPath.next());
            }
            Iterator<MascoptVertexSet> itVertexSet = reader.getVertexSets();
            while (itVertexSet.hasNext()) {
                this.vertexSetVector.add(itVertexSet.next());
            }
            this.lastLoadOrSave = fileName;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getClass() + ":" + e.getMessage(), Messages.getString("Editor.error"), 0);
        }
        this.fillMapList();
        this.fillContextList();
        this.fillGraphList();
        if (this.graphVector.size() == 0 && this.pathVector.size() == 0) {
            JOptionPane.showMessageDialog(this, Messages.getString("Editor.noGraph"), Messages.getString("Editor.error"), 0);
            if (this.objectEdited != null) {
                this.layerManager.removeGraph(this.objectEdited);
                this.objectEdited = null;
            }
        } else {
            this.editGraph(this.getGraphSelected(0));
        }
        this.graphList.setSelectedIndex(0);
        this.getMapList().setSelectedIndex(0);
        this.changeCurrentMap(0);
        this.getContextList().setSelectedIndex(0);
        this.changeCurrentContext(0);
        this.noSaved = false;
    }

    private int fillMapList() {
        int previousSelection = 0;
        if (this.getMapList().getSelectedIndex() != -1) {
            previousSelection = this.getMapList().getSelectedIndex();
        }
        if (previousSelection > this.mapsVector.size()) {
            previousSelection = this.mapsVector.size();
        }
        Vector<String> mapName = new Vector<String>();
        mapName.add(Messages.getString("Editor.noMap"));
        Iterator<MascoptMap> it = this.mapsVector.iterator();
        while (it.hasNext()) {
            mapName.add(((MascoptObject)it.next()).getName());
        }
        this.getMapList().setListData(mapName);
        this.getMapList().setSelectedIndex(previousSelection);
        return previousSelection;
    }

    int fillContextList() {
        int previousSelection = 0;
        if (this.getContextList().getSelectedIndex() != -1) {
            previousSelection = this.getContextList().getSelectedIndex();
        }
        if (previousSelection > this.graphVector.size()) {
            previousSelection = this.graphVector.size();
        }
        Vector<String> contextName = new Vector<String>();
        contextName.add(Messages.getString("Editor.noContext"));
        Iterator<MascoptAbstractGraph> it = this.graphVector.iterator();
        while (it.hasNext()) {
            contextName.add(((MascoptObject)it.next()).getName());
        }
        this.getContextList().setListData(contextName);
        this.getContextList().setSelectedIndex(previousSelection);
        return previousSelection;
    }

    private int fillGraphList() {
        int previousSelection = 0;
        if (this.graphList.getSelectedIndex() != -1) {
            previousSelection = this.graphList.getSelectedIndex();
        }
        if (previousSelection > this.graphVector.size() + this.pathVector.size() - 1) {
            previousSelection = this.graphVector.size() + this.pathVector.size() - 1;
        }
        Vector<String> graphName = new Vector<String>();
        Iterator<MascoptAbstractGraph> itGraph = this.graphVector.iterator();
        while (itGraph.hasNext()) {
            graphName.add(((MascoptObject)itGraph.next()).getName());
        }
        Iterator<MascoptAbstractPath> itPath = this.pathVector.iterator();
        while (itPath.hasNext()) {
            graphName.add(((MascoptObject)itPath.next()).getName());
        }
        this.graphList.setListData(graphName);
        this.graphList.setSelectedIndex(previousSelection);
        if ((this.graphVector.size() > 0 || this.pathVector.size() > 0) && this.objectEdited != this.getGraphSelected(previousSelection)) {
            this.editGraph(this.getGraphSelected(previousSelection));
        }
        if (this.graphVector.size() == 0 && this.pathVector.size() == 0) {
            return -1;
        }
        return previousSelection;
    }

    public void saveFile() {
        String fileName = this.lastLoadOrSave == null ? MascoptChooser.getFileName("./", new String[]{"mgl"}, Messages.getString("Editor.mglFile"), Messages.getString("Editor.save")) : this.lastLoadOrSave;
        if (fileName == null) {
            return;
        }
        try {
            MGLWriter writer = new MGLWriter(fileName);
            Iterator<MascoptObject> it = this.graphVector.iterator();
            System.out.print(Messages.getString("Editor.savingGraph"));
            while (it.hasNext()) {
                MascoptAbstractGraph g = it.next();
                writer.add(g);
                System.out.print(g.getName());
                if (!it.hasNext()) continue;
                System.out.print(",");
            }
            System.out.println(".");
            it = this.mapsVector.iterator();
            System.out.print(Messages.getString("Editor.savinfMap"));
            while (it.hasNext()) {
                MascoptMap map = (MascoptMap)it.next();
                writer.add(map);
                System.out.print(map.getName());
                if (!it.hasNext()) continue;
                System.out.print(",");
            }
            System.out.println(".");
            it = this.pathVector.iterator();
            System.out.print(Messages.getString("Editor.savingPath"));
            while (it.hasNext()) {
                MascoptAbstractPath path = (MascoptAbstractPath)it.next();
                writer.add(path);
                System.out.print(path.getName());
                if (!it.hasNext()) continue;
                System.out.print(",");
            }
            System.out.println(".");
            writer.write();
            System.out.println(String.format(Messages.getString("Editor.succesSave"), fileName));
        }
        catch (FileNotFoundException e) {
            System.err.println(String.valueOf(Messages.getString("Editor.errorWriting")) + fileName + ".");
            e.printStackTrace();
        }
        this.lastLoadOrSave = fileName;
        this.noSaved = false;
    }

    public void insertGraph() {
        Object[] message = new Object[3];
        JPanel jpX = new JPanel();
        JTextField jtfX = new JTextField(this.oldX, 5);
        jpX.add(new JLabel("X:"));
        jpX.add(jtfX);
        JPanel jpY = new JPanel();
        JTextField jtfY = new JTextField(this.oldY, 5);
        jpY.add(new JLabel("Y:"));
        jpY.add(jtfY);
        message[0] = new JLabel(Messages.getString("Editor.insertGraphAt"));
        message[1] = jpX;
        message[2] = jpY;
        JOptionPane.showMessageDialog(null, message, Messages.getString("Editor.info"), 1);
        this.oldX = jtfX.getText();
        this.oldY = jtfY.getText();
        double x = 0.0;
        double y = 0.0;
        try {
            x = Double.parseDouble(this.oldX);
            y = Double.parseDouble(this.oldY);
        }
        catch (NumberFormatException e) {
            System.out.println(Messages.getString("Editor.filedMustBeNumeric"));
            return;
        }
        MGLDOMReader reader = MascoptChooser.getMGLDomReader();
        MascoptAbstractGraph<? extends MascoptAbstractLink> ag = MascoptChooser.getAbstractGraph(reader);
        if (ag != null) {
            if (this.objectEdited == null) {
                this.editGraph(ag);
            } else {
                if (!(this.objectEdited instanceof MascoptAbstractGraph)) {
                    message = new Object[]{"The object " + this.objectEdited + " is not a graph", Messages.getString("Editor.cantInsertGraph")};
                    JOptionPane.showMessageDialog(null, message, Messages.getString("Editor.info"), 1);
                    return;
                }
                MascoptVertexSet vs = ((MascoptAbstractGraph)this.objectEdited).vertexSet();
                HierarchicalSet aes = ((MascoptAbstractGraph)this.objectEdited).edgeSet();
                for (MascoptVertex an : ag.vertexSet()) {
                    an.setX(an.getX() + x);
                    an.setY(an.getY() + y);
                    vs.add(an);
                }
                Iterator itE = ((MascoptAbstractLinkSet)ag.edgeSet()).iterator();
                while (itE.hasNext()) {
                    ((MascoptAbstractLinkSet)aes).add((MascoptAbstractLink)itE.next());
                }
                this.setModified();
            }
        }
    }

    private void addVectorToComboBox(Vector v, JComboBox combo) {
        for (Object obj : v) {
            Object current;
            if (obj instanceof MascoptObject) {
                current = (MascoptObject)obj;
                combo.addItem(((MascoptObject)current).getName());
                continue;
            }
            if (obj instanceof GView) {
                current = (GView)obj;
                combo.addItem(((GView)current).getName());
                continue;
            }
            assert (false);
        }
    }

    public void dumpGraph() {
        GView viewToDump;
        if (this.gViewVector.size() == 0) {
            return;
        }
        String fileName = MascoptChooser.getFileName("./", new String[]{"png"}, Messages.getString("Editor.imagesFile"), Messages.getString("Editor.save"));
        if (fileName == null) {
            return;
        }
        if (this.gViewVector.size() == 1) {
            viewToDump = this.gViewVector.get(0);
        } else {
            JComboBox<String> viewList;
            do {
                Object[] message = new Object[2];
                viewList = new JComboBox<String>();
                viewList.addItem(Messages.getString("Editor.newOne"));
                viewList.removeAllItems();
                this.addVectorToComboBox(this.gViewVector, viewList);
                message[0] = new JLabel(Messages.getString("Editor.selectDumpView"));
                message[1] = viewList;
                JOptionPane.showMessageDialog(null, message, Messages.getString("Editor.info"), 1);
            } while (viewList.getSelectedIndex() < 0);
            viewToDump = this.gViewVector.get(viewList.getSelectedIndex());
        }
        try {
            BufferedImage bufferedImage = new BufferedImage(viewToDump.getWidth(), viewToDump.getHeight(), 1);
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.setColor(Color.lightGray);
            g2d.fillRect(0, 0, viewToDump.getWidth(), viewToDump.getHeight());
            viewToDump.paint(g2d);
            g2d.dispose();
            if (!fileName.endsWith(".png") && !fileName.endsWith(".PNG")) {
                fileName = String.valueOf(fileName) + ".png";
            }
            File file = new File(fileName);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            JOptionPane.showMessageDialog(this, Messages.getString("Editor.Done"), Messages.getString("Editor.done"), 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void killEditor() {
        if (this.noSaved) {
            Object[] errorMessage = new Object[]{Messages.getString("Editor.modifcationNotSave"), Messages.getString("Editor.continue")};
            int answer = JOptionPane.showConfirmDialog(null, errorMessage, Messages.getString("Editor.exiting"), 2);
            if (answer == 2) {
                return;
            }
        }
        System.out.println(Messages.getString("Editor.exitEditor"));
        System.exit(0);
    }

    public void newGraph() {
        MascoptVertexSet ns;
        Object[] message = new Object[3];
        JPanel jpName = new JPanel();
        JTextField jtfName = new JTextField("", 10);
        jpName.add(new JLabel(Messages.getString("Editor.nameLabel")));
        jpName.add(jtfName);
        JPanel vertexSetPanel = new JPanel();
        JLabel mes = new JLabel(Messages.getString("Editor.vertexSet"));
        JComboBox<String> vertexSetList = new JComboBox<String>();
        vertexSetList.addItem(Messages.getString("Editor.newOne"));
        this.addVectorToComboBox(this.vertexSetVector, vertexSetList);
        vertexSetPanel.add(mes);
        vertexSetPanel.add(vertexSetList);
        message[0] = new JLabel(Messages.getString("Editor.graphInfo"));
        message[1] = jpName;
        message[2] = vertexSetPanel;
        JOptionPane.showMessageDialog(null, message, Messages.getString("Editor.info"), 1);
        int index = vertexSetList.getSelectedIndex();
        if (index > 0 && index < vertexSetList.getItemCount()) {
            ns = this.vertexSetVector.get(index - 1);
        } else {
            ns = new MascoptVertexSet();
            this.vertexSetVector.add(ns);
        }
        String name = jtfName.getText();
        MascoptEdgeSet es = new MascoptEdgeSet(ns);
        MascoptGraph g = new MascoptGraph(es);
        if (!name.equals("")) {
            g.setName(name);
        }
        this.graphVector.add(g);
        this.fillGraphList();
        this.fillContextList();
        this.setModified();
    }

    public void newDiGraph() {
        MascoptVertexSet ns;
        Object[] message = new Object[3];
        JPanel jpName = new JPanel();
        JTextField jtfName = new JTextField("", 10);
        jpName.add(new JLabel(Messages.getString("Editor.nameLabel")));
        jpName.add(jtfName);
        JPanel vertexSetPanel = new JPanel();
        JLabel mes = new JLabel(Messages.getString("Editor.vertexSet"));
        JComboBox<String> vertexSetList = new JComboBox<String>();
        vertexSetList.addItem(Messages.getString("Editor.newOne"));
        this.addVectorToComboBox(this.vertexSetVector, vertexSetList);
        vertexSetPanel.add(mes);
        vertexSetPanel.add(vertexSetList);
        message[0] = new JLabel(Messages.getString("Editor.diGraphInfo"));
        message[1] = jpName;
        message[2] = vertexSetPanel;
        JOptionPane.showMessageDialog(null, message, Messages.getString("Editor.info"), 1);
        int index = vertexSetList.getSelectedIndex();
        if (index > 0 && index < vertexSetList.getItemCount()) {
            ns = this.vertexSetVector.get(index - 1);
        } else {
            ns = new MascoptVertexSet();
            this.vertexSetVector.add(ns);
        }
        String name = jtfName.getText();
        MascoptArcSet as = new MascoptArcSet(ns);
        MascoptDiGraph dg = new MascoptDiGraph(as);
        if (!name.equals("")) {
            dg.setName(name);
        }
        this.graphVector.add(dg);
        index = this.fillGraphList();
        this.editGraph(this.graphVector.get(index));
        index = this.fillContextList();
        this.changeCurrentContext(index);
        this.setModified();
    }

    public void newPath() {
        Object[] message = new Object[2];
        JPanel jpName = new JPanel();
        JTextField jtfName = new JTextField("", 10);
        jpName.add(new JLabel(Messages.getString("Editor.nameLabel")));
        jpName.add(jtfName);
        message[0] = new JLabel(Messages.getString("Editor.pathInfo"));
        message[1] = jpName;
        JOptionPane.showMessageDialog(null, message, Messages.getString("Editor.info"), 1);
        String name = jtfName.getText();
        MascoptPath p = new MascoptPath();
        if (!name.equals("")) {
            p.setName(name);
        }
        this.pathVector.add(p);
        this.fillGraphList();
        this.fillContextList();
        this.setModified();
    }

    public void newDiPath() {
        Object[] message = new Object[2];
        JPanel jpName = new JPanel();
        JTextField jtfName = new JTextField("", 10);
        jpName.add(new JLabel(Messages.getString("Editor.nameLabel")));
        jpName.add(jtfName);
        message[0] = new JLabel(Messages.getString("Editor.diPathInfo"));
        message[1] = jpName;
        JOptionPane.showMessageDialog(null, message, Messages.getString("Editor.info"), 1);
        String name = jtfName.getText();
        MascoptDiPath p = new MascoptDiPath();
        if (!name.equals("")) {
            p.setName(name);
        }
        this.pathVector.add(p);
        this.fillGraphList();
        this.fillContextList();
        this.setModified();
    }

    public void newMap() {
        MascoptMap map = new MascoptMap();
        Object[] message = new Object[2];
        JPanel jpName = new JPanel();
        JTextField jtfName = new JTextField("", 10);
        jpName.add(new JLabel(Messages.getString("Editor.nameLabel")));
        jpName.add(jtfName);
        message[0] = new JLabel(Messages.getString("Editor.mapInfo"));
        message[1] = jpName;
        JOptionPane.showMessageDialog(null, message, Messages.getString("Editor.info"), 1);
        String name = jtfName.getText();
        if (!name.equals("")) {
            map.setName(name);
        }
        this.mapsVector.add(map);
        this.fillMapList();
        this.setModified();
    }

    public void newView() {
        GView vv = this.layerManager.newView(String.valueOf(Messages.getString("Editor.view")) + ++this.viewNumber, 800, 600, 1.0);
        this.layerManager.addLayerInView(this.layer, vv);
        this.createViewFrame(vv, 500, 500, null);
    }

    private JFrame createViewFrame(GView v, int w, int h, JPanel title) {
        JFrame jfView = new JFrame(v.getName());
        JPanel jpM = new JPanel();
        jpM.setLayout(new BorderLayout());
        if (title != null) {
            jpM.add((Component)title, "North");
        }
        jpM.add((Component)v, "Center");
        jfView.getContentPane().add(jpM);
        v.setPreferredSize(new Dimension(w, h));
        jfView.pack();
        jfView.setVisible(true);
        ViewWindowListener viewListener = new ViewWindowListener(this, v);
        jfView.addWindowListener(viewListener);
        this.gViewVector.add(v);
        this.jFrameVector.add(jfView);
        return jfView;
    }

    void removeOneView(JFrame frame) {
        int index = this.jFrameVector.indexOf(frame);
        assert (index != -1);
        this.gViewVector.remove(index);
        this.jFrameVector.remove(index);
    }

    private void viewsSetBackground(Image image) {
        for (GView current : this.gViewVector) {
            current.setBackGroundImage(image);
            current.repaint();
        }
    }

    public void setImageBackground() {
        String fileName = MascoptChooser.getFileName("./", new String[]{"png"}, Messages.getString("Editor.imageFile"), Messages.getString("Editor.load"));
        if (fileName != null) {
            File file = new File(fileName);
            try {
                BufferedImage image = ImageIO.read(file);
                this.viewsSetBackground(image);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("Editor.error"), 0);
            }
        }
    }

    private void viewsSetCursor(Cursor cursor) {
        for (GView current : this.gViewVector) {
            current.setCursor(cursor);
        }
    }

    public void showLabels(boolean show) {
        this.getShowLabelButton().setSelected(show);
        this.layerManager.setVisibleLabels(show);
    }

    private void removeGraphSelected(int index) {
        if (this.graphVector.size() - 1 < index) {
            if (this.pathVector.size() <= index - this.graphVector.size()) {
                return;
            }
            this.pathVector.remove(index - this.graphVector.size());
            return;
        }
        this.graphVector.remove(index);
    }

    private JScrollPane getJScrollPaneMapList() {
        if (this.jScrollPaneMapList == null) {
            this.jScrollPaneMapList = new JScrollPane();
            this.jScrollPaneMapList.setViewportView(this.getMapList());
            this.jScrollPaneMapList.setVerticalScrollBarPolicy(20);
            this.jScrollPaneMapList.setHorizontalScrollBarPolicy(30);
        }
        return this.jScrollPaneMapList;
    }

    private JScrollPane getJScrollPaneGraphList() {
        if (this.jScrollPaneGraphList == null) {
            this.jScrollPaneGraphList = new JScrollPane();
            this.jScrollPaneGraphList.setViewportView(this.getGraphList());
            this.jScrollPaneGraphList.setVerticalScrollBarPolicy(20);
            this.jScrollPaneGraphList.setHorizontalScrollBarPolicy(30);
        }
        return this.jScrollPaneGraphList;
    }

    private JScrollPane getJScrollPaneContextList() {
        if (this.jScrollPaneContextList == null) {
            this.jScrollPaneContextList = new JScrollPane();
            this.jScrollPaneContextList.setViewportView(this.getContextList());
            this.jScrollPaneContextList.setVerticalScrollBarPolicy(20);
            this.jScrollPaneContextList.setHorizontalScrollBarPolicy(30);
        }
        return this.jScrollPaneContextList;
    }
}

