/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.editor;

import bridge.abstractClasses.AbstractScalar;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.View;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptDiPath;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.gui.editor.Editor;
import mascoptLib.gui.editor.Messages;
import mascoptLib.gui.layerManager.DefaultEventListener;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GView;
import mascoptLib.gui.layerManager.Selectable;
import mascoptLib.numeric.MascoptDouble;
import mascoptLib.numeric.MascoptInteger;
import mascoptLib.numeric.MascoptMPDecimal;
import mascoptLib.numeric.MascoptMPInteger;

class ViewsEditorListener
extends DefaultEventListener {
    static final int CREATE = 0;
    static final int DESTROY = 1;
    static final int SET_VALUE = 2;
    static final int SET_COLOR = 3;
    static final int SET_NAME = 4;
    private MascoptObject ag;
    private GLayer layer;
    private int action = 0;
    private String currentEntry = "";
    private String currentValue = "";
    private Color currentColor = Color.white;
    private String currentName = "";
    private Editor editor;
    private static JComboBox typeList = new JComboBox();
    private boolean creatingLink = false;

    static {
        typeList.addItem("MascoptInteger");
        typeList.addItem("MascoptDouble");
        typeList.addItem("MascoptMPInteger");
        typeList.addItem("MascoptMPDecimal");
        typeList.addItem("String");
    }

    public ViewsEditorListener(Editor editor) {
        this.setAction(0);
        this.editor = editor;
    }

    public void setGraph(MascoptObject ag) {
        this.ag = ag;
    }

    public void setLayer(GLayer gl) {
        this.layer = gl;
    }

    public void setAction(int type) {
        this.action = type;
    }

    private Object getValuesFromStringAndType(String valueString, int type) {
        switch (type) {
            case 0: {
                try {
                    return new MascoptInteger(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 1: {
                try {
                    return new MascoptDouble(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 2: {
                try {
                    return new MascoptMPInteger(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 3: {
                try {
                    return new MascoptMPDecimal(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 4: {
                return valueString;
            }
        }
        assert (false);
        return null;
    }

    private void destroyOperation(MascoptObject select) {
        if (this.ag instanceof MascoptAbstractGraph) {
            if (select instanceof MascoptVertex) {
                if (this.ag != null) {
                    ((MascoptAbstractGraph)this.ag).vertexSet().remove(select);
                    this.editor.setModified();
                }
            } else if (select instanceof MascoptAbstractLink && this.ag != null) {
                ((MascoptAbstractLinkSet)((MascoptAbstractGraph)this.ag).edgeSet()).remove(select);
                this.editor.setModified();
            }
        } else {
            try {
                if (select instanceof MascoptVertex) {
                    ((MascoptAbstractPath)this.ag).remove((MascoptVertex)select);
                } else if (select instanceof MascoptAbstractLink) {
                    ((MascoptAbstractPath)this.ag).remove((MascoptAbstractLink)select);
                }
            }
            catch (IllegalArgumentException e) {
                Object[] errorMessage = new Object[]{e.getMessage()};
                JOptionPane.showConfirmDialog(null, errorMessage, Messages.getString("ViewsEditorListener.removeError"), -1, 0);
            }
        }
    }

    private void setValuesOperation(MascoptObject select) {
        Object value;
        int type;
        String boxMessage;
        MascoptMap map = this.getLayerManager().getGraphLayerMapValues(this.ag, this.layer);
        MascoptObject context = this.getLayerManager().getGraphLayerContextValues(this.ag, this.layer);
        if (select instanceof MascoptVertex) {
            boxMessage = Messages.getString("ViewsEditorListener.setValueNode");
        } else if (select instanceof MascoptAbstractLink) {
            boxMessage = Messages.getString("ViewsEditorListener.setValueEdge");
        } else {
            return;
        }
        if (map == null) {
            Object[] errorMessage = new Object[]{Messages.getString("ViewsEditorListener.cantSetValue")};
            JOptionPane.showMessageDialog(null, errorMessage, Messages.getString("ViewsEditorListener.setValueError"), 0);
            return;
        }
        boolean finish = false;
        do {
            Object[] errorMessage;
            finish = true;
            Object[] message = new Object[4];
            JPanel jpEntry = new JPanel();
            JTextField jtfEntry = new JTextField(this.currentEntry, 10);
            jpEntry.add(new JLabel(Messages.getString("ViewsEditorListener.nameLabel")));
            jpEntry.add(jtfEntry);
            JPanel jpValue = new JPanel();
            JTextField jtfValue = new JTextField(this.currentValue, 10);
            jpValue.add(new JLabel(Messages.getString("ViewsEditorListener.valueLabel")));
            jpValue.add(jtfValue);
            message[0] = new JLabel(String.valueOf(boxMessage) + select.getId());
            message[1] = jpEntry;
            message[2] = jpValue;
            message[3] = typeList;
            if (JOptionPane.showConfirmDialog(null, message, Messages.getString("ViewsEditorListener.info"), 2) == 2) {
                return;
            }
            this.currentEntry = jtfEntry.getText();
            this.currentValue = jtfValue.getText();
            type = typeList.getSelectedIndex();
            value = this.getValuesFromStringAndType(this.currentValue, type);
            if (this.currentEntry.equals("")) {
                finish = false;
                errorMessage = new Object[]{Messages.getString("ViewsEditorListener.nameCantBeEmpty")};
                JOptionPane.showMessageDialog(null, errorMessage, Messages.getString("ViewsEditorListener.setValueError"), 2);
                continue;
            }
            if (value != null) continue;
            finish = false;
            finish = false;
            errorMessage = new Object[]{this.currentValue + Messages.getString("ViewsEditorListener.notValid") + (type == 0 ? "Integer" : "Double")};
            JOptionPane.showMessageDialog(null, errorMessage, Messages.getString("ViewsEditorListener.setValueError"), 2);
        } while (!finish);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                map.putValue(select, this.currentEntry, context == null ? select : context, (AbstractScalar)value);
                break;
            }
            case 4: {
                map.putString(select, this.currentEntry, context == null ? select : context, (String)value);
                break;
            }
            default: {
                assert (false);
                throw new RuntimeException("Warning the type of value is unknow !");
            }
        }
        this.editor.setModified();
        this.editor.fillNodeAndEdgeValue();
    }

    private void setColorOperation(MascoptObject select) {
        if (!(select instanceof MascoptVertex) && !(select instanceof MascoptAbstractLink)) {
            return;
        }
        Color newColor = JColorChooser.showDialog(null, Messages.getString("ViewsEditorListener.colorChooser"), this.currentColor);
        if (newColor == null) {
            return;
        }
        select.setColor(newColor.getRGB());
        this.currentColor = newColor;
        this.editor.setModified();
    }

    private void setNameOperation(MascoptObject select) {
        String input = "";
        if (select instanceof MascoptVertex) {
            input = String.valueOf(Messages.getString("ViewsEditorListener.nameVertex")) + select.getName();
        } else if (select instanceof MascoptAbstractLink) {
            input = String.valueOf(Messages.getString("ViewsEditorListener.nameEdge")) + select.getName();
        } else if (select instanceof MascoptAbstractGraph) {
            select = this.ag;
            input = String.valueOf(Messages.getString("ViewsEditorListener.nameGraph")) + this.ag.getName();
        } else {
            return;
        }
        String val = JOptionPane.showInputDialog(input, (Object)this.currentName);
        if (val == null) {
            return;
        }
        select.setName(val);
        this.currentName = val;
        this.editor.setModified();
    }

    private void createOperation(MouseEvent e) {
        MascoptObject select = this.getMascoptObjectFromMouseEvent(e);
        if (this.ag instanceof MascoptAbstractGraph) {
            if (select == null) {
                Object obj = e.getSource();
                if (obj instanceof GView) {
                    GView view = (GView)obj;
                    Point p = this.getRealPoint(e, view);
                    MascoptVertex newVertex = new MascoptVertex(p.x, p.y);
                    ((MascoptAbstractGraph)this.ag).addVertex(newVertex);
                    this.editor.setModified();
                }
            } else if (select instanceof MascoptVertex) {
                if (!this.creatingLink) {
                    this.beginLinkCreation((MascoptVertex)select, this.ag, this.layer);
                    this.creatingLink = true;
                } else {
                    ((MascoptAbstractGraph)this.ag).addEdge(this.finalizeLinkCreation((MascoptVertex)select, (MascoptAbstractGraph)this.ag, this.layer, true));
                    this.editor.setModified();
                }
            }
        } else {
            MascoptAbstractPath path = (MascoptAbstractPath)this.ag;
            if (select == null) {
                Object obj = e.getSource();
                if (obj instanceof GView) {
                    GView view = (GView)obj;
                    Point p = this.getRealPoint(e, view);
                    MascoptVertex newVertex = new MascoptVertex(p.x, p.y);
                    if (path.length() == 0 && !this.creatingLink) {
                        this.beginLinkCreation(newVertex, this.ag, this.layer);
                        this.creatingLink = true;
                        return;
                    }
                    if (this.creatingLink) {
                        MascoptAbstractLink newEdge = this.finalizeLinkCreation(newVertex, path, this.layer, false);
                        if (path instanceof MascoptDiPath && path.getFirstVertex() == ((MascoptArc)newEdge).getTail()) {
                            newEdge = new MascoptArc(((MascoptArc)newEdge).getHead(), ((MascoptArc)newEdge).getTail());
                        }
                        path.concat(newEdge);
                        this.creatingLink = false;
                        this.editor.setModified();
                    }
                }
            } else if (select instanceof MascoptVertex && path.isEnd((MascoptVertex)select) && !this.creatingLink) {
                this.beginLinkCreation((MascoptVertex)select, this.ag, this.layer);
                this.creatingLink = true;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.ag == null) {
            return;
        }
        MascoptObject select = this.getMascoptObjectFromMouseEvent(e);
        if (e.getModifiers() == 4) {
            this.stopLinkCreation(this.layer);
            this.creatingLink = false;
            return;
        }
        if (this.action == 1) {
            this.destroyOperation(select);
            return;
        }
        if (this.action == 2) {
            this.setValuesOperation(select);
            return;
        }
        if (this.action == 3) {
            this.setColorOperation(select);
            return;
        }
        if (this.action == 4) {
            if (e.getSource() instanceof View) {
                this.setNameOperation(this.ag);
            } else {
                this.setNameOperation(select);
            }
            return;
        }
        if (this.action == 0) {
            this.createOperation(e);
        } else {
            System.out.println(Messages.getString("ViewsEditorListener.unknowAction"));
            assert (false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Selectable) {
            ((Selectable)obj).enter();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Selectable) {
            ((Selectable)obj).exit();
        }
    }
}

