/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.graphgenerator;

import bridge.interfaces.Link;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import mascoptLib.algorithms.graphs.minCut.MascoptGraphMinCutStoerWagner;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.graphgenerator.criterium.CriterionFactory;
import mascoptLib.graphgenerator.numericproperty.NumericPropriertyComputator;
import mascoptLib.graphgenerator.numericproperty.SimpleComputator;
import mascoptLib.graphgenerator.numericproperty.common.AverageDegreeComputator;
import mascoptLib.graphgenerator.numericproperty.common.AverageDistanceComputator;
import mascoptLib.graphgenerator.numericproperty.common.DiameterComputator;
import mascoptLib.graphgenerator.numericproperty.common.LinkNoComputator;
import mascoptLib.graphgenerator.numericproperty.common.MaximalDegreeComputator;
import mascoptLib.graphgenerator.numericproperty.common.StandardDeviationComputator;
import mascoptLib.graphgenerator.numericproperty.undirected.MinCutComputator;
import mascoptLib.graphgenerator.random.AbstractRandomGraphGenerator;
import mascoptLib.graphgenerator.topology.MascoptStartingGraphFactory;
import mascoptLib.graphgenerator.topology.StartingAbstractGraphFactory;
import mascoptLib.gui.editor.Messages;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GView;
import mascoptLib.gui.layerManager.LayerManager;
import mascoptLib.io.MascoptChooser.MascoptChooser;
import mascoptLib.io.interfaces.Reader;
import mascoptLib.io.reader.mgl.sax.MGLSaxReader;
import mascoptLib.io.reader.snd.natives.SNDNetworkNativeReader;
import mascoptLib.io.writer.mgl.dom.MGLWriter;

public class GeneratorGui<GeneratorT extends AbstractRandomGraphGenerator<MascoptVertex, ?>, CriterionT extends CriterionFactory<MascoptVertex, ?>, GraphFactoryT extends StartingAbstractGraphFactory, GraphT extends MascoptAbstractGraph>
extends JPanel {
    private Class<GeneratorT> GeneratorClass_;
    private Class<CriterionT> CriterionClass_;
    private Class<GraphFactoryT> GraphFactoryClass_;
    private boolean isDiGraph_ = false;
    private static final Dimension textFieldSize = new Dimension(0, 25);
    private static final Dimension listSize = new Dimension(250, 25);
    private static final long serialVersionUID = 8397856560145160718L;
    private JFrame jFrame = null;
    private JPanel jContentPane = null;
    private JSplitPane jSplitPane = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JButton jButton = null;
    private JLabel jLabel = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JComboBox jComboBox1 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JTextField jTextField = null;
    private JPanel jPanel3 = null;
    private JLabel jLabel5 = null;
    private JLabel jLabel7 = null;
    private JLabel jLabel8 = null;
    private JLabel jLabel9 = null;
    private JTextField jTextField1 = null;
    private JTextField jTextField2 = null;
    private JPanel jPanel4 = null;
    private JLabel jLabel10 = null;
    private JButton jButton1 = null;
    private JLabel jLabel11 = null;
    private JComboBox jComboBox2 = null;
    private JLabel jLabel12 = null;
    private JLabel jLabel13 = null;
    private JLabel jLabel14 = null;
    private JTextField jTextField3 = null;
    private JTextField jTextField4 = null;
    private JTextField jTextField5 = null;
    private JTextField[] params = new JTextField[3];
    private JLabel[] paramsNames = new JLabel[3];
    private JSplitPane jSplitPane1 = null;
    private JList jList = null;
    private JPanel jPanel7 = null;
    private JButton jButton3 = null;
    private JButton jButton5 = null;
    private JButton jButton6 = null;
    private JPanel jPanel8 = null;
    private final String add = "ADD";
    private final String remove = "REMOVE";
    private final String addRemove = "ADD/REMOVE";
    private Reader fileReader_;
    private JLabel jLabel6 = null;
    private JButton jButton2 = null;
    private JComboBox jComboBox = null;
    private JLabel jLabel15 = null;
    private JLabel jLabel16 = null;
    private JLabel jLabel17 = null;
    private JTextField jTextField6 = null;
    private JTextField jTextField7 = null;
    private JTextField jTextField8 = null;
    private JSplitPane jSplitPane11 = null;
    private JPanel jPanel71 = null;
    private JButton jButton51 = null;
    private JButton jButton31 = null;
    private JComboBox jComboBox3 = null;
    private JLabel jLabel151 = null;
    private JTextField jTextField71 = null;
    private JList jList1 = null;
    GraphT graph_;
    private JPanel jPanel5 = null;
    private JLabel jLabel18 = null;
    private JLabel jLabel19 = null;
    private JLabel jLabel20 = null;

    public GeneratorGui(Class<GeneratorT> GeneratorClass, Class<CriterionT> CriterionClass, Class<GraphFactoryT> GraphFactoryClass, boolean isDiGraph) {
        this.GeneratorClass_ = GeneratorClass;
        this.CriterionClass_ = CriterionClass;
        this.GraphFactoryClass_ = GraphFactoryClass;
        this.isDiGraph_ = isDiGraph;
        this.initialize();
        JFrame principalFrame = this.getJFrame();
        principalFrame.pack();
        principalFrame.setVisible(true);
    }

    private void initialize() {
        this.setSize(new Dimension(900, 380));
    }

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setSize(new Dimension(908, 433));
            this.jFrame.setTitle("Random Graph Generator GUI");
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.jFrame;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = this;
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setLeftComponent(this.getJPanel());
            this.jSplitPane.setRightComponent(this.getJPanel8());
        }
        return this.jSplitPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJPanel1(), "South");
            this.jPanel.add((Component)this.getJTabbedPane(), "North");
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setText(" Save the graph on file ");
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(gridLayout);
            this.jPanel1.add((Component)this.getJLabel(), null);
            this.jPanel1.add((Component)this.getJButton2(), null);
            this.jPanel1.add((Component)this.jLabel6, null);
            this.jPanel1.add(this.getJButton());
        }
        return this.jPanel1;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setSize(new Dimension(92, 32));
            this.jButton.setText("  SAVE  ");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String fileName = MascoptChooser.getFileName("./", new String[]{"mgl"}, Messages.getString("Editor.mglFile"), Messages.getString("Editor.save"));
                    if (fileName == null) {
                        return;
                    }
                    try {
                        MGLWriter writer = new MGLWriter(fileName);
                        writer.add((MascoptObject)GeneratorGui.this.graph_);
                        if (GeneratorGui.this.fileReader_ != null) {
                            Iterator<MascoptObject> it = GeneratorGui.this.fileReader_.getAllObjects();
                            while (it.hasNext()) {
                                MascoptObject current = it.next();
                                if (current == GeneratorGui.this.graph_) continue;
                                writer.add(current);
                            }
                        }
                        writer.write();
                    }
                    catch (FileNotFoundException ee) {
                        System.err.println(String.valueOf(Messages.getString("Editor.errorWriting")) + fileName + ".");
                        ee.printStackTrace();
                    }
                }
            });
        }
        return this.jButton;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText(" Generate the graph ");
        }
        return this.jLabel;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Strategy", null, this.getJPanel2(), null);
            this.jTabbedPane.addTab("Limits", null, this.getJPanel3(), null);
            this.jTabbedPane.addTab("Starting graph", null, this.getJPanel4(), null);
            this.jTabbedPane.addTab("Valutators", null, this.getJSplitPane1(), null);
            this.jTabbedPane.addTab("Invariants", null, this.getJSplitPane11(), null);
            this.jTabbedPane.addTab("Graph Proprieties", null, this.getJPanel5(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("<html>You have to select a number<br> that represent the maximum number<br>of actions maded in one round.<br> Leave it empty or put '0', to choose the default option.");
            this.jLabel4.setBounds(new Rectangle(7, 124, 339, 60));
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("<html>The strategy define what type of action are admitted<br>during the generation process of the graph.</html>");
            this.jLabel3.setBounds(new Rectangle(7, 47, 329, 30));
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(" Select the strategy ");
            this.jLabel1.setBounds(new Rectangle(7, 16, 123, 15));
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(" Action for round ");
            this.jLabel2.setBounds(new Rectangle(7, 93, 111, 15));
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(null);
            this.jPanel2.add((Component)this.jLabel1, null);
            this.jPanel2.add((Component)this.getJComboBox1(), null);
            this.jPanel2.add((Component)this.jLabel3, null);
            this.jPanel2.add((Component)this.jLabel2, null);
            this.jPanel2.add((Component)this.getJTextField(), null);
            this.jPanel2.add((Component)this.jLabel4, null);
        }
        return this.jPanel2;
    }

    private JComboBox getJComboBox1() {
        if (this.jComboBox1 == null) {
            this.jComboBox1 = new JComboBox();
            this.jComboBox1.setBounds(new Rectangle(137, 11, 250, 25));
            this.jComboBox1.setPreferredSize(listSize);
            this.jComboBox1.addItem("ADD");
            this.jComboBox1.addItem("REMOVE");
            this.jComboBox1.addItem("ADD/REMOVE");
        }
        return this.jComboBox1;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField(10);
            this.jTextField.setText("50");
            this.jTextField.setBounds(new Rectangle(125, 88, 114, 25));
            this.jTextField.setPreferredSize(textFieldSize);
        }
        return this.jTextField;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jLabel9 = new JLabel();
            this.jLabel9.setText("Limit Evalutations");
            this.jLabel9.setBounds(new Rectangle(100, 10, 113, 15));
            this.jLabel8 = new JLabel();
            this.jLabel8.setText("<html>This represent the maximum number of evaluation<br>that the algorithm do on a graph befor decideing it is completed.</html>");
            this.jLabel8.setBounds(new Rectangle(13, 35, 406, 30));
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("Limit Improvements");
            this.jLabel7.setBounds(new Rectangle(94, 75, 126, 15));
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("<html>This is the maximum number of improvement that<br> the algorithm will do.</html>");
            this.jLabel5.setBounds(new Rectangle(58, 100, 317, 30));
            this.jPanel3 = new JPanel();
            this.jPanel3.setPreferredSize(new Dimension(500, 150));
            this.jPanel3.setLayout(null);
            this.jPanel3.add((Component)this.jLabel9, null);
            this.jPanel3.add((Component)this.getJTextField1(), null);
            this.jPanel3.add((Component)this.jLabel8, null);
            this.jPanel3.add((Component)this.jLabel7, null);
            this.jPanel3.add((Component)this.getJTextField2(), null);
            this.jPanel3.add((Component)this.jLabel5, null);
        }
        return this.jPanel3;
    }

    private JTextField getJTextField1() {
        if (this.jTextField1 == null) {
            this.jTextField1 = new JTextField(10);
            this.jTextField1.setText("50");
            this.jTextField1.setBounds(new Rectangle(218, 5, 114, 25));
            this.jTextField1.setPreferredSize(textFieldSize);
        }
        return this.jTextField1;
    }

    private JTextField getJTextField2() {
        if (this.jTextField2 == null) {
            this.jTextField2 = new JTextField(10);
            this.jTextField2.setText("50");
            this.jTextField2.setBounds(new Rectangle(225, 70, 114, 25));
            this.jTextField2.setPreferredSize(textFieldSize);
        }
        return this.jTextField2;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jLabel14 = new JLabel();
            this.jLabel14.setText("JLabel");
            this.jLabel13 = new JLabel();
            this.jLabel13.setText("JLabel");
            this.jLabel12 = new JLabel();
            this.jLabel12.setText("JLabel");
            this.paramsNames[0] = this.jLabel13;
            this.paramsNames[1] = this.jLabel12;
            this.paramsNames[2] = this.jLabel14;
            this.getJTextField3();
            this.getJTextField5();
            this.getJTextField4();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.ipadx = 10;
            gridBagConstraints.ipady = 10;
            GridBagConstraints gridBagConstraints00 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints00.gridx = 0;
            gridBagConstraints00.gridy = 0;
            GridBagConstraints gridBagConstraints01 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints01.gridx = 1;
            gridBagConstraints01.gridy = 0;
            GridBagConstraints gridBagConstraints10 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 1;
            GridBagConstraints gridBagConstraints11 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints20 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.gridy = 2;
            gridBagConstraints20.gridwidth = 2;
            GridBagConstraints gridBagConstraints30 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints30.gridx = 0;
            gridBagConstraints30.gridy = 3;
            GridBagConstraints gridBagConstraints31 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints31.gridx = 1;
            gridBagConstraints31.gridy = 3;
            gridBagConstraints31.ipadx = 100;
            GridBagConstraints gridBagConstraints40 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints40.gridx = 0;
            gridBagConstraints40.gridy = 4;
            GridBagConstraints gridBagConstraints41 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints41.gridx = 1;
            gridBagConstraints41.gridy = 4;
            gridBagConstraints41.ipadx = 100;
            GridBagConstraints gridBagConstraints50 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints50.gridx = 0;
            gridBagConstraints50.gridy = 5;
            GridBagConstraints gridBagConstraints51 = (GridBagConstraints)gridBagConstraints.clone();
            gridBagConstraints51.gridx = 1;
            gridBagConstraints51.gridy = 5;
            gridBagConstraints51.ipadx = 100;
            this.jLabel11 = new JLabel();
            this.jLabel11.setText("Generate the graph");
            this.jLabel10 = new JLabel();
            this.jLabel10.setText("Load from a file");
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new GridBagLayout());
            this.jPanel4.add((Component)this.jLabel10, gridBagConstraints00);
            this.jPanel4.add((Component)this.getJButton1(), gridBagConstraints01);
            this.jPanel4.add((Component)this.jLabel11, gridBagConstraints10);
            this.jPanel4.add((Component)this.getJComboBox2(), gridBagConstraints20);
            this.jPanel4.add((Component)this.getJButton6(), gridBagConstraints11);
            this.jPanel4.add((Component)this.jLabel13, gridBagConstraints30);
            this.jPanel4.add((Component)this.jLabel12, gridBagConstraints40);
            this.jPanel4.add((Component)this.jLabel14, gridBagConstraints50);
            this.jPanel4.add((Component)this.getJTextField3(), gridBagConstraints31);
            this.jPanel4.add((Component)this.getJTextField5(), gridBagConstraints41);
            this.jPanel4.add((Component)this.getJTextField4(), gridBagConstraints51);
            this.setLabels();
        }
        return this.jPanel4;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("Load");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String fileName = MascoptChooser.getFileName("./", new String[]{"mgl", "snd"}, Messages.getString("Editor.mglFile"), Messages.getString("Editor.load"));
                    if (fileName == null) {
                        return;
                    }
                    try {
                        if (fileName.endsWith(".mgl")) {
                            GeneratorGui.this.fileReader_ = new MGLSaxReader(fileName);
                        } else {
                            GeneratorGui.this.fileReader_ = new SNDNetworkNativeReader(fileName);
                        }
                        GeneratorGui.this.fileReader_.parse();
                        GeneratorGui.this.graph_ = GeneratorGui.this.isDiGraph_ ? MascoptChooser.getDiGraph(GeneratorGui.this.fileReader_, "Choose the graph") : MascoptChooser.getGraph(GeneratorGui.this.fileReader_, "Choose the graph");
                    }
                    catch (Exception ee) {
                        JOptionPane.showMessageDialog(GeneratorGui.this.jFrame, ee.getClass() + ":" + ee.getMessage(), Messages.getString("Editor.error"), 0);
                    }
                    if (GeneratorGui.this.graph_ == null) {
                        JOptionPane.showMessageDialog(GeneratorGui.this.jFrame, Messages.getString("Editor.noGraph"), Messages.getString("Editor.error"), 0);
                    }
                    GeneratorGui.this.displayGraph(GeneratorGui.this.graph_);
                }
            });
        }
        return this.jButton1;
    }

    private JComboBox getJComboBox2() {
        if (this.jComboBox2 == null) {
            this.jComboBox2 = new JComboBox();
            this.jComboBox2.setPreferredSize(listSize);
            this.jComboBox2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneratorGui.this.setLabels();
                }
            });
            PrettyPrintableMethod[] prettyPrintableMethodArray = PrettyPrintableMethod.GenerateSet(MascoptStartingGraphFactory.class);
            int n = prettyPrintableMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrettyPrintableMethod method = prettyPrintableMethodArray[n2];
                if (method.method_.getName().compareTo("getRegularGraph") == 0 || method.method_.getName().compareTo("getRegularGraphWithCenter") == 0) {
                    method.setParameterNames("vertices degree", "vertices No");
                } else if (method.method_.getName().compareTo("getSpiderGraph") == 0) {
                    method.setParameterNames("Number of paw", "Paw lenght");
                } else if (method.method_.getParameterTypes().length == 2) {
                    method.setParameterNames("vertices No X", "vertices No Y");
                } else if (method.method_.getName().compareTo("getCartepilarGraph") == 0) {
                    method.setParameterNames("Cartepilar deep");
                } else {
                    method.setParameterNames("vertices No");
                }
                this.jComboBox2.addItem(method);
                ++n2;
            }
        }
        return this.jComboBox2;
    }

    private JTextField getJTextField3() {
        if (this.jTextField3 == null) {
            this.jTextField3 = new JTextField();
            this.jTextField3.setPreferredSize(textFieldSize);
            this.params[0] = this.jTextField3;
        }
        return this.jTextField3;
    }

    private JTextField getJTextField4() {
        if (this.jTextField4 == null) {
            this.jTextField4 = new JTextField();
            this.jTextField4.setPreferredSize(textFieldSize);
            this.params[2] = this.jTextField4;
        }
        return this.jTextField4;
    }

    private JTextField getJTextField5() {
        if (this.jTextField5 == null) {
            this.jTextField5 = new JTextField();
            this.jTextField5.setPreferredSize(textFieldSize);
            this.params[1] = this.jTextField5;
        }
        return this.jTextField5;
    }

    private JSplitPane getJSplitPane1() {
        if (this.jSplitPane1 == null) {
            this.jSplitPane1 = new JSplitPane();
            this.jSplitPane1.setRightComponent(this.getJList());
            this.jSplitPane1.setLeftComponent(this.getJPanel7());
        }
        return this.jSplitPane1;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList(new DefaultListModel());
        }
        return this.jList;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.gridwidth = 3;
            gridBagConstraints14.gridy = 0;
            gridBagConstraints14.gridy = 0;
            this.jLabel20 = new JLabel();
            this.jLabel20.setText("<html>Valutators are fitness<br> criteria that valuate the graph<br> and guide the generation<br> process from the start<br> to the result.</html>");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 3;
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.gridy = 5;
            gridBagConstraints9.ipadx = 100;
            gridBagConstraints9.ipady = 10;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(5, 0, 5, 0);
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridy = 5;
            gridBagConstraints8.ipadx = 10;
            gridBagConstraints8.ipady = 10;
            gridBagConstraints8.gridx = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 3;
            gridBagConstraints7.gridy = 4;
            gridBagConstraints7.ipadx = 100;
            gridBagConstraints7.ipady = 10;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.insets = new Insets(5, 0, 5, 0);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.ipadx = 10;
            gridBagConstraints6.ipady = 10;
            gridBagConstraints6.gridy = 4;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 3;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.ipadx = 100;
            gridBagConstraints5.ipady = 10;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = new Insets(5, 0, 5, 0);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.ipady = 10;
            gridBagConstraints4.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.ipadx = 10;
            gridBagConstraints3.ipady = 10;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(10, 0, 10, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.ipadx = 10;
            gridBagConstraints2.ipady = 10;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.ipadx = 10;
            gridBagConstraints1.ipady = 10;
            gridBagConstraints1.gridy = 1;
            this.jLabel17 = new JLabel();
            this.jLabel17.setText("heavy");
            this.jLabel16 = new JLabel();
            this.jLabel16.setText("Scale factor");
            this.jLabel15 = new JLabel();
            this.jLabel15.setText("AspectedValue");
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new GridBagLayout());
            this.jPanel7.add((Component)this.jLabel20, gridBagConstraints14);
            this.jPanel7.add((Component)this.getJButton3(), gridBagConstraints2);
            this.jPanel7.add((Component)this.getJButton5(), gridBagConstraints1);
            this.jPanel7.add((Component)this.getJComboBox(), gridBagConstraints3);
            this.jPanel7.add((Component)this.jLabel15, gridBagConstraints4);
            this.jPanel7.add((Component)this.getJTextField7(), gridBagConstraints5);
            this.jPanel7.add((Component)this.jLabel16, gridBagConstraints6);
            this.jPanel7.add((Component)this.getJTextField8(), gridBagConstraints7);
            this.jPanel7.add((Component)this.jLabel17, gridBagConstraints8);
            this.jPanel7.add((Component)this.getJTextField6(), gridBagConstraints9);
        }
        return this.jPanel7;
    }

    private JButton getJButton3() {
        if (this.jButton3 == null) {
            this.jButton3 = new JButton("New Valutator");
            this.jButton3.setSize(new Dimension(82, 18));
            this.jButton3.setText("  New ");
            this.jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ((DefaultListModel)GeneratorGui.this.getJList().getModel()).addElement(new ValutatorData((PrettyPrintableMethod)GeneratorGui.this.getJComboBox().getSelectedItem(), Double.parseDouble(GeneratorGui.this.getJTextField7().getText()), Double.parseDouble(GeneratorGui.this.getJTextField8().getText()), Double.parseDouble(GeneratorGui.this.getJTextField6().getText())));
                    }
                    catch (NumberFormatException format) {
                        JOptionPane.showMessageDialog(GeneratorGui.this.getJFrame(), "Display::error " + format, "Format Error", 0);
                        return;
                    }
                }
            });
        }
        return this.jButton3;
    }

    private JButton getJButton5() {
        if (this.jButton5 == null) {
            this.jButton5 = new JButton();
            this.jButton5.setText("Delete");
            this.jButton5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeneratorGui.this.getJList().getSelectedIndex() != -1) {
                        ((DefaultListModel)GeneratorGui.this.getJList().getModel()).remove(GeneratorGui.this.getJList().getSelectedIndex());
                    }
                }
            });
        }
        return this.jButton5;
    }

    private JButton getJButton6() {
        if (this.jButton6 == null) {
            this.jButton6 = new JButton();
            this.jButton6.setText("Generate");
            this.jButton6.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrettyPrintableMethod caller = (PrettyPrintableMethod)GeneratorGui.this.getJComboBox2().getSelectedItem();
                    Object[] intPar = new Integer[caller.getParameterNames().length];
                    try {
                        int i = 0;
                        while (i < intPar.length) {
                            intPar[i] = Integer.parseInt(GeneratorGui.this.params[i].getText());
                            ++i;
                        }
                    }
                    catch (NumberFormatException format) {
                        JOptionPane.showMessageDialog(GeneratorGui.this.getJFrame(), "Display::error " + format, "Format Error", 0);
                        return;
                    }
                    GeneratorGui.this.displayGraph((MascoptAbstractGraph)caller.invoke(GeneratorGui.newInstance(GeneratorGui.this.GraphFactoryClass_), intPar));
                }
            });
        }
        return this.jButton6;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            this.jPanel8 = new JPanel();
            this.jPanel8.setPreferredSize(new Dimension(500, 500));
            this.jPanel8.setLayout(new BorderLayout());
        }
        return this.jPanel8;
    }

    private JButton getJButton2() {
        throw new Error("Unresolved compilation problems: \n\tThe method addValuator(FitnessCriterion<MascoptVertex,capture#6-of ?>, double) in the type AbstractRandomGraphGenerator<MascoptVertex,capture#6-of ?> is not applicable for the arguments (FitnessCriterion<MascoptVertex,MascoptEdge>, double)\n\tThe method addInvariant(FitnessCriterion<MascoptVertex,capture#7-of ?>) in the type AbstractRandomGraphGenerator<MascoptVertex,capture#7-of ?> is not applicable for the arguments (FitnessCriterion<MascoptVertex,MascoptEdge>)\n");
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setPreferredSize(listSize);
            PrettyPrintableMethod[] prettyPrintableMethodArray = PrettyPrintableMethod.GenerateSet(this.CriterionClass_);
            int n = prettyPrintableMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrettyPrintableMethod method = prettyPrintableMethodArray[n2];
                this.jComboBox.addItem(method);
                ++n2;
            }
        }
        return this.jComboBox;
    }

    private JTextField getJTextField6() {
        if (this.jTextField6 == null) {
            this.jTextField6 = new JTextField();
            this.jTextField6.setPreferredSize(textFieldSize);
            this.jTextField6.setToolTipText("How much is important this criterion: add a criterion with 3 ofheavy is equivalent to add 3 times a criterion with heavy 1.");
        }
        return this.jTextField6;
    }

    private JTextField getJTextField7() {
        if (this.jTextField7 == null) {
            this.jTextField7 = new JTextField();
            this.jTextField7.setToolTipText("This is the value that you want to obtain in the result graph");
            this.jTextField7.setPreferredSize(textFieldSize);
        }
        return this.jTextField7;
    }

    private JTextField getJTextField8() {
        if (this.jTextField8 == null) {
            this.jTextField8 = new JTextField();
            this.jTextField8.setPreferredSize(textFieldSize);
            this.jTextField8.setToolTipText("How much a little difference is important, this value is used in this formula: tanh(abs(value-expectedValue)*scaleFactor*0.001)");
        }
        return this.jTextField8;
    }

    private JSplitPane getJSplitPane11() {
        if (this.jSplitPane11 == null) {
            this.jSplitPane11 = new JSplitPane();
            this.jSplitPane11.setLeftComponent(this.getJPanel71());
            this.jSplitPane11.setRightComponent(this.getJList1());
        }
        return this.jSplitPane11;
    }

    private JPanel getJPanel71() {
        if (this.jPanel71 == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.insets = new Insets(2, 1, 0, 0);
            gridBagConstraints13.ipadx = 20;
            gridBagConstraints13.ipady = 23;
            gridBagConstraints13.gridy = 0;
            this.jLabel19 = new JLabel();
            this.jLabel19.setText("<html>Invariants are constraints<br> that must be verified<br> for the starting graph,<br> and that are grant <br> verified for the resulted graph.</html>");
            GridBagConstraints gridBagConstraints52 = new GridBagConstraints();
            gridBagConstraints52.fill = 3;
            gridBagConstraints52.gridx = 1;
            gridBagConstraints52.gridy = 3;
            gridBagConstraints52.ipadx = 100;
            gridBagConstraints52.ipady = 10;
            gridBagConstraints52.weightx = 1.0;
            gridBagConstraints52.insets = new Insets(5, 0, 5, 0);
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.gridx = 0;
            gridBagConstraints42.ipady = 10;
            gridBagConstraints42.gridy = 3;
            this.jLabel151 = new JLabel();
            this.jLabel151.setText("AspectedValue");
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.fill = 3;
            gridBagConstraints32.gridwidth = 2;
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.gridy = 2;
            gridBagConstraints32.ipadx = 10;
            gridBagConstraints32.ipady = 10;
            gridBagConstraints32.weightx = 1.0;
            gridBagConstraints32.insets = new Insets(10, 0, 10, 0);
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.ipadx = 10;
            gridBagConstraints21.ipady = 10;
            gridBagConstraints21.gridy = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.ipadx = 10;
            gridBagConstraints12.ipady = 10;
            gridBagConstraints12.gridy = 1;
            this.jPanel71 = new JPanel();
            this.jPanel71.setLayout(new GridBagLayout());
            this.jPanel71.add((Component)this.getJButton51(), gridBagConstraints12);
            this.jPanel71.add((Component)this.getJButton31(), gridBagConstraints21);
            this.jPanel71.add((Component)this.getJComboBox3(), gridBagConstraints32);
            this.jPanel71.add((Component)this.jLabel151, gridBagConstraints42);
            this.jPanel71.add((Component)this.getJTextField71(), gridBagConstraints52);
            this.jPanel71.add((Component)this.jLabel19, gridBagConstraints13);
        }
        return this.jPanel71;
    }

    private JButton getJButton51() {
        if (this.jButton51 == null) {
            this.jButton51 = new JButton();
            this.jButton51.setText("Delete");
            this.jButton51.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeneratorGui.this.getJList1().getSelectedIndex() != -1) {
                        ((DefaultListModel)GeneratorGui.this.getJList1().getModel()).remove(GeneratorGui.this.getJList1().getSelectedIndex());
                    }
                }
            });
        }
        return this.jButton51;
    }

    private JButton getJButton31() {
        if (this.jButton31 == null) {
            this.jButton31 = new JButton("New Valutator");
            this.jButton31.setSize(new Dimension(82, 18));
            this.jButton31.setText("  New ");
            this.jButton31.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ((DefaultListModel)GeneratorGui.this.getJList1().getModel()).addElement(new InvariantData((PrettyPrintableMethod)GeneratorGui.this.getJComboBox3().getSelectedItem(), Double.parseDouble(GeneratorGui.this.getJTextField71().getText())));
                    }
                    catch (NumberFormatException format) {
                        JOptionPane.showMessageDialog(GeneratorGui.this.getJFrame(), "Display::error " + format, "Format Error", 0);
                        return;
                    }
                }
            });
        }
        return this.jButton31;
    }

    private JComboBox getJComboBox3() {
        if (this.jComboBox3 == null) {
            this.jComboBox3 = new JComboBox();
            this.jComboBox3.setPreferredSize(listSize);
            PrettyPrintableMethod[] prettyPrintableMethodArray = PrettyPrintableMethod.GenerateSet(this.CriterionClass_);
            int n = prettyPrintableMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrettyPrintableMethod method = prettyPrintableMethodArray[n2];
                this.jComboBox3.addItem(method);
                ++n2;
            }
        }
        return this.jComboBox3;
    }

    private JTextField getJTextField71() {
        if (this.jTextField71 == null) {
            this.jTextField71 = new JTextField();
            this.jTextField71.setPreferredSize(textFieldSize);
        }
        return this.jTextField71;
    }

    private JList getJList1() {
        if (this.jList1 == null) {
            this.jList1 = new JList(new DefaultListModel());
        }
        return this.jList1;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jLabel18 = new JLabel();
            this.jLabel18.setText("No Graph Charged");
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new FlowLayout());
            this.jPanel5.add((Component)this.jLabel18, null);
        }
        return this.jPanel5;
    }

    void displayGraph(GraphT graph) {
        this.graph_ = graph;
        LayerManager layerManager = new LayerManager();
        GView v = layerManager.newView("A NAME");
        GLayer graphLayer = layerManager.newLayer("graph");
        layerManager.addGraph((MascoptObject)this.graph_);
        try {
            layerManager.setVisibleGraphInLayer((MascoptObject)this.graph_, graphLayer, true);
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
        layerManager.setVertexLabelGraphInLayerVisibility((MascoptObject)this.graph_, graphLayer, true);
        layerManager.addLayerInView(graphLayer, v);
        v.setZoom(0.6);
        this.getJPanel8().removeAll();
        v.repaint();
        this.getJPanel8().add(v);
        v.repaint();
        v.setSize(this.getJPanel8().getSize());
        this.getJPanel8().repaint();
        String text = "";
        text = String.valueOf(text) + "<html><h2>Graph Proprieties:</h2>";
        text = String.valueOf(text) + this.htmlProprietyOfGraph(graph, !this.isDiGraph_);
        text = String.valueOf(text) + "</html>";
        if (this.jLabel18 != null) {
            this.jLabel18.setText(text);
        }
    }

    private static String format(double value) {
        String[] values = Double.toString(value).split("\\.");
        if (values.length == 0) {
            return Double.toString(value);
        }
        if (values.length == 1 || values[1].equals("0")) {
            return values[0];
        }
        return String.valueOf(values[0]) + "." + values[1].substring(0, Math.min(4, values[1].length()));
    }

    private <L extends Link<MascoptVertex>> String htmlProprietyOfGraph(GraphT graph, boolean undirected) {
        HashMap<String, SimpleComputator> computators = new HashMap<String, SimpleComputator>();
        computators.put("Diameter", new DiameterComputator());
        computators.put("Average Distance", new AverageDistanceComputator());
        computators.put("Average Vertex Degree", new AverageDegreeComputator());
        computators.put("Vertex Degree Standard Deviation", new StandardDeviationComputator());
        computators.put("Maximal Vertex Degree", new MaximalDegreeComputator());
        computators.put("Links Number", new LinkNoComputator());
        if (undirected) {
            computators.put("Min Cut", new MinCutComputator<MascoptVertex, MascoptEdge>(new MascoptGraphMinCutStoerWagner()));
        }
        String result = "<ul>";
        for (String s : computators.keySet()) {
            ((NumericPropriertyComputator)computators.get(s)).setGraph(graph);
            ((NumericPropriertyComputator)computators.get(s)).compute();
            result = String.valueOf(result) + "<li><bold>" + s + "</bold> = " + (((NumericPropriertyComputator)computators.get(s)).getResult() != null ? GeneratorGui.format(((NumericPropriertyComputator)computators.get(s)).getResult().doubleValue()) : "Error") + "</li>";
        }
        result = String.valueOf(result) + "</ul>";
        return result;
    }

    void setLabels() {
        String[] names = ((PrettyPrintableMethod)this.jComboBox2.getSelectedItem()).getParameterNames();
        int i = 0;
        while (i < this.paramsNames.length) {
            this.paramsNames[i].setText("");
            ++i;
        }
        i = 0;
        while (i < this.params.length) {
            this.params[i].setEnabled(false);
            ++i;
        }
        i = 0;
        while (i < names.length) {
            this.paramsNames[i].setText(names[i]);
            ++i;
        }
        i = 0;
        while (i < names.length) {
            this.params[i].setEnabled(true);
            ++i;
        }
    }

    static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    int checkTextBox(JTextField field, String errorMessage) {
        try {
            return Integer.parseInt(field.getText());
        }
        catch (NumberFormatException format) {
            JOptionPane.showMessageDialog(this.getJFrame(), "Display::error " + format + " in field for " + errorMessage, "Format Error", 0);
            throw format;
        }
    }

    static class InvariantData {
        PrettyPrintableMethod method;
        double aspectedValue;

        public String toString() {
            return ": " + this.method + " [ " + this.aspectedValue + " ]";
        }

        public InvariantData(PrettyPrintableMethod method, double aspectedValue) {
            this.method = method;
            this.aspectedValue = aspectedValue;
        }
    }

    private static class PrettyPrintableMethod {
        Method method_;
        String[] parameterNames_;
        static final List<Method> objectMethods = Arrays.asList(Object.class.getMethods());

        public String[] getParameterNames() {
            return this.parameterNames_;
        }

        public void setParameterNames(String ... parameterNames) {
            this.parameterNames_ = parameterNames;
        }

        PrettyPrintableMethod(Method method) {
            this.method_ = method;
        }

        static PrettyPrintableMethod[] GenerateSet(Class<?> clazz) {
            ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(clazz.getMethods()));
            methods.removeAll(objectMethods);
            PrettyPrintableMethod[] result = new PrettyPrintableMethod[methods.size()];
            int i = 0;
            while (i < methods.size()) {
                result[i] = new PrettyPrintableMethod((Method)methods.get(i));
                ++i;
            }
            return result;
        }

        public String toString() {
            return " " + this.method_.getName().substring(3);
        }

        public Object invoke(Object istance, Object[] args) {
            try {
                assert (this.method_.getParameterTypes().length == args.length);
                return this.method_.invoke(istance, args);
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (IllegalArgumentException e3) {
                e3.printStackTrace();
            }
            catch (IllegalAccessException e4) {
                e4.printStackTrace();
            }
            catch (InvocationTargetException e5) {
                e5.printStackTrace();
            }
            return null;
        }
    }

    static class ValutatorData {
        PrettyPrintableMethod method;
        double aspectedValue;
        double unitValue;
        double weight;

        public String toString() {
            return ": " + this.method + " [ " + this.aspectedValue + "; " + this.unitValue + "; " + this.weight + " ]";
        }

        public ValutatorData(PrettyPrintableMethod method, double aspectedValue, double unitValue, double weight) {
            this.method = method;
            this.aspectedValue = aspectedValue;
            this.unitValue = unitValue;
            this.weight = weight;
        }
    }
}

