/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import mascoptLib.gui.layerManager.GObject;
import mascoptLib.gui.layerManager.Link;

class ArrowedLink
extends Link {
    private static final long serialVersionUID = 2L;
    private boolean visibleArrow = true;
    private Polygon arrowPolygon;
    private static final int ArrowLength = 5;
    private static final int arrowWidth = 4;
    private int offsetAxis = 5;
    private int offsetNormal = 5;

    public ArrowedLink(GObject source, GObject target, Color color) {
        this(source, target, color, 0);
    }

    public ArrowedLink(GObject source, GObject target, Color color, int shift) {
        this(source, target, source.getWidth() / 2, source.getHeight() / 2, target.getWidth() / 2, target.getHeight() / 2, color, shift);
    }

    public ArrowedLink(GObject source, GObject target, int offSetSourceX, int offSetSourceY, int offSetTargetX, int offSetTargetY, Color color) {
        this(source, target, offSetSourceX, offSetSourceY, offSetTargetX, offSetTargetY, color, 0);
    }

    public ArrowedLink(GObject source, GObject target, int offSetSourceX, int offSetSourceY, int offSetTargetX, int offSetTargetY, Color color, int shift) {
        super(source, target, offSetSourceX, offSetSourceY, offSetTargetX, offSetTargetY, color, shift);
        this.setVisibleArrow(true);
        this.updateBounds();
    }

    public void setOffsetAxis(int v) {
        this.offsetAxis = v;
    }

    public void setOffsetNormal(int v) {
        this.offsetNormal = v;
    }

    public Point getCenterArrow() {
        return new Point(this.arrowPolygon.xpoints[1], this.arrowPolygon.ypoints[1]);
    }

    public void setVisibleArrow(boolean b) {
        this.visibleArrow = b;
    }

    @Override
    protected void updateBounds() {
        this.MARGIN = Math.max(this.offsetNormal, this.offsetAxis);
        super.updateBounds();
        Point sourceLocation = this.getSource().getLocation();
        Point targetLocation = this.getTarget().getLocation();
        sourceLocation.translate(this.getOffsetSourceX(), this.getOffsetSourceY());
        targetLocation.translate(this.getOffsetTargetX(), this.getOffsetTargetY());
        Point location = this.getLocation();
        sourceLocation.translate(-location.x, -location.y);
        targetLocation.translate(-location.x, -location.y);
        if (this.getSource() != this.getTarget()) {
            double X = targetLocation.x - sourceLocation.x;
            double Y = targetLocation.y - sourceLocation.y;
            double headArrowX = (long)sourceLocation.x + Math.round(X / 2.0) + (long)this.getDx();
            double headArrowY = (long)sourceLocation.y + Math.round(Y / 2.0) + (long)this.getDy();
            double centerBaseX = headArrowX - 5.0 / this.getDistance() * X;
            double centerBaseY = headArrowY - 5.0 / this.getDistance() * Y;
            double x1 = centerBaseX + (double)this.getArrowWidth() / this.getDistance() * -Y;
            double y1 = centerBaseY + (double)this.getArrowWidth() / this.getDistance() * X;
            double x2 = centerBaseX - (double)this.getArrowWidth() / this.getDistance() * -Y;
            double y2 = centerBaseY - (double)this.getArrowWidth() / this.getDistance() * X;
            int[] xp = new int[]{(int)Math.round(x1), (int)Math.round(headArrowX), (int)Math.round(x2)};
            int[] yp = new int[]{(int)Math.round(y1), (int)Math.round(headArrowY), (int)Math.round(y2)};
            this.arrowPolygon = new Polygon(xp, yp, 3);
        } else {
            double headArrowX = sourceLocation.x + 2 * (this.getBaseRadiusOfLoop() + this.getDx());
            double headArrowY = sourceLocation.y;
            double centerBaseX = headArrowX;
            double centerBaseY = headArrowY + 5.0;
            double x1 = centerBaseX + (double)this.getArrowWidth();
            double y1 = centerBaseY;
            double x2 = centerBaseX - (double)this.getArrowWidth();
            double y2 = centerBaseY;
            int[] xp = new int[]{(int)Math.round(x1), (int)Math.round(headArrowX), (int)Math.round(x2)};
            int[] yp = new int[]{(int)Math.round(y1), (int)Math.round(headArrowY), (int)Math.round(y2)};
            this.arrowPolygon = new Polygon(xp, yp, 3);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.visibleArrow) {
            g.fillPolygon(this.arrowPolygon);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            return true;
        }
        return this.arrowPolygon.contains((double)x, (double)y);
    }

    private int getArrowWidth() {
        return 4 + this.getLinkWidth() / 2;
    }
}

