/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.Notification;
import mascoptLib.core.interfaces.MascoptObserver;
import mascoptLib.gui.layerManager.DefaultEventListener;
import mascoptLib.gui.layerManager.GEdge;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GObject;
import mascoptLib.gui.layerManager.GVertex;
import mascoptLib.gui.layerManager.LayerManager;
import mascoptLib.gui.layerManager.Link;
import mascoptLib.gui.layerManager.LinkManager;
import mascoptLib.gui.layerManager.Origin;

abstract class GDispatch<E extends MascoptAbstractLink>
implements MascoptObserver {
    private Hashtable<MascoptObject, GObject> gObjects_;
    private LayerManager layerManager_;
    private GLayer gLayer_;
    private LinkManager<E> linkManager_;
    private MascoptMap verticesImagesMap_;
    private MascoptMap linksImagesMap_;
    private String verticesImagesName_ = "Images";
    private String linksImagesName_ = "Images";
    private MascoptObject verticesImagesContext_ = null;
    private MascoptObject linksImagesContext_ = null;
    protected Color vertexColor_ = Color.yellow;
    protected Color linkColor_ = Color.blue;
    private DefaultEventListener eventListener_;

    public GDispatch(LayerManager lm, GLayer gl) {
        this.layerManager_ = lm;
        this.gLayer_ = gl;
        this.gObjects_ = new Hashtable();
        this.eventListener_ = gl.getDefaultViewAdapter();
        Origin o = new Origin(15, Color.black);
        this.gLayer_.add(o, 0);
        this.linkManager_ = new LinkManager(this);
    }

    protected abstract MascoptObject getGraph();

    void setLinkWidth(int width) {
        this.linkManager_.setLinkWidth(width);
    }

    int getEdgesWidth() {
        return this.linkManager_.getLinkWidth();
    }

    void changeEdgeShift(GEdge link, GEdge movingLink, int x, int y) {
        this.linkManager_.changeEdgeShift(link, movingLink, x, y);
    }

    void setEdgeShift(GEdge link, int newShift) {
        this.linkManager_.setEdgeShift(link, newShift);
    }

    protected LayerManager getLayerManager() {
        return this.layerManager_;
    }

    protected GLayer getLayer() {
        return this.gLayer_;
    }

    protected DefaultEventListener getMouseListenner() {
        return this.eventListener_;
    }

    protected GObject getGObject(MascoptObject n) {
        return this.gObjects_.get(n);
    }

    protected Hashtable<MascoptObject, GObject> getGObjectMapping() {
        return this.gObjects_;
    }

    void remove() {
        this.gLayer_ = null;
        this.eventListener_ = null;
        this.layerManager_ = null;
        if (this.verticesImagesMap_ != null) {
            this.verticesImagesMap_.deleteValueObserver(this);
        }
        this.verticesImagesMap_ = null;
        this.verticesImagesName_ = null;
        this.verticesImagesContext_ = null;
        if (this.linksImagesMap_ != null) {
            this.linksImagesMap_.deleteValueObserver(this);
        }
        this.linksImagesMap_ = null;
        this.linksImagesName_ = null;
        this.linksImagesContext_ = null;
    }

    void addGraphicEdge(MascoptAbstractLink edge) {
        MascoptVertex[] vertices = edge.toArray(new MascoptVertex[0]);
        GVertex nS = (GVertex)this.getGObject(vertices[0]);
        GVertex nT = (GVertex)this.getGObject(vertices[1]);
        if (edge instanceof MascoptArc) {
            nS = (GVertex)this.getGObject(((MascoptArc)edge).getTail());
            nT = (GVertex)this.getGObject(((MascoptArc)edge).getHead());
        }
        int h = this.linkManager_.getFreeShift(nS, nT);
        GEdge ga = new GEdge(nS, nT, edge, this.linkColor_, h);
        if (edge instanceof MascoptArc) {
            ga.setVisibleArrow(true);
        } else {
            ga.setVisibleArrow(false);
        }
        int rgb = edge.getColor();
        if (rgb != -1) {
            ga.setColor(new Color(rgb));
        }
        ga.addMouseListener(this.getMouseListenner());
        ga.addMouseMotionListener(this.getMouseListenner());
        this.getLayer().add(ga, 1);
        this.getGObjectMapping().put(edge, ga);
        edge.addValueObserver(this);
    }

    void addGraphicVertex(MascoptVertex vertex) {
        GVertex gn = new GVertex(vertex, 15, 15, this.vertexColor_, this);
        int rgb = vertex.getColor();
        if (rgb != -1) {
            gn.setColor(new Color(rgb));
        }
        gn.addMouseListener(this.getMouseListenner());
        gn.addMouseMotionListener(this.getMouseListenner());
        this.getLayer().add(gn);
        this.getGObjectMapping().put(vertex, gn);
        vertex.addValueObserver(this);
    }

    void setVerticesImagesMap(MascoptMap m, boolean update) throws IOException {
        if (this.verticesImagesMap_ != null) {
            this.verticesImagesMap_.deleteValueObserver(this);
        }
        this.verticesImagesMap_ = m;
        if (this.verticesImagesMap_ != null) {
            this.verticesImagesMap_.addValueObserver(this);
            this.verticesImagesMap_.addRemoveObserver(this);
        }
        if (update) {
            this.loadImagesOfVertices();
        }
    }

    protected MascoptMap getVerticesImagesMap() {
        return this.verticesImagesMap_;
    }

    void setVerticesImagesName(String name, boolean update) throws IOException {
        this.verticesImagesName_ = name;
        if (update) {
            this.loadImagesOfVertices();
        }
    }

    protected String getVerticesImagesName() {
        return this.verticesImagesName_;
    }

    void setVerticesImagesContext(MascoptObject context, boolean update) throws IOException {
        this.verticesImagesContext_ = context;
        if (update) {
            this.loadImagesOfVertices();
        }
    }

    protected MascoptObject getVerticesImagesContext() {
        return this.verticesImagesContext_;
    }

    abstract void loadImagesOfVertices() throws IOException;

    void setEdgesImagesMap(MascoptMap m, boolean update) throws IOException {
        if (this.linksImagesMap_ != null) {
            this.linksImagesMap_.deleteValueObserver(this);
        }
        this.linksImagesMap_ = m;
        if (this.linksImagesMap_ != null) {
            this.linksImagesMap_.addValueObserver(this);
            this.linksImagesMap_.addRemoveObserver(this);
        }
        if (update) {
            this.loadImagesOfEdges();
        }
    }

    protected MascoptMap getEdgesImagesMap() {
        return this.linksImagesMap_;
    }

    void setEdgesImagesName(String name, boolean update) throws IOException {
        this.linksImagesName_ = name;
        if (update) {
            this.loadImagesOfEdges();
        }
    }

    protected String getEdgesImagesName() {
        return this.linksImagesName_;
    }

    void setEdgesImagesContext(MascoptObject context, boolean update) throws IOException {
        this.linksImagesContext_ = context;
        if (update) {
            this.loadImagesOfEdges();
        }
    }

    protected MascoptObject getEdgesImagesContext() {
        return this.linksImagesContext_;
    }

    abstract void loadImagesOfEdges() throws IOException;

    void removeGraphicVertex(MascoptVertex node) {
        GVertex gn = (GVertex)this.getGObject(node);
        gn.removeMouseListener(this.getMouseListenner());
        gn.removeMouseMotionListener(this.getMouseListenner());
        this.getLayer().remove(gn);
        node.deleteValueObserver(this);
        this.getGObjectMapping().remove(node);
        gn.remove();
        this.getLayer().removeLabel(node, this.getGraph());
    }

    void removeGraphicEdge(MascoptAbstractLink edge) {
        GEdge ga = (GEdge)this.getGObject(edge);
        ga.removeMouseListener(this.getMouseListenner());
        ga.removeMouseMotionListener(this.getMouseListenner());
        this.getLayer().remove(ga);
        this.linkManager_.setShiftFree((GVertex)ga.getSource(), (GVertex)ga.getTarget(), ga.getShift());
        edge.deleteValueObserver(this);
        this.getGObjectMapping().remove(edge);
        this.getLayer().removeLabel(edge, this.getGraph());
    }

    protected void setImageFromMap(MascoptObject key, MascoptMap imagesMap, String imagesName, MascoptObject imagesContext) throws IOException {
        if (key instanceof MascoptVertex) {
            String ressource = imagesMap.getString(key, imagesName, imagesContext == null ? key : imagesContext);
            if (ressource == null) {
                ((GVertex)this.getGObject(key)).setImage(null);
                return;
            }
            URL address = this.getClass().getResource(ressource);
            if (address == null) {
                throw new IOException("Can't find " + ressource);
            }
            BufferedImage image = ImageIO.read(this.getClass().getResource(ressource));
            ((GVertex)this.getGObject(key)).setImage(image);
        } else if (key instanceof MascoptAbstractLink) {
            String ressource = imagesMap.getString(key, imagesName, imagesContext == null ? key : imagesContext);
            if (ressource == null) {
                ((Link)this.getGObject(key)).setPicture(null);
                return;
            }
            URL address = this.getClass().getResource(ressource);
            if (address == null) {
                throw new IOException("Can't find " + ressource);
            }
            BufferedImage image = ImageIO.read(this.getClass().getResource(ressource));
            ((Link)this.getGObject(key)).setPicture(image);
        }
    }

    void addingUpdate(Object[] objs) throws IOException {
        MascoptMap imagesMap;
        if (objs[0] instanceof MascoptVertex) {
            MascoptMap imagesMap2 = this.getVerticesImagesMap();
            if (imagesMap2 != null) {
                String imagesName = this.getVerticesImagesName();
                MascoptObject imagesContext = this.getVerticesImagesContext();
                this.setImageFromMap((MascoptObject)objs[0], imagesMap2, imagesName, imagesContext);
            }
        } else if (objs[0] instanceof MascoptAbstractLink && (imagesMap = this.getEdgesImagesMap()) != null) {
            String imagesName = this.getEdgesImagesName();
            MascoptObject imagesContext = this.getEdgesImagesContext();
            this.setImageFromMap((MascoptObject)objs[0], imagesMap, imagesName, imagesContext);
        }
    }

    abstract void removeUpdate(Object[] var1);

    abstract void changeValueUpdate(Object[] var1);

    abstract Iterator<MascoptVertex> getMascoptVertexIterator();

    abstract Iterator<E> edgeIterator();

    private boolean suppressImageFromMap(MascoptMap map, String name, MascoptObject context, Object[] objs) {
        boolean goodContext;
        boolean goodName = name != null && name.equals(objs[1]);
        boolean bl = goodContext = context == objs[2] || context == null && objs[0] == objs[2];
        if (goodName && goodContext) {
            if (objs[0] instanceof MascoptVertex) {
                ((GVertex)this.getGObject((MascoptObject)objs[0])).setImage(null);
            } else {
                ((GEdge)this.getGObject((MascoptObject)objs[0])).setPicture(null);
            }
            this.getLayer().repaint();
        }
        return goodName && goodContext;
    }

    private void updateOneLabel(Object[] objs) {
        boolean goodContext;
        MascoptObject labelContext = this.getLayerManager().getGraphLayerContextValues(this.getGraph(), this.getLayer());
        boolean bl = goodContext = labelContext == objs[2] || labelContext == null && objs[0] == objs[2];
        if (goodContext) {
            this.getLayerManager().updateLabelOfObject((MascoptObject)objs[0], this.getGraph(), this.getLayer(), (String)objs[1]);
        }
    }

    private boolean updateImageFromMap(MascoptMap map, String name, MascoptObject context, Object[] objs) throws IOException {
        boolean goodContext;
        boolean goodName = name != null && name.equals(objs[1]);
        boolean bl = goodContext = context == objs[2] || context == null && objs[0] == objs[2];
        if (goodName && goodContext) {
            this.setImageFromMap((MascoptObject)objs[0], map, name, context);
        }
        return goodName && goodContext;
    }

    @Override
    public void update(MascoptObservableObject emetor, Notification nr) {
        Object[] objs = nr.getObjects();
        MascoptObservableObject.MascoptEventType message = nr.getEventType();
        MascoptMap mapValues = this.getLayerManager().getGraphLayerMapValues(this.getGraph(), this.getLayer());
        if (message == MascoptObservableObject.MascoptEventType.ADD) {
            try {
                this.addingUpdate(objs);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else if (message == MascoptObservableObject.MascoptEventType.REMOVE) {
            boolean notificationProcessed = false;
            if (emetor == this.verticesImagesMap_ || emetor == this.linksImagesMap_) {
                if (objs[0] instanceof MascoptVertex) {
                    notificationProcessed = this.suppressImageFromMap(this.verticesImagesMap_, this.verticesImagesName_, this.verticesImagesContext_, objs);
                } else if (objs[0] instanceof MascoptAbstractLink) {
                    notificationProcessed = this.suppressImageFromMap(this.linksImagesMap_, this.linksImagesName_, this.linksImagesContext_, objs);
                }
            }
            if (!notificationProcessed && emetor == mapValues) {
                this.updateOneLabel(objs);
            } else if (!(emetor instanceof MascoptMap)) {
                this.removeUpdate(objs);
            }
        } else if (message == MascoptObservableObject.MascoptEventType.VALUE_CHANGE) {
            boolean notificationProcessed = false;
            if (emetor == this.verticesImagesMap_ || emetor == this.linksImagesMap_) {
                try {
                    if (objs[0] instanceof MascoptVertex) {
                        notificationProcessed = this.updateImageFromMap(this.verticesImagesMap_, this.verticesImagesName_, this.verticesImagesContext_, objs);
                    } else if (objs[0] instanceof MascoptAbstractLink) {
                        notificationProcessed = this.updateImageFromMap(this.linksImagesMap_, this.linksImagesName_, this.linksImagesContext_, objs);
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            if (!notificationProcessed && emetor == mapValues) {
                this.updateOneLabel(objs);
            } else if (!(emetor instanceof MascoptMap)) {
                this.changeValueUpdate(objs);
            }
        }
    }
}

