/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.awt.Point;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.gui.layerManager.ArrowedLink;
import mascoptLib.gui.layerManager.GDispatch;
import mascoptLib.gui.layerManager.GVertex;
import mascoptLib.gui.layerManager.Selectable;

class GEdge
extends ArrowedLink
implements Selectable {
    private static final long serialVersionUID = 2L;
    private MascoptAbstractLink mascoptLink_;
    private Color colorOn_;
    private Color colorOff_;
    private Color colorSelect_;
    private final GDispatch gGraph_;

    public GEdge(GVertex n0, GVertex n1, MascoptAbstractLink link, Color col) {
        this(n0, n1, link, col, 0);
    }

    public GEdge(GVertex n0, GVertex n1, MascoptAbstractLink link, Color col, int shift) {
        super(n0, n1, col, shift);
        assert (n0.getGGraph() == n1.getGGraph());
        this.gGraph_ = n0.getGGraph();
        this.colorOff_ = col;
        this.colorOn_ = Color.red;
        this.colorSelect_ = Color.green;
        super.setColor(col);
        super.setLinkWidth(this.gGraph_.getEdgesWidth());
        this.mascoptLink_ = link;
        link.addValueObserver(this.getGGraph());
    }

    GEdge(GVertex n0, GVertex n1, Color col, int shift) {
        super(n0, n1, col, shift);
        assert (n0.getGGraph() == n1.getGGraph());
        this.gGraph_ = n0.getGGraph();
        this.colorOff_ = col;
        this.colorOn_ = Color.red;
        this.colorSelect_ = Color.green;
        super.setColor(col);
        super.setLinkWidth(this.gGraph_.getEdgesWidth());
    }

    public GDispatch getGGraph() {
        return this.gGraph_;
    }

    public MascoptAbstractLink getAbstractEdge() {
        return this.mascoptLink_;
    }

    @Override
    public void setColor(Color newColor) {
        this.colorOff_ = newColor;
        super.setColor(newColor);
    }

    @Override
    public void setLocation(int x, int y) {
    }

    @Override
    public void setLocation(Point p) {
    }

    @Override
    public void select() {
        super.setColor(this.colorSelect_);
        this.repaint();
    }

    @Override
    public void enter() {
        super.setColor(this.colorOn_);
        this.repaint();
    }

    @Override
    public void exit() {
        super.setColor(this.colorOff_);
        this.repaint();
    }
}

