/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.io.IOException;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.interfaces.MascoptObserver;
import mascoptLib.gui.layerManager.GDispatch;
import mascoptLib.gui.layerManager.GEdge;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GVertex;
import mascoptLib.gui.layerManager.LayerManager;

class GGraph<E extends MascoptAbstractLink>
extends GDispatch<E>
implements MascoptObserver {
    private MascoptAbstractGraph<E> graph;

    @Override
    protected MascoptAbstractGraph<E> getGraph() {
        return this.graph;
    }

    public GGraph(MascoptAbstractGraph<E> graph, LayerManager lm, GLayer gl) {
        super(lm, gl);
        assert (lm != null);
        this.graph = graph;
        graph.vertexSet().addAddObserver(this);
        ((MascoptObservableObject)((Object)graph.edgeSet())).addAddObserver(this);
        graph.vertexSet().addRemoveObserver(this);
        ((MascoptObservableObject)((Object)graph.edgeSet())).addRemoveObserver(this);
        Iterator vertexIt = graph.vertexSet().iterator();
        while (vertexIt.hasNext()) {
            this.addGraphicVertex((MascoptVertex)vertexIt.next());
        }
        Iterator linkIt = ((MascoptAbstractLinkSet)graph.edgeSet()).iterator();
        while (linkIt.hasNext()) {
            this.addGraphicEdge((MascoptAbstractLink)linkIt.next());
        }
    }

    @Override
    void remove() {
        Iterator vertexIt = this.graph.vertexSet().iterator();
        while (vertexIt.hasNext()) {
            this.removeGraphicVertex((MascoptVertex)vertexIt.next());
        }
        Iterator linkIt = ((MascoptAbstractLinkSet)this.graph.edgeSet()).iterator();
        while (vertexIt.hasNext()) {
            this.removeGraphicEdge((MascoptAbstractLink)linkIt.next());
        }
        this.getGObjectMapping().clear();
        this.graph.vertexSet().deleteRemoveObserver(this);
        ((MascoptObservableObject)((Object)this.graph.edgeSet())).deleteRemoveObserver(this);
        this.graph.vertexSet().deleteAddObserver(this);
        ((MascoptObservableObject)((Object)this.graph.edgeSet())).deleteAddObserver(this);
        this.graph = null;
        super.remove();
    }

    @Override
    void addingUpdate(Object[] objs) throws IOException {
        if (objs[0] instanceof MascoptVertex) {
            this.addGraphicVertex((MascoptVertex)objs[0]);
            this.getLayer().addLabel((MascoptObject)objs[0], this.graph);
        } else if (objs[0] instanceof MascoptAbstractLink) {
            this.addGraphicEdge((MascoptAbstractLink)objs[0]);
            this.getLayer().addLabel((MascoptObject)objs[0], this.graph);
        }
        super.addingUpdate(objs);
        this.getLayer().repaint();
    }

    @Override
    void removeUpdate(Object[] objs) {
        if (objs[0] instanceof MascoptVertex) {
            this.removeGraphicVertex((MascoptVertex)objs[0]);
        } else if (objs[0] instanceof MascoptAbstractLink) {
            this.removeGraphicEdge((MascoptAbstractLink)objs[0]);
        }
        this.getLayer().repaint();
    }

    @Override
    void changeValueUpdate(Object[] objs) {
        String value = (String)objs[1];
        if (objs[0] instanceof MascoptVertex) {
            MascoptVertex vertex = (MascoptVertex)objs[0];
            if (!((MascoptAbstractGraph)this.getGraph()).vertexSet().contains(vertex)) {
                return;
            }
            GVertex graphicVertex = (GVertex)this.getGObject(vertex);
            assert (graphicVertex != null);
            if (value.equals("x") || value.equals("y")) {
                graphicVertex.setLocation((int)Math.round(vertex.getX()), (int)Math.round(vertex.getY()));
                this.getLayer().repaint();
                this.getLayerManager().updateLabelOfObject(vertex, this.graph, this.getLayer(), value);
                return;
            }
            if (value.equals("name")) {
                this.getLayer().refreshObjectLabels(vertex, this.graph);
                this.getLayer().repaint();
                return;
            }
            if (value.equals("color")) {
                int colValue = vertex.getColor();
                if (colValue != -1) {
                    graphicVertex.setColor(new Color(colValue));
                } else {
                    graphicVertex.setColor(this.vertexColor_);
                }
                this.getLayer().repaint();
                return;
            }
        } else if (objs[0] instanceof MascoptAbstractLink) {
            MascoptAbstractLink edge = (MascoptAbstractLink)objs[0];
            if (!((MascoptFixedSet)((MascoptAbstractGraph)this.getGraph()).edgeSet()).contains(edge)) {
                return;
            }
            GEdge graphicEdge = (GEdge)this.getGObject(edge);
            assert (graphicEdge != null);
            if (value.equals("name")) {
                this.getLayer().refreshObjectLabels(edge, this.graph);
                this.getLayer().repaint();
                return;
            }
            if (value.equals("color")) {
                int colValue = edge.getColor();
                if (colValue != -1) {
                    graphicEdge.setColor(new Color(colValue));
                } else {
                    graphicEdge.setColor(this.linkColor_);
                }
                this.getLayer().repaint();
                return;
            }
        }
    }

    @Override
    Iterator<E> edgeIterator() {
        return ((MascoptAbstractLinkSet)this.graph.edgeSet()).iterator();
    }

    @Override
    Iterator<MascoptVertex> getMascoptVertexIterator() {
        return this.graph.vertexSet().iterator();
    }

    @Override
    void setLinkWidth(int width) {
        super.setLinkWidth(width);
        Iterator edgesIt = ((MascoptAbstractLinkSet)((MascoptAbstractGraph)this.getGraph()).edgeSet()).iterator();
        while (edgesIt.hasNext()) {
            GEdge current = (GEdge)this.getGObject((MascoptObject)edgesIt.next());
            current.setLinkWidth(width);
        }
    }

    @Override
    void loadImagesOfVertices() throws IOException {
        MascoptMap imagesMap = this.getVerticesImagesMap();
        String imagesName = this.getVerticesImagesName();
        MascoptObject imagesContext = this.getVerticesImagesContext();
        for (MascoptVertex current : this.graph.vertexSet()) {
            this.setImageFromMap(current, imagesMap, imagesName, imagesContext);
        }
    }

    @Override
    void loadImagesOfEdges() throws IOException {
        MascoptMap imagesMap = this.getEdgesImagesMap();
        String imagesName = this.getEdgesImagesName();
        MascoptObject imagesContext = this.getEdgesImagesContext();
        for (MascoptAbstractLink current : this.graph.edgeSet()) {
            this.setImageFromMap(current, imagesMap, imagesName, imagesContext);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

