/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.flows.MascoptMultiFlow;
import mascoptLib.gui.layerManager.DefaultEventListener;
import mascoptLib.gui.layerManager.GDispatch;
import mascoptLib.gui.layerManager.GFlow;
import mascoptLib.gui.layerManager.GGraph;
import mascoptLib.gui.layerManager.GLabel;
import mascoptLib.gui.layerManager.GObject;
import mascoptLib.gui.layerManager.GPath;
import mascoptLib.gui.layerManager.Layer;
import mascoptLib.gui.layerManager.LayerManager;

public class GLayer
extends Layer {
    private Vector<GDispatch<? extends MascoptAbstractLink>> gDispatchVector;
    private LayerManager lm;
    private DefaultEventListener vl;
    private String name;
    private HashMap<String, GLabel> labels;

    protected GLayer(String name, LayerManager lm, DefaultEventListener vl) {
        this.name = name;
        this.lm = lm;
        this.vl = vl;
        this.gDispatchVector = new Vector();
        this.labels = new HashMap();
    }

    DefaultEventListener getDefaultViewAdapter() {
        return this.vl;
    }

    void setName(String name) {
        this.name = name;
    }

    String getName() {
        if (this.name == null) {
            this.name = "No name";
        }
        return this.name;
    }

    void addObject(MascoptObject mo) {
        if (this.gDispatchVector.contains(mo)) {
            return;
        }
        if (mo instanceof MascoptAbstractGraph) {
            this.gDispatchVector.add(new GGraph((MascoptAbstractGraph)mo, this.lm, this));
        } else if (mo instanceof MascoptAbstractPath) {
            this.gDispatchVector.add(new GPath((MascoptAbstractPath)mo, this.lm, this));
        } else if (mo instanceof MascoptMultiFlow) {
            this.gDispatchVector.add(new GFlow((MascoptMultiFlow)mo, this.lm, this));
        } else {
            throw new RuntimeException("The type " + mo.getClass() + " of the currently displayed object is unknow");
        }
    }

    boolean removeObject(MascoptObject mo) {
        GDispatch<?> gDispatch = this.getObject(mo);
        if (gDispatch == null) {
            return false;
        }
        this.gDispatchVector.removeElement(gDispatch);
        gDispatch.remove();
        return true;
    }

    void removeAllObjects() {
        int nbGGraph = this.gDispatchVector.size();
        int i = nbGGraph - 1;
        while (i >= 0) {
            GDispatch<? extends MascoptAbstractLink> g = this.gDispatchVector.elementAt(i);
            this.removeObject(g.getGraph());
            --i;
        }
        this.gDispatchVector = new Vector(100);
        this.labels.clear();
    }

    GDispatch<?> getObject(MascoptObject mo) {
        int nbGGraph = this.gDispatchVector.size();
        int i = 0;
        while (i < nbGGraph) {
            GDispatch<? extends MascoptAbstractLink> gd = this.gDispatchVector.elementAt(i);
            if (gd.getGraph() == mo) {
                return gd;
            }
            ++i;
        }
        return null;
    }

    boolean contains(MascoptObject mo) {
        return this.getObject(mo) != null;
    }

    GLabel addLabel(MascoptObject object, MascoptObject context) {
        this.removeLabel(object, context);
        GDispatch<?> gDispatch = this.getObject(context);
        if (gDispatch == null) {
            return null;
        }
        String[] labelText = this.lm.getLabelText(object, context, this);
        GObject gobject = gDispatch.getGObject(object);
        if (gobject == null) {
            return null;
        }
        GLabel label = new GLabel(gobject, labelText);
        this.labels.put(this.hash(object, context), label);
        if (this.lm.getLabelVisibility(object, context, this)) {
            this.add(label);
        }
        return label;
    }

    boolean removeLabel(MascoptObject obj, MascoptObject context) {
        GLabel l = this.labels.get(this.hash(obj, context));
        if (l == null) {
            return false;
        }
        this.remove(l);
        this.labels.remove(this.hash(obj, context));
        return true;
    }

    void refreshAllLabels(MascoptObject graph) {
        GDispatch<?> gObject = this.getObject(graph);
        if (gObject == null) {
            System.err.println("Can't find graphic representation of " + graph + " in " + this);
            return;
        }
        Iterator<MascoptVertex> vertexIt = gObject.getMascoptVertexIterator();
        while (vertexIt.hasNext()) {
            this.refreshObjectLabels(vertexIt.next(), graph);
        }
        Iterator<?> edgeIt = gObject.edgeIterator();
        while (edgeIt.hasNext()) {
            this.refreshObjectLabels((MascoptObject)edgeIt.next(), graph);
        }
        this.repaint();
    }

    void refreshObjectLabels(MascoptObject object, MascoptObject context) {
        this.addLabel(object, context);
    }

    void hideObjectLabels(MascoptObject object, MascoptObject context) {
        GLabel l = this.labels.get(this.hash(object, context));
        if (l != null) {
            this.remove(l);
        }
    }

    void showObjectLabels(MascoptObject object, MascoptObject context) {
        GLabel l = this.labels.get(this.hash(object, context));
        if (l == null) {
            this.addLabel(object, context);
            return;
        }
        this.remove(l);
        this.add(l);
    }

    void moveLabelsUnderEverything() {
        Iterator<GLabel> it = this.labels.values().iterator();
        while (it.hasNext()) {
            this.moveUnderEverything(it.next());
        }
    }

    void restoreLabelsPosition() {
        Iterator<GLabel> it = this.labels.values().iterator();
        while (it.hasNext()) {
            this.restorePosition(it.next());
        }
    }

    private String hash(MascoptObject mo, MascoptObject context) {
        return String.valueOf(mo.getId()) + context.getId();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

