/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import mascoptLib.core.MascoptVertex;
import mascoptLib.gui.layerManager.GDispatch;
import mascoptLib.gui.layerManager.GObject;
import mascoptLib.gui.layerManager.Selectable;

class GVertex
extends GObject
implements Selectable {
    private static final long serialVersionUID = 2L;
    private MascoptVertex node;
    private Color color;
    private Color colorOn;
    private Color colorOff;
    private Color colorSelect;
    private final GDispatch gGraph;
    private BufferedImage image = null;
    private BufferedImage imageOn;
    private BufferedImage imageOff;

    public GVertex(MascoptVertex n, int w, int h, Color col, GDispatch g) {
        super((int)Math.round(n.getX()), (int)Math.round(n.getY()), w, h);
        this.gGraph = g;
        this.colorOn = Color.red;
        this.colorOff = col;
        this.colorSelect = Color.green;
        this.color = col;
        this.node = n;
        n.addValueObserver(g);
    }

    public GDispatch getGGraph() {
        return this.gGraph;
    }

    public void remove() {
        this.image = null;
        this.imageOff = null;
        this.imageOn = null;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.imageOff = image;
        if (image != null) {
            float[] brightKernel = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.2f, 0.0f, 0.0f, 0.0f, 0.0f};
            ConvolveOp bright = new ConvolveOp(new Kernel(3, 3, brightKernel));
            this.imageOn = bright.filter(image, null);
        }
    }

    public MascoptVertex getVertex() {
        return this.node;
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        if (this.node != null) {
            int xNode = (int)Math.round(this.node.getX());
            int yNode = (int)Math.round(this.node.getY());
            if (xNode != x) {
                this.node.setX(x);
            }
            if (yNode != y) {
                this.node.setY(y);
            }
        }
    }

    public void setColor(Color newColor) {
        this.colorOff = newColor;
        this.color = newColor;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void select() {
        this.color = this.colorSelect;
        this.repaint();
    }

    @Override
    public void enter() {
        if (this.image == null) {
            this.color = this.colorOn;
        } else {
            this.image = this.imageOn;
        }
        this.repaint();
    }

    @Override
    public void exit() {
        if (this.image == null) {
            this.color = this.colorOff;
        } else {
            this.image = this.imageOff;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.image == null) {
            ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, this.color, this.getWidth(), this.getHeight(), this.color.darker().darker()));
            g.fillOval(0, 0, this.getWidth(), this.getHeight());
        } else {
            int width = this.getWidth() < this.image.getWidth() ? this.getWidth() : this.image.getWidth();
            int height = this.getHeight() < this.image.getHeight() ? this.getHeight() : this.image.getHeight();
            g.drawImage(this.image, 0, 0, width, height, this);
        }
    }
}

