/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Vector;
import mascoptLib.gui.layerManager.GObject;
import mascoptLib.gui.layerManager.View;

class Layer {
    private Vector<Vector<GObject>> priorityObjects = new Vector();
    private static int MAX_PRIORITY = 5;
    private Vector<View> views;
    private HashMap<GObject, Integer> oldPosition;

    public Layer() {
        int i = 0;
        while (i < MAX_PRIORITY + 1) {
            this.priorityObjects.add(i, null);
            ++i;
        }
        this.priorityObjects.set(0, new Vector());
        this.views = new Vector();
        this.oldPosition = new HashMap();
    }

    public void add(GObject comp) {
        this.add(comp, MAX_PRIORITY);
    }

    public void add(GObject comp, int priority) {
        int realPriority = priority;
        if (priority <= 0) {
            realPriority = 1;
        } else if (priority > MAX_PRIORITY) {
            realPriority = MAX_PRIORITY;
        }
        Vector<GObject> priorityLevel = this.priorityObjects.get(realPriority);
        if (priorityLevel == null) {
            priorityLevel = new Vector();
            this.priorityObjects.set(priority, priorityLevel);
        }
        priorityLevel.add(comp);
        comp.setLayer(this);
    }

    public void remove(GObject comp) {
        int priority = 0;
        while (priority <= MAX_PRIORITY) {
            this.remove(comp, priority);
            ++priority;
        }
    }

    public void moveUnderEverything(GObject comp) {
        int i = 1;
        while (i <= MAX_PRIORITY) {
            Vector<GObject> current = this.priorityObjects.get(i);
            if (current != null && current.contains(comp)) {
                this.oldPosition.put(comp, new Integer(i));
                current.remove(comp);
                current = this.priorityObjects.get(0);
                current.add(comp);
                return;
            }
            ++i;
        }
    }

    public void restorePosition(GObject comp) {
        Vector<GObject> underAll = this.priorityObjects.get(0);
        if (underAll.contains(comp)) {
            underAll.remove(comp);
            Integer oldPos = this.oldPosition.get(comp);
            this.oldPosition.remove(comp);
            this.priorityObjects.get(oldPos).add(comp);
        }
    }

    public boolean contains(GObject comp) {
        int priority = MAX_PRIORITY;
        while (priority >= 0) {
            Vector<GObject> priorityLevel = this.priorityObjects.get(priority);
            if (priorityLevel != null && priorityLevel.contains(comp)) {
                return true;
            }
            --priority;
        }
        return false;
    }

    public void remove(GObject comp, int priority) {
        int realPriority = priority;
        if (priority < 0) {
            realPriority = 0;
        } else if (priority > MAX_PRIORITY) {
            realPriority = MAX_PRIORITY;
        }
        Vector<GObject> priorityLevel = this.priorityObjects.get(realPriority);
        if (priorityLevel != null) {
            priorityLevel.remove(comp);
            comp.setLayer(null);
        }
    }

    public void addView(View v) {
        this.views.add(v);
    }

    public void removeView(View v) {
        this.views.remove(v);
    }

    public void repaint() {
        int nbViews = this.views.size();
        int i = 0;
        while (i < nbViews) {
            this.views.elementAt(i).repaint();
            ++i;
        }
    }

    public Component getComponentAt(Point p) {
        int priority = MAX_PRIORITY;
        while (priority >= 0) {
            Vector<GObject> priorityLevel = this.priorityObjects.get(priority);
            if (priorityLevel != null) {
                int i = 0;
                while (i < priorityLevel.size()) {
                    Component component = priorityLevel.elementAt(i);
                    Point location = component.getLocation();
                    if (component.contains(new Point(p.x - location.x, p.y - location.y))) {
                        return component;
                    }
                    ++i;
                }
            }
            --priority;
        }
        return null;
    }

    public void paint(Graphics g, Rectangle view) {
        int priority = 0;
        while (priority <= MAX_PRIORITY) {
            Vector<GObject> priorityLevel = this.priorityObjects.get(priority);
            if (priorityLevel != null) {
                int i = 0;
                while (i < priorityLevel.size()) {
                    Component component = priorityLevel.elementAt(i);
                    Rectangle bounds = component.getBounds();
                    if (view.intersects(bounds)) {
                        Graphics newG = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
                        component.paint(newG);
                    }
                    ++i;
                }
            }
            ++priority;
        }
    }
}

