/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.gui.layerManager.DefaultEventListener;
import mascoptLib.gui.layerManager.GDispatch;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GView;
import mascoptLib.gui.layerManager.LayerInfo;

public class LayerManager {
    private final boolean DEFAULT_VISIBLE_LABEL = true;
    private HashMap<String, LabelConfiguration> vertexLabel;
    private HashMap<String, LabelConfiguration> edgeLabel;
    private DefaultEventListener vl;
    private Vector<GView> gviews = new Vector();
    private Vector<GLayer> glayers = new Vector();
    private Vector<Boolean> updateLabelsWhenValuesChange = new Vector();
    private Vector<MascoptObject> agraphs = new Vector();
    private HashMap<GLayer, Vector<MascoptObject>> layerToGraph;
    private HashMap<String, MascoptMap> graphAndLayerToMapValues = new HashMap();
    private HashMap<String, MascoptObject> graphAndLayerToContextValues = new HashMap();
    private HashMap<String, MascoptMap> graphAndLayerToVertexImagesMap = new HashMap();
    private HashMap<String, String> graphAndLayerToVertexImagesName = new HashMap();
    private HashMap<String, MascoptObject> graphAndLayerToVertexImagesContext = new HashMap();
    private HashMap<String, MascoptMap> graphAndLayerToEdgeImagesMap = new HashMap();
    private HashMap<String, String> graphAndLayerToEdgeImagesName = new HashMap();
    private HashMap<String, MascoptObject> graphAndLayerToEdgeImagesContext = new HashMap();

    public LayerManager() {
        this(new DefaultEventListener());
    }

    public LayerManager(DefaultEventListener vl) {
        this.layerToGraph = new HashMap();
        this.vertexLabel = new HashMap();
        this.edgeLabel = new HashMap();
        this.vl = vl;
        vl.setLayerManager(this);
    }

    public GView newView() {
        int nbViews = this.gviews.size();
        return this.newView("View #" + (nbViews + 1));
    }

    public GView newView(String name) {
        return this.newView(name, 0, 0, 1.0);
    }

    public GView newView(String name, int centerX, int centerY, double zoom) {
        if (this.getView(name) != null) {
            return this.newView(String.valueOf(name) + "'", centerX, centerY, zoom);
        }
        GView v = new GView(name, centerX, centerY, zoom);
        v.addMouseMotionListener(this.vl);
        v.addMouseListener(this.vl);
        v.addMouseWheelListener(this.vl);
        this.gviews.add(v);
        return v;
    }

    public GView getView(String name) {
        int nbView = this.gviews.size();
        int i = 0;
        while (i < nbView) {
            GView gv = this.gviews.elementAt(i);
            if (gv.getName().equalsIgnoreCase(name)) {
                return gv;
            }
            ++i;
        }
        return null;
    }

    public void setBackGroundOfView(GView v, Image image) {
        v.setBackGroundImage(image);
    }

    public void setBackGroundOfView(GView v, Color color) {
        v.setBackground(color);
    }

    public GLayer newLayer(String name) {
        if (this.getLayer(name) != null) {
            return this.newLayer(String.valueOf(name) + "'");
        }
        GLayer gl = new GLayer(name, this, this.vl);
        this.glayers.add(gl);
        this.updateLabelsWhenValuesChange.add(new Boolean(false));
        return gl;
    }

    public void destroyLayer(GLayer layer) {
        for (GView v : this.gviews) {
            this.removeLayerInView(layer, v);
        }
        this.updateLabelsWhenValuesChange.remove(this.glayers.indexOf(layer));
        this.glayers.remove(layer);
        layer.removeAllObjects();
    }

    public GLayer getLayer(String name) {
        int nbLayer = this.glayers.size();
        int i = 0;
        while (i < nbLayer) {
            GLayer gl = this.glayers.elementAt(i);
            if (gl.getName().equalsIgnoreCase(name)) {
                return gl;
            }
            ++i;
        }
        return null;
    }

    public String getLayerName(GLayer layer) {
        return layer.getName();
    }

    public boolean addLayerInView(GLayer l, GView v) {
        if (v.contains(l)) {
            return false;
        }
        v.addLayer(l);
        v.repaint();
        return true;
    }

    public boolean removeLayerInView(GLayer l, GView v) {
        if (v.getLayerIndex(l) == -1) {
            return false;
        }
        v.removeLayer(l);
        v.repaint();
        return true;
    }

    public void setVisibleLayerInView(GLayer l, GView v, boolean visible) {
        v.setVisibleLayer(l, visible);
        v.repaint();
    }

    public void moveUpLayerInView(GLayer l, GView v) {
        int position = v.getLayerIndex(l);
        if (position == -1) {
            return;
        }
        if (position == 0) {
            return;
        }
        LayerInfo li = v.getLayerInfo(l);
        v.removeLayer(l);
        v.insertLayerInfo(position - 1, li);
        v.repaint();
    }

    public void moveDownLayerInView(GLayer l, GView v) {
        int position = v.getLayerIndex(l);
        if (position == -1) {
            System.out.println(v + " ne contient pas " + l);
            return;
        }
        if (position == v.getLayerCount() - 1) {
            return;
        }
        LayerInfo li = v.getLayerInfo(l);
        v.removeLayer(l);
        v.insertLayerInfo(position + 1, li);
        v.repaint();
    }

    public boolean addGraph(MascoptObject g) {
        if (this.agraphs.contains(g)) {
            return false;
        }
        if (g.getName() == null) {
            g.setName("No Name #" + this.agraphs.size());
        }
        this.agraphs.add(g);
        return true;
    }

    public boolean removeGraph(MascoptObject g) {
        int i = 0;
        while (i < this.glayers.size()) {
            try {
                this.setVisibleGraphInLayer(g, this.glayers.get(i), false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.glayers.get(i).repaint();
            ++i;
        }
        return this.agraphs.remove(g);
    }

    public MascoptObject getGraph(String name) {
        int nbGraph = this.agraphs.size();
        int i = 0;
        while (i < nbGraph) {
            MascoptObject ag = this.agraphs.elementAt(i);
            if (ag.getName().equalsIgnoreCase(name)) {
                return ag;
            }
            ++i;
        }
        return null;
    }

    public void setVisibleGraphInLayer(MascoptObject graph, GLayer layer, boolean visible) throws IOException {
        Vector<MascoptObject> graphs = this.layerToGraph.get(layer);
        if (graphs == null) {
            graphs = new Vector();
            this.layerToGraph.put(layer, graphs);
        }
        MascoptMap labelMap = this.graphAndLayerToMapValues.get(this.hash(graph, layer));
        MascoptMap verticesImagesMap = this.graphAndLayerToVertexImagesMap.get(this.hash(graph, layer));
        String verticesImagesName = this.graphAndLayerToVertexImagesName.get(this.hash(graph, layer));
        MascoptObject verticesImagesContext = this.graphAndLayerToVertexImagesContext.get(this.hash(graph, layer));
        MascoptMap edgesImagesMap = this.graphAndLayerToEdgeImagesMap.get(this.hash(graph, layer));
        String edgesImagesName = this.graphAndLayerToEdgeImagesName.get(this.hash(graph, layer));
        MascoptObject edgesImagesContext = this.graphAndLayerToEdgeImagesContext.get(this.hash(graph, layer));
        if (visible && !layer.contains(graph)) {
            layer.addObject(graph);
            graphs.add(graph);
            if (labelMap != null) {
                labelMap.addValueObserver(layer.getObject(graph));
            }
            if (verticesImagesMap != null) {
                layer.getObject(graph).setVerticesImagesMap(verticesImagesMap, false);
                layer.getObject(graph).setVerticesImagesName(verticesImagesName, false);
                layer.getObject(graph).setVerticesImagesContext(verticesImagesContext, true);
            }
            if (edgesImagesMap != null) {
                layer.getObject(graph).setEdgesImagesMap(edgesImagesMap, false);
                layer.getObject(graph).setEdgesImagesName(edgesImagesName, false);
                layer.getObject(graph).setEdgesImagesContext(edgesImagesContext, true);
            }
            LabelConfiguration lcv = this.vertexLabel.get(this.hash(graph, layer));
            LabelConfiguration lce = this.edgeLabel.get(this.hash(graph, layer));
            if (lcv != null && lcv.visible || lce != null && lce.visible) {
                this.setGraphInLayerVisibleLabels(graph, layer, true);
            }
        } else {
            if (labelMap != null) {
                labelMap.deleteValueObserver(layer.getObject(graph));
            }
            layer.removeObject(graph);
            graphs.remove(graph);
        }
    }

    public void setGraphLayerVertexImagesMap(MascoptObject graph, GLayer layer, MascoptMap map) throws IOException {
        if (layer.getObject(graph) != null) {
            layer.getObject(graph).setVerticesImagesMap(map, false);
        }
        this.graphAndLayerToVertexImagesMap.put(this.hash(graph, layer), map);
    }

    public void setGraphLayerEdgeImagesMap(MascoptObject graph, GLayer layer, MascoptMap map) throws IOException {
        if (layer.getObject(graph) != null) {
            layer.getObject(graph).setEdgesImagesMap(map, false);
        }
        this.graphAndLayerToEdgeImagesMap.put(this.hash(graph, layer), map);
    }

    public void setGraphLayerVertexImagesName(MascoptObject graph, GLayer layer, String name) throws IOException {
        if (layer.getObject(graph) != null) {
            layer.getObject(graph).setVerticesImagesName(name, false);
        }
        this.graphAndLayerToVertexImagesName.put(this.hash(graph, layer), name);
    }

    public void setGraphLayerEdgeImagesName(MascoptObject graph, GLayer layer, String name) throws IOException {
        if (layer.getObject(graph) != null) {
            layer.getObject(graph).setEdgesImagesName(name, false);
        }
        this.graphAndLayerToEdgeImagesName.put(this.hash(graph, layer), name);
    }

    public void setGraphLayerVertexImagesContext(MascoptObject graph, GLayer layer, MascoptObject context) throws IOException {
        if (layer.getObject(graph) != null) {
            layer.getObject(graph).setVerticesImagesContext(context, false);
        }
        this.graphAndLayerToVertexImagesContext.put(this.hash(graph, layer), context);
    }

    public void setGraphLayerEdgeImagesContext(MascoptObject graph, GLayer layer, MascoptObject context) throws IOException {
        if (layer.getObject(graph) != null) {
            layer.getObject(graph).setEdgesImagesContext(context, false);
        }
        this.graphAndLayerToEdgeImagesContext.put(this.hash(graph, layer), context);
    }

    public void graphLayerVertexImageLoad(MascoptObject graph, GLayer layer) throws IOException {
        if (layer.getObject(graph) != null) {
            layer.getObject(graph).loadImagesOfVertices();
        }
    }

    public void graphLayerEdgeImageLoad(MascoptObject graph, GLayer layer) throws IOException {
        if (layer.getObject(graph) != null) {
            layer.getObject(graph).loadImagesOfEdges();
        }
    }

    public void setGraphLayerMapValues(MascoptObject graph, GLayer layer, MascoptMap map) {
        MascoptMap oldMap = this.graphAndLayerToMapValues.get(this.hash(graph, layer));
        if (oldMap != null) {
            oldMap.deleteValueObserver(layer.getObject(graph));
        }
        if (map != null) {
            map.addValueObserver(layer.getObject(graph));
        }
        this.graphAndLayerToMapValues.put(this.hash(graph, layer), map);
        layer.refreshAllLabels(graph);
    }

    public MascoptMap getGraphLayerMapValues(MascoptObject graph, GLayer layer) {
        return this.graphAndLayerToMapValues.get(this.hash(graph, layer));
    }

    public void setGraphLayerContextValues(MascoptObject graph, GLayer layer, MascoptObject context) {
        this.graphAndLayerToContextValues.put(this.hash(graph, layer), context);
        layer.refreshAllLabels(graph);
    }

    public MascoptObject getGraphLayerContextValues(MascoptObject graph, GLayer layer) {
        return this.graphAndLayerToContextValues.get(this.hash(graph, layer));
    }

    public void setVisibleLabels(boolean visible) {
        int nbGlayers = this.glayers.size();
        int i = 0;
        while (i < nbGlayers) {
            this.setLayerVisibleLabels(this.glayers.get(i), visible);
            ++i;
        }
    }

    public void setLayerVisibleLabels(GLayer layer, boolean visible) {
        Vector<MascoptObject> graphInLayer = this.layerToGraph.get(layer);
        if (graphInLayer != null) {
            int i = 0;
            while (i < graphInLayer.size()) {
                this.setGraphInLayerVisibleLabels(graphInLayer.get(i), layer, visible);
                ++i;
            }
        }
    }

    public void setGraphInLayerVisibleLabels(MascoptObject graph, GLayer layer, boolean visible) {
        LabelConfiguration lce;
        LabelConfiguration lcv = this.vertexLabel.get(this.hash(graph, layer));
        if (lcv != null) {
            GDispatch<?> gObject = layer.getObject(graph);
            if (gObject == null) {
                System.err.println("The object " + graph + " is not in layer " + layer);
                return;
            }
            Iterator<MascoptVertex> itVertex = gObject.getMascoptVertexIterator();
            lcv.visible = visible;
            while (itVertex.hasNext()) {
                this.setObjectInLayerVisibleLabels(itVertex.next(), graph, layer, visible);
            }
        }
        if ((lce = this.edgeLabel.get(this.hash(graph, layer))) != null) {
            lce.visible = visible;
            GDispatch<?> gObject = layer.getObject(graph);
            if (gObject == null) {
                System.err.println("The object " + graph + " is not in layer " + layer);
                return;
            }
            Iterator<?> itEdge = gObject.edgeIterator();
            while (itEdge.hasNext()) {
                this.setObjectInLayerVisibleLabels((MascoptObject)itEdge.next(), graph, layer, visible);
            }
        }
        layer.repaint();
    }

    private void setObjectInLayerVisibleLabels(MascoptObject object, MascoptObject context, GLayer layer, boolean visible) {
        if (visible) {
            layer.showObjectLabels(object, context);
        } else {
            layer.hideObjectLabels(object, context);
        }
    }

    public void setVertexLabelGraphInLayer(MascoptObject graph, GLayer l, String[] value) {
        if (!l.contains(graph)) {
            return;
        }
        if (value == null) {
            this.vertexLabel.remove(this.hash(graph, l));
            l.refreshAllLabels(graph);
            return;
        }
        LabelConfiguration lnv = this.vertexLabel.get(this.hash(graph, l));
        if (lnv == null) {
            lnv = new LabelConfiguration(value, true);
            this.vertexLabel.put(this.hash(graph, l), lnv);
        }
        lnv.labels = value;
        l.refreshAllLabels(graph);
    }

    public void setVertexLabelGraphInLayerVisibility(MascoptObject graph, GLayer layer, boolean visible) {
        if (!layer.contains(graph)) {
            return;
        }
        LabelConfiguration lnv = this.vertexLabel.get(this.hash(graph, layer));
        if (lnv == null) {
            return;
        }
        lnv.visible = visible;
        layer.refreshAllLabels(graph);
    }

    public void setEdgeLabelGraphInLayer(MascoptObject graph, GLayer l, String[] value) {
        if (!l.contains(graph)) {
            return;
        }
        if (value == null) {
            this.edgeLabel.remove(this.hash(graph, l));
            l.refreshAllLabels(graph);
            return;
        }
        LabelConfiguration lnv = this.edgeLabel.get(this.hash(graph, l));
        if (lnv == null) {
            lnv = new LabelConfiguration(value, true);
            this.edgeLabel.put(this.hash(graph, l), lnv);
        }
        lnv.labels = value;
        l.refreshAllLabels(graph);
    }

    public void setEdgeLabelGraphInLayerVisibility(MascoptObject graph, GLayer layer, boolean visible) {
        if (!layer.contains(graph)) {
            return;
        }
        LabelConfiguration lne = this.edgeLabel.get(this.hash(graph, layer));
        if (lne == null) {
            return;
        }
        lne.visible = visible;
        layer.refreshAllLabels(graph);
    }

    public String[] getVertexLabelGraphInLayer(MascoptObject graph, GLayer l) {
        LabelConfiguration lnv = this.vertexLabel.get(this.hash(graph, l));
        if (lnv == null) {
            return new String[0];
        }
        return lnv.labels;
    }

    public String[] getEdgeLabelGraphInLayer(MascoptObject graph, GLayer l) {
        LabelConfiguration lnv = this.edgeLabel.get(this.hash(graph, l));
        if (lnv == null) {
            return new String[0];
        }
        return lnv.labels;
    }

    public void moveLabelsUnderEverything() {
        int i = 0;
        while (i < this.glayers.size()) {
            this.glayers.get(i).moveLabelsUnderEverything();
            ++i;
        }
    }

    public void restoreLabelsPosition() {
        int i = 0;
        while (i < this.glayers.size()) {
            this.glayers.get(i).restoreLabelsPosition();
            ++i;
        }
    }

    void updateLabelOfObject(MascoptObject object, MascoptObject graph, GLayer layer, String valueChange) {
        if (this.updateLabelsWhenValuesChange.get(this.glayers.indexOf(layer)).booleanValue()) {
            LabelConfiguration lc = this.vertexLabel.get(this.hash(graph, layer));
            if (lc != null && this.labelUseValue(lc.labels, valueChange)) {
                layer.refreshObjectLabels(object, graph);
            }
            if ((lc = this.edgeLabel.get(this.hash(graph, layer))) != null && this.labelUseValue(lc.labels, valueChange)) {
                layer.refreshObjectLabels(object, graph);
            }
            layer.repaint();
        }
    }

    String[] getLabelText(MascoptObject object, MascoptObject graph, GLayer layer) {
        LabelConfiguration lc;
        if (object instanceof MascoptVertex) {
            lc = this.vertexLabel.get(this.hash(graph, layer));
        } else if (object instanceof MascoptAbstractLink) {
            lc = this.edgeLabel.get(this.hash(graph, layer));
        } else {
            return new String[]{""};
        }
        if (lc == null) {
            return new String[]{""};
        }
        return this.resolveValues(object, graph, layer, lc.labels);
    }

    boolean getLabelVisibility(MascoptObject object, MascoptObject graph, GLayer layer) {
        LabelConfiguration lc;
        if (object instanceof MascoptVertex) {
            lc = this.vertexLabel.get(this.hash(graph, layer));
        } else if (object instanceof MascoptAbstractLink) {
            lc = this.edgeLabel.get(this.hash(graph, layer));
        } else {
            return false;
        }
        if (lc == null) {
            return false;
        }
        return lc.visible;
    }

    public void setLayerUpdateLabelsWhenValuesChange(GLayer layer, boolean update) {
        this.updateLabelsWhenValuesChange.set(this.glayers.indexOf(layer), new Boolean(update));
    }

    boolean getLayerUpdateLabelsWhenValuesChange(GLayer layer) {
        return this.updateLabelsWhenValuesChange.get(this.glayers.indexOf(layer));
    }

    public void setGraphLinkWidth(MascoptObject graph, GLayer layer, int width) {
        GDispatch<?> gGraph = layer.getObject(graph);
        assert (gGraph != null);
        assert (width > 0);
        if (gGraph == null) {
            return;
        }
        gGraph.setLinkWidth(width);
    }

    int getGraphEdgeWidth(MascoptObject graph, GLayer layer) {
        GDispatch<?> gGraph = layer.getObject(graph);
        return gGraph.getEdgesWidth();
    }

    private String hash(MascoptObject mo, GLayer layer) {
        return String.valueOf(mo.getId()) + layer.getName();
    }

    private String[] resolveValues(MascoptObject mo, MascoptObject context, GLayer layer, String[] code) {
        String[] result = new String[code.length];
        int i = 0;
        while (i < code.length) {
            String resolved = "";
            String str = code[i];
            StringTokenizer st = new StringTokenizer(code[i], "$", false);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.equals(str)) {
                    resolved = String.valueOf(resolved) + tok;
                    continue;
                }
                if (tok.startsWith("(")) {
                    int endIndex = tok.indexOf(41);
                    if (endIndex == -1) {
                        resolved = String.valueOf(resolved) + tok;
                        continue;
                    }
                    String toResolve = tok.substring(1, endIndex);
                    String value = null;
                    MascoptMap mapValues = this.graphAndLayerToMapValues.get(this.hash(context, layer));
                    MascoptObject contextValues = this.graphAndLayerToContextValues.get(this.hash(context, layer));
                    if (toResolve.equals("name")) {
                        value = mo.getName();
                    } else if (toResolve.equals("id")) {
                        value = mo.getId();
                    } else if (toResolve.equalsIgnoreCase("x") && mo instanceof MascoptVertex) {
                        value = "" + ((MascoptVertex)mo).getX();
                    } else if (toResolve.equalsIgnoreCase("y") && mo instanceof MascoptVertex) {
                        value = "" + ((MascoptVertex)mo).getY();
                    } else if (mapValues == null) {
                        value = "No Map";
                    } else {
                        String type = mapValues.getDataType(mo, toResolve, contextValues == null ? mo : contextValues);
                        if (type != null) {
                            if (type.equals("String")) {
                                value = "";
                                value = String.valueOf(value) + mapValues.getString(mo, toResolve, contextValues == null ? mo : contextValues);
                            } else {
                                value = "";
                                value = String.valueOf(value) + mapValues.getValue(mo, toResolve, contextValues == null ? mo : contextValues);
                            }
                        }
                    }
                    if (value == null) {
                        value = "??";
                    }
                    resolved = String.valueOf(resolved) + value;
                    resolved = String.valueOf(resolved) + tok.substring(endIndex + 1);
                    continue;
                }
                resolved = String.valueOf(resolved) + tok;
            }
            result[i] = resolved;
            ++i;
        }
        return result;
    }

    private boolean labelUseValue(String[] label, String value) {
        if (label == null) {
            return false;
        }
        int i = 0;
        while (i < label.length) {
            if (label[i].indexOf("$(" + value + ")") != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class LabelConfiguration {
        public String[] labels;
        public boolean visible;

        public LabelConfiguration(String[] n, boolean b) {
            this.labels = n;
            this.visible = b;
        }
    }
}

