/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Point;
import java.util.HashMap;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptVertex;
import mascoptLib.exception.MascoptInternalError;
import mascoptLib.gui.layerManager.GDispatch;
import mascoptLib.gui.layerManager.GEdge;
import mascoptLib.gui.layerManager.GVertex;

public class LinkManager<E extends MascoptAbstractLink> {
    private GDispatch<E> dispatch_;
    private HashMap<String, Vector<Integer>> shiftMap_ = new HashMap();
    private final int initialShift_ = 4;
    private final int stepShift_ = 6;
    private int linksWidth_ = 1;

    public LinkManager(GDispatch<E> dispath) {
        this.dispatch_ = dispath;
    }

    private String getKey(GVertex n0, GVertex n1) {
        return String.valueOf(n0.getVertex().getId()) + n1.getVertex().getId();
    }

    private int getNumberOfShift(double distance) {
        return (int)((distance - (double)(4 + (this.linksWidth_ - 1))) / (double)(6 + (this.linksWidth_ - 1)));
    }

    private int getShiftFromShiftIndex(int index) {
        return 4 + (this.linksWidth_ - 1) + index * (6 + (this.linksWidth_ - 1));
    }

    private int getNextShift(int shift) {
        return shift + (6 + (this.linksWidth_ - 1));
    }

    private int getMax(Vector<Integer> freeShift) {
        if (freeShift.size() == 0) {
            throw new MascoptInternalError("Free Shift vector is empty");
        }
        int max = freeShift.elementAt(0);
        int i = 1;
        while (i < freeShift.size()) {
            int t = freeShift.elementAt(i);
            if (t > max) {
                max = t;
            }
            ++i;
        }
        return max;
    }

    private int getMinAndRemove(Vector<Integer> freeShift) {
        if (freeShift.size() == 0) {
            throw new MascoptInternalError("Free Shift vector is empty");
        }
        int min = freeShift.elementAt(0);
        int indexMin = 0;
        assert (min >= 0);
        int i = 1;
        while (i < freeShift.size()) {
            int t = freeShift.elementAt(i);
            if (t < min) {
                min = t;
                indexMin = i;
            }
            ++i;
        }
        freeShift.remove(indexMin);
        return min;
    }

    private int getClosestShiftAndRemove(Vector<Integer> freeShift, double espectedValue) {
        if (freeShift.size() == 0) {
            throw new MascoptInternalError("Free Shift vector is empty");
        }
        int delta = Integer.MAX_VALUE;
        int result = this.getShiftFromShiftIndex(0);
        int indexResult = 0;
        int i = 0;
        while (i < freeShift.size()) {
            int t = freeShift.elementAt(i);
            if (Math.abs((double)t - espectedValue) < (double)delta) {
                delta = (int)Math.abs((double)t - espectedValue);
                result = t;
                indexResult = i;
            }
            ++i;
        }
        freeShift.remove(indexResult);
        if (freeShift.size() == 0) {
            freeShift.add(new Integer(this.getNextShift(result)));
        }
        return result;
    }

    public void setEdgeShift(GEdge link, int newShift) {
        String key = this.getKey((GVertex)this.dispatch_.getGObject(link.getAbstractEdge().toArray(new MascoptVertex[0])[0]), (GVertex)this.dispatch_.getGObject(link.getAbstractEdge().toArray(new MascoptVertex[0])[1]));
        Vector<Integer> freeShift = this.shiftMap_.get(key);
        if (freeShift == null) {
            throw new MascoptInternalError("freeShift vector null for an existing link");
        }
        if (freeShift.contains(new Integer(link.getShift()))) {
            throw new MascoptInternalError("A shift belong to free shift and is already used");
        }
        freeShift.add(new Integer(link.getShift()));
        int nbShift = this.getNumberOfShift(newShift);
        int currentMaxShift = this.getMax(freeShift);
        if (newShift > currentMaxShift) {
            int i = this.getNumberOfShift(currentMaxShift) + 1;
            while (i < nbShift) {
                freeShift.add(new Integer(this.getShiftFromShiftIndex(i)));
                ++i;
            }
            freeShift.add(new Integer(this.getShiftFromShiftIndex(nbShift + 1)));
        } else {
            newShift = this.getClosestShiftAndRemove(freeShift, newShift);
        }
        link.setShift(newShift);
        link.updateBounds();
    }

    public void changeEdgeShift(GEdge link, GEdge movingLink, int x, int y) {
        if (link.getSource() == link.getTarget()) {
            Point sourceLocation = link.getSourceRealCoordinates();
            double distance = Math.sqrt((x - sourceLocation.x) * (x - sourceLocation.x) + (y - sourceLocation.y) * (y - sourceLocation.y));
            int computedShift = (int)((distance - (double)(2 * link.getBaseRadiusOfLoop())) / 2.0);
            int nbShift = this.getNumberOfShift(computedShift);
            int newShift = this.getShiftFromShiftIndex(nbShift);
            movingLink.setShift(newShift);
            movingLink.updateBounds();
            this.dispatch_.getLayer().repaint();
            return;
        }
        Point sourceLocation = link.getSourceRealCoordinates();
        Point targetLocation = link.getTargetRealCoordinates();
        double X = targetLocation.x - sourceLocation.x;
        double Y = targetLocation.y - sourceLocation.y;
        double xIntersection = (-X * (double)x - Y * (double)y - Y * Y / X * (double)sourceLocation.x + Y * (double)sourceLocation.y) / (-Y * Y / X - X);
        double yIntersection = Y / X * xIntersection + (double)sourceLocation.y - Y / X * (double)sourceLocation.x;
        double distance = Math.sqrt(((double)x - xIntersection) * ((double)x - xIntersection) + ((double)y - yIntersection) * ((double)y - yIntersection));
        int nbShift = this.getNumberOfShift(distance);
        int newShift = this.getShiftFromShiftIndex(nbShift);
        movingLink.setShift(newShift);
        movingLink.updateBounds();
        this.dispatch_.getLayer().repaint();
    }

    public void setShiftFree(GVertex v0, GVertex v1, int h) {
        String key = this.getKey(v0, v1);
        Vector<Integer> free = this.shiftMap_.get(key);
        if (free == null) {
            assert (false);
            return;
        }
        free.insertElementAt(new Integer(h), 0);
    }

    public int getFreeShift(GVertex v0, GVertex v1) {
        String key = this.getKey(v0, v1);
        Vector<Integer> free = this.shiftMap_.get(key);
        if (free == null) {
            free = new Vector();
            free.add(new Integer(this.getShiftFromShiftIndex(1)));
            this.shiftMap_.put(key, free);
            return this.getShiftFromShiftIndex(0);
        }
        int retVal = this.getMinAndRemove(free);
        if (free.size() == 0) {
            free.add(new Integer(this.getNextShift(retVal)));
        }
        return retVal;
    }

    public void setLinkWidth(int linksWidth) {
        this.linksWidth_ = linksWidth;
    }

    public int getLinkWidth() {
        return this.linksWidth_;
    }
}

