/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.MascoptChooser;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

class Filter
extends FileFilter {
    private Hashtable<String, FileFilter> filters_ = null;
    private String description_ = null;
    private String fullDescription_ = null;
    private boolean useExtensionsInDescription_ = true;

    public Filter() {
        this((String)null, (String)null);
    }

    public Filter(String extension) {
        this(extension, null);
    }

    public Filter(String extension, String description) {
        this(new String[]{extension}, description);
    }

    public Filter(String[] filters) {
        this(filters, null);
    }

    public Filter(String[] filters, String description) {
        this.filters_ = new Hashtable(filters.length);
        int i = 0;
        while (i < filters.length) {
            this.addExtension(filters[i]);
            ++i;
        }
        this.setDescription(description);
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters_.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters_ == null) {
            this.filters_ = new Hashtable(5);
        }
        this.filters_.put(extension.toLowerCase(), this);
        this.fullDescription_ = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription_ == null) {
            if (this.description_ == null || this.isExtensionListInDescription()) {
                if (this.description_ != null) {
                    this.fullDescription_ = this.description_;
                }
                this.fullDescription_ = String.valueOf(this.fullDescription_) + " (";
                Enumeration<String> extensions = this.filters_.keys();
                if (extensions != null) {
                    this.fullDescription_ = String.valueOf(this.fullDescription_) + "." + extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription_ = String.valueOf(this.fullDescription_) + ", " + extensions.nextElement();
                    }
                }
                this.fullDescription_ = String.valueOf(this.fullDescription_) + ")";
            } else {
                this.fullDescription_ = this.description_;
            }
        }
        return this.fullDescription_;
    }

    public void setDescription(String description) {
        this.description_ = description;
        this.fullDescription_ = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription_ = b;
        this.fullDescription_ = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription_;
    }
}

