/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.MascoptChooser;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptSet;
import mascoptLib.gui.ThemeManager;
import mascoptLib.io.MascoptChooser.Filter;
import mascoptLib.io.interfaces.Reader;
import mascoptLib.io.reader.mgl.dom.MGLDOMReader;
import mascoptLib.io.reader.mgl.sax.MGLSaxReader;

public class MascoptChooser {
    private static final ClassLoader loader = ClassLoader.getSystemClassLoader();

    private MascoptChooser() {
    }

    private static <E extends MascoptAbstractLink> MascoptAbstractGraph<E> getGraph(Reader reader, Class<MascoptAbstractGraph<E>> type, String message) {
        MascoptChooser.checkTheme();
        try {
            reader.parse();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getClass() + ":" + e.getMessage(), "error", 0);
            return null;
        }
        Hashtable<String, MascoptAbstractGraph<? extends MascoptAbstractLink>> ht = new Hashtable<String, MascoptAbstractGraph<? extends MascoptAbstractLink>>();
        Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> graphs = reader.getGraphs();
        while (graphs.hasNext()) {
            MascoptAbstractGraph<? extends MascoptAbstractLink> ag = graphs.next();
            if (type != null && !ag.getClass().equals(type)) continue;
            String name = ag.getName();
            if (name == null) {
                name = "no name (" + ag.vertexSet().size() + " nodes, " + ag.edgeSet() + " edges";
            }
            ht.put(name, ag);
        }
        if (ht.size() == 0) {
            return null;
        }
        Object[] names = new String[ht.size()];
        ht.keySet().toArray(names);
        String graphNameSelected = ht.size() == 1 ? names[0] : (String)JOptionPane.showInputDialog(null, message, "MascoptChooser", 2, null, names, names[0]);
        if (graphNameSelected == null) {
            return null;
        }
        return (MascoptAbstractGraph)ht.get(graphNameSelected);
    }

    public static MascoptMap getMap(Reader reader) {
        return MascoptChooser.getMap(reader, "");
    }

    /*
     * Unable to fully structure code
     */
    public static MascoptMap getMap(Reader reader, String message) {
        MascoptChooser.checkTheme();
        ht = new Hashtable<String, MascoptMap>();
        try {
            reader.parse();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        maps = reader.getMaps();
        if (maps.hasNext()) ** GOTO lbl16
        return null;
lbl-1000:
        // 1 sources

        {
            map = maps.next();
            name = map.getName();
            ht.put(name, map);
lbl16:
            // 2 sources

            ** while (maps.hasNext())
        }
lbl17:
        // 1 sources

        names = new String[ht.size()];
        ht.keySet().toArray(names);
        mapNameSelected = ht.size() == 1 ? names[0] : (String)JOptionPane.showInputDialog(null, message, "MGLChooser", 2, null, names, names[0]);
        if (mapNameSelected == null) {
            return null;
        }
        return (MascoptMap)ht.get(mapNameSelected);
    }

    public static MascoptAbstractGraph<? extends MascoptAbstractLink> getAbstractGraph(Reader reader) {
        return MascoptChooser.getAbstractGraph(reader, "Choose a graph");
    }

    public static <E extends MascoptAbstractLink> MascoptAbstractGraph<E> getAbstractGraph(Reader reader, String message) {
        return MascoptChooser.getGraph(reader, null, message);
    }

    public static MascoptGraph getGraph(Reader reader) {
        return MascoptChooser.getGraph(reader, "Choose a graph");
    }

    public static <E extends MascoptEdge> MascoptGraph getGraph(Reader reader, String message) {
        try {
            return (MascoptGraph)MascoptChooser.getGraph(reader, loader.loadClass("mascoptLib.core.MascoptGraph"), message);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            System.exit(1);
            return null;
        }
    }

    public static MascoptDiGraph getDiGraph(Reader reader) {
        return MascoptChooser.getDiGraph(reader, "Choose a graph");
    }

    public static <A extends MascoptArc> MascoptDiGraph getDiGraph(Reader reader, String message) {
        try {
            return (MascoptDiGraph)MascoptChooser.getGraph(reader, loader.loadClass("mascoptLib.core.MascoptDiGraph"), message);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            System.exit(1);
            return null;
        }
    }

    public static MGLDOMReader getMGLDomReader() {
        return MascoptChooser.getMGLDomReader(null);
    }

    public static MGLSaxReader getMGLSaxReader() {
        return MascoptChooser.getMGLSaxReader(null);
    }

    public static MGLDOMReader getMGLDomReader(String directory) {
        String fileName = MascoptChooser.getFileName(directory, new String[]{"mgl"}, "mascopt files", "Load");
        if (fileName == null) {
            return null;
        }
        MGLDOMReader mglr = null;
        try {
            mglr = new MGLDOMReader(fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("Sorry, the file " + fileName + " was not found.");
        }
        return mglr;
    }

    public static MGLSaxReader getMGLSaxReader(String directory) {
        String fileName = MascoptChooser.getFileName(directory, new String[]{"mgl"}, "mascopt files", "Load");
        if (fileName == null) {
            return null;
        }
        MGLSaxReader mglr = null;
        mglr = new MGLSaxReader(fileName);
        return mglr;
    }

    public static MascoptSet<? extends MascoptObject> getSet(Reader reader, String message) {
        MascoptChooser.checkTheme();
        try {
            reader.parse();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getClass() + ":" + e.getMessage(), "error", 0);
            return null;
        }
        Hashtable<String, MascoptSet> ht = new Hashtable<String, MascoptSet>();
        Iterator<MascoptObject> mascoptObjectIt = reader.getAllObjects();
        while (mascoptObjectIt.hasNext()) {
            MascoptObject current = mascoptObjectIt.next();
            if (!(current instanceof MascoptSet)) continue;
            String name = current.getName();
            ht.put(name, (MascoptSet)current);
        }
        if (ht.size() == 0) {
            return null;
        }
        Object[] names = new String[ht.size()];
        ht.keySet().toArray(names);
        String setNameSelected = ht.size() == 1 ? names[0] : (String)JOptionPane.showInputDialog(null, message, "MascoptChooser", 2, null, names, names[0]);
        if (setNameSelected == null) {
            return null;
        }
        return (MascoptSet)ht.get(setNameSelected);
    }

    public static String getFileName(String initialDirectory, String[] filter, String ident, String actionText) {
        File theFile;
        MascoptChooser.checkTheme();
        File directoryFile = initialDirectory != null ? new File(initialDirectory) : null;
        JFileChooser chooser = new JFileChooser(directoryFile);
        chooser.setApproveButtonText(actionText);
        Filter myFilter = new Filter(filter, ident);
        chooser.addChoosableFileFilter(myFilter);
        chooser.setFileFilter(myFilter);
        int retval = chooser.showOpenDialog(null);
        if (retval == 0 && (theFile = chooser.getSelectedFile()) != null) {
            return theFile.getAbsolutePath();
        }
        return null;
    }

    private static void checkTheme() {
        ThemeManager tm = new ThemeManager();
        tm.setTheme();
    }
}

