/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.god;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractCycle;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.flows.MascoptFlow;
import mascoptLib.io.interfaces.Reader;
import mascoptLib.numeric.MascoptDouble;

public class GodReader
implements Reader {
    private Vector<MascoptVertex> vertex;
    private Vector<MascoptAbstractLink> edges;
    private Vector<MascoptVertexSet> vertexSets;
    private Vector<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> edgeSets;
    private Vector<MascoptAbstractPath<? extends MascoptAbstractLink>> paths;
    private Vector<MascoptAbstractGraph<? extends MascoptAbstractLink>> graphs;
    private Vector<MascoptMap> maps;
    private int NO_LIGNE = 0;
    private BufferedReader reader;
    private BufferedReader reader2;
    private boolean mirrorArc;
    private boolean mirrorRequest;

    public GodReader(String fileGraph, boolean mirrorArc) {
        this(fileGraph, null, false, mirrorArc);
    }

    public GodReader(String fileIn, String fileIn2) {
        this(fileIn, fileIn2, false, false);
    }

    public GodReader(String fileIn, String fileIn2, boolean mirrorArc, boolean mirrorRequest) {
        this.mirrorArc = mirrorArc;
        this.mirrorRequest = mirrorRequest;
        this.vertex = new Vector();
        this.edges = new Vector();
        this.vertexSets = new Vector();
        this.edgeSets = new Vector();
        this.paths = new Vector();
        this.graphs = new Vector();
        this.maps = new Vector();
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileIn)));
            if (fileIn2 != null) {
                this.reader2 = new BufferedReader(new InputStreamReader(new FileInputStream(fileIn2)));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void parse() {
        int nodeTo;
        int nodeFrom;
        String flag;
        StringTokenizer st;
        String line;
        MascoptVertexSet vertexSet = new MascoptVertexSet();
        this.vertexSets.add(vertexSet);
        MascoptArcSet cables = new MascoptArcSet(vertexSet);
        this.edgeSets.add(cables);
        MascoptDiGraph cableG = new MascoptDiGraph(cables);
        cableG.setName("graph Cable");
        this.graphs.add(cableG);
        MascoptMap map = new MascoptMap();
        this.maps.add(map);
        while ((line = this.getLine(this.reader)) != null) {
            if (line.trim().length() == 0) continue;
            st = new StringTokenizer(line, " \t");
            flag = st.nextToken();
            if (flag.equals("n")) {
                int nbNodes = Integer.parseInt(st.nextToken());
                int i = 0;
                while (i < nbNodes) {
                    MascoptVertex n = new MascoptVertex(0.0, 0.0);
                    vertexSet.add(n);
                    this.vertex.add(n);
                    ++i;
                }
            }
            if (!flag.equals("e")) continue;
            nodeFrom = Integer.parseInt(st.nextToken());
            nodeTo = Integer.parseInt(st.nextToken());
            MascoptVertex from = this.vertex.elementAt(nodeFrom);
            MascoptVertex to = this.vertex.elementAt(nodeTo);
            MascoptArc a = new MascoptArc(from, to);
            cables.add(a);
            this.edges.add(a);
            if (!this.mirrorArc) continue;
            MascoptArc aReverse = new MascoptArc(to, from);
            cables.add(aReverse);
            this.edges.add(aReverse);
        }
        if (this.reader2 != null) {
            MascoptArcSet demands = new MascoptArcSet(vertexSet);
            this.edgeSets.add(demands);
            MascoptDiGraph requestG = new MascoptDiGraph(demands);
            requestG.setName("graph Request");
            this.graphs.add(requestG);
            while ((line = this.getLine(this.reader2)) != null) {
                if (line.trim().length() == 0 || !(flag = (st = new StringTokenizer(line, " \t")).nextToken()).equals("r")) continue;
                nodeFrom = Integer.parseInt(st.nextToken());
                nodeTo = Integer.parseInt(st.nextToken());
                int capa = Integer.parseInt(st.nextToken());
                MascoptVertex from = this.vertex.elementAt(nodeFrom);
                MascoptVertex to = this.vertex.elementAt(nodeTo);
                MascoptArc a = new MascoptArc(from, to);
                map.putValue(a, "request_size", new MascoptDouble(capa));
                demands.add(a);
                this.edges.add(a);
                if (!this.mirrorRequest) continue;
                MascoptArc aRev = new MascoptArc(to, from);
                map.putValue(aRev, "request_size", new MascoptDouble(capa));
                demands.add(aRev);
                this.edges.add(aRev);
            }
        }
    }

    private String getLine(BufferedReader br) {
        ++this.NO_LIGNE;
        String newL = "";
        while (newL.equals("")) {
            try {
                newL = br.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (newL == null) {
                return null;
            }
            if (!newL.startsWith("//") && !newL.trim().equals("")) continue;
            newL = "";
            ++this.NO_LIGNE;
        }
        return newL;
    }

    @Override
    public Iterator<MascoptVertex> getVertices() {
        return this.vertex.iterator();
    }

    public Iterator<MascoptAbstractLink> getEdges() {
        return this.edges.iterator();
    }

    @Override
    public Iterator<MascoptVertexSet> getVertexSets() {
        return this.vertexSets.iterator();
    }

    @Override
    public Iterator<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> getEdgeSets() {
        return this.edgeSets.iterator();
    }

    @Override
    public Iterator<MascoptAbstractPath<? extends MascoptAbstractLink>> getPaths() {
        return this.paths.iterator();
    }

    @Override
    public Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> getGraphs() {
        return this.graphs.iterator();
    }

    @Override
    public Iterator<MascoptMap> getMaps() {
        return this.maps.iterator();
    }

    @Override
    public Iterator<MascoptFlow> getFlows() {
        return new Vector().iterator();
    }

    @Override
    public Iterator<MascoptAbstractCycle<? extends MascoptAbstractLink>> getCycles() {
        return new Vector().iterator();
    }

    @Override
    public Iterator<MascoptObject> getAllObjects() {
        Vector<MascoptObject> ret = new Vector<MascoptObject>();
        ret.addAll(this.vertex);
        ret.addAll(this.edges);
        ret.addAll(this.vertexSets);
        ret.addAll(this.edgeSets);
        ret.addAll(this.paths);
        ret.addAll(this.graphs);
        ret.addAll(this.maps);
        return ret.iterator();
    }
}

