/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.mgl.dom;

import bridge.abstractClasses.AbstractScalar;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mascoptLib.core.MascoptAbstractCycle;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptCycle;
import mascoptLib.core.MascoptDiCycle;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptDiPath;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptEdgeSet;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptPath;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.flows.MascoptFlow;
import mascoptLib.exception.MascoptImpossibleOperationPathException;
import mascoptLib.io.interfaces.Reader;
import mascoptLib.io.reader.mgl.dom.MGLNodeFilter;
import mascoptLib.io.validation.mgl.MGLValidator;
import mascoptLib.numeric.MascoptAbstractScalar;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MGLDOMReader
implements Reader {
    private boolean validate = true;
    private String nameofstream;
    private InputStream streamtoparse;
    private MGLNodeFilter nodefilter;
    private Document doc;
    private Vector<MascoptVertex> vertexVector;
    private Vector<MascoptAbstractLink> abstractEdgeVector;
    private Vector<MascoptVertexSet> vertexSetVector;
    private Vector<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> abstractEdgeSetVector;
    private Vector<MascoptAbstractPath<? extends MascoptAbstractLink>> abstractPathVector;
    private Vector<MascoptAbstractCycle<? extends MascoptAbstractLink>> abstractCycleVector;
    private Vector<MascoptAbstractGraph<? extends MascoptAbstractLink>> abstractGraphVector;
    private Vector<MascoptMap> mapVector;
    private Vector<MascoptFlow> flowVector;
    private boolean alreadyParse = false;

    public MGLDOMReader(String streamname) throws FileNotFoundException, SecurityException {
        this(streamname, true, new MGLNodeFilter());
    }

    public MGLDOMReader(String streamname, boolean validate) throws FileNotFoundException, SecurityException {
        this(streamname, validate, new MGLNodeFilter());
    }

    public MGLDOMReader(String streamname, boolean validate, MGLNodeFilter customnodefilter) throws FileNotFoundException, SecurityException {
        this.nameofstream = streamname;
        StringTokenizer st = new StringTokenizer(streamname, ":");
        try {
            this.streamtoparse = st.nextToken().equals("file") ? new FileInputStream(streamname.substring(6)) : new FileInputStream(streamname);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        this.validate = validate;
        this.nodefilter = customnodefilter;
        this.doc = null;
    }

    @Override
    public void parse() {
        if (this.alreadyParse) {
            return;
        }
        this.alreadyParse = true;
        System.out.println("Reading " + this.nameofstream);
        Document doc = this.getDocument(this.streamtoparse);
        if (doc == null) {
            System.err.println("Error parsing file !");
            return;
        }
        this.vertexVector = new Vector();
        this.abstractEdgeVector = new Vector();
        this.vertexSetVector = new Vector();
        this.abstractEdgeSetVector = new Vector();
        this.abstractPathVector = new Vector();
        this.abstractCycleVector = new Vector();
        this.abstractGraphVector = new Vector();
        this.mapVector = new Vector();
        this.flowVector = new Vector();
        DocumentTraversal traversable = (DocumentTraversal)((Object)doc);
        NodeIterator iterator = traversable.createNodeIterator(doc, -1, this.nodefilter, true);
        this.createObjects(iterator);
        doc = null;
    }

    private Document getDocument(InputStream in) {
        InputSource source = new InputSource(in);
        if (this.validate && !MGLValidator.isValid(this.nameofstream)) {
            System.err.println("The file is not valid");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            System.out.println("Parsing MGL file..." + db);
            db.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
                    return null;
                }
            });
            this.doc = db.parse(source);
        }
        catch (DOMException e) {
            System.out.println("Error while creating parser: " + e);
            return null;
        }
        catch (ParserConfigurationException e) {
            System.out.println("Error while creating parser: " + e);
            return null;
        }
        catch (SAXException e) {
            System.out.println("Error while creating parser: " + e);
            return null;
        }
        catch (IOException e) {
            System.out.println("Error while creating parser: " + e);
            return null;
        }
        System.out.println("Parsing done.");
        return this.doc;
    }

    @Override
    public Iterator<MascoptAbstractPath<? extends MascoptAbstractLink>> getPaths() {
        return this.abstractPathVector.iterator();
    }

    @Override
    public Iterator<MascoptAbstractCycle<? extends MascoptAbstractLink>> getCycles() {
        return this.abstractCycleVector.iterator();
    }

    @Override
    public Iterator<? extends MascoptAbstractLink> getEdges() {
        return this.abstractEdgeVector.iterator();
    }

    @Override
    public Iterator<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> getEdgeSets() {
        return this.abstractEdgeSetVector.iterator();
    }

    @Override
    public Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> getGraphs() {
        return this.abstractGraphVector.iterator();
    }

    @Override
    public Iterator<MascoptVertex> getVertices() {
        return this.vertexVector.iterator();
    }

    @Override
    public Iterator<MascoptVertexSet> getVertexSets() {
        return this.vertexSetVector.iterator();
    }

    @Override
    public Iterator<MascoptMap> getMaps() {
        return this.mapVector.iterator();
    }

    @Override
    public Iterator<MascoptFlow> getFlows() {
        return this.flowVector.iterator();
    }

    @Override
    public Iterator<MascoptObject> getAllObjects() {
        Vector<MascoptObject> all = new Vector<MascoptObject>();
        all.addAll(this.vertexVector);
        all.addAll(this.abstractEdgeVector);
        all.addAll(this.vertexSetVector);
        all.addAll(this.abstractEdgeSetVector);
        all.addAll(this.abstractPathVector);
        all.addAll(this.abstractCycleVector);
        all.addAll(this.abstractGraphVector);
        all.addAll(this.mapVector);
        return all.iterator();
    }

    private void createObjects(NodeIterator nodeiterator) {
        Node currentNode = nodeiterator.getRoot();
        while (currentNode != null) {
            this.createObjectFromNode(currentNode);
            currentNode = nodeiterator.nextNode();
        }
    }

    private MascoptObject createObjectFromNode(Node currentNode) {
        if (currentNode.getNodeName().equalsIgnoreCase("VERTEX")) {
            return this.createAndAttachVertex(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("EDGE") || currentNode.getNodeName().equalsIgnoreCase("ARC")) {
            return this.createAndAttachEdge(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("VERTEX_SET")) {
            return this.createAndAttachVertexSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("EDGE_SET") || currentNode.getNodeName().equalsIgnoreCase("ARC_SET")) {
            return this.createAndAttachEdgeSet(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("PATH") || currentNode.getNodeName().equalsIgnoreCase("DIPATH")) {
            return this.createAndAttachPath(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("GRAPH") || currentNode.getNodeName().equalsIgnoreCase("DIGRAPH")) {
            return this.createAndAttachGraph(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("MAP")) {
            return this.createAndAttachMap(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("flow")) {
            return this.createAndAttachFlow(currentNode);
        }
        if (currentNode.getNodeName().equalsIgnoreCase("CYCLE") || currentNode.getNodeName().equalsIgnoreCase("DICYCLE")) {
            return this.createAndAttachCycle(currentNode);
        }
        return null;
    }

    private MascoptObject getObjectByRef(Node currentNode) {
        if (currentNode.getNodeName().equalsIgnoreCase("vertex_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachVertex(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("edge_ref") || currentNode.getNodeName().equalsIgnoreCase("arc_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachEdge(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("vertex_set_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachVertexSet(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("edge_set_ref") || currentNode.getNodeName().equalsIgnoreCase("arc_set_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachEdgeSet(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("graph_ref") || currentNode.getNodeName().equalsIgnoreCase("digraph_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachGraph(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("path_ref") || currentNode.getNodeName().equalsIgnoreCase("dipath_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachPath(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("cycle_ref") || currentNode.getNodeName().equalsIgnoreCase("dicycle_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachCycle(this.doc.getElementById(refname));
        }
        if (currentNode.getNodeName().equalsIgnoreCase("map_ref")) {
            String refname = this.getReferenceName(currentNode);
            return this.createAndAttachMap(this.doc.getElementById(refname));
        }
        return null;
    }

    private String getReferenceName(Node currentNode) {
        String refname = null;
        NamedNodeMap nnm = currentNode.getAttributes();
        NodeList reflist = nnm.getNamedItem("idref").getChildNodes();
        int i = 0;
        while (refname == null && i < reflist.getLength()) {
            if (reflist.item(i).getNodeName().equalsIgnoreCase("#text")) {
                refname = reflist.item(i).getNodeValue();
            }
            ++i;
        }
        return refname;
    }

    private Node getElementNodeInSubtree(String element, Node node) {
        if (node == null || element == null) {
            return null;
        }
        Node returnedNode = null;
        if (node.getNodeName().equalsIgnoreCase(element)) {
            returnedNode = node;
        } else {
            NodeList nl = node.getChildNodes();
            int i = 0;
            while (returnedNode == null && i < nl.getLength()) {
                returnedNode = this.getElementNodeInSubtree(element, nl.item(i));
                ++i;
            }
        }
        return returnedNode;
    }

    private MascoptVertex createAndAttachVertex(Node currentNode) {
        String color;
        Node colorNode;
        MascoptVertex vertex = (MascoptVertex)currentNode.getUserData("vertex");
        if (vertex != null) {
            return vertex;
        }
        vertex = new MascoptVertex();
        this.vertexVector.add(vertex);
        currentNode.setUserData("vertex", vertex, null);
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("position")) {
                this.setPosition(vertex, nl.item(i));
            }
            ++i;
        }
        this.searchAndSetName(vertex, currentNode);
        NamedNodeMap nnm = currentNode.getAttributes();
        if (nnm != null && (colorNode = this.getElementNodeInSubtree("#text", nnm.getNamedItem("color"))) != null && (color = colorNode.getNodeValue()) != null) {
            try {
                vertex.setColor(Integer.parseInt(color));
            }
            catch (NumberFormatException e) {
                System.out.println("e");
            }
        }
        return vertex;
    }

    private MascoptAbstractLink createAndAttachEdge(Node currentNode) {
        String color;
        Node colorNode;
        MascoptAbstractLink edge = (MascoptAbstractLink)currentNode.getUserData("edge");
        if (edge != null) {
            return edge;
        }
        Vector<MascoptVertex> myvertices = new Vector<MascoptVertex>();
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_ref")) {
                myvertices.add((MascoptVertex)this.getObjectByRef(nl.item(i)));
            }
            ++i;
        }
        if (currentNode.getNodeName().equalsIgnoreCase("edge")) {
            edge = new MascoptEdge((MascoptVertex)myvertices.elementAt(0), (MascoptVertex)myvertices.elementAt(1));
        } else if (currentNode.getNodeName().equalsIgnoreCase("arc")) {
            edge = new MascoptArc((MascoptVertex)myvertices.elementAt(0), (MascoptVertex)myvertices.elementAt(1));
        }
        this.abstractEdgeVector.add(edge);
        currentNode.setUserData("edge", edge, null);
        this.searchAndSetName(edge, currentNode);
        NamedNodeMap nnm = currentNode.getAttributes();
        if (nnm != null && (colorNode = this.getElementNodeInSubtree("#text", nnm.getNamedItem("color"))) != null && (color = colorNode.getNodeValue()) != null) {
            try {
                edge.setColor(Integer.parseInt(color));
            }
            catch (NumberFormatException e) {
                System.out.println(e);
            }
        }
        return edge;
    }

    private MascoptAbstractGraph<? extends MascoptAbstractLink> createAndAttachGraph(Node currentNode) {
        MascoptAbstractGraph graph = (MascoptAbstractGraph)currentNode.getUserData("graph");
        if (graph != null) {
            return graph;
        }
        MascoptAbstractLinkSet es = null;
        MascoptAbstractGraph g = null;
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("graph_ref")) {
                g = (MascoptAbstractGraph)this.getObjectByRef(nl.item(i));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("edge_set_ref")) {
                es = (MascoptEdgeSet)this.getObjectByRef(nl.item(i));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("arc_set_ref")) {
                es = (MascoptArcSet)this.getObjectByRef(nl.item(i));
            }
            ++i;
        }
        if (g != null) {
            if (currentNode.getNodeName().equalsIgnoreCase("graph")) {
                graph = new MascoptGraph((MascoptGraph)g);
            } else if (currentNode.getNodeName().equalsIgnoreCase("digraph")) {
                graph = new MascoptDiGraph((MascoptDiGraph)g);
            }
        } else if (es != null) {
            if (currentNode.getNodeName().equalsIgnoreCase("graph")) {
                graph = new MascoptGraph((MascoptEdgeSet)es);
            } else if (currentNode.getNodeName().equalsIgnoreCase("digraph")) {
                graph = new MascoptDiGraph((MascoptArcSet)es);
            }
        } else assert (false) : "The edge set is missing for the graph.";
        currentNode.setUserData("graph", graph, null);
        this.abstractGraphVector.add(graph);
        this.searchAndSetName(graph, currentNode);
        return graph;
    }

    private MascoptAbstractPath<? extends MascoptAbstractLink> createAndAttachPath(Node currentNode) {
        MascoptAbstractPath path = (MascoptAbstractPath)currentNode.getUserData("path");
        if (path != null) {
            return path;
        }
        if (currentNode.getNodeName().equalsIgnoreCase("path")) {
            path = new MascoptPath();
        } else if (currentNode.getNodeName().equalsIgnoreCase("dipath")) {
            path = new MascoptDiPath();
        }
        this.abstractPathVector.add(path);
        currentNode.setUserData("path", path, null);
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("edge_ref")) {
                ((MascoptPath)path).concat((MascoptEdge)this.getObjectByRef(nl.item(i)));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("arc_ref")) {
                ((MascoptDiPath)path).concat((MascoptArc)this.getObjectByRef(nl.item(i)));
            }
            ++i;
        }
        this.searchAndSetName(path, currentNode);
        return path;
    }

    private MascoptAbstractCycle<? extends MascoptAbstractLink> createAndAttachCycle(Node currentNode) {
        MascoptAbstractPath tmpPath = null;
        MascoptAbstractCycle cycle = (MascoptAbstractCycle)currentNode.getUserData("cycle");
        if (cycle != null) {
            return cycle;
        }
        if (currentNode.getNodeName().equalsIgnoreCase("cycle")) {
            tmpPath = new MascoptPath();
        } else if (currentNode.getNodeName().equalsIgnoreCase("dicycle")) {
            tmpPath = new MascoptDiPath();
        }
        currentNode.setUserData("cycle", cycle, null);
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            block11: {
                if (nl.item(i).getNodeName().equalsIgnoreCase("edge_ref") || nl.item(i).getNodeName().equalsIgnoreCase("arc_ref")) {
                    MascoptAbstractLink currentEdge = (MascoptAbstractLink)this.getObjectByRef(nl.item(i));
                    try {
                        if (tmpPath instanceof MascoptPath) {
                            ((MascoptPath)tmpPath).concat((MascoptEdge)currentEdge);
                        } else {
                            ((MascoptDiPath)tmpPath).concat((MascoptArc)currentEdge);
                        }
                    }
                    catch (MascoptImpossibleOperationPathException e) {
                        if (currentNode.getNodeName().equalsIgnoreCase("cycle")) {
                            cycle = new MascoptCycle((MascoptPath)tmpPath, (MascoptEdge)currentEdge);
                        }
                        if (!currentNode.getNodeName().equalsIgnoreCase("dicycle")) break block11;
                        cycle = new MascoptDiCycle((MascoptDiPath)tmpPath, (MascoptArc)currentEdge);
                    }
                }
            }
            ++i;
        }
        this.abstractCycleVector.add(cycle);
        this.searchAndSetName(cycle, currentNode);
        return cycle;
    }

    private void setName(MascoptObject object, Node name) {
        Node text_node = this.getElementNodeInSubtree("#text", name);
        if (text_node != null) {
            object.setName(text_node.getNodeValue().trim());
        }
    }

    private void setPosition(MascoptObject object, Node position) {
        NodeList nl = position.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("x")) {
                ((MascoptVertex)object).setX(Double.parseDouble(this.getElementNodeInSubtree("#text", nl.item(i)).getNodeValue()));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("y")) {
                ((MascoptVertex)object).setY(Double.parseDouble(this.getElementNodeInSubtree("#text", nl.item(i)).getNodeValue()));
            }
            ++i;
        }
    }

    private MascoptVertexSet createAndAttachVertexSet(Node currentNode) {
        MascoptVertexSet vertexset = (MascoptVertexSet)currentNode.getUserData("vertexset");
        if (vertexset != null) {
            return vertexset;
        }
        MascoptVertexSet super_vs = null;
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_set_ref")) {
                super_vs = (MascoptVertexSet)this.getObjectByRef(nl.item(i));
            }
            ++i;
        }
        vertexset = super_vs == null ? new MascoptVertexSet() : new MascoptVertexSet(super_vs);
        this.vertexSetVector.add(vertexset);
        currentNode.setUserData("vertexset", vertexset, null);
        nl = currentNode.getChildNodes();
        i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_ref")) {
                vertexset.add((MascoptVertex)this.getObjectByRef(nl.item(i)));
            }
            ++i;
        }
        this.searchAndSetName(vertexset, currentNode);
        return vertexset;
    }

    private MascoptAbstractLinkSet<?> createAndAttachEdgeSet(Node currentNode) {
        MascoptAbstractLinkSet edgeset = (MascoptAbstractLinkSet)currentNode.getUserData("edgeset");
        if (edgeset != null) {
            return edgeset;
        }
        MascoptVertexSet vs_based = null;
        MascoptAbstractLinkSet super_es = null;
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_set_ref")) {
                vs_based = (MascoptVertexSet)this.getObjectByRef(nl.item(i));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("edge_set_ref")) {
                super_es = (MascoptAbstractLinkSet)this.getObjectByRef(nl.item(i));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("arc_set_ref")) {
                super_es = (MascoptArcSet)this.getObjectByRef(nl.item(i));
            }
            ++i;
        }
        if (super_es == null && vs_based != null) {
            if (currentNode.getNodeName().equalsIgnoreCase("edge_set")) {
                edgeset = new MascoptEdgeSet(vs_based);
            } else if (currentNode.getNodeName().equalsIgnoreCase("arc_set")) {
                edgeset = new MascoptArcSet(vs_based);
            }
        } else if (super_es != null && vs_based != null) {
            if (currentNode.getNodeName().equalsIgnoreCase("edge_set")) {
                edgeset = new MascoptEdgeSet((MascoptEdgeSet)super_es);
            } else if (currentNode.getNodeName().equalsIgnoreCase("arc_set")) {
                edgeset = new MascoptArcSet((MascoptArcSet)super_es);
            }
        }
        this.abstractEdgeSetVector.add(edgeset);
        currentNode.setUserData("edgeset", edgeset, null);
        i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(edgeset, nl.item(i));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("edge_ref")) {
                ((MascoptEdgeSet)edgeset).add((MascoptEdge)this.getObjectByRef(nl.item(i)));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("arc_ref")) {
                ((MascoptArcSet)edgeset).add((MascoptArc)this.getObjectByRef(nl.item(i)));
            }
            ++i;
        }
        return edgeset;
    }

    public void setValidating(boolean validation) {
        this.validate = validation;
    }

    private void searchAndSetName(MascoptObject o, Node currentNode) {
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("name")) {
                this.setName(o, nl.item(i));
            }
            ++i;
        }
    }

    private MascoptMap createAndAttachMap(Node currentNode) {
        MascoptMap m = (MascoptMap)currentNode.getUserData("map");
        if (m != null) {
            return m;
        }
        m = new MascoptMap();
        this.mapVector.add(m);
        currentNode.setUserData("map", m, null);
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("entry")) {
                Node entry = nl.item(i);
                this.writeEntryInMap(m, entry);
            }
            ++i;
        }
        this.searchAndSetName(m, currentNode);
        return m;
    }

    private MascoptFlow createAndAttachFlow(Node currentNode) {
        MascoptFlow flow = (MascoptFlow)currentNode.getUserData("flow");
        if (flow != null) {
            return flow;
        }
        NodeList nl = currentNode.getChildNodes();
        int i = 0;
        i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("digraph_ref")) {
                flow = new MascoptFlow((MascoptDiGraph)this.getObjectByRef(nl.item(i)));
                break;
            }
            ++i;
        }
        MascoptVertex source = null;
        MascoptVertex destination = null;
        MascoptAbstractScalar value = null;
        i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_ref")) {
                source = (MascoptVertex)this.getObjectByRef(nl.item(i));
                break;
            }
            ++i;
        }
        i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("vertex_ref")) {
                destination = (MascoptVertex)this.getObjectByRef(nl.item(i));
            } else if (nl.item(i).getNodeName().equalsIgnoreCase("scalar")) {
                value = this.getScalar(nl.item(i));
            }
            ++i;
        }
        flow.setFlow(source, destination, (AbstractScalar)value);
        i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase("map_ref")) {
                MascoptMap m = (MascoptMap)this.getObjectByRef(nl.item(i));
                Iterator<? extends MascoptObject> it = m.keysIterator();
                while (it.hasNext()) {
                    MascoptArc current = (MascoptArc)it.next();
                    flow.setFlow(current, m.getValue(current, "FlowValue"));
                }
            }
            ++i;
        }
        currentNode.setUserData("flow", flow, null);
        this.flowVector.add(flow);
        this.searchAndSetName(flow, currentNode);
        return flow;
    }

    private void writeEntryInMap(MascoptMap m, Node entry) {
        NamedNodeMap nnm = entry.getAttributes();
        String type = this.getElementNodeInSubtree("#text", nnm.getNamedItem("type")).getNodeValue();
        String name = this.getElementNodeInSubtree("#text", nnm.getNamedItem("name")).getNodeValue();
        String value = this.getElementNodeInSubtree("#text", nnm.getNamedItem("value")).getNodeValue();
        MascoptObject o = null;
        MascoptObject context = null;
        NodeList nl = entry.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("#text")) {
                if (o == null) {
                    o = this.getObjectByRef(nl.item(i));
                } else if (context == null) {
                    context = this.getObjectByRef(nl.item(i));
                } else {
                    throw new RuntimeException("Error in the file: too many pointers for an entry. Only one object and one context are necessary.");
                }
            }
            ++i;
        }
        if (type.equalsIgnoreCase("string")) {
            m.putString(o, name, context, value);
        } else if (type.equalsIgnoreCase("MascoptDouble") || type.equalsIgnoreCase("double")) {
            m.putValue(o, name, context, this.constructScalar(type, value));
        } else if (type.equalsIgnoreCase("MascoptInteger") || type.equalsIgnoreCase("integer")) {
            m.putValue(o, name, context, this.constructScalar(type, value));
        } else if (type.equalsIgnoreCase("MascoptMPDecimal")) {
            m.putValue(o, name, context, this.constructScalar(type, value));
        } else if (type.equalsIgnoreCase("MascoptMPInteger")) {
            m.putValue(o, name, context, this.constructScalar(type, value));
        } else {
            throw new RuntimeException("The type of value is unknow.");
        }
    }

    private MascoptAbstractScalar getScalar(Node scalarNode) {
        NamedNodeMap nnm = scalarNode.getAttributes();
        String type = this.getElementNodeInSubtree("#text", nnm.getNamedItem("type")).getNodeValue();
        String value = null;
        NodeList nl = scalarNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (!nl.item(i).getNodeName().equalsIgnoreCase("#text")) {
                throw new RuntimeException("Scalar is misformated");
            }
            value = nl.item(i).getNodeValue().trim();
            ++i;
        }
        if (value == null) {
            throw new RuntimeException("Can't find value of an AbstractScalar");
        }
        return this.constructScalar(type, value);
    }

    private MascoptAbstractScalar constructScalar(String type, String value) {
        try {
            Class<?> classValue = Class.forName("mascoptLib.numeric." + type);
            Class[] classArgs = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> classConstructor = classValue.getConstructor(classArgs);
            Object[] args = new String[]{value};
            return (MascoptAbstractScalar)classConstructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
        catch (SecurityException e) {
            System.err.println(e);
        }
        catch (NoSuchMethodException e) {
            System.err.println(e);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
        }
        catch (InstantiationException e) {
            System.err.println(e);
        }
        catch (IllegalAccessException e) {
            System.err.println(e);
        }
        catch (InvocationTargetException e) {
            System.err.println(e);
        }
        throw new RuntimeException("Error during " + type + " creation");
    }
}

