/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.mgl.sax;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractCycle;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.flows.MascoptFlow;
import mascoptLib.io.reader.mgl.sax.ArcSetDescription;
import mascoptLib.io.reader.mgl.sax.CycleDescription;
import mascoptLib.io.reader.mgl.sax.EdgeSetDescription;
import mascoptLib.io.reader.mgl.sax.GraphDescription;
import mascoptLib.io.reader.mgl.sax.LinkDescription;
import mascoptLib.io.reader.mgl.sax.MapDescription;
import mascoptLib.io.reader.mgl.sax.MascoptObjectDescription;
import mascoptLib.io.reader.mgl.sax.Messages;
import mascoptLib.io.reader.mgl.sax.PathDescription;
import mascoptLib.io.reader.mgl.sax.SetDescription;
import mascoptLib.io.reader.mgl.sax.VertexDescription;
import mascoptLib.io.reader.mgl.sax.VertexSetDescription;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InternalSaxReader
extends DefaultHandler {
    static HashMap<String, MascoptObject> idrefToObject_ = null;
    static HashMap<String, MascoptObjectDescription> idrefToDescription_ = null;
    private Vector<MascoptObject> allObjectVector_ = new Vector();
    private Vector<MascoptVertex> vertexVector_ = new Vector();
    private Vector<MascoptAbstractLink> abstractEdgeVector_ = new Vector();
    private Vector<MascoptVertexSet> vertexSetVector_ = new Vector();
    private Vector<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> abstractEdgeSetVector_ = new Vector();
    private Vector<MascoptAbstractPath<? extends MascoptAbstractLink>> abstractPathVector_ = new Vector();
    private Vector<MascoptAbstractCycle<? extends MascoptAbstractLink>> abstractCycleVector_ = new Vector();
    private Vector<MascoptAbstractGraph<? extends MascoptAbstractLink>> abstractGraphVector_ = new Vector();
    private Vector<MascoptMap> mapVector_ = new Vector();
    private Vector<MascoptFlow> flowVector_ = new Vector();
    private Stack<MascoptObjectDescription> stack_ = new Stack();
    private Vector<MascoptObjectDescription> closed_ = new Vector();
    private String buffer_;
    private double x;
    private double y;
    private String lastKey;
    private String valueName;
    private String lastContext;
    private String valueType;
    private String value;
    private String sourceId = null;

    public InternalSaxReader() {
        idrefToObject_ = new HashMap();
        idrefToDescription_ = new HashMap();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        String tmp = new String(ch, start, length);
        if (this.buffer_ == null) {
            this.buffer_ = new String();
        }
        this.buffer_ = this.buffer_.concat(tmp);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (localName.compareToIgnoreCase("GRAPH") == 0 || localName.compareToIgnoreCase("DIGRAPH") == 0 || localName.compareToIgnoreCase("PATH") == 0 || localName.compareToIgnoreCase("DIPATH") == 0 || localName.compareToIgnoreCase("CYCLE") == 0 || localName.compareToIgnoreCase("DICYCLE") == 0 || localName.compareToIgnoreCase("MAP") == 0 || localName.compareToIgnoreCase("FIXED_SET") == 0 || localName.compareToIgnoreCase("SET") == 0 || localName.compareToIgnoreCase("EDGE_SET") == 0 || localName.compareToIgnoreCase("ARC_SET") == 0 || localName.compareToIgnoreCase("VERTEX_SET") == 0 || localName.compareToIgnoreCase("ARC") == 0 || localName.compareToIgnoreCase("EDGE") == 0 || localName.compareToIgnoreCase("VERTEX") == 0) {
            MascoptObjectDescription o = this.stack_.pop();
            this.closed_.add(o);
        } else if (localName.compareToIgnoreCase("NAME") == 0) {
            this.stack_.peek().setName(this.buffer_.trim());
            this.buffer_ = null;
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof VertexDescription && (localName.compareToIgnoreCase("x") == 0 || localName.compareToIgnoreCase("y") == 0)) {
            if (localName.compareToIgnoreCase("x") == 0) {
                this.x = Double.parseDouble(this.buffer_);
                this.buffer_ = null;
            } else {
                this.y = Double.parseDouble(this.buffer_);
                this.buffer_ = null;
            }
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof VertexDescription && localName.compareToIgnoreCase("POSITION") == 0) {
            ((VertexDescription)this.stack_.peek()).setX(this.x);
            ((VertexDescription)this.stack_.peek()).setY(this.y);
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof MapDescription && localName.compareToIgnoreCase("ENTRY") == 0) {
            ((MapDescription)this.stack_.peek()).addEntry(this.lastKey, this.valueName, this.lastContext, this.valueType, this.value);
            this.lastContext = null;
            this.lastKey = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String id = null;
        int color = -1;
        int index = 0;
        while (index < attributes.getLength()) {
            if (attributes.getLocalName(index).compareToIgnoreCase("id") == 0) {
                id = attributes.getValue(index);
            } else if (attributes.getLocalName(index).compareToIgnoreCase("Color") == 0) {
                color = Integer.parseInt(attributes.getValue(index));
            }
            ++index;
        }
        MascoptObjectDescription newDescription = null;
        if (localName.compareToIgnoreCase("GRAPH") == 0 || localName.compareToIgnoreCase("DIGRAPH") == 0) {
            newDescription = new GraphDescription(id, localName.compareToIgnoreCase("DIGRAPH") == 0);
        } else if (localName.compareToIgnoreCase("PATH") == 0 || localName.compareToIgnoreCase("DIPATH") == 0) {
            newDescription = new PathDescription(id, localName.compareToIgnoreCase("DIPATH") == 0);
        } else if (localName.compareToIgnoreCase("CYCLE") == 0 || localName.compareToIgnoreCase("DICYCLE") == 0) {
            newDescription = new CycleDescription(id, localName.compareToIgnoreCase("DICYCLE") == 0);
        } else if (localName.compareToIgnoreCase("FIXED_SET") == 0 || localName.compareToIgnoreCase("SET") == 0) {
            newDescription = new SetDescription(id);
        } else if (localName.compareToIgnoreCase("EDGE_SET") == 0) {
            newDescription = new EdgeSetDescription(id);
        } else if (localName.compareToIgnoreCase("ARC_SET") == 0) {
            newDescription = new ArcSetDescription(id);
        } else if (localName.compareToIgnoreCase("ARC") == 0 || localName.compareToIgnoreCase("EDGE") == 0) {
            newDescription = new LinkDescription(id, localName.compareToIgnoreCase("ARC") == 0);
            ((LinkDescription)newDescription).setColor(color);
        } else if (localName.compareToIgnoreCase("VERTEX_SET") == 0) {
            newDescription = new VertexSetDescription(id);
        } else if (localName.compareToIgnoreCase("VERTEX") == 0) {
            newDescription = new VertexDescription(id);
            ((VertexDescription)newDescription).setColor(color);
        } else if (localName.compareToIgnoreCase("MAP") == 0) {
            newDescription = new MapDescription(id);
        } else if (localName.compareToIgnoreCase("NAME") == 0) {
            this.buffer_ = null;
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof GraphDescription && (localName.compareToIgnoreCase("ARC_SET_REF") == 0 || localName.compareToIgnoreCase("EDGE_SET_REF") == 0)) {
            String idref = null;
            int index2 = 0;
            while (index2 < attributes.getLength()) {
                if (attributes.getLocalName(index2).compareToIgnoreCase("idref") == 0) {
                    idref = attributes.getValue(index2);
                }
                ++index2;
            }
            ((GraphDescription)this.stack_.peek()).setLinkSetId(idref);
        } else if (this.stack_.size() != 0 && (this.stack_.peek() instanceof ArcSetDescription || this.stack_.peek() instanceof EdgeSetDescription) && localName.compareToIgnoreCase("VERTEX_SET_REF") == 0) {
            String idref = null;
            int index3 = 0;
            while (index3 < attributes.getLength()) {
                if (attributes.getLocalName(index3).compareToIgnoreCase("idref") == 0) {
                    idref = attributes.getValue(index3);
                }
                ++index3;
            }
            if (this.stack_.peek() instanceof ArcSetDescription) {
                ((ArcSetDescription)this.stack_.peek()).setVertexSetId(idref);
            } else {
                ((EdgeSetDescription)this.stack_.peek()).setVertexSetId(idref);
            }
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof LinkDescription && localName.compareToIgnoreCase("VERTEX_REF") == 0) {
            String idref = null;
            int index4 = 0;
            while (index4 < attributes.getLength()) {
                if (attributes.getLocalName(index4).compareToIgnoreCase("idref") == 0) {
                    idref = attributes.getValue(index4);
                }
                ++index4;
            }
            if (this.sourceId != null) {
                ((LinkDescription)this.stack_.peek()).setIdOfVertices(this.sourceId, idref);
                this.sourceId = null;
            } else {
                this.sourceId = idref;
            }
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof SetDescription && localName.endsWith("_REF")) {
            String idref = null;
            int index5 = 0;
            while (index5 < attributes.getLength()) {
                if (attributes.getLocalName(index5).compareToIgnoreCase("idref") == 0) {
                    idref = attributes.getValue(index5);
                    break;
                }
                ++index5;
            }
            if (localName.equals("VERTEX_SET_REF")) {
                ((SetDescription)this.stack_.peek()).setSuperSetId(idref);
            } else {
                ((SetDescription)this.stack_.peek()).addElement(idref);
            }
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof VertexDescription && (localName.compareToIgnoreCase("x") == 0 || localName.compareToIgnoreCase("y") == 0)) {
            this.buffer_ = null;
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof MapDescription && localName.compareToIgnoreCase("ENTRY") == 0) {
            int index6 = 0;
            while (index6 < attributes.getLength()) {
                if (attributes.getLocalName(index6).compareToIgnoreCase("name") == 0) {
                    this.valueName = attributes.getValue(index6);
                } else if (attributes.getLocalName(index6).compareToIgnoreCase("type") == 0) {
                    this.valueType = attributes.getValue(index6);
                } else if (attributes.getLocalName(index6).compareToIgnoreCase("value") == 0) {
                    this.value = attributes.getValue(index6);
                }
                ++index6;
            }
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof MapDescription && localName.endsWith("_REF")) {
            String idref = null;
            int index7 = 0;
            while (index7 < attributes.getLength()) {
                if (attributes.getLocalName(index7).compareToIgnoreCase("idref") == 0) {
                    idref = attributes.getValue(index7);
                    break;
                }
                ++index7;
            }
            if (this.lastKey != null) {
                this.lastContext = idref;
            } else {
                this.lastKey = idref;
            }
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof PathDescription && (localName.compareToIgnoreCase("ARC_REF") == 0 || localName.compareToIgnoreCase("EDGE_REF") == 0)) {
            String idref = null;
            int index8 = 0;
            while (index8 < attributes.getLength()) {
                if (attributes.getLocalName(index8).compareToIgnoreCase("idref") == 0) {
                    idref = attributes.getValue(index8);
                    break;
                }
                ++index8;
            }
            ((PathDescription)this.stack_.peek()).addEdge(idref);
        } else if (this.stack_.size() != 0 && this.stack_.peek() instanceof CycleDescription && (localName.compareToIgnoreCase("ARC_REF") == 0 || localName.compareToIgnoreCase("EDGE_REF") == 0)) {
            String idref = null;
            int index9 = 0;
            while (index9 < attributes.getLength()) {
                if (attributes.getLocalName(index9).compareToIgnoreCase("idref") == 0) {
                    idref = attributes.getValue(index9);
                    break;
                }
                ++index9;
            }
            ((CycleDescription)this.stack_.peek()).addEdge(idref);
        }
        if (newDescription != null) {
            this.stack_.push(newDescription);
        }
    }

    void createObject() {
        Iterator<MascoptObjectDescription> it = this.closed_.iterator();
        while (it.hasNext()) {
            MascoptObject o = it.next().createObject();
            this.allObjectVector_.add(o);
            if (o instanceof MascoptAbstractCycle) {
                this.abstractCycleVector_.add((MascoptAbstractCycle)o);
                continue;
            }
            if (o instanceof MascoptAbstractLinkSet) {
                this.abstractEdgeSetVector_.add((MascoptAbstractLinkSet)o);
                continue;
            }
            if (o instanceof MascoptAbstractLink) {
                this.abstractEdgeVector_.add((MascoptAbstractLink)o);
                continue;
            }
            if (o instanceof MascoptAbstractGraph) {
                this.abstractGraphVector_.add((MascoptAbstractGraph)o);
                continue;
            }
            if (o instanceof MascoptAbstractPath) {
                this.abstractPathVector_.add((MascoptAbstractPath)o);
                continue;
            }
            if (o instanceof MascoptFlow) {
                this.flowVector_.add((MascoptFlow)o);
                continue;
            }
            if (o instanceof MascoptMap) {
                this.mapVector_.add((MascoptMap)o);
                continue;
            }
            if (o instanceof MascoptVertexSet) {
                this.vertexSetVector_.add((MascoptVertexSet)o);
                continue;
            }
            if (o instanceof MascoptVertex) {
                this.vertexVector_.add((MascoptVertex)o);
                continue;
            }
            if (o instanceof MascoptSet) continue;
            throw new RuntimeException(Messages.getString("InternalSaxReader.unknowType"));
        }
    }

    public Iterator<MascoptAbstractPath<? extends MascoptAbstractLink>> getPaths() {
        return this.abstractPathVector_.iterator();
    }

    public Iterator<MascoptAbstractCycle<? extends MascoptAbstractLink>> getCycles() {
        return this.abstractCycleVector_.iterator();
    }

    public Iterator<? extends MascoptAbstractLink> getLinks() {
        return this.abstractEdgeVector_.iterator();
    }

    public Iterator<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> getEdgeSets() {
        return this.abstractEdgeSetVector_.iterator();
    }

    public Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> getGraphs() {
        return this.abstractGraphVector_.iterator();
    }

    public Iterator<MascoptVertex> getVertices() {
        return this.vertexVector_.iterator();
    }

    public Iterator<MascoptVertexSet> getVertexSets() {
        return this.vertexSetVector_.iterator();
    }

    public Iterator<MascoptMap> getMaps() {
        return this.mapVector_.iterator();
    }

    public Iterator<MascoptFlow> getFlows() {
        return this.flowVector_.iterator();
    }

    public Iterator<MascoptObject> getAllObjects() {
        return this.allObjectVector_.iterator();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (systemId.startsWith("ftp://ftp-sop.inria.fr/mascotte/mascopt/dtd/")) {
            InputSource dtdSource = null;
            StringTokenizer sT = new StringTokenizer(systemId, "/");
            String filename = null;
            while (sT.hasMoreTokens()) {
                filename = sT.nextToken();
            }
            URL local = this.getClass().getResource("/dtd/" + filename);
            if (local != null) {
                dtdSource = new InputSource(local.toString());
            }
            if (dtdSource != null) {
                System.out.println(String.valueOf(Messages.getString("InternalSaxReader.localRessource")) + dtdSource.getSystemId());
            } else {
                System.out.println(String.valueOf(Messages.getString("InternalSaxReader.remoteRessource")) + systemId);
                try {
                    URL u = new URL(systemId);
                    InputStream raw = u.openStream();
                    dtdSource = new InputSource(raw);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return dtdSource;
        }
        return super.resolveEntity(publicId, systemId);
    }
}

