/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.mgl.sax;

import java.io.IOException;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractCycle;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.flows.MascoptFlow;
import mascoptLib.io.interfaces.Reader;
import mascoptLib.io.reader.mgl.sax.InternalSaxReader;
import mascoptLib.io.reader.mgl.sax.Messages;
import mascoptLib.io.validation.mgl.MGLEntityResolver;
import mascoptLib.io.validation.mgl.MGLValidator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MGLSaxReader
implements Reader {
    private InternalSaxReader realReader_ = new InternalSaxReader();
    private XMLReader saxReader_;
    private String filename_;
    private boolean mustBeValidate_ = true;
    private boolean alreadyParse_ = false;

    public MGLSaxReader(String filename) {
        this.filename_ = filename;
    }

    public MGLSaxReader(String filename, boolean validate) {
        this.filename_ = filename;
        this.mustBeValidate_ = validate;
    }

    @Override
    public Iterator<MascoptObject> getAllObjects() {
        return this.realReader_.getAllObjects();
    }

    @Override
    public Iterator<MascoptAbstractCycle<? extends MascoptAbstractLink>> getCycles() {
        return this.realReader_.getCycles();
    }

    @Override
    public Iterator<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> getEdgeSets() {
        return this.realReader_.getEdgeSets();
    }

    @Override
    public Iterator<? extends MascoptAbstractLink> getEdges() {
        return this.realReader_.getLinks();
    }

    @Override
    public Iterator<MascoptFlow> getFlows() {
        return this.realReader_.getFlows();
    }

    @Override
    public Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> getGraphs() {
        return this.realReader_.getGraphs();
    }

    @Override
    public Iterator<MascoptMap> getMaps() {
        return this.realReader_.getMaps();
    }

    @Override
    public Iterator<MascoptAbstractPath<? extends MascoptAbstractLink>> getPaths() {
        return this.realReader_.getPaths();
    }

    @Override
    public Iterator<MascoptVertexSet> getVertexSets() {
        return this.realReader_.getVertexSets();
    }

    @Override
    public Iterator<MascoptVertex> getVertices() {
        return this.realReader_.getVertices();
    }

    @Override
    public void parse() {
        if (!this.alreadyParse_) {
            this.alreadyParse_ = true;
            try {
                if (this.mustBeValidate_) {
                    System.out.println(String.valueOf(Messages.getString("MGLSaxReader.validating")) + this.filename_);
                    if (!MGLValidator.isValid(this.filename_)) {
                        return;
                    }
                }
                System.out.println(String.valueOf(Messages.getString("MGLSaxReader.reading")) + this.filename_);
                this.saxReader_ = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                this.saxReader_.setFeature("http://xml.org/sax/features/validation", false);
                this.saxReader_.setContentHandler(this.realReader_);
                this.saxReader_.setEntityResolver(new MGLEntityResolver());
                this.saxReader_.parse(this.filename_);
                this.realReader_.createObject();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }
}

