/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.mgl.sax;

import java.util.Vector;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.io.reader.mgl.sax.MascoptObjectDescription;
import mascoptLib.io.reader.mgl.sax.Messages;
import mascoptLib.numeric.MascoptAbstractScalar;
import mascoptLib.numeric.MascoptDouble;
import mascoptLib.numeric.MascoptInteger;
import mascoptLib.numeric.MascoptMPDecimal;
import mascoptLib.numeric.MascoptMPInteger;

public class MapDescription
extends MascoptObjectDescription {
    private Vector<Entry> contents = new Vector();

    public MapDescription(String id) {
        super(id);
    }

    public void addEntry(String keyId, String name, String contextId, String type, String value) {
        this.contents.add(new Entry(keyId, name, contextId, type, value));
    }

    @Override
    public MascoptObject createObject() {
        if (MapDescription.getObjectFromId(this.getId()) != null) {
            return MapDescription.getObjectFromId(this.getId());
        }
        MascoptMap result = new MascoptMap();
        int i = 0;
        while (i < this.contents.size()) {
            this.contents.get(i).addToMap(result);
            ++i;
        }
        return this.finalizeCreation(result);
    }

    private class Entry {
        private String keyId;
        private String name;
        private String contextId;
        private String type;
        private String value;

        Entry(String keyId, String name, String contextId, String type, String value) {
            this.keyId = keyId;
            this.name = name;
            this.contextId = contextId;
            this.type = type;
            this.value = value;
        }

        void addToMap(MascoptMap m) {
            if (this.type.compareToIgnoreCase("String") == 0) {
                m.putString(MapDescription.getObjectFromId(this.keyId), this.name, MapDescription.getObjectFromId(this.contextId), this.value);
            } else {
                MascoptAbstractScalar number;
                if (this.type.compareToIgnoreCase("MascoptInteger") == 0) {
                    number = new MascoptInteger(this.value);
                } else if (this.type.compareToIgnoreCase("MascoptDouble") == 0) {
                    number = new MascoptDouble(this.value);
                } else if (this.type.compareToIgnoreCase("MascoptMPInteger") == 0) {
                    number = new MascoptMPInteger(this.value);
                } else if (this.type.compareToIgnoreCase("MascoptMPDecimal") == 0) {
                    number = new MascoptMPDecimal(this.value);
                } else {
                    throw new RuntimeException(String.valueOf(Messages.getString("MapDescription.unknowValueType")) + this.type);
                }
                m.putValue(MapDescription.getOrCreateObject(this.keyId), this.name, MapDescription.getOrCreateObject(this.contextId), number);
            }
        }
    }
}

