/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.mgl.sax;

import mascoptLib.core.MascoptObject;
import mascoptLib.io.reader.mgl.sax.InternalSaxReader;
import mascoptLib.io.reader.mgl.sax.Messages;

public abstract class MascoptObjectDescription {
    private String id_;
    private String name_ = null;

    public MascoptObjectDescription(String id) {
        this.id_ = id;
        MascoptObjectDescription.associatedIdAndDescription(id, this);
    }

    protected String getId() {
        return this.id_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    protected static MascoptObject getObjectFromId(String id) {
        return InternalSaxReader.idrefToObject_.get(id.intern());
    }

    private static MascoptObjectDescription getDescriptionFromId(String id) {
        return InternalSaxReader.idrefToDescription_.get(id.intern());
    }

    protected static MascoptObject getOrCreateObject(String id) {
        if (MascoptObjectDescription.getObjectFromId(id) != null) {
            return MascoptObjectDescription.getObjectFromId(id);
        }
        MascoptObjectDescription desc = MascoptObjectDescription.getDescriptionFromId(id);
        return desc.createObject();
    }

    private static void associatedIdAndDescription(String id, MascoptObjectDescription description) {
        if (MascoptObjectDescription.getDescriptionFromId(id) != null) {
            throw new RuntimeException(Messages.getString("MascoptObjectDescription.existingAssociation"));
        }
        InternalSaxReader.idrefToDescription_.put(id.intern(), description);
    }

    private static void associateIdAndObject(String id, MascoptObject object) {
        if (MascoptObjectDescription.getObjectFromId(id) != null) {
            throw new RuntimeException(Messages.getString("MascoptObjectDescription.existingAssociation"));
        }
        InternalSaxReader.idrefToObject_.put(id.intern(), object);
    }

    protected MascoptObject finalizeCreation(MascoptObject o) {
        if (this.getName() != null) {
            o.setName(this.getName());
        }
        MascoptObjectDescription.associateIdAndObject(this.getId(), o);
        return o;
    }

    public abstract MascoptObject createObject();
}

