/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.net;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractCycle;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptDiGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.flows.MascoptFlow;
import mascoptLib.io.interfaces.Reader;
import mascoptLib.numeric.MascoptDouble;

public class NetReader
implements Reader {
    private Vector<MascoptVertex> vertex;
    private Vector<MascoptAbstractLink> edges;
    private Vector<MascoptVertexSet> vertexSets;
    private Vector<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> edgeSets;
    private Vector<MascoptAbstractPath<? extends MascoptAbstractLink>> paths;
    private Vector<MascoptAbstractGraph<? extends MascoptAbstractLink>> graphs;
    private int NO_LIGNE = 0;
    private BufferedReader reader;
    private MascoptVertexSet nodeSet;
    private Vector<MascoptMap> maps;
    private MascoptMap map;
    private MascoptArcSet cables;
    private MascoptArcSet demands;
    private boolean mirrorArc;
    private boolean mirrorRequest;

    public NetReader(String fileIn) {
        this(fileIn, false, false);
    }

    public NetReader(String fileIn, boolean mirrorArc, boolean mirrorRequest) {
        this.mirrorArc = mirrorArc;
        this.mirrorRequest = mirrorRequest;
        this.vertex = new Vector();
        this.edges = new Vector();
        this.vertexSets = new Vector();
        this.edgeSets = new Vector();
        this.paths = new Vector();
        this.graphs = new Vector();
        this.maps = new Vector();
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileIn)));
        }
        catch (FileNotFoundException e) {
            System.out.println("Error opening file " + fileIn);
            return;
        }
        this.nodeSet = new MascoptVertexSet();
        this.vertexSets.add(this.nodeSet);
        this.cables = new MascoptArcSet(this.nodeSet);
        this.demands = new MascoptArcSet(this.nodeSet);
        this.edgeSets.add(this.cables);
        this.edgeSets.add(this.demands);
        MascoptDiGraph cableG = new MascoptDiGraph(this.cables);
        cableG.setName("graph Cable");
        this.graphs.add(cableG);
        MascoptDiGraph requestG = new MascoptDiGraph(this.demands);
        requestG.setName("graph Request");
        this.graphs.add(requestG);
        this.map = new MascoptMap();
        this.maps.add(this.map);
    }

    @Override
    public void parse() {
        String line;
        MascoptVertex from;
        String capa;
        StringTokenizer st = new StringTokenizer(this.getLine(), " \t");
        String read = st.nextToken();
        int nbLevel = Integer.parseInt(read);
        int i = 0;
        while (i < nbLevel) {
            this.getLine();
            ++i;
        }
        st = new StringTokenizer(this.getLine(), " \t");
        read = st.nextToken();
        int nbNodes = Integer.parseInt(read);
        int i2 = 0;
        while (i2 < nbNodes) {
            st = new StringTokenizer(this.getLine(), " \t");
            String cityName = st.nextToken();
            String cityX = st.nextToken();
            String cityY = st.nextToken();
            MascoptVertex n = new MascoptVertex(Integer.parseInt(cityX), Integer.parseInt(cityY));
            n.setName(cityName);
            this.map.putString(n, "NetID", Integer.toString(i2));
            this.nodeSet.add(n);
            this.vertex.add(n);
            ++i2;
        }
        st = new StringTokenizer(this.getLine(), " \t");
        read = st.nextToken();
        int nbCables = Integer.parseInt(read);
        int i3 = 0;
        while (i3 < nbCables) {
            st = new StringTokenizer(this.getLine(), " \t");
            int nodeFrom = Integer.parseInt(st.nextToken());
            int nodeTo = Integer.parseInt(st.nextToken());
            capa = st.nextToken();
            String longueur = st.nextToken();
            from = this.vertex.elementAt(nodeFrom);
            MascoptVertex to = this.vertex.elementAt(nodeTo);
            MascoptArc a = new MascoptArc(from, to);
            this.map.putValue(a, "Capacity", new MascoptDouble(capa));
            this.map.putValue(a, "Length", new MascoptDouble(longueur));
            this.cables.add(a);
            this.edges.add(a);
            if (this.mirrorArc) {
                MascoptArc aReverse = new MascoptArc(to, from);
                this.map.putValue(aReverse, "Capacity", new MascoptDouble(capa));
                this.map.putValue(aReverse, "Length", new MascoptDouble(longueur));
                this.cables.add(aReverse);
                this.edges.add(aReverse);
            }
            ++i3;
        }
        while ((line = this.getLine()) != null) {
            if (line.trim().length() == 0) continue;
            st = new StringTokenizer(line, " \t");
            int nodeFrom = Integer.parseInt(st.nextToken());
            int nodeTo = Integer.parseInt(st.nextToken());
            capa = st.nextToken();
            MascoptVertex to = this.vertex.elementAt(nodeTo);
            from = this.vertex.elementAt(nodeFrom);
            MascoptArc a = new MascoptArc(from, to);
            this.map.putValue(a, "reques Size", new MascoptDouble(capa));
            this.demands.add(a);
            this.edges.add(a);
            if (!this.mirrorRequest) continue;
            MascoptArc aRev = new MascoptArc(to, from);
            this.map.putValue(aRev, "reques Size", new MascoptDouble(capa));
            this.demands.add(aRev);
            this.edges.add(aRev);
        }
    }

    private String getLine() {
        ++this.NO_LIGNE;
        String newL = "";
        while (newL.equals("")) {
            try {
                newL = this.reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (newL == null) {
                return null;
            }
            if (!newL.startsWith("//") && !newL.trim().equals("")) continue;
            newL = "";
            ++this.NO_LIGNE;
        }
        return newL;
    }

    @Override
    public Iterator<MascoptVertex> getVertices() {
        return this.vertex.iterator();
    }

    public Iterator<MascoptAbstractLink> getEdges() {
        return this.edges.iterator();
    }

    @Override
    public Iterator<MascoptVertexSet> getVertexSets() {
        return this.vertexSets.iterator();
    }

    @Override
    public Iterator<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> getEdgeSets() {
        return this.edgeSets.iterator();
    }

    @Override
    public Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> getGraphs() {
        return this.graphs.iterator();
    }

    @Override
    public Iterator<MascoptObject> getAllObjects() {
        Vector<MascoptObject> ret = new Vector<MascoptObject>();
        ret.addAll(this.vertex);
        ret.addAll(this.edges);
        ret.addAll(this.vertexSets);
        ret.addAll(this.edgeSets);
        ret.addAll(this.paths);
        ret.addAll(this.graphs);
        ret.addAll(this.maps);
        return ret.iterator();
    }

    @Override
    public Iterator<MascoptMap> getMaps() {
        return this.maps.iterator();
    }

    @Override
    public Iterator<MascoptFlow> getFlows() {
        return new Vector().iterator();
    }

    @Override
    public Iterator<MascoptAbstractCycle<? extends MascoptAbstractLink>> getCycles() {
        return new Vector().iterator();
    }

    @Override
    public Iterator<MascoptAbstractPath<? extends MascoptAbstractLink>> getPaths() {
        return this.paths.iterator();
    }
}

