/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.snd.natives;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class SNDModelNativeReader {
    public static final String NODE_MODEL = "NODE_MODEL";
    public static final String DEMAND_MODEL = "DEMAND_MODEL";
    public static final String LINK_MODEL = "LINK_MODEL";
    public static final String LINK_CAPACITY_MODEL = "LINK_CAPACITY_MODEL";
    public static final String FIXED_CHARGE_MODEL = "FIXED_CHARGE_MODEL";
    public static final String ROUTING_MODEL = "ROUTING_MODEL";
    public static final String ADMISSIBLE_PATH_MODEL = "ADMISSIBLE_PATH_MODEL";
    public static final String HOP_LIMIT_MODEL = "HOP_LIMIT_MODEL";
    public static final String OBJECTIVE_MODEL = "OBJECTIVE_MODEL";
    private BufferedReader reader;
    private int demandModel;
    private int linkModel;
    private int linkCapacityModel;
    private boolean fixedChargeModel;
    private int routingModel;
    private boolean pathModel;
    private boolean pathHopLimit;
    private boolean nodeModel = false;
    private int objectiveType;
    private int numLine = 0;

    public SNDModelNativeReader(String fileName) throws Exception {
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
    }

    public void parse() throws IOException {
        String line = this.reader.readLine();
        if (line != null && !line.trim().equals("?SNDlib native format; type: model; version: 1.0".trim())) {
            throw new IOException("SND model native file exepted");
        }
        ++this.numLine;
        while ((line = this.reader.readLine()) != null) {
            if (line.trim().length() != 0 && !line.trim().startsWith("#")) continue;
            ++this.numLine;
        }
    }

    public int getDemandsModel() {
        return this.demandModel;
    }

    public int getLinksModel() {
        return this.linkModel;
    }

    public int getLinkCapacityModel() {
        return this.linkCapacityModel;
    }

    public boolean fixedChargeModel() {
        return this.fixedChargeModel;
    }

    public int getRoutingModel() {
        return this.routingModel;
    }

    public boolean useAllPath() {
        return this.pathModel;
    }

    public boolean hopLimit() {
        return this.pathHopLimit;
    }

    public boolean hardwareNode() {
        return this.nodeModel;
    }

    public int getObjectiveType() {
        return this.objectiveType;
    }
}

