/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.validation.mgl;

import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import mascoptLib.io.validation.mgl.MGLEntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public final class MGLValidator {
    public static boolean isValid(InputSource source) {
        ErrorRecorder recorder = MGLValidator.validateWithXerces(source, true);
        if (recorder != null && !recorder.hasErrors() && !recorder.hasWarnings()) {
            return true;
        }
        System.out.println("Try to fix the Schema used for validation...");
        recorder = MGLValidator.validateWithXerces(source, false);
        return recorder != null && !recorder.hasErrors() && !recorder.hasWarnings();
    }

    public static boolean isValid(String filename) {
        InputSource source = new InputSource(filename);
        return MGLValidator.isValid(source);
    }

    private static ErrorRecorder validateWithXerces(InputSource source, boolean useInternalXsd) {
        SAXParser parser = new SAXParser();
        try {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            if (!useInternalXsd) {
                parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "ftp://ftp-sop.inria.fr/mascotte/mascopt/dtd/mgl_v2.0.xsd");
            }
            parser.setEntityResolver(new MGLEntityResolver());
            ErrorRecorder recorder = new ErrorRecorder();
            parser.setErrorHandler(recorder);
            parser.parse(source);
            return recorder;
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static class ErrorRecorder
    implements ErrorHandler {
        Vector<SAXParseException> errors = new Vector();
        Vector<SAXParseException> warnings = new Vector();

        private ErrorRecorder() {
        }

        public boolean hasErrors() {
            return this.errors.size() > 0;
        }

        public boolean hasWarnings() {
            return this.warnings.size() > 0;
        }

        public SAXParseException[] getErrors() {
            return this.errors.toArray(new SAXParseException[0]);
        }

        public SAXParseException[] getWarnings() {
            return this.warnings.toArray(new SAXParseException[0]);
        }

        public String listErrors() {
            StringBuffer list = new StringBuffer();
            Enumeration<SAXParseException> e = this.errors.elements();
            while (e.hasMoreElements()) {
                list.append(String.valueOf(e.nextElement().getMessage()) + System.getProperty("line.separator"));
            }
            return list.toString();
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) {
            System.out.println("Error : " + exception.getMessage());
            this.errors.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            System.out.println("Warning : " + exception.getMessage());
            this.warnings.add(exception);
        }
    }
}

