/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.writer.java;

import bridge.interfaces.HierarchicalSet;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.io.MascoptChooser.MascoptChooser;
import mascoptLib.io.interfaces.Writer;
import mascoptLib.io.reader.mgl.dom.MGLDOMReader;
import tools.CommandLineParse;

public class ClassWriter
implements Writer {
    private static final String PACKAGE_PATH_REGULAR_EXPRESSION = "[^\\.]+\\.";
    private static final String IMPORTS_LINES = String.valueOf(System.getProperty("line.separator")) + "import mascoptLib.core.*;" + System.getProperty("line.separator");
    private String fileName_;
    private String className_;
    private String packageName_;
    private PrintStream fileWriter;
    private Vector<MascoptObject> toGenerate = new Vector();

    @Override
    public void add(MascoptObject mascoptObject) {
        if (this.toGenerate.contains(mascoptObject)) {
            return;
        }
        if (mascoptObject instanceof MascoptMap) {
            MascoptMap map = (MascoptMap)mascoptObject;
            Iterator<? extends MascoptObject> it_keys = map.keysIterator();
            while (it_keys.hasNext()) {
                MascoptObject o = it_keys.next();
                this.add(o);
                Iterator<? extends MascoptObject> contexts = map.contextsIterator(o);
                while (contexts.hasNext()) {
                    MascoptObject c = contexts.next();
                    this.add(c);
                }
            }
        } else if (mascoptObject instanceof MascoptAbstractGraph) {
            MascoptAbstractGraph graph = (MascoptAbstractGraph)mascoptObject;
            this.add(graph.vertexSet());
            this.add((MascoptObject)((Object)graph.edgeSet()));
        } else if (mascoptObject instanceof MascoptSet) {
            MascoptSet set = (MascoptSet)mascoptObject;
            if (set.getSuperSet() != null) {
                this.add((MascoptObject)((Object)set.getSuperSet()));
            }
            Iterator contentIt = set.iterator();
            while (contentIt.hasNext()) {
                this.add((MascoptObject)contentIt.next());
            }
        } else if (mascoptObject instanceof MascoptAbstractLink) {
            MascoptAbstractLink link = (MascoptAbstractLink)mascoptObject;
            MascoptVertex[] vertices = link.getVertices();
            this.add(vertices[0]);
            this.add(vertices[1]);
        } else if (!(mascoptObject instanceof MascoptVertex)) {
            throw new IllegalArgumentException("This type is not managed " + mascoptObject.getClass());
        }
        this.toGenerate.add(mascoptObject);
    }

    private void initializeWriting() {
        try {
            this.fileWriter = new PrintStream(new FileOutputStream(this.fileName_));
        }
        catch (FileNotFoundException fne) {
            fne.printStackTrace();
        }
        if (this.packageName_ != null) {
            this.fileWriter.println("package " + this.packageName_ + ";");
        }
        if (this.className_ != null) {
            this.fileWriter.println("");
            this.fileWriter.println(IMPORTS_LINES);
            this.fileWriter.println("public class " + this.className_ + " {");
            this.fileWriter.println("");
        }
    }

    private void writeNameIfNeed(MascoptObject mascoptObject) {
        if (mascoptObject.getId().compareTo(mascoptObject.getName()) != 0) {
            this.fileWriter.println(String.valueOf(mascoptObject.getId()) + ".setName(" + mascoptObject.getName() + ");");
        }
    }

    private String getTypeFromClass(MascoptObject mascoptObject) {
        return mascoptObject.getClass().getName().replaceAll(PACKAGE_PATH_REGULAR_EXPRESSION, "");
    }

    private void declareVertex(MascoptVertex vertex) {
        this.fileWriter.println("MascoptVertex " + vertex.getId() + ";");
    }

    private void writeVertex(MascoptVertex vertex) {
        this.fileWriter.println(String.valueOf(vertex.getId()) + " = new MascoptVertex(" + vertex.getX() + "," + vertex.getY() + ");");
    }

    private void declareLink(MascoptAbstractLink link) {
        String type = this.getTypeFromClass(link);
        this.fileWriter.println(String.valueOf(type) + " " + link.getId() + ";");
    }

    private void writeLink(MascoptAbstractLink link) {
        String type = this.getTypeFromClass(link);
        MascoptVertex[] vertices = link.getVertices();
        this.fileWriter.println(String.valueOf(link.getId()) + " = new " + type + "(" + vertices[0] + "," + vertices[1] + ");");
    }

    private void declareSet(MascoptSet<? extends MascoptObject> set) {
        String setType = this.getTypeFromClass(set);
        this.fileWriter.println(String.valueOf(setType) + " " + set.getId() + ";");
    }

    private void writeSet(MascoptSet<? extends MascoptObject> set) {
        String setType = this.getTypeFromClass(set);
        if (set.getSuperSet() == null && set instanceof MascoptAbstractLinkSet) {
            String vertexSetName = ((MascoptAbstractLinkSet)set).getVertexSet().getId();
            this.fileWriter.println(String.valueOf(set.getId()) + " = new " + setType + "(" + vertexSetName + ");");
        } else if (set.getSuperSet() == null) {
            this.fileWriter.println(String.valueOf(set.getId()) + " = new " + setType + "();");
        } else {
            String superSetName = ((MascoptFixedSet)set.getSuperSet()).getId();
            this.fileWriter.println(String.valueOf(setType) + " " + set.getId() + " = new " + setType + "(" + superSetName + ");");
        }
        for (MascoptObject mascoptObject : set) {
            this.fileWriter.println(String.valueOf(set.getId()) + ".add(" + mascoptObject.getId() + ");");
        }
    }

    private void declareGraph(MascoptAbstractGraph<?> graph) {
        this.fileWriter.println("MascoptAbstractGraph " + graph.getId() + " ;");
    }

    private void writeGraph(MascoptAbstractGraph<?> graph) {
        this.fileWriter.println();
        HierarchicalSet linkSet = graph.edgeSet();
        if (graph instanceof MascoptGraph) {
            this.fileWriter.println(String.valueOf(graph.getId()) + " = new MascoptGraph(" + ((MascoptObject)((Object)linkSet)).getId() + ");");
        } else {
            this.fileWriter.println(String.valueOf(graph.getId()) + " = new MascoptDiGraph(" + ((MascoptObject)((Object)linkSet)).getId() + ");");
        }
        this.fileWriter.println();
    }

    private void writeOneMapEntry(MascoptMap map, MascoptObject key, String name, MascoptObject context) {
        Object value;
        String typeName;
        String subType = null;
        if (map.getDataType(key, name, context).compareTo("String") == 0) {
            typeName = "String";
            value = map.getString(key, name, context);
        } else {
            typeName = "Value";
            subType = map.getDataType(key, name, context);
            value = map.getValue(key, name, context);
        }
        this.fileWriter.println(String.valueOf(map.getId()) + ".put" + typeName + "(" + key.getId() + ", \"" + name + "\", " + context.getId() + ", " + (subType == null ? value : "new " + subType + "(" + value + ")") + ");");
    }

    private void declareMap(MascoptMap map) {
        this.fileWriter.println("MascoptMap " + map.getId() + " ;");
    }

    private void writeMap(MascoptMap map) {
        this.fileWriter.println(String.valueOf(map.getId()) + "= new MascoptMap();");
        Iterator<? extends MascoptObject> it_keys = map.keysIterator();
        while (it_keys.hasNext()) {
            MascoptObject o = it_keys.next();
            Iterator<? extends MascoptObject> contexts = map.contextsIterator(o);
            while (contexts.hasNext()) {
                MascoptObject c = contexts.next();
                Iterator<String> names = map.namesIterator(o, c);
                while (names.hasNext()) {
                    String name = names.next();
                    this.writeOneMapEntry(map, o, name, c);
                }
            }
        }
    }

    private void declareMascoptObject(MascoptObject mascoptObject) {
        if (mascoptObject instanceof MascoptMap) {
            this.declareMap((MascoptMap)mascoptObject);
        } else if (mascoptObject instanceof MascoptAbstractGraph) {
            this.declareGraph((MascoptAbstractGraph)mascoptObject);
        } else if (mascoptObject instanceof MascoptSet) {
            this.declareSet((MascoptSet)mascoptObject);
        } else if (mascoptObject instanceof MascoptAbstractLink) {
            this.declareLink((MascoptAbstractLink)mascoptObject);
        } else if (mascoptObject instanceof MascoptVertex) {
            this.declareVertex((MascoptVertex)mascoptObject);
        } else {
            throw new IllegalArgumentException("This type is not managed " + mascoptObject.getClass());
        }
    }

    private void writeMascoptObject(MascoptObject mascoptObject) {
        if (mascoptObject instanceof MascoptMap) {
            this.writeMap((MascoptMap)mascoptObject);
        } else if (mascoptObject instanceof MascoptAbstractGraph) {
            this.writeGraph((MascoptAbstractGraph)mascoptObject);
        } else if (mascoptObject instanceof MascoptSet) {
            this.writeSet((MascoptSet)mascoptObject);
        } else if (mascoptObject instanceof MascoptAbstractLink) {
            this.writeLink((MascoptAbstractLink)mascoptObject);
        } else if (mascoptObject instanceof MascoptVertex) {
            this.writeVertex((MascoptVertex)mascoptObject);
        } else {
            throw new IllegalArgumentException("This type is not managed " + mascoptObject.getClass());
        }
        this.writeNameIfNeed(mascoptObject);
    }

    @Override
    public void write() {
        this.initializeWriting();
        Iterator<MascoptObject> toWriteIt = this.toGenerate.iterator();
        while (toWriteIt.hasNext()) {
            this.declareMascoptObject(toWriteIt.next());
        }
        toWriteIt = this.toGenerate.iterator();
        while (toWriteIt.hasNext()) {
            this.writeMascoptObject(toWriteIt.next());
        }
    }

    public void setFile(String fileName) {
        this.fileName_ = fileName;
    }

    public void setPackage(String packageName) {
        this.packageName_ = packageName;
    }

    public void setClass(String className) {
        this.className_ = className;
        this.fileName_ = String.valueOf(className) + ".java";
    }

    public ClassWriter(String name) {
        this.fileName_ = name;
    }

    public static void main(String[] args) {
        CommandLineParse parser = new CommandLineParse(args);
        CommandLineParse.StringParameter file = parser.declareStringParameter("i", "input", true);
        file.setExplanation("The name of input file");
        CommandLineParse.StringParameter javaFile = parser.declareStringParameter("f", "file", false);
        javaFile.setExplanation("The file used to store generated code");
        CommandLineParse.StringParameter classNameOption = parser.declareStringParameter("c", "class", false);
        classNameOption.setExplanation("The name of the generated class");
        CommandLineParse.StringParameter packageName = parser.declareStringParameter("p", "package", false);
        packageName.setExplanation("The name of the package");
        CommandLineParse.BooleanParameter help = parser.declareHelpParameter();
        help.setExplanation("Print this message");
        try {
            parser.parse();
        }
        catch (IllegalArgumentException e) {
            System.err.println("java ClassWriter [options]");
            System.err.println(parser.usage());
            System.exit(1);
        }
        if (help.isFound() || !javaFile.isFound() && !classNameOption.isFound()) {
            System.out.println(parser.usage());
            System.exit(0);
        }
        MGLDOMReader reader = null;
        try {
            reader = new MGLDOMReader(file.getStringValue());
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (SecurityException e) {
            System.err.println(e);
            System.exit(1);
        }
        MascoptAbstractGraph<? extends MascoptAbstractLink> ag = MascoptChooser.getAbstractGraph(reader);
        MascoptMap map = MascoptChooser.getMap(reader);
        String fileName = javaFile.isFound() ? javaFile.getStringValue() : "GenarateGraph.java";
        ClassWriter writer = new ClassWriter(fileName);
        if (packageName.isFound()) {
            writer.setPackage(packageName.getStringValue());
        }
        writer.add(ag);
        if (map != null) {
            writer.add(map);
        }
        writer.write();
        System.exit(0);
    }
}

