/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.lpSolver.Impl;

import java.util.Iterator;
import java.util.Vector;
import mascoptLib.lpSolver.Impl.LpContinuousVariableImpl;
import mascoptLib.lpSolver.Impl.LpExprImpl;
import mascoptLib.lpSolver.Impl.LpIntegerVariableImpl;
import mascoptLib.lpSolver.Impl.LpLinearContinuousExprImpl;
import mascoptLib.lpSolver.Impl.LpLinearExprImpl;
import mascoptLib.lpSolver.Impl.LpLinearIntegerExprImpl;
import mascoptLib.lpSolver.exception.LpException;
import mascoptLib.lpSolver.interfaces.LinearProgram;
import mascoptLib.lpSolver.interfaces.LpContinuousVariable;
import mascoptLib.lpSolver.interfaces.LpIntegerVariable;
import mascoptLib.lpSolver.interfaces.LpLinearContinuousExpr;
import mascoptLib.lpSolver.interfaces.LpLinearExpr;
import mascoptLib.lpSolver.interfaces.LpLinearIntegerExpr;

public abstract class AbstractLinearProgram
implements LinearProgram {
    private LpExprImpl objective_ = null;
    private ObjectiveSense objectiveSense_ = ObjectiveSense.UNDEF;
    private boolean isFilled_ = false;
    private boolean containsIntegerVariable_ = false;
    private boolean isSolved_ = false;
    private int constraintIndexGenerator = 1;
    private static final String CONSTRAINT_NAME_PREFIX = "Constraint";
    private Vector<LpConstraintImpl> constraints_ = new Vector();
    private Vector<LpContinuousVariableImpl> variables_ = new Vector();

    @Override
    public void maximize(LpLinearExpr objective) {
        this.isFilled_ = false;
        this.objective_ = (LpExprImpl)((Object)objective);
        this.objectiveSense_ = ObjectiveSense.MAXIMIZE;
    }

    @Override
    public void minimize(LpLinearExpr objective) {
        this.isFilled_ = false;
        this.objective_ = (LpExprImpl)((Object)objective);
        this.objectiveSense_ = ObjectiveSense.MINIMIZE;
    }

    @Override
    public void addEqualConstraint(LpLinearExpr expr, double val) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr, val, ConstraintsType.EQUAL_CONSTRAINT);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addEqualConstraint(LpLinearExpr expr, double val, String name) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr, val, ConstraintsType.EQUAL_CONSTRAINT, name);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addEqualConstraint(LpLinearExpr expr1, LpLinearExpr expr2) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr1, (LpLinearExprImpl)expr2, ConstraintsType.EQUAL_CONSTRAINT);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addEqualConstraint(LpLinearExpr expr1, LpLinearExpr expr2, String name) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr1, (LpLinearExprImpl)expr2, ConstraintsType.EQUAL_CONSTRAINT, name);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addLesserConstraint(LpLinearExpr expr, double upperBound) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr, upperBound, ConstraintsType.LESSER_CONSTRAINT);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addLesserConstraint(LpLinearExpr expr, double upperBound, String name) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr, upperBound, ConstraintsType.LESSER_CONSTRAINT, name);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addLesserConstraint(LpLinearExpr expr1, LpLinearExpr expr2) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr1, (LpLinearExprImpl)expr2, ConstraintsType.LESSER_CONSTRAINT);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addLesserConstraint(LpLinearExpr expr1, LpLinearExpr expr2, String name) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr1, (LpLinearExprImpl)expr2, ConstraintsType.LESSER_CONSTRAINT, name);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addUpperConstraint(LpLinearExpr expr, double lowerBound) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr, lowerBound, ConstraintsType.UPPER_CONSTRAINT);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addUpperConstraint(LpLinearExpr expr, double lowerBound, String name) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr, lowerBound, ConstraintsType.UPPER_CONSTRAINT, name);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addUpperConstraint(LpLinearExpr expr1, LpLinearExpr expr2) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr1, (LpLinearExprImpl)expr2, ConstraintsType.UPPER_CONSTRAINT);
        this.constraints_.add(newConstraint);
    }

    @Override
    public void addUpperConstraint(LpLinearExpr expr1, LpLinearExpr expr2, String name) {
        this.isFilled_ = false;
        LpConstraintImpl newConstraint = new LpConstraintImpl((LpLinearExprImpl)expr1, (LpLinearExprImpl)expr2, ConstraintsType.UPPER_CONSTRAINT, name);
        this.constraints_.add(newConstraint);
    }

    @Override
    public double getExprValue(LpLinearExpr expr) throws LpException {
        if (!this.isSolved_) {
            throw new LpException("The problem is not solved");
        }
        double result = 0.0;
        if (expr instanceof LpLinearContinuousExprImpl) {
            Iterator<LpExprImpl.LpTermImpl> termIterator = ((LpLinearContinuousExprImpl)expr).termIterator();
            while (termIterator.hasNext()) {
                LpExprImpl.LpTermImpl current = termIterator.next();
                result += current.getCoef() * this.getVariableValue(current.getVar().getVariableIndex());
            }
        } else {
            Iterator<LpExprImpl.LpIntTermImpl> termIterator = ((LpLinearIntegerExprImpl)expr).termIterator();
            while (termIterator.hasNext()) {
                LpExprImpl.LpIntTermImpl current = termIterator.next();
                result += current.getCoef() * this.getVariableValue(current.getVar().getVariableIndex());
            }
        }
        return result;
    }

    @Override
    public double getVarValue(LpContinuousVariable var) throws LpException {
        if (!this.isSolved_) {
            throw new LpException("The problem is not solved");
        }
        int varIndex = ((LpContinuousVariableImpl)var).getVariableIndex();
        if (varIndex == -1) {
            throw new LpException("This variable not belong to this program");
        }
        return this.getVariableValue(varIndex);
    }

    @Override
    public double getVarValue(LpIntegerVariable var) throws LpException {
        if (!this.isSolved_) {
            throw new LpException("The problem is not solved");
        }
        int varIndex = ((LpContinuousVariableImpl)((Object)var)).getVariableIndex();
        if (varIndex == -1) {
            throw new LpException("This variable not belong to this program");
        }
        return this.getVariableValue(varIndex);
    }

    @Override
    public double getObjectiveValue() throws LpException {
        if (!this.isSolved()) {
            throw new LpException("The problem is not solved");
        }
        return this.getExprValue((LpLinearExpr)((Object)this.objective_));
    }

    @Override
    public int getNumberOfConstraint() throws LpException {
        return this.constraints_.size();
    }

    @Override
    public int getNumberOfVariable() throws LpException {
        return this.variables_.size();
    }

    @Override
    public LpContinuousVariable newContinuousVariable(double lowerBound, double upperBound) {
        return new LpContinuousVariableImpl(lowerBound, upperBound);
    }

    @Override
    public LpContinuousVariable newContinuousVariable(double lowerBound, double upperBound, String name) {
        return new LpContinuousVariableImpl(lowerBound, upperBound, name);
    }

    @Override
    public LpIntegerVariable newIntegerVariable(int lowerBound, int upperBound) {
        return new LpIntegerVariableImpl(lowerBound, upperBound);
    }

    @Override
    public LpIntegerVariable newIntegerVariable(int lowerBound, int upperBound, String name) {
        return new LpIntegerVariableImpl(lowerBound, upperBound, name);
    }

    @Override
    public LpLinearContinuousExpr newLinearContinuousExpr() {
        return new LpLinearContinuousExprImpl();
    }

    @Override
    public LpLinearIntegerExpr newLinearIntegerExpr() {
        return new LpLinearIntegerExprImpl();
    }

    private boolean variablesIndexIsValid() {
        int i = 0;
        while (i < this.variables_.size()) {
            if (this.variables_.get(i).getVariableIndex() != i + 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean constraintsIndexIsValid() {
        int i = 0;
        while (i < this.constraints_.size()) {
            if (this.constraints_.get(i).index_ != i + 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract double getVariableValue(int var1) throws LpException;

    protected abstract void setConstraintNumber(int var1);

    protected abstract void setVariableNumber(int var1);

    protected abstract void setProblemClass(ProblemClass var1);

    protected abstract void setObjectiveExpr(int var1, double[] var2, int[] var3);

    protected abstract void setObjectiveSense(ObjectiveSense var1) throws LpException;

    protected abstract void setVariableName(int var1, String var2) throws LpException;

    protected abstract void setVariableType(int var1, VariableType var2) throws LpException;

    protected abstract void setVariableBounds(int var1, double var2, double var4) throws LpException;

    protected abstract void setConstraintName(int var1, String var2) throws LpException;

    protected abstract void setConstraintBounds(int var1, double var2, ConstraintsType var4) throws LpException;

    protected abstract void addConstraint(int var1, int var2, int[] var3, double[] var4) throws LpException;

    private void initializeLinearProgram() throws LpException {
        this.isFilled_ = true;
        for (LpConstraintImpl current : this.constraints_) {
            current.indexVariable();
        }
        assert (this.variablesIndexIsValid());
        this.setConstraintNumber(this.constraints_.size());
        System.out.println("Define constraint...");
        for (LpConstraintImpl current : this.constraints_) {
            current.defineConstraint();
        }
        assert (this.constraintsIndexIsValid());
        System.out.println("Define variables...");
        this.setVariableNumber(this.variables_.size());
        for (LpContinuousVariableImpl current : this.variables_) {
            this.setVariableName(current.getVariableIndex(), current.getName());
            if (current instanceof LpIntegerVariableImpl) {
                this.containsIntegerVariable_ = true;
            }
            this.setVariableBounds(current.getVariableIndex(), current.getLowerBound(), current.getUpperBound());
        }
        if (this.containsIntegerVariable_) {
            this.setProblemClass(ProblemClass.MIXED_INTEGER_PROBLEM);
            for (LpContinuousVariableImpl current : this.variables_) {
                if (current instanceof LpIntegerVariableImpl) {
                    this.setVariableType(current.getVariableIndex(), VariableType.INTEGER_VARIABLE);
                    continue;
                }
                this.setVariableType(current.getVariableIndex(), VariableType.CONTINUOUS_VARIABLE);
            }
        }
        System.out.println("Define objective...");
        this.setObjectiveSense(this.objectiveSense_);
        int nbTerm = ((LpLinearExprImpl)this.objective_).size();
        double[] objCoef = new double[nbTerm + 1];
        int[] objVarIndex = new int[nbTerm + 1];
        int termIndex = 1;
        Iterator<? extends LpExprImpl.LpTermImpl> obIterator = ((LpLinearExprImpl)this.objective_).termIterator();
        while (obIterator.hasNext()) {
            LpExprImpl.LpTermImpl current = obIterator.next();
            objCoef[termIndex] = current.getCoef();
            objVarIndex[termIndex++] = current.getVar().getVariableIndex();
        }
        this.setObjectiveExpr(nbTerm, objCoef, objVarIndex);
        System.out.println("Fill and load matrix problem...");
        int[] varIndex = new int[this.variables_.size()];
        double[] varCoef = new double[this.variables_.size()];
        for (LpConstraintImpl current : this.constraints_) {
            nbTerm = current.fillArray(varCoef, varIndex);
            this.addConstraint(current.index_, nbTerm, varIndex, varCoef);
        }
    }

    protected abstract boolean callingSolve();

    protected boolean isSolved() {
        return this.isSolved_;
    }

    protected void setSolved(boolean solved) {
        this.isSolved_ = solved;
    }

    protected boolean isMIP() {
        return this.containsIntegerVariable_;
    }

    @Override
    public boolean solve() throws LpException {
        if (!this.isFilled_) {
            this.isSolved_ = false;
            this.initializeLinearProgram();
        }
        return this.callingSolve();
    }

    protected abstract void writeMpsFile(String var1);

    protected abstract void writeCplexFile(String var1);

    @Override
    public void writeLp(String fileName, LinearProgram.FileFormat format) throws LpException {
        if (!this.isFilled_) {
            this.initializeLinearProgram();
        }
        switch (format) {
            case CPLEX_FORMAT: {
                this.writeCplexFile(fileName);
                break;
            }
            case MPS: {
                this.writeMpsFile(fileName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow format");
            }
        }
    }

    public static enum ConstraintsType {
        EQUAL_CONSTRAINT,
        LESSER_CONSTRAINT,
        UPPER_CONSTRAINT;

    }

    private class LpConstraintImpl {
        private LpLinearExprImpl expr1_;
        private LpLinearExprImpl expr2_;
        private LpLinearExprImpl expr_;
        private double bound_;
        private ConstraintsType type_;
        private String name_;
        private int index_;

        LpConstraintImpl(LpLinearExprImpl e, double bound, ConstraintsType type, String name) {
            this.expr1_ = e;
            this.expr2_ = null;
            this.bound_ = bound;
            this.type_ = type;
            this.name_ = name;
            AbstractLinearProgram abstractLinearProgram2 = AbstractLinearProgram.this;
            int n = abstractLinearProgram2.constraintIndexGenerator;
            abstractLinearProgram2.constraintIndexGenerator = n + 1;
            this.index_ = n;
        }

        LpConstraintImpl(LpLinearExprImpl e, double bound, ConstraintsType type) {
            this(e, bound, type, AbstractLinearProgram.CONSTRAINT_NAME_PREFIX + abstractLinearProgram.constraintIndexGenerator);
        }

        LpConstraintImpl(LpLinearExprImpl e1, LpLinearExprImpl e2, ConstraintsType type, String name) {
            this.expr1_ = e1;
            this.expr2_ = e2;
            this.bound_ = 0.0;
            this.type_ = type;
            this.name_ = name;
            AbstractLinearProgram abstractLinearProgram2 = AbstractLinearProgram.this;
            int n = abstractLinearProgram2.constraintIndexGenerator;
            abstractLinearProgram2.constraintIndexGenerator = n + 1;
            this.index_ = n;
        }

        LpConstraintImpl(LpLinearExprImpl e1, LpLinearExprImpl e2, ConstraintsType type) {
            this(e1, e2, type, AbstractLinearProgram.CONSTRAINT_NAME_PREFIX + abstractLinearProgram.constraintIndexGenerator);
        }

        private int indexExpressionVariables(LpLinearExprImpl expr) throws LpException {
            int result = 0;
            if (expr instanceof LpLinearIntegerExprImpl) {
                Iterator<LpIntegerVariable> varIt = ((LpLinearIntegerExprImpl)expr).iterator();
                while (varIt.hasNext()) {
                    LpIntegerVariableImpl current = (LpIntegerVariableImpl)varIt.next();
                    if (current.getVariableIndex() == -1) {
                        current.setVariableIndex(AbstractLinearProgram.this.variables_.size() + 1);
                        AbstractLinearProgram.this.variables_.add(current);
                    }
                    ++result;
                }
            } else if (expr instanceof LpLinearContinuousExprImpl) {
                Iterator<LpContinuousVariable> varIt = ((LpLinearContinuousExprImpl)expr).iterator();
                while (varIt.hasNext()) {
                    LpContinuousVariableImpl current = (LpContinuousVariableImpl)varIt.next();
                    if (current.getVariableIndex() == -1) {
                        current.setVariableIndex(AbstractLinearProgram.this.variables_.size() + 1);
                        AbstractLinearProgram.this.variables_.add(current);
                    }
                    ++result;
                }
            } else if (expr instanceof LpIntegerVariableImpl) {
                if (((LpIntegerVariableImpl)expr).getVariableIndex() == -1) {
                    ((LpIntegerVariableImpl)expr).setVariableIndex(AbstractLinearProgram.this.variables_.size() + 1);
                    AbstractLinearProgram.this.variables_.add((LpContinuousVariableImpl)expr);
                }
                ++result;
            } else {
                if (((LpContinuousVariableImpl)expr).getVariableIndex() == -1) {
                    ((LpContinuousVariableImpl)expr).setVariableIndex(AbstractLinearProgram.this.variables_.size() + 1);
                    AbstractLinearProgram.this.variables_.add((LpContinuousVariableImpl)expr);
                }
                ++result;
            }
            return result;
        }

        int indexVariable() throws LpException {
            this.expr_ = this.expr2_ == null ? this.expr1_ : this.substract(this.expr1_, this.expr2_);
            return this.indexExpressionVariables(this.expr_);
        }

        private double getConstant(LpLinearExprImpl e) {
            if (e instanceof LpLinearIntegerExprImpl) {
                return ((LpLinearIntegerExprImpl)e).getConstant();
            }
            if (e instanceof LpLinearContinuousExprImpl) {
                return ((LpLinearContinuousExprImpl)e).getConstant();
            }
            return 0.0;
        }

        private LpLinearExprImpl substract(LpLinearExprImpl e1, LpLinearExprImpl e2) {
            LpExprImpl.LpTermImpl current;
            LpLinearContinuousExprImpl result = new LpLinearContinuousExprImpl();
            Iterator<? extends LpExprImpl.LpTermImpl> termIt = e1.termIterator();
            while (termIt.hasNext()) {
                current = termIt.next();
                result.addTerm(current.getCoef(), current.getVar());
            }
            termIt = e2.termIterator();
            while (termIt.hasNext()) {
                current = termIt.next();
                result.addTerm(-current.getCoef(), current.getVar());
            }
            result.setConstant(this.getConstant(e1) - this.getConstant(e2));
            return result;
        }

        void defineConstraint() throws LpException {
            this.index_ = AbstractLinearProgram.this.constraints_.indexOf(this) + 1;
            AbstractLinearProgram.this.setConstraintName(this.index_, this.name_);
            AbstractLinearProgram.this.setConstraintBounds(this.index_, this.bound_, this.type_);
        }

        int fillArray(double[] coef, int[] varIndex) {
            int result = 0;
            Iterator<? extends LpExprImpl.LpTermImpl> termIt = this.expr_.termIterator();
            while (termIt.hasNext()) {
                LpExprImpl.LpTermImpl current = termIt.next();
                if (current.getCoef() != 0.0) {
                    varIndex[result + 1] = current.getVar().getVariableIndex();
                    coef[result + 1] = current.getCoef();
                    ++result;
                    continue;
                }
                System.err.println("Warning : suppress variable with coef = 0");
            }
            return result;
        }
    }

    protected static enum ObjectiveSense {
        UNDEF,
        MAXIMIZE,
        MINIMIZE;

    }

    protected static enum ProblemClass {
        MIXED_INTEGER_PROBLEM,
        FRACTIONNAL_PROBLEM;

    }

    protected static enum VariableType {
        CONTINUOUS_VARIABLE,
        INTEGER_VARIABLE;

    }
}

